/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalTabCloseListener;
import org.jetbrains.plugins.terminal.TerminalToolWindowManager;
import org.jetbrains.plugins.terminal.action.TerminalSessionContextMenuActionBase;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u0013\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/terminal/action/MoveTerminalToolwindowTabLeftRightAction;", "Lorg/jetbrains/plugins/terminal/action/TerminalSessionContextMenuActionBase;", "Lcom/intellij/openapi/project/DumbAware;", "moveLeft", "", "<init>", "(Z)V", "actionPerformedInTerminalToolWindow", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "content", "Lcom/intellij/ui/content/Content;", "terminalWidget", "Lcom/intellij/terminal/ui/TerminalWidget;", "updateInTerminalToolWindow", "isAvailable", "move", "intellij.terminal"})
public class MoveTerminalToolwindowTabLeftRightAction
extends TerminalSessionContextMenuActionBase
implements DumbAware {
    private final boolean moveLeft;

    public MoveTerminalToolwindowTabLeftRightAction(boolean moveLeft) {
        this.moveLeft = moveLeft;
    }

    @Override
    public void actionPerformedInTerminalToolWindow(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Content content, @NotNull TerminalWidget terminalWidget) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)terminalWidget, (String)"terminalWidget");
        this.move(content, project);
    }

    @Override
    public void updateInTerminalToolWindow(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Content content, @NotNull TerminalWidget terminalWidget) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)terminalWidget, (String)"terminalWidget");
        e.getPresentation().setEnabled(this.isAvailable(content));
    }

    public final boolean isAvailable(@NotNull Content content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        ContentManager contentManager = content.getManager();
        if (contentManager == null) {
            return false;
        }
        ContentManager manager = contentManager;
        int ind = manager.getIndexOfContent(content);
        return this.moveLeft ? ind > 0 : ind >= 0 && ind < manager.getContentCount() - 1;
    }

    public final void move(@NotNull Content content, @NotNull Project project) {
        int otherInd;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ContentManager contentManager = content.getManager();
        if (contentManager == null) {
            return;
        }
        ContentManager manager = contentManager;
        int ind = manager.getIndexOfContent(content);
        int n = otherInd = this.moveLeft ? ind - 1 : ind + 1;
        if (ind >= 0 && otherInd >= 0 && otherInd < manager.getContentCount()) {
            Content content2 = manager.getContent(otherInd);
            Intrinsics.checkNotNull((Object)content2);
            Content otherContent = content2;
            TerminalTabCloseListener.Companion.executeContentOperationSilently(otherContent, (Function0<Unit>)((Function0)() -> MoveTerminalToolwindowTabLeftRightAction.move$lambda$0(manager, otherContent, ind, project)));
        }
    }

    private static final Unit move$lambda$0(ContentManager $manager, Content $otherContent, int $ind, Project $project) {
        $manager.removeContent($otherContent, false, false, false).doWhenDone(() -> MoveTerminalToolwindowTabLeftRightAction.move$lambda$0$0($manager, $otherContent, $ind, $project));
        return Unit.INSTANCE;
    }

    private static final void move$lambda$0$0(ContentManager $manager, Content $otherContent, int $ind, Project $project) {
        $manager.addContent($otherContent, $ind);
        TerminalToolWindowManager terminalToolWindowManager = TerminalToolWindowManager.getInstance($project);
        Intrinsics.checkNotNullExpressionValue((Object)terminalToolWindowManager, (String)"getInstance(...)");
        new TerminalTabCloseListener($otherContent, $project, terminalToolWindowManager);
    }
}

