/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.reworked;

import com.intellij.openapi.editor.impl.FrozenDocument;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.reworked.FrozenTerminalOutputModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalLine;
import org.jetbrains.plugins.terminal.block.reworked.TerminalLineImpl;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOffset;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOffsetImpl;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0011H\u0016J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/terminal/block/reworked/FrozenTerminalOutputModelImpl;", "Lorg/jetbrains/plugins/terminal/block/reworked/FrozenTerminalOutputModel;", "document", "Lcom/intellij/openapi/editor/impl/FrozenDocument;", "trimmedCharsCount", "", "trimmedLinesCount", "cursorOffset", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOffset;", "<init>", "(Lcom/intellij/openapi/editor/impl/FrozenDocument;JJLorg/jetbrains/plugins/terminal/block/reworked/TerminalOffset;)V", "getDocument", "()Lcom/intellij/openapi/editor/impl/FrozenDocument;", "getCursorOffset", "()Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOffset;", "relativeOffset", "offset", "", "absoluteOffset", "relativeLine", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalLine;", "line", "absoluteLine", "intellij.terminal"})
@ApiStatus.Internal
public final class FrozenTerminalOutputModelImpl
implements FrozenTerminalOutputModel {
    @NotNull
    private final FrozenDocument document;
    private final long trimmedCharsCount;
    private final long trimmedLinesCount;
    @NotNull
    private final TerminalOffset cursorOffset;

    public FrozenTerminalOutputModelImpl(@NotNull FrozenDocument document, long trimmedCharsCount, long trimmedLinesCount, @NotNull TerminalOffset cursorOffset) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)cursorOffset, (String)"cursorOffset");
        this.document = document;
        this.trimmedCharsCount = trimmedCharsCount;
        this.trimmedLinesCount = trimmedLinesCount;
        this.cursorOffset = cursorOffset;
    }

    @Override
    @NotNull
    public FrozenDocument getDocument() {
        return this.document;
    }

    @Override
    @NotNull
    public TerminalOffset getCursorOffset() {
        return this.cursorOffset;
    }

    @Override
    @NotNull
    public TerminalOffset relativeOffset(int offset) {
        return new TerminalOffsetImpl(this.trimmedCharsCount, offset);
    }

    @Override
    @NotNull
    public TerminalOffset absoluteOffset(long offset) {
        return new TerminalOffsetImpl(this.trimmedCharsCount, (int)(offset - this.trimmedCharsCount));
    }

    @Override
    @NotNull
    public TerminalLine relativeLine(int line) {
        return new TerminalLineImpl(this.trimmedLinesCount, line);
    }

    @Override
    @NotNull
    public TerminalLine absoluteLine(long line) {
        return new TerminalLineImpl(this.trimmedLinesCount, (int)(line - this.trimmedLinesCount));
    }
}

