/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.reworked;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.terminal.TerminalColorPalette;
import com.intellij.terminal.session.StyleRange;
import com.intellij.terminal.session.TerminalOutputModelState;
import com.intellij.util.EventDispatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.terminal.block.output.HighlightingInfo;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputHighlightingsSnapshot;
import org.jetbrains.plugins.terminal.block.output.TextStyleAdapter;
import org.jetbrains.plugins.terminal.block.reworked.FrozenTerminalOutputModel;
import org.jetbrains.plugins.terminal.block.reworked.FrozenTerminalOutputModelImpl;
import org.jetbrains.plugins.terminal.block.reworked.TerminalLine;
import org.jetbrains.plugins.terminal.block.reworked.TerminalLineImpl;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOffset;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOffsetImpl;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModelImplKt;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModelListener;
import org.jetbrains.plugins.terminal.block.ui.BlockTerminalColorPalette;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001YB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\f2\u0006\u0010,\u001a\u00020\u0005H\u0016J\u0010\u0010-\u001a\u00020\f2\u0006\u0010,\u001a\u00020\u0019H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0005H\u0016J\u0010\u00101\u001a\u00020/2\u0006\u00100\u001a\u00020\u0019H\u0016J\u0010\u00102\u001a\u00020\u00192\u0006\u00103\u001a\u00020\u0005H\u0016J&\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u00192\u0006\u00107\u001a\u0002082\f\u00109\u001a\b\u0012\u0004\u0012\u00020;0:H\u0016J.\u0010<\u001a\u0002052\u0006\u0010,\u001a\u00020\f2\u0006\u0010=\u001a\u00020\u00052\u0006\u00107\u001a\u0002082\f\u0010>\u001a\b\u0012\u0004\u0012\u00020;0:H\u0016J\u0018\u0010?\u001a\u0002052\u0006\u00106\u001a\u00020\u00192\u0006\u0010@\u001a\u00020\u0005H\u0016J\u0010\u0010?\u001a\u0002052\u0006\u0010,\u001a\u00020\fH\u0016J&\u0010A\u001a\u00020\u00052\u0006\u0010B\u001a\u00020\u00052\u0006\u00107\u001a\u0002082\f\u00109\u001a\b\u0012\u0004\u0012\u00020;0:H\u0002J\u0010\u0010C\u001a\u0002052\u0006\u0010B\u001a\u00020\u0005H\u0002J.\u0010D\u001a\u00020\u00052\u0006\u0010E\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\u00052\u0006\u00107\u001a\u0002082\f\u00109\u001a\b\u0012\u0004\u0012\u00020;0:H\u0002J\b\u0010F\u001a\u000205H\u0002J\b\u0010G\u001a\u00020\u0005H\u0002J\u0010\u0010G\u001a\u00020\u00052\u0006\u0010H\u001a\u00020\u0005H\u0002J \u0010I\u001a\u0002052\b\b\u0002\u0010(\u001a\u00020'2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00050KH\u0002J\b\u0010L\u001a\u00020MH\u0016J\u0012\u0010N\u001a\u0004\u0018\u00010O2\u0006\u00103\u001a\u00020\u0005H\u0016J\u0018\u0010P\u001a\u0002052\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020\u0015H\u0016J\u0016\u0010T\u001a\u0002052\f\u0010J\u001a\b\u0012\u0004\u0012\u0002050KH\u0016J\b\u0010U\u001a\u00020VH\u0016J\u0010\u0010W\u001a\u0002052\u0006\u0010X\u001a\u00020VH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u00060\u0012R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0013\u001a\u0015\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00150\u00150\u0014\u00a2\u0006\u0002\b\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u00020\u00198\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001e\u0010\u001e\u001a\u00020\u00198\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR\u001e\u0010!\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModelImpl;", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;", "document", "Lcom/intellij/openapi/editor/Document;", "maxOutputLength", "", "<init>", "(Lcom/intellij/openapi/editor/Document;I)V", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "mutableCursorOffsetState", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOffset;", "cursorOffsetState", "Lkotlinx/coroutines/flow/StateFlow;", "getCursorOffsetState", "()Lkotlinx/coroutines/flow/StateFlow;", "highlightingsModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModelImpl$HighlightingsModel;", "dispatcher", "Lcom/intellij/util/EventDispatcher;", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModelListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "trimmedLinesCount", "", "getTrimmedLinesCount", "()J", "setTrimmedLinesCount", "(J)V", "trimmedCharsCount", "getTrimmedCharsCount", "setTrimmedCharsCount", "firstLineTrimmedCharsCount", "getFirstLineTrimmedCharsCount", "()I", "setFirstLineTrimmedCharsCount", "(I)V", "contentUpdateInProgress", "", "isTypeAhead", "freeze", "Lorg/jetbrains/plugins/terminal/block/reworked/FrozenTerminalOutputModel;", "relativeOffset", "offset", "absoluteOffset", "relativeLine", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalLine;", "line", "absoluteLine", "getAbsoluteLineIndex", "documentOffset", "updateContent", "", "absoluteLineIndex", "text", "", "styles", "", "Lcom/intellij/terminal/session/StyleRange;", "replaceContent", "length", "newStyles", "updateCursorPosition", "columnIndex", "doUpdateContent", "documentLineIndex", "ensureDocumentHasLine", "doReplaceContent", "relativeStartOffset", "ensureCorrectCursorOffset", "trimToSize", "maxLength", "changeDocumentContent", "block", "Lkotlin/Function0;", "getHighlightings", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputHighlightingsSnapshot;", "getHighlightingAt", "Lorg/jetbrains/plugins/terminal/block/output/HighlightingInfo;", "addListener", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "listener", "withTypeAhead", "dumpState", "Lcom/intellij/terminal/session/TerminalOutputModelState;", "restoreFromState", "state", "HighlightingsModel", "intellij.terminal"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTerminalOutputModelImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalOutputModelImpl.kt\norg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModelImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,513:1\n60#2,5:514\n60#2,5:519\n60#2,5:524\n60#2,5:529\n60#2,5:534\n60#2,5:540\n1#3:539\n*S KotlinDebug\n*F\n+ 1 TerminalOutputModelImpl.kt\norg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModelImpl\n*L\n93#1:514,5\n119#1:519,5\n129#1:524,5\n146#1:529,5\n160#1:534,5\n112#1:540,5\n*E\n"})
public final class TerminalOutputModelImpl
implements TerminalOutputModel {
    @NotNull
    private final Document document;
    private final int maxOutputLength;
    @NotNull
    private final MutableStateFlow<TerminalOffset> mutableCursorOffsetState;
    @NotNull
    private final StateFlow<TerminalOffset> cursorOffsetState;
    @NotNull
    private final HighlightingsModel highlightingsModel;
    @NotNull
    private final EventDispatcher<TerminalOutputModelListener> dispatcher;
    @VisibleForTesting
    private long trimmedLinesCount;
    @VisibleForTesting
    private long trimmedCharsCount;
    @VisibleForTesting
    private int firstLineTrimmedCharsCount;
    private boolean contentUpdateInProgress;
    private boolean isTypeAhead;

    public TerminalOutputModelImpl(@NotNull Document document, int maxOutputLength) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.document = document;
        this.maxOutputLength = maxOutputLength;
        this.mutableCursorOffsetState = StateFlowKt.MutableStateFlow((Object)this.absoluteOffset(0L));
        this.cursorOffsetState = FlowKt.asStateFlow(this.mutableCursorOffsetState);
        this.highlightingsModel = new HighlightingsModel();
        EventDispatcher eventDispatcher2 = EventDispatcher.create(TerminalOutputModelListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher2, (String)"create(...)");
        this.dispatcher = eventDispatcher2;
    }

    @Override
    @NotNull
    public Document getDocument() {
        return this.document;
    }

    @Override
    @NotNull
    public StateFlow<TerminalOffset> getCursorOffsetState() {
        return this.cursorOffsetState;
    }

    public final long getTrimmedLinesCount() {
        return this.trimmedLinesCount;
    }

    public final void setTrimmedLinesCount(long l) {
        this.trimmedLinesCount = l;
    }

    public final long getTrimmedCharsCount() {
        return this.trimmedCharsCount;
    }

    public final void setTrimmedCharsCount(long l) {
        this.trimmedCharsCount = l;
    }

    public final int getFirstLineTrimmedCharsCount() {
        return this.firstLineTrimmedCharsCount;
    }

    public final void setFirstLineTrimmedCharsCount(int n) {
        this.firstLineTrimmedCharsCount = n;
    }

    @Override
    @NotNull
    public FrozenTerminalOutputModel freeze() {
        Document document = this.getDocument();
        Intrinsics.checkNotNull((Object)document, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.DocumentImpl");
        FrozenDocument frozenDocument = ((DocumentImpl)document).freeze();
        Intrinsics.checkNotNullExpressionValue((Object)frozenDocument, (String)"freeze(...)");
        return new FrozenTerminalOutputModelImpl(frozenDocument, this.trimmedCharsCount, this.trimmedLinesCount, (TerminalOffset)this.getCursorOffsetState().getValue());
    }

    @Override
    @NotNull
    public TerminalOffset relativeOffset(int offset) {
        return new TerminalOffsetImpl(this.trimmedCharsCount, offset);
    }

    @Override
    @NotNull
    public TerminalOffset absoluteOffset(long offset) {
        return new TerminalOffsetImpl(this.trimmedCharsCount, (int)(offset - this.trimmedCharsCount));
    }

    @Override
    @NotNull
    public TerminalLine relativeLine(int line) {
        return new TerminalLineImpl(this.trimmedLinesCount, line);
    }

    @Override
    @NotNull
    public TerminalLine absoluteLine(long line) {
        return new TerminalLineImpl(this.trimmedLinesCount, (int)(line - this.trimmedLinesCount));
    }

    @Override
    public long getAbsoluteLineIndex(int documentOffset) {
        int documentLineIndex = this.getDocument().getLineNumber(documentOffset);
        return this.trimmedLinesCount + (long)documentLineIndex;
    }

    @Override
    public void updateContent(long absoluteLineIndex, @NotNull String text, @NotNull List<StyleRange> styles) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(styles, (String)"styles");
        TerminalOutputModelImpl.changeDocumentContent$default(this, false, () -> TerminalOutputModelImpl.updateContent$lambda$0(absoluteLineIndex, this, text, styles), 1, null);
    }

    @Override
    public void replaceContent(@NotNull TerminalOffset offset, int length, @NotNull String text, @NotNull List<StyleRange> newStyles) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(newStyles, (String)"newStyles");
        this.changeDocumentContent(this.isTypeAhead, (Function0<Integer>)((Function0)() -> TerminalOutputModelImpl.replaceContent$lambda$0(offset, this, length, text, newStyles)));
    }

    @Override
    public void updateCursorPosition(long absoluteLineIndex, int columnIndex) {
        Logger logger;
        int documentLineIndex = (int)(absoluteLineIndex - this.trimmedLinesCount);
        Logger $this$debug_u24default$iv = TerminalOutputModelImplKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Updating the cursor position to absolute line = " + absoluteLineIndex + " (relative " + documentLineIndex + "), column = " + columnIndex, e$iv);
        }
        this.ensureDocumentHasLine(documentLineIndex);
        int lineStartOffset = this.getDocument().getLineStartOffset(documentLineIndex);
        int lineEndOffset = this.getDocument().getLineEndOffset(documentLineIndex);
        int trimmedCharsInLine = documentLineIndex == 0 ? this.firstLineTrimmedCharsCount : 0;
        int trimmedColumnIndex = columnIndex - trimmedCharsInLine;
        int lineLength = lineEndOffset - lineStartOffset;
        if (trimmedColumnIndex > lineLength) {
            int spacesToAdd = trimmedColumnIndex - lineLength;
            String spaces = StringsKt.repeat((CharSequence)" ", (int)spacesToAdd);
            TerminalOutputModelImpl.changeDocumentContent$default(this, false, () -> TerminalOutputModelImpl.updateCursorPosition$lambda$1(this, lineEndOffset, spaces, spacesToAdd), 1, null);
        }
        int newCursorOffset = lineStartOffset + trimmedColumnIndex;
        Logger $this$debug_u24default$iv2 = TerminalOutputModelImplKt.access$getLOG$p();
        Throwable e$iv2 = null;
        boolean $i$f$debug2 = false;
        if ($this$debug_u24default$iv2.isDebugEnabled()) {
            logger = $this$debug_u24default$iv2;
            boolean bl = false;
            logger.debug("Updated the cursor position to " + newCursorOffset, e$iv2);
        }
        this.mutableCursorOffsetState.setValue((Object)this.relativeOffset(newCursorOffset));
    }

    @Override
    public void updateCursorPosition(@NotNull TerminalOffset offset) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        this.mutableCursorOffsetState.setValue((Object)offset);
    }

    private final int doUpdateContent(int documentLineIndex, String text, List<StyleRange> styles) {
        Logger logger;
        Logger $this$debug_u24default$iv = TerminalOutputModelImplKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Content update from the relative line = " + documentLineIndex + " (absolute " + ((long)documentLineIndex + this.trimmedLinesCount) + "), length = " + text.length() + ", current length = " + this.getDocument().getTextLength() + " chars, " + this.getDocument().getLineCount() + " lines, currently trimmed = " + this.trimmedCharsCount + " chars, " + this.trimmedLinesCount + " lines", e$iv);
        }
        this.ensureDocumentHasLine(documentLineIndex);
        int replaceStartOffset = this.getDocument().getLineStartOffset(documentLineIndex);
        this.getDocument().replaceString(replaceStartOffset, this.getDocument().getTextLength(), (CharSequence)text);
        this.ensureCorrectCursorOffset();
        this.highlightingsModel.removeAfter(replaceStartOffset);
        this.highlightingsModel.addHighlightings(replaceStartOffset, styles);
        int trimmedCount = this.trimToSize();
        Logger $this$debug_u24default$iv2 = TerminalOutputModelImplKt.access$getLOG$p();
        Throwable e$iv2 = null;
        boolean $i$f$debug2 = false;
        if ($this$debug_u24default$iv2.isDebugEnabled()) {
            logger = $this$debug_u24default$iv2;
            boolean bl = false;
            logger.debug("Content updated from relative offset = " + replaceStartOffset + ", new length = " + this.getDocument().getTextLength() + " chars, " + this.getDocument().getLineCount() + " lines, currently trimmed = " + this.trimmedCharsCount + " chars, " + this.trimmedLinesCount + " lines", e$iv2);
        }
        return Math.max(0, replaceStartOffset - trimmedCount);
    }

    private final void ensureDocumentHasLine(int documentLineIndex) {
        if (documentLineIndex > 0 && documentLineIndex >= this.getDocument().getLineCount()) {
            int newLinesToAdd = documentLineIndex - this.getDocument().getLineCount() + 1;
            String newLines = StringsKt.repeat((CharSequence)"\n", (int)newLinesToAdd);
            this.getDocument().insertString(this.getDocument().getTextLength(), (CharSequence)newLines);
            Logger $this$debug_u24default$iv = TerminalOutputModelImplKt.access$getLOG$p();
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Added " + newLinesToAdd + " lines to make the line valid", e$iv);
            }
        }
    }

    private final int doReplaceContent(int relativeStartOffset, int length, String text, List<StyleRange> styles) {
        int relativeEndOffset = relativeStartOffset + length;
        this.getDocument().replaceString(relativeStartOffset, relativeEndOffset, (CharSequence)text);
        this.highlightingsModel.updateHighlightings(relativeStartOffset, length, text.length(), styles);
        int trimmedCount = this.trimToSize();
        this.ensureCorrectCursorOffset();
        return Math.max(0, relativeStartOffset - trimmedCount);
    }

    private final void ensureCorrectCursorOffset() {
        int newLength = this.getDocument().getTextLength();
        TerminalOffset docEndOffset = this.relativeOffset(newLength);
        if (((TerminalOffset)this.mutableCursorOffsetState.getValue()).compareTo(docEndOffset) > 0) {
            this.mutableCursorOffsetState.setValue((Object)docEndOffset);
        }
    }

    private final int trimToSize() {
        return this.maxOutputLength > 0 && this.getDocument().getTextLength() > this.maxOutputLength ? this.trimToSize(this.maxOutputLength) : 0;
    }

    private final int trimToSize(int maxLength) {
        int textLength = this.getDocument().getTextLength();
        if (!(textLength > maxLength)) {
            boolean $i$a$-check-TerminalOutputModelImpl$trimToSize$22 = false;
            String $i$a$-check-TerminalOutputModelImpl$trimToSize$22 = "This method should be called only if text length " + textLength + " is greater than max length " + maxLength;
            throw new IllegalStateException($i$a$-check-TerminalOutputModelImpl$trimToSize$22.toString());
        }
        int lineCountBefore = this.getDocument().getLineCount();
        int removeUntilOffset = textLength - maxLength;
        int futureFirstLineNumber = this.getDocument().getLineNumber(removeUntilOffset);
        int futureFirstLineStart = this.getDocument().getLineStartOffset(futureFirstLineNumber);
        this.getDocument().deleteString(0, removeUntilOffset);
        this.highlightingsModel.removeBefore(removeUntilOffset);
        this.trimmedCharsCount += (long)removeUntilOffset;
        this.trimmedLinesCount += (long)(lineCountBefore - this.getDocument().getLineCount());
        this.firstLineTrimmedCharsCount = removeUntilOffset - futureFirstLineStart;
        return removeUntilOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void changeDocumentContent(boolean isTypeAhead, Function0<Integer> block) {
        int n;
        ((TerminalOutputModelListener)this.dispatcher.getMulticaster()).beforeContentChanged(this);
        this.contentUpdateInProgress = true;
        try {
            n = ((Number)block.invoke()).intValue();
        }
        finally {
            this.contentUpdateInProgress = false;
        }
        int changeStartOffset = n;
        ((TerminalOutputModelListener)this.dispatcher.getMulticaster()).afterContentChanged(this, changeStartOffset, isTypeAhead);
    }

    static /* synthetic */ void changeDocumentContent$default(TerminalOutputModelImpl terminalOutputModelImpl, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        terminalOutputModelImpl.changeDocumentContent(bl, (Function0<Integer>)function0);
    }

    @Override
    @NotNull
    public TerminalOutputHighlightingsSnapshot getHighlightings() {
        return this.contentUpdateInProgress ? new TerminalOutputHighlightingsSnapshot(this.getDocument(), CollectionsKt.emptyList()) : this.highlightingsModel.getHighlightingsSnapshot();
    }

    @Override
    @Nullable
    public HighlightingInfo getHighlightingAt(int documentOffset) {
        return this.highlightingsModel.getHighlightingAt(documentOffset);
    }

    @Override
    public void addListener(@NotNull Disposable parentDisposable, @NotNull TerminalOutputModelListener listener2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.dispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void withTypeAhead(@NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (!(!this.isTypeAhead)) {
            boolean bl = false;
            String string = "Already in the type-ahead mode";
            throw new IllegalStateException(string.toString());
        }
        this.isTypeAhead = true;
        try {
            block.invoke();
        }
        finally {
            this.isTypeAhead = false;
        }
    }

    @Override
    @NotNull
    public TerminalOutputModelState dumpState() {
        String string = this.getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return new TerminalOutputModelState(string, this.trimmedLinesCount, this.trimmedCharsCount, this.firstLineTrimmedCharsCount, ((TerminalOffset)this.getCursorOffsetState().getValue()).toRelative(), this.highlightingsModel.dumpState());
    }

    @Override
    public void restoreFromState(@NotNull TerminalOutputModelState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        TerminalOutputModelImpl.changeDocumentContent$default(this, false, () -> TerminalOutputModelImpl.restoreFromState$lambda$0(this, state), 1, null);
    }

    private static final int updateContent$lambda$0(long $absoluteLineIndex, TerminalOutputModelImpl this$0, String $text, List $styles) {
        if ($absoluteLineIndex < this$0.trimmedLinesCount) {
            this$0.trimmedLinesCount = 0L;
            this$0.trimmedCharsCount = 0L;
            this$0.firstLineTrimmedCharsCount = 0;
        }
        int documentLineIndex = (int)($absoluteLineIndex - this$0.trimmedLinesCount);
        return this$0.doUpdateContent(documentLineIndex, $text, $styles);
    }

    private static final int replaceContent$lambda$0(TerminalOffset $offset, TerminalOutputModelImpl this$0, int $length, String $text, List $newStyles) {
        int relativeStartOffset = $offset.toRelative();
        return this$0.doReplaceContent(relativeStartOffset, $length, $text, $newStyles);
    }

    private static final int updateCursorPosition$lambda$1(TerminalOutputModelImpl this$0, int $lineEndOffset, String $spaces, int $spacesToAdd) {
        this$0.getDocument().insertString($lineEndOffset, (CharSequence)$spaces);
        Logger $this$debug_u24default$iv = TerminalOutputModelImplKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Added " + $spacesToAdd + " spaces to make the column valid", e$iv);
        }
        this$0.highlightingsModel.insertEmptyHighlightings($lineEndOffset, $spacesToAdd);
        return $lineEndOffset;
    }

    private static final int restoreFromState$lambda$0(TerminalOutputModelImpl this$0, TerminalOutputModelState $state) {
        this$0.trimmedLinesCount = $state.getTrimmedLinesCount();
        this$0.trimmedCharsCount = $state.getTrimmedCharsCount();
        this$0.firstLineTrimmedCharsCount = $state.getFirstLineTrimmedCharsCount();
        this$0.getDocument().setText((CharSequence)$state.getText());
        this$0.highlightingsModel.restoreFromState($state.getHighlightings());
        this$0.mutableCursorOffsetState.setValue((Object)this$0.relativeOffset($state.getCursorOffset()));
        return 0;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\nJ\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001c\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0013J\u0016\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fJ\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fJ,\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0013J\u0018\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J \u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\b0\u0013J\u0014\u0010$\u001a\u00020\u00112\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModelImpl$HighlightingsModel;", "", "<init>", "(Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModelImpl;)V", "colorPalette", "Lcom/intellij/terminal/TerminalColorPalette;", "styleRanges", "", "Lcom/intellij/terminal/session/StyleRange;", "highlightingsSnapshot", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputHighlightingsSnapshot;", "getHighlightingsSnapshot", "getHighlightingAt", "Lorg/jetbrains/plugins/terminal/block/output/HighlightingInfo;", "documentOffset", "", "addHighlightings", "", "styles", "", "insertEmptyHighlightings", "length", "removeAfter", "removeBefore", "updateHighlightings", "relativeStartOffset", "oldLength", "newLength", "shift", "shiftFromIndex", "updateAffectedRanges", "affectedIndexes", "Lkotlin/ranges/IntRange;", "affectedAbsoluteOffsets", "Lkotlin/ranges/LongRange;", "dumpState", "restoreFromState", "state", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nTerminalOutputModelImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalOutputModelImpl.kt\norg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModelImpl$HighlightingsModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,513:1\n1563#2:514\n1634#2,3:515\n1563#2:519\n1634#2,3:520\n1563#2:523\n1634#2,3:524\n1#3:518\n*S KotlinDebug\n*F\n+ 1 TerminalOutputModelImpl.kt\norg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModelImpl$HighlightingsModel\n*L\n304#1:514\n304#1:515,3\n344#1:519\n344#1:520,3\n418#1:523\n418#1:524,3\n*E\n"})
    private final class HighlightingsModel {
        @NotNull
        private final TerminalColorPalette colorPalette = new BlockTerminalColorPalette();
        @NotNull
        private final List<StyleRange> styleRanges = (List)new ArrayDeque();
        @Nullable
        private TerminalOutputHighlightingsSnapshot highlightingsSnapshot;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TerminalOutputHighlightingsSnapshot getHighlightingsSnapshot() {
            TerminalOutputHighlightingsSnapshot snapshot;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            if (this.highlightingsSnapshot != null) {
                TerminalOutputHighlightingsSnapshot terminalOutputHighlightingsSnapshot = this.highlightingsSnapshot;
                Intrinsics.checkNotNull((Object)terminalOutputHighlightingsSnapshot);
                return terminalOutputHighlightingsSnapshot;
            }
            Iterable iterable = this.styleRanges;
            TerminalOutputModelImpl terminalOutputModelImpl = TerminalOutputModelImpl.this;
            boolean $i$f$map = false;
            void var5_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                StyleRange styleRange = (StyleRange)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new HighlightingInfo((int)(it.getStartOffset() - terminalOutputModelImpl.getTrimmedCharsCount()), (int)(it.getEndOffset() - terminalOutputModelImpl.getTrimmedCharsCount()), new TextStyleAdapter(it.getStyle(), this.colorPalette)));
            }
            List documentRelativeHighlightings = (List)destination$iv$iv;
            this.highlightingsSnapshot = snapshot = new TerminalOutputHighlightingsSnapshot(TerminalOutputModelImpl.this.getDocument(), documentRelativeHighlightings);
            return snapshot;
        }

        @Nullable
        public final HighlightingInfo getHighlightingAt(int documentOffset) {
            HighlightingInfo highlightingInfo;
            if (documentOffset < 0 || documentOffset >= TerminalOutputModelImpl.this.getDocument().getTextLength()) {
                return null;
            }
            long absoluteOffset = (long)documentOffset + TerminalOutputModelImpl.this.getTrimmedCharsCount();
            int index = CollectionsKt.binarySearch$default(this.styleRanges, (int)0, (int)0, arg_0 -> HighlightingsModel.getHighlightingAt$lambda$0(absoluteOffset, arg_0), (int)3, null);
            if (index >= 0) {
                StyleRange range = this.styleRanges.get(index);
                highlightingInfo = new HighlightingInfo((int)(range.getStartOffset() - TerminalOutputModelImpl.this.getTrimmedCharsCount()), (int)(range.getEndOffset() - TerminalOutputModelImpl.this.getTrimmedCharsCount()), new TextStyleAdapter(range.getStyle(), this.colorPalette));
            } else {
                highlightingInfo = null;
            }
            return highlightingInfo;
        }

        /*
         * WARNING - void declaration
         */
        public final void addHighlightings(int documentOffset, @NotNull List<StyleRange> styles) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(styles, (String)"styles");
            long absoluteOffset = (long)documentOffset + TerminalOutputModelImpl.this.getTrimmedCharsCount();
            if (!(this.styleRanges.isEmpty() || ((StyleRange)CollectionsKt.last(this.styleRanges)).getEndOffset() <= absoluteOffset)) {
                boolean $i$a$-check-TerminalOutputModelImpl$HighlightingsModel$addHighlightings$22 = false;
                String $i$a$-check-TerminalOutputModelImpl$HighlightingsModel$addHighlightings$22 = "New highlightings overlap with existing";
                throw new IllegalStateException($i$a$-check-TerminalOutputModelImpl$HighlightingsModel$addHighlightings$22.toString());
            }
            Iterable $this$map$iv = styles;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                StyleRange styleRange = (StyleRange)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new StyleRange(absoluteOffset + it.getStartOffset(), absoluteOffset + it.getEndOffset(), it.getStyle()));
            }
            List adjustedStyles = (List)destination$iv$iv;
            this.styleRanges.addAll(adjustedStyles);
            this.highlightingsSnapshot = null;
        }

        public final void insertEmptyHighlightings(int documentOffset, int length) {
            int updateFromIndex;
            long absoluteOffset = (long)documentOffset + TerminalOutputModelImpl.this.getTrimmedCharsCount();
            int styleIndex = CollectionsKt.binarySearch$default(this.styleRanges, (int)0, (int)0, arg_0 -> HighlightingsModel.insertEmptyHighlightings$lambda$0(absoluteOffset, arg_0), (int)3, null);
            int n = updateFromIndex = styleIndex < 0 ? -styleIndex - 1 : styleIndex;
            if (updateFromIndex < this.styleRanges.size()) {
                int n2 = this.styleRanges.size();
                for (int ind = updateFromIndex; ind < n2; ++ind) {
                    StyleRange cur = this.styleRanges.get(ind);
                    this.styleRanges.set(ind, new StyleRange(cur.getStartOffset() + (long)length, cur.getEndOffset() + (long)length, cur.getStyle()));
                }
                this.highlightingsSnapshot = null;
            }
        }

        public final void removeAfter(int documentOffset) {
            int ind;
            long absoluteOffset = (long)documentOffset + TerminalOutputModelImpl.this.getTrimmedCharsCount();
            int styleIndex = CollectionsKt.binarySearch$default(this.styleRanges, (int)0, (int)0, arg_0 -> HighlightingsModel.removeAfter$lambda$0(absoluteOffset, arg_0), (int)3, null);
            int removeFromIndex = styleIndex < 0 ? -styleIndex - 1 : styleIndex + 1;
            if (removeFromIndex <= (ind = this.styleRanges.size() - 1)) {
                while (true) {
                    this.styleRanges.remove(ind);
                    if (ind == removeFromIndex) break;
                    --ind;
                }
            }
            this.highlightingsSnapshot = null;
        }

        public final void removeBefore(int documentOffset) {
            long absoluteOffset = (long)documentOffset + TerminalOutputModelImpl.this.getTrimmedCharsCount();
            int styleIndex = CollectionsKt.binarySearch$default(this.styleRanges, (int)0, (int)0, arg_0 -> HighlightingsModel.removeBefore$lambda$0(absoluteOffset, arg_0), (int)3, null);
            int removeUntilHighlightingIndex = styleIndex < 0 ? -styleIndex - 1 : styleIndex;
            int n = 0;
            while (n < removeUntilHighlightingIndex) {
                int it = n++;
                boolean bl = false;
                this.styleRanges.remove(0);
            }
            this.highlightingsSnapshot = null;
        }

        /*
         * WARNING - void declaration
         */
        public final void updateHighlightings(int relativeStartOffset, int oldLength, int newLength, @NotNull List<StyleRange> styles) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(styles, (String)"styles");
            long absoluteStartOffset = (long)relativeStartOffset + TerminalOutputModelImpl.this.getTrimmedCharsCount();
            long absoluteEndOffset = absoluteStartOffset + (long)oldLength;
            int i = CollectionsKt.binarySearch$default(this.styleRanges, (int)0, (int)0, arg_0 -> HighlightingsModel.updateHighlightings$lambda$0(absoluteStartOffset, arg_0), (int)3, null);
            boolean bl = false;
            int lastUnaffectedIndexBefore = i >= 0 ? i : -i - 2;
            int i2 = CollectionsKt.binarySearch$default(this.styleRanges, (int)0, (int)0, arg_0 -> HighlightingsModel.updateHighlightings$lambda$2(absoluteEndOffset, arg_0), (int)3, null);
            boolean bl2 = false;
            int firstUnaffectedIndexAfter = i2 >= 0 ? i2 : -i2 - 1;
            int shift = newLength - oldLength;
            this.shift(firstUnaffectedIndexAfter, shift);
            this.updateAffectedRanges(RangesKt.until((int)(lastUnaffectedIndexBefore + 1), (int)firstUnaffectedIndexAfter), RangesKt.until((long)absoluteStartOffset, (long)absoluteEndOffset), shift);
            int i3 = CollectionsKt.binarySearch$default(this.styleRanges, (int)0, (int)0, arg_0 -> HighlightingsModel.updateHighlightings$lambda$4(absoluteEndOffset, shift, arg_0), (int)3, null);
            boolean bl3 = false;
            int insertionIndex = i3 >= 0 ? i3 : -i3 - 1;
            Iterable $this$map$iv = styles;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void styleRange;
                StyleRange styleRange2 = (StyleRange)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(StyleRange.copy$default((StyleRange)styleRange, (long)(styleRange.getStartOffset() + absoluteStartOffset), (long)(styleRange.getEndOffset() + absoluteStartOffset), null, (int)4, null));
            }
            List absoluteStyles = (List)destination$iv$iv;
            this.styleRanges.addAll(insertionIndex, absoluteStyles);
        }

        private final void shift(int shiftFromIndex, int shift) {
            if (shift == 0) {
                return;
            }
            int n = this.styleRanges.size();
            for (int i = shiftFromIndex; i < n; ++i) {
                StyleRange styleRange = this.styleRanges.get(i);
                this.styleRanges.set(i, StyleRange.copy$default((StyleRange)styleRange, (long)(styleRange.getStartOffset() + (long)shift), (long)(styleRange.getEndOffset() + (long)shift), null, (int)4, null));
            }
        }

        private final void updateAffectedRanges(IntRange affectedIndexes, LongRange affectedAbsoluteOffsets, int shift) {
            if (affectedIndexes.isEmpty()) {
                return;
            }
            long absoluteStartOffset = affectedAbsoluteOffsets.getFirst();
            long absoluteEndOffset = affectedAbsoluteOffsets.getLast() + 1L;
            List<StyleRange> affectedRanges = this.styleRanges.subList(affectedIndexes.getFirst(), affectedIndexes.getLast() + 1);
            List updatedRanges = new ArrayList();
            for (StyleRange range : affectedRanges) {
                if (range.getStartOffset() < absoluteStartOffset && range.getEndOffset() <= absoluteEndOffset) {
                    updatedRanges.add(StyleRange.copy$default((StyleRange)range, (long)0L, (long)absoluteStartOffset, null, (int)5, null));
                    continue;
                }
                long l = affectedAbsoluteOffsets.getFirst();
                long l2 = affectedAbsoluteOffsets.getLast();
                long l3 = range.getStartOffset();
                boolean bl = l <= l3 ? l3 <= l2 : false;
                if (bl && range.getEndOffset() > absoluteEndOffset) {
                    updatedRanges.add(StyleRange.copy$default((StyleRange)range, (long)(absoluteEndOffset + (long)shift), (long)(range.getEndOffset() + (long)shift), null, (int)4, null));
                    continue;
                }
                if (range.getStartOffset() >= absoluteStartOffset || range.getEndOffset() <= absoluteEndOffset) continue;
                updatedRanges.add(StyleRange.copy$default((StyleRange)range, (long)0L, (long)absoluteStartOffset, null, (int)5, null));
                updatedRanges.add(StyleRange.copy$default((StyleRange)range, (long)(absoluteEndOffset + (long)shift), (long)(range.getEndOffset() + (long)shift), null, (int)4, null));
            }
            affectedRanges.clear();
            affectedRanges.addAll(updatedRanges);
        }

        @NotNull
        public final List<StyleRange> dumpState() {
            return CollectionsKt.toList((Iterable)this.styleRanges);
        }

        public final void restoreFromState(@NotNull List<StyleRange> state) {
            Intrinsics.checkNotNullParameter(state, (String)"state");
            this.styleRanges.clear();
            this.styleRanges.addAll((Collection<StyleRange>)state);
            this.highlightingsSnapshot = null;
        }

        private static final int getHighlightingAt$lambda$0(long $absoluteOffset, StyleRange it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getEndOffset() <= $absoluteOffset ? -1 : (it.getStartOffset() > $absoluteOffset ? 1 : 0);
        }

        private static final int insertEmptyHighlightings$lambda$0(long $absoluteOffset, StyleRange it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.compare((long)it.getStartOffset(), (long)$absoluteOffset);
        }

        private static final int removeAfter$lambda$0(long $absoluteOffset, StyleRange it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.compare((long)it.getEndOffset(), (long)$absoluteOffset);
        }

        private static final int removeBefore$lambda$0(long $absoluteOffset, StyleRange it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.compare((long)it.getStartOffset(), (long)$absoluteOffset);
        }

        private static final int updateHighlightings$lambda$0(long $absoluteStartOffset, StyleRange it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.compare((long)it.getEndOffset(), (long)$absoluteStartOffset);
        }

        private static final int updateHighlightings$lambda$2(long $absoluteEndOffset, StyleRange it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.compare((long)it.getStartOffset(), (long)$absoluteEndOffset);
        }

        private static final int updateHighlightings$lambda$4(long $absoluteEndOffset, int $shift, StyleRange it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.compare((long)it.getStartOffset(), (long)($absoluteEndOffset + (long)$shift));
        }
    }
}

