/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.station.comms.common.netty.server;

import com.intellij.station.comms.common.ServicesServerHostApplication;
import com.intellij.station.comms.common.netty.server.RootHandler;
import com.intellij.station.comms.common.netty.util.ExtensionsKt;
import com.intellij.station.comms.common.netty.util.NettyThreadFactory;
import com.intellij.station.comms.common.utils.Logging;
import com.intellij.station.comms.common.utils.StationConstants;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.nio.NioDomainSocketChannel;
import io.netty.channel.socket.nio.NioServerDomainSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.SocketAddress;
import java.net.UnixDomainSocketAddress;
import java.nio.channels.spi.SelectorProvider;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/station/comms/common/netty/server/NettyServicesServerBase;", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "hostApplication", "Lcom/intellij/station/comms/common/ServicesServerHostApplication;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/station/comms/common/ServicesServerHostApplication;)V", "runningStateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "serverAttemptFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "isRunning", "Lkotlinx/coroutines/flow/StateFlow;", "()Lkotlinx/coroutines/flow/StateFlow;", "eventLoop", "Lio/netty/channel/MultiThreadIoEventLoopGroup;", "Companion", "intellij.station.comms.common"})
@SourceDebugExtension(value={"SMAP\nNettyServicesServerBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NettyServicesServerBase.kt\ncom/intellij/station/comms/common/netty/server/NettyServicesServerBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Logging.kt\ncom/intellij/station/comms/common/utils/Logging\n*L\n1#1,159:1\n1#2:160\n7#3:161\n*S KotlinDebug\n*F\n+ 1 NettyServicesServerBase.kt\ncom/intellij/station/comms/common/netty/server/NettyServicesServerBase\n*L\n45#1:161\n*E\n"})
public final class NettyServicesServerBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final ServicesServerHostApplication hostApplication;
    @NotNull
    private final MutableStateFlow<Boolean> runningStateFlow;
    @NotNull
    private final MutableSharedFlow<Unit> serverAttemptFlow;
    @NotNull
    private final StateFlow<Boolean> isRunning;
    @NotNull
    private final MultiThreadIoEventLoopGroup eventLoop;
    public static final int MAX_CONTENT_LENGTH_BYTES = 0xA00000;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final AttributeKey<ChannelHandler> DEFAULT_HANDLER;
    @NotNull
    private static final AtomicInteger serversCounter;

    /*
     * WARNING - void declaration
     */
    public NettyServicesServerBase(@NotNull CoroutineScope scope, @NotNull ServicesServerHostApplication hostApplication) {
        void it;
        MutableSharedFlow mutableSharedFlow;
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)hostApplication, (String)"hostApplication");
        this.scope = scope;
        this.hostApplication = hostApplication;
        this.runningStateFlow = StateFlowKt.MutableStateFlow((Object)false);
        MutableSharedFlow mutableSharedFlow2 = mutableSharedFlow = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, null, (int)6, null);
        NettyServicesServerBase nettyServicesServerBase = this;
        boolean bl = false;
        it.tryEmit((Object)Unit.INSTANCE);
        nettyServicesServerBase.serverAttemptFlow = mutableSharedFlow;
        this.isRunning = (StateFlow)this.runningStateFlow;
        this.eventLoop = new MultiThreadIoEventLoopGroup(3, (ThreadFactory)new NettyThreadFactory("Netty Station Server", serversCounter), NioIoHandler.newFactory((SelectorProvider)SelectorProvider.provider()));
        UnixDomainSocketAddress endpoint = this.hostApplication.getBindAddress();
        UnixDomainSocketAddress linkAddress = this.hostApplication.getAdditionalLinkAddress();
        Set<PosixFilePermission> permissions = PosixFilePermissions.fromString("rwx------");
        logger.info("Starting services server on " + endpoint.getPath());
        Files.deleteIfExists(endpoint.getPath());
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ NettyServicesServerBase this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = DelayKt.awaitCancellation((Continuation)((Continuation)this));
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        Object object2;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            object2 = $result;
                            throw new KotlinNothingValueException();
                        }
                        catch (Throwable throwable) {
                            this.this$0.eventLoop.shutdownGracefully().await();
                            throw throwable;
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, endpoint, permissions, linkAddress, null){
            int label;
            final /* synthetic */ NettyServicesServerBase this$0;
            final /* synthetic */ UnixDomainSocketAddress $endpoint;
            final /* synthetic */ Set<PosixFilePermission> $permissions;
            final /* synthetic */ UnixDomainSocketAddress $linkAddress;
            {
                this.this$0 = $receiver;
                this.$endpoint = $endpoint;
                this.$permissions = $permissions;
                this.$linkAddress = $linkAddress;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)((Flow)this.this$0.serverAttemptFlow), (Function2)((Function2)new Function2<Unit, Continuation<? super Unit>, Object>(this.this$0, this.$endpoint, this.$permissions, this.$linkAddress, null){
                            Object L$0;
                            Object L$1;
                            int label;
                            final /* synthetic */ NettyServicesServerBase this$0;
                            final /* synthetic */ UnixDomainSocketAddress $endpoint;
                            final /* synthetic */ Set<PosixFilePermission> $permissions;
                            final /* synthetic */ UnixDomainSocketAddress $linkAddress;
                            {
                                this.this$0 = $receiver;
                                this.$endpoint = $endpoint;
                                this.$permissions = $permissions;
                                this.$linkAddress = $linkAddress;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        bootstrap = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)NettyServicesServerBase.access$getEventLoop$p(this.this$0)).channel(NioServerDomainSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(NettyServicesServerBase.class, LogLevel.INFO))).childHandler((ChannelHandler)new ChannelInitializer<NioDomainSocketChannel>(this.this$0){
                                            final /* synthetic */ NettyServicesServerBase this$0;
                                            {
                                                this.this$0 = $receiver;
                                            }

                                            protected void initChannel(NioDomainSocketChannel ch) {
                                                Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
                                                ChannelPipeline pipeline = ch.pipeline();
                                                ChannelHandler[] channelHandlerArray = new ChannelHandler[]{new HttpServerCodec()};
                                                pipeline.addLast(channelHandlerArray);
                                                channelHandlerArray = new ChannelHandler[]{new HttpObjectAggregator(0xA00000)};
                                                pipeline.addLast(channelHandlerArray);
                                                RootHandler defaultHandler = new RootHandler(NettyServicesServerBase.access$getScope$p(this.this$0), NettyServicesServerBase.access$getHostApplication$p(this.this$0));
                                                ChannelHandler[] channelHandlerArray2 = new ChannelHandler[]{defaultHandler};
                                                pipeline.addLast(channelHandlerArray2);
                                                pipeline.channel().attr(NettyServicesServerBase.Companion.getDEFAULT_HANDLER()).set((Object)((Object)defaultHandler));
                                            }
                                        });
                                        channel = null;
                                        v0 = bootstrap.bind((SocketAddress)this.$endpoint);
                                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"bind(...)");
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)bootstrap);
                                        this.label = 1;
                                        v1 = ExtensionsKt.awaitSuspend(v0, (Continuation<? super Channel>)((Continuation)this));
                                        ** if (v1 != var9_2) goto lbl16
lbl15:
                                        // 1 sources

                                        return var9_2;
lbl16:
                                        // 1 sources

                                        ** GOTO lbl24
                                    }
                                    case 1: {
                                        channel = null;
                                        bootstrap = (ServerBootstrap)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
lbl24:
                                        // 2 sources

                                        channel = (Channel)v1;
                                        if (StationConstants.INSTANCE.isLinux()) {
                                            try {
                                                Files.setPosixFilePermissions(this.$endpoint.getPath(), this.$permissions);
                                            }
                                            catch (UnsupportedOperationException ex) {
                                                NettyServicesServerBase.access$getLogger$cp().debug("POSIX permissions are not supported", (Throwable)ex);
                                            }
                                            catch (Exception ex) {
                                                $i$f$currentCoroutineContext = false;
                                                JobKt.ensureActive((CoroutineContext)this.getContext());
                                                NettyServicesServerBase.access$getLogger$cp().error("Unable to set station socket permissions:", (Throwable)ex);
                                            }
                                        }
                                        NettyServicesServerBase.access$getLogger$cp().info("Services server started");
                                        NettyServicesServerBase.access$getRunningStateFlow$p(this.this$0).setValue((Object)Boxing.boxBoolean((boolean)true));
                                        channel.closeFuture().addListener((GenericFutureListener)LambdaMetafactory.metafactory(null, null, null, (Lio/netty/util/concurrent/Future;)V, invokeSuspend$lambda$0(com.intellij.station.comms.common.netty.server.NettyServicesServerBase io.netty.util.concurrent.Future ), (Lio/netty/util/concurrent/Future;)V)((NettyServicesServerBase)this.this$0));
                                        if (this.$linkAddress != null) {
                                            try {
                                                Files.deleteIfExists(this.$linkAddress.getPath());
                                                Files.createSymbolicLink(this.$linkAddress.getPath(), this.$endpoint.getPath(), new FileAttribute[0]);
                                            }
                                            catch (Exception ex) {
                                                NettyServicesServerBase.access$getLogger$cp().warn("Unable to create link " + this.$linkAddress.getPath() + " -> " + this.$endpoint.getPath(), (Throwable)ex);
                                            }
                                        }
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)bootstrap);
                                        this.L$1 = channel;
                                        this.label = 2;
                                        v2 = DelayKt.awaitCancellation((Continuation)((Continuation)this));
                                        ** if (v2 != var9_2) goto lbl59
lbl58:
                                        // 1 sources

                                        return var9_2;
lbl59:
                                        // 1 sources

                                        ** GOTO lbl67
                                    }
                                    case 2: {
                                        channel = (Channel)this.L$1;
                                        bootstrap = (ServerBootstrap)this.L$0;
                                        try {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v2 = $result;
lbl67:
                                            // 2 sources

                                            throw new KotlinNothingValueException();
                                        }
                                        catch (Throwable var4_11) {
                                            NettyServicesServerBase.access$getLogger$cp().info("Shutting down services server");
                                            v3 = channel;
                                            if (v3 != null) {
                                                v3.close();
                                            }
                                            Files.deleteIfExists(this.$endpoint.getPath());
                                            v4 = this.$linkAddress;
                                            if (v4 != null) {
                                                it = v4;
                                                $i$a$-let-NettyServicesServerBase$2$1$2 = false;
                                                Boxing.boxBoolean((boolean)Files.deleteIfExists(it.getPath()));
                                            }
                                            throw var4_11;
                                        }
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(Unit p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }

                            private static final void invokeSuspend$lambda$0(NettyServicesServerBase this$0, Future it) {
                                logger.info("Services server shut down");
                                this$0.runningStateFlow.setValue((Object)false);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, endpoint, null){
            int label;
            final /* synthetic */ NettyServicesServerBase this$0;
            final /* synthetic */ UnixDomainSocketAddress $endpoint;
            {
                this.this$0 = $receiver;
                this.$endpoint = $endpoint;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)((Flow)this.this$0.runningStateFlow), (Function2)((Function2)new Function2<Boolean, Continuation<? super Unit>, Object>(this.$endpoint, this.this$0, null){
                            Object L$0;
                            int label;
                            /* synthetic */ boolean Z$0;
                            final /* synthetic */ UnixDomainSocketAddress $endpoint;
                            final /* synthetic */ NettyServicesServerBase this$0;
                            {
                                this.$endpoint = $endpoint;
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var2_2 = this.Z$0;
                                var4_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        if (it == false) {
                                            return Unit.INSTANCE;
                                        }
lbl8:
                                        // 6 sources

                                        while (true) {
                                            this.L$0 = null;
                                            this.Z$0 = it;
                                            this.label = 1;
                                            v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), (Continuation)((Continuation)this));
                                            if (v0 == var4_3) {
                                                return var4_3;
                                            }
                                            ** GOTO lbl20
                                            break;
                                        }
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl20:
                                        // 2 sources

                                        try {
                                            v1 = this.$endpoint.getPath();
                                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getPath(...)");
                                            NettyServicesServerBase.Companion.bumpModificationTime(v1);
                                            ** GOTO lbl8
                                        }
                                        catch (IOException ex) {
                                            if (!(ex instanceof NoSuchFileException) && !(ex instanceof FileNotFoundException)) break;
                                            NettyServicesServerBase.access$getLogger$cp().warn("Station server socket file at " + this.$endpoint.getPath() + " not found, will restart server");
                                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)ex);
                                            this.Z$0 = it;
                                            this.label = 2;
                                            v2 = NettyServicesServerBase.access$getServerAttemptFlow$p(this.this$0).emit((Object)Unit.INSTANCE, (Continuation)this);
                                            if (v2 != var4_3) ** GOTO lbl8
                                            return var4_3;
                                        }
                                    }
                                    case 2: {
                                        ex = (IOException)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v2 = $result;
                                        ** GOTO lbl8
                                    }
                                }
                                NettyServicesServerBase.access$getLogger$cp().error("Unexpected IO error watching station server socket file at " + this.$endpoint.getPath(), (Throwable)ex);
                                ** while (true)
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.Z$0 = (Boolean)value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(boolean p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final StateFlow<Boolean> isRunning() {
        return this.isRunning;
    }

    public static final /* synthetic */ CoroutineScope access$getScope$p(NettyServicesServerBase $this) {
        return $this.scope;
    }

    public static final /* synthetic */ ServicesServerHostApplication access$getHostApplication$p(NettyServicesServerBase $this) {
        return $this.hostApplication;
    }

    static {
        Logging logging = Logging.INSTANCE;
        Companion $this$myLogger$iv = Companion;
        boolean $i$f$myLogger = false;
        Logger logger = LoggerFactory.getLogger(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        NettyServicesServerBase.logger = logger;
        AttributeKey attributeKey = AttributeKey.valueOf((String)"default.channel.handler");
        Intrinsics.checkNotNullExpressionValue((Object)attributeKey, (String)"valueOf(...)");
        DEFAULT_HANDLER = attributeKey;
        serversCounter = new AtomicInteger();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/station/comms/common/netty/server/NettyServicesServerBase$Companion;", "", "<init>", "()V", "MAX_CONTENT_LENGTH_BYTES", "", "logger", "Lorg/slf4j/Logger;", "DEFAULT_HANDLER", "Lio/netty/util/AttributeKey;", "Lio/netty/channel/ChannelHandler;", "getDEFAULT_HANDLER", "()Lio/netty/util/AttributeKey;", "serversCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "bumpModificationTime", "", "path", "Ljava/nio/file/Path;", "intellij.station.comms.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeKey<ChannelHandler> getDEFAULT_HANDLER() {
            return DEFAULT_HANDLER;
        }

        @VisibleForTesting
        public final void bumpModificationTime(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            path.toFile().setLastModified(System.currentTimeMillis());
            if (!Files.exists(path, new LinkOption[0])) {
                throw new NoSuchFileException(((Object)path).toString());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

