/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.core.nio.fs;

import com.intellij.platform.core.nio.fs.BasicFileAttributesHolder2;
import com.intellij.platform.core.nio.fs.CorePath;
import com.intellij.platform.core.nio.fs.DelegatingFileSystem;
import com.intellij.platform.core.nio.fs.MultiRoutingFsPath;
import com.intellij.platform.core.nio.fs.RoutingAwareFileSystemProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DelegatingFileSystemProvider<P extends DelegatingFileSystemProvider<P, F>, F extends DelegatingFileSystem<P>>
extends FileSystemProvider
implements RoutingAwareFileSystemProvider {
    @NotNull
    public abstract F wrapDelegateFileSystem(@NotNull FileSystem var1);

    @NotNull
    protected abstract FileSystemProvider getDelegate(@Nullable Path var1, @Nullable Path var2);

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    protected abstract Path wrapDelegatePath(@Nullable Path var1);

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    protected abstract Path toDelegatePath(@Nullable Path var1);

    @Override
    public boolean canHandleRouting(@NotNull Path path) {
        RoutingAwareFileSystemProvider rafsp;
        if (path == null) {
            DelegatingFileSystemProvider.$$$reportNull$$$0(0);
        }
        FileSystemProvider delegate = this.getDelegate(path, null);
        return path.getFileSystem().provider().equals(delegate) || delegate instanceof RoutingAwareFileSystemProvider && (rafsp = (RoutingAwareFileSystemProvider)((Object)delegate)).canHandleRouting(path);
    }

    @Nullable
    public F newFileSystem(Path path, Map<String, ?> env) throws IOException {
        return this.wrapDelegateFileSystem(this.getDelegate(path, null).newFileSystem(this.toDelegatePath(path), env));
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        return this.getDelegate(path, null).newInputStream(this.toDelegatePath(path), options);
    }

    @Override
    public OutputStream newOutputStream(Path path, OpenOption ... options) throws IOException {
        return this.getDelegate(path, null).newOutputStream(this.toDelegatePath(path), options);
    }

    @Override
    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return this.getDelegate(path, null).newFileChannel(this.toDelegatePath(path), options, attrs);
    }

    @Override
    public AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set<? extends OpenOption> options, ExecutorService executor, FileAttribute<?> ... attrs) throws IOException {
        return this.getDelegate(path, null).newAsynchronousFileChannel(this.toDelegatePath(path), options, executor, attrs);
    }

    @Override
    public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
        this.getDelegate(link, target).createSymbolicLink(this.toDelegatePath(link), this.toDelegatePath(target), attrs);
    }

    @Override
    public void createLink(Path link, Path existing) throws IOException {
        this.getDelegate(link, existing).createLink(this.toDelegatePath(link), this.toDelegatePath(existing));
    }

    @Override
    public boolean deleteIfExists(Path path) throws IOException {
        return this.getDelegate(path, null).deleteIfExists(this.toDelegatePath(path));
    }

    @Override
    public Path readSymbolicLink(Path link) throws IOException {
        return this.wrapDelegatePath(this.getDelegate(link, null).readSymbolicLink(this.toDelegatePath(link)));
    }

    @Override
    public String getScheme() {
        return this.getDelegate(null, null).getScheme();
    }

    @Nullable
    public F newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        return this.wrapDelegateFileSystem(this.getDelegate(null, null).newFileSystem(uri, env));
    }

    @NotNull
    public F getFileSystem(URI uri) {
        F f = this.wrapDelegateFileSystem(this.getDelegate(null, null).getFileSystem(uri));
        if (f == null) {
            DelegatingFileSystemProvider.$$$reportNull$$$0(1);
        }
        return f;
    }

    @Override
    @NotNull
    public Path getPath(@NotNull URI uri) {
        if (uri == null) {
            DelegatingFileSystemProvider.$$$reportNull$$$0(2);
        }
        Path path = this.wrapDelegatePath(this.getDelegate(null, null).getPath(uri));
        if (path == null) {
            DelegatingFileSystemProvider.$$$reportNull$$$0(3);
        }
        return path;
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return this.getDelegate(path, null).newByteChannel(this.toDelegatePath(path), options, attrs);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(final Path dir, final @Nullable DirectoryStream.Filter<? super Path> filter) throws IOException {
        return new DirectoryStream<Path>(){
            final DirectoryStream<Path> myStream;
            {
                this.myStream = DelegatingFileSystemProvider.this.getDelegate(dir, null).newDirectoryStream(DelegatingFileSystemProvider.this.toDelegatePath(dir), DelegatingFileSystemProvider.this.craftFilter(filter));
            }

            @Override
            public Iterator<Path> iterator() {
                return new Iterator<Path>(){
                    final Iterator<Path> myIterator;
                    {
                        this.myIterator = myStream.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.myIterator.hasNext();
                    }

                    @Override
                    public Path next() {
                        return DelegatingFileSystemProvider.this.wrapDelegatePath(this.myIterator.next());
                    }
                };
            }

            @Override
            public void close() throws IOException {
                this.myStream.close();
            }
        };
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    private DirectoryStream.Filter<? super Path> craftFilter(@Nullable DirectoryStream.Filter<? super Path> originalFilter) {
        if (originalFilter == null) {
            return null;
        }
        if (BasicFileAttributesHolder2.FetchAttributesFilter.isFetchAttributesFilter(originalFilter)) {
            return p -> originalFilter.accept(this.wrapDelegatePath((Path)p));
        }
        return p -> originalFilter.accept(this.wrapDelegatePath((Path)p));
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        this.getDelegate(dir, null).createDirectory(this.toDelegatePath(dir), attrs);
    }

    @Override
    public void delete(Path path) throws IOException {
        this.getDelegate(path, null).delete(this.toDelegatePath(path));
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        this.getDelegate(source, target).copy(this.toDelegatePath(source), this.toDelegatePath(target), options);
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        this.getDelegate(source, target).move(this.toDelegatePath(source), this.toDelegatePath(target), options);
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        return this.getDelegate(path, path2).isSameFile(this.toDelegatePath(path), this.toDelegatePath(path2));
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        return this.getDelegate(path, null).isHidden(this.toDelegatePath(path));
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        return this.getDelegate(path, null).getFileStore(this.toDelegatePath(path));
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        this.getDelegate(path, null).checkAccess(this.toDelegatePath(path), modes);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        return this.getDelegate(path, null).getFileAttributeView(this.toDelegatePath(path), type, options);
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        return this.getDelegate(path, null).readAttributes(this.toDelegatePath(path), type, options);
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        return this.getDelegate(path, null).readAttributes(this.toDelegatePath(path), attributes, options);
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        this.getDelegate(path, null).setAttribute(this.toDelegatePath(path), attribute, value, options);
    }

    public byte[] getSunPathForSocketFile(Path path) {
        FileSystemProvider provider = this.getDelegate(path, null);
        Path path1 = path;
        if (path1 instanceof CorePath) {
            path1 = ((CorePath)path1).getDelegate();
        } else if (path1 instanceof MultiRoutingFsPath) {
            path1 = ((MultiRoutingFsPath)path1).getInitialDelegate();
        }
        try {
            Method method = provider.getClass().getMethod("getSunPathForSocketFile", Path.class);
            method.setAccessible(true);
            Object result = method.invoke((Object)provider, path1);
            return (byte[])result;
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new Error("Can't find getSunPathForSocketFile(Path) in the non-default file system provider " + String.valueOf(provider.getClass()));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Can't invoke getSunPathForSocketFile(Path) from a non-default file system provider", e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/core/nio/fs/DelegatingFileSystemProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/core/nio/fs/DelegatingFileSystemProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canHandleRouting";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }
}

