/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.core.nio.fs;

import com.intellij.platform.core.nio.fs.DelegatingFileSystemProvider;
import com.intellij.platform.core.nio.fs.MultiRoutingFileSystem;
import com.intellij.platform.core.nio.fs.MultiRoutingFsPath;
import com.intellij.platform.core.nio.fs.RoutingAwareFileSystemProvider;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.nio.file.spi.FileTypeDetector;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import sun.nio.fs.DefaultFileTypeDetector;

public final class MultiRoutingFileSystemProvider
extends DelegatingFileSystemProvider<MultiRoutingFileSystemProvider, MultiRoutingFileSystem> {
    static final boolean ourForceDefaultFs = Objects.equals(System.getProperty("idea.force.default.filesystem"), "true");
    @VisibleForTesting
    public final FileSystemProvider myLocalProvider;
    private final MultiRoutingFileSystem myFileSystem;
    private static final String KEY_MRFS = "MRFS";
    private static final String KEY_COMPUTE_FN = "KEY_COMPUTE_FN";
    private static final String KEY_GET_CUSTOM_ROOTS_FN = "KEY_GET_CUSTOM_ROOTS_FN";
    private static final String KEY_GET_CUSTOM_FILE_STORES_FN = "KEY_GET_CUSTOM_FILE_STORES_FN";

    @NotNull
    public MultiRoutingFileSystem getTheOnlyFileSystem() {
        MultiRoutingFileSystem multiRoutingFileSystem = this.myFileSystem;
        if (multiRoutingFileSystem == null) {
            MultiRoutingFileSystemProvider.$$$reportNull$$$0(0);
        }
        return multiRoutingFileSystem;
    }

    public MultiRoutingFileSystemProvider(FileSystemProvider localFSProvider) {
        this.myLocalProvider = localFSProvider;
        this.myFileSystem = new MultiRoutingFileSystem(this, this.myLocalProvider.getFileSystem(URI.create("file:///")));
    }

    @Override
    @NotNull
    public MultiRoutingFileSystem wrapDelegateFileSystem(@NotNull FileSystem delegateFs) {
        if (delegateFs == null) {
            MultiRoutingFileSystemProvider.$$$reportNull$$$0(1);
        }
        return new MultiRoutingFileSystem(this, delegateFs);
    }

    @Override
    @Nullable
    public MultiRoutingFileSystem newFileSystem(Path path, @Nullable Map<String, ?> env) {
        throw new UnsupportedOperationException(MultiRoutingFileSystemProvider.class.getName() + " doesn't open other files as filesystems");
    }

    @Override
    @Nullable
    public MultiRoutingFileSystem newFileSystem(URI uri, @Nullable Map<String, ?> env) {
        if (env == null || !env.containsKey(KEY_MRFS)) {
            throw new UnsupportedOperationException(MultiRoutingFileSystem.class.getName() + " can be created only with `" + MultiRoutingFileSystemProvider.class.getName() + ".computeBackend()`. Otherwise, this file system provider behaves as a default file system provider and throws an error.");
        }
        BiFunction computeFn = Objects.requireNonNull((BiFunction)env.get(KEY_COMPUTE_FN));
        Function getCustomRootsFn = Objects.requireNonNull((Function)env.get(KEY_GET_CUSTOM_ROOTS_FN));
        Function getCustomFileStoresFn = Objects.requireNonNull((Function)env.get(KEY_GET_CUSTOM_FILE_STORES_FN));
        this.myFileSystem.setBackendProvider(computeFn, getCustomRootsFn, getCustomFileStoresFn);
        return null;
    }

    @Override
    @NotNull
    public MultiRoutingFileSystem getFileSystem(@NotNull URI uri) {
        if (uri == null) {
            MultiRoutingFileSystemProvider.$$$reportNull$$$0(2);
        }
        if (uri.equals(URI.create("file:///"))) {
            MultiRoutingFileSystem multiRoutingFileSystem = this.myFileSystem;
            if (multiRoutingFileSystem == null) {
                MultiRoutingFileSystemProvider.$$$reportNull$$$0(3);
            }
            return multiRoutingFileSystem;
        }
        throw new UnsupportedOperationException(String.format("Unexpected URI: %s\nThis class is supposed to replace the local file system.", uri));
    }

    @Override
    @NotNull
    protected FileSystemProvider getDelegate(@Nullable Path path1, @Nullable Path path2) {
        String path2String;
        FileSystem backend2;
        FileSystemProvider provider2;
        if (ourForceDefaultFs) {
            FileSystemProvider fileSystemProvider = this.myLocalProvider;
            if (fileSystemProvider == null) {
                MultiRoutingFileSystemProvider.$$$reportNull$$$0(4);
            }
            return fileSystemProvider;
        }
        if (path1 == null) {
            if (path2 == null) {
                FileSystemProvider fileSystemProvider = this.myLocalProvider;
                if (fileSystemProvider == null) {
                    MultiRoutingFileSystemProvider.$$$reportNull$$$0(5);
                }
                return fileSystemProvider;
            }
            path1 = path2;
            path2 = null;
        }
        if (!path1.isAbsolute()) {
            path1 = path1.toAbsolutePath();
        }
        String path1String = path1.toString();
        FileSystem backend1 = this.myFileSystem.getBackend(path1String);
        FileSystemProvider provider1 = backend1.provider();
        if (path2 == null) {
            FileSystemProvider fileSystemProvider = provider1;
            if (fileSystemProvider == null) {
                MultiRoutingFileSystemProvider.$$$reportNull$$$0(6);
            }
            return fileSystemProvider;
        }
        if (!path2.isAbsolute()) {
            path2 = path2.toAbsolutePath();
        }
        if (provider1.equals(provider2 = (backend2 = this.myFileSystem.getBackend(path2String = path2.toString())).provider())) {
            FileSystemProvider fileSystemProvider = provider1;
            if (fileSystemProvider == null) {
                MultiRoutingFileSystemProvider.$$$reportNull$$$0(7);
            }
            return fileSystemProvider;
        }
        if (MultiRoutingFileSystemProvider.canHandleRouting(provider1, backend2.getPath(path2String, new String[0]))) {
            FileSystemProvider fileSystemProvider = provider1;
            if (fileSystemProvider == null) {
                MultiRoutingFileSystemProvider.$$$reportNull$$$0(8);
            }
            return fileSystemProvider;
        }
        if (MultiRoutingFileSystemProvider.canHandleRouting(provider2, backend1.getPath(path1String, new String[0]))) {
            FileSystemProvider fileSystemProvider = provider2;
            if (fileSystemProvider == null) {
                MultiRoutingFileSystemProvider.$$$reportNull$$$0(9);
            }
            return fileSystemProvider;
        }
        throw new IllegalArgumentException(String.format("Provider mismatch: %s != %s", provider1, provider2));
    }

    private static boolean canHandleRouting(FileSystemProvider provider, @NotNull Path path) {
        if (path == null) {
            MultiRoutingFileSystemProvider.$$$reportNull$$$0(10);
        }
        if (provider instanceof RoutingAwareFileSystemProvider) {
            RoutingAwareFileSystemProvider rafsp = (RoutingAwareFileSystemProvider)((Object)provider);
            return rafsp.canHandleRouting(path);
        }
        return false;
    }

    @Override
    @Contract(value="null -> null; !null -> !null")
    @VisibleForTesting
    @Nullable
    public Path wrapDelegatePath(@Nullable Path delegatePath) {
        if (delegatePath == null) {
            return null;
        }
        if (delegatePath instanceof MultiRoutingFsPath) {
            return delegatePath;
        }
        return new MultiRoutingFsPath(this.myFileSystem, delegatePath);
    }

    @NotNull
    private static FileTypeDetector getDefaultFileTypeDetector() {
        FileTypeDetector fileTypeDetector;
        try {
            fileTypeDetector = DefaultFileTypeDetector.create();
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            return new FileTypeDetector(){

                @Override
                public String probeContentType(Path path) {
                    return null;
                }
            };
        }
        if (fileTypeDetector == null) {
            MultiRoutingFileSystemProvider.$$$reportNull$$$0(11);
        }
        return fileTypeDetector;
    }

    @NotNull
    static FileTypeDetector getFileTypeDetector(FileSystemProvider multiRoutingFileSystemProvider) {
        FileTypeDetector fileTypeDetector;
        if (multiRoutingFileSystemProvider instanceof MultiRoutingFileSystemProvider) {
            MultiRoutingFileSystemProvider provider = (MultiRoutingFileSystemProvider)multiRoutingFileSystemProvider;
            try {
                fileTypeDetector = provider.getFileTypeDetectorInternal();
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace(System.err);
                fileTypeDetector = MultiRoutingFileSystemProvider.getDefaultFileTypeDetector();
            }
        } else {
            fileTypeDetector = MultiRoutingFileSystemProvider.getDefaultFileTypeDetector();
        }
        FileTypeDetector fileTypeDetector2 = fileTypeDetector;
        if (fileTypeDetector2 == null) {
            MultiRoutingFileSystemProvider.$$$reportNull$$$0(12);
        }
        return fileTypeDetector2;
    }

    private FileTypeDetector getFileTypeDetectorInternal() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        FileTypeDetector delegateDetector;
        Class<? extends FileSystemProvider> unixFileSystemProviderClass = this.getUnixFileSystemProviderClass();
        if (unixFileSystemProviderClass != null) {
            Method getFileTypeDetectorMethod = unixFileSystemProviderClass.getDeclaredMethod("getFileTypeDetector", new Class[0]);
            getFileTypeDetectorMethod.setAccessible(true);
            delegateDetector = (FileTypeDetector)getFileTypeDetectorMethod.invoke((Object)this.myLocalProvider, new Object[0]);
        } else {
            delegateDetector = MultiRoutingFileSystemProvider.getDefaultFileTypeDetector();
        }
        return new FileTypeDetector(){

            @Override
            public String probeContentType(Path path) throws IOException {
                return delegateDetector.probeContentType(MultiRoutingFileSystemProvider.this.toDelegatePath(path));
            }
        };
    }

    @Nullable
    private Class<? extends FileSystemProvider> getUnixFileSystemProviderClass() {
        Class<Object> unixFileSystemProviderClass = this.myLocalProvider.getClass();
        while (unixFileSystemProviderClass != null && !"sun.nio.fs.UnixFileSystemProvider".equals(unixFileSystemProviderClass.getName())) {
            Class<?> superclass = unixFileSystemProviderClass.getSuperclass();
            if (FileSystemProvider.class.isAssignableFrom(superclass)) {
                unixFileSystemProviderClass = superclass.asSubclass(FileSystemProvider.class);
                continue;
            }
            unixFileSystemProviderClass = null;
        }
        return unixFileSystemProviderClass;
    }

    @Override
    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public Path toDelegatePath(@Nullable Path path) {
        if (path instanceof MultiRoutingFsPath) {
            return ((MultiRoutingFsPath)path).getCurrentDelegate();
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/core/nio/fs/MultiRoutingFileSystemProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegateFs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTheOnlyFileSystem";
                break;
            }
            case 1: 
            case 2: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/core/nio/fs/MultiRoutingFileSystemProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFileTypeDetector";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeDetector";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "wrapDelegateFileSystem";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFileSystem";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "canHandleRouting";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 10 -> new IllegalArgumentException(string);
        };
    }
}

