/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.utils;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginInfoProvider;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginUtils;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.internal.statistic.FeaturedPluginsInfoProvider;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginType;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.TimeoutCachedValue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0012\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0010\u0010\b\u001a\u00020\u00012\b\u0010\t\u001a\u0004\u0018\u00010\n\u001a\u000e\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r\u001a\u0018\u0010\u000e\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u001a\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0007\u001a\u001a\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u001a\u001e\u0010&\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u001a\u0014\u0010'\u001a\u00020\u00052\n\u0010(\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0002\u001a\u0010\u0010)\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\rH\u0002\"\u000e\u0010\u0014\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0015\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0016\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0017\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001a\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u001b\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0011\u0010\u001e\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001d\"\u000e\u0010 \u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010!\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00190#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"getPluginInfo", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "aClass", "Ljava/lang/Class;", "hasStandardExceptionPrefix", "", "className", "", "getPluginInfoById", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "getPluginInfoByDescriptor", "plugin", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "getPluginInfoByDescriptorWithFeaturedPlugins", "featuredPlugins", "Lcom/intellij/internal/statistic/FeaturedPluginsInfoProvider;", "findPluginTypeByValue", "Lcom/intellij/internal/statistic/utils/PluginType;", "value", "tbePluginId", "aeExperimentsPluginId", "aeDatabasePluginId", "jcpAnalyticsPluginId", "allowedPlugins", "", "jvmCore", "platformPlugin", "getPlatformPlugin", "()Lcom/intellij/internal/statistic/utils/PluginInfo;", "unknownPlugin", "getUnknownPlugin", "notListedPlugin", "builtFromSources", "pluginIdsFromOfficialJbPluginRepo", "Ljava/util/function/Supplier;", "isSafeToReportFrom", "descriptor", "isPluginFromOfficialJbPluginRepo", "isClassFromCoreOrJetBrainsPlugin", "clazz", "isCoreOrJetBrainsPlugin", "intellij.platform.statistics"})
@SourceDebugExtension(value={"SMAP\nPluginInfoDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginInfoDetector.kt\ncom/intellij/internal/statistic/utils/PluginInfoDetectorKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,253:1\n1#2:254\n*E\n"})
public final class PluginInfoDetectorKt {
    @NotNull
    private static final String tbePluginId = "org.jetbrains.toolbox-enterprise-client";
    @NotNull
    private static final String aeExperimentsPluginId = "com.jetbrains.ae.experiments";
    @NotNull
    private static final String aeDatabasePluginId = "com.jetbrains.ae.database";
    @NotNull
    private static final String jcpAnalyticsPluginId = "org.jetbrains.jcp";
    @NotNull
    private static final Set<String> allowedPlugins;
    @NotNull
    private static final PluginInfo jvmCore;
    @NotNull
    private static final PluginInfo platformPlugin;
    @NotNull
    private static final PluginInfo unknownPlugin;
    @NotNull
    private static final PluginInfo notListedPlugin;
    @NotNull
    private static final PluginInfo builtFromSources;
    @NotNull
    private static final Supplier<Set<PluginId>> pluginIdsFromOfficialJbPluginRepo;

    @NotNull
    public static final PluginInfo getPluginInfo(@NotNull Class<?> aClass) {
        PluginInfo pluginInfo;
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        ClassLoader classLoader = aClass.getClassLoader();
        if (classLoader instanceof PluginAwareClassLoader) {
            PluginDescriptor pluginDescriptor = ((PluginAwareClassLoader)classLoader).getPluginDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)pluginDescriptor, (String)"getPluginDescriptor(...)");
            pluginInfo = PluginInfoDetectorKt.getPluginInfoByDescriptor(pluginDescriptor);
        } else if (PluginManagerCore.isRunningFromSources()) {
            pluginInfo = builtFromSources;
        } else {
            String string = aClass.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            pluginInfo = PluginInfoDetectorKt.getPluginInfo(string);
        }
        return pluginInfo;
    }

    @ApiStatus.Internal
    public static final boolean hasStandardExceptionPrefix(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        return StringsKt.startsWith$default((String)className, (String)"java.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)className, (String)"javax.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)className, (String)"sun.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)className, (String)"com.sun.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)className, (String)"jdk.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)className, (String)"kotlin.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)className, (String)"kotlinx.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)className, (String)"groovy.", (boolean)false, (int)2, null);
    }

    @NotNull
    public static final PluginInfo getPluginInfo(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        if (PluginInfoDetectorKt.hasStandardExceptionPrefix(className)) {
            return jvmCore;
        }
        PluginDescriptor pluginDescriptor = PluginUtils.getPluginDescriptorOrPlatformByClassName((String)className);
        if (pluginDescriptor == null) {
            return unknownPlugin;
        }
        PluginDescriptor plugin = pluginDescriptor;
        return PluginInfoDetectorKt.getPluginInfoByDescriptor(plugin);
    }

    @NotNull
    public static final PluginInfo getPluginInfoById(@Nullable PluginId pluginId) {
        if (pluginId == null) {
            return unknownPlugin;
        }
        IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)pluginId);
        if (plugin == null) {
            return PluginInfoDetectorKt.isPluginFromOfficialJbPluginRepo$default(pluginId, null, 2, null) ? new PluginInfo(PluginType.LISTED, pluginId.getIdString(), null) : unknownPlugin;
        }
        return PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)plugin);
    }

    @NotNull
    public static final PluginInfo getPluginInfoByDescriptor(@NotNull PluginDescriptor plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        return PluginInfoDetectorKt.getPluginInfoByDescriptorWithFeaturedPlugins(plugin, null);
    }

    @NotNull
    public static final PluginInfo getPluginInfoByDescriptorWithFeaturedPlugins(@NotNull PluginDescriptor plugin, @Nullable FeaturedPluginsInfoProvider featuredPlugins) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        if (Intrinsics.areEqual((Object)PluginManagerCore.CORE_ID, (Object)plugin.getPluginId())) {
            return platformPlugin;
        }
        String id = plugin.getPluginId().getIdString();
        String version = plugin.getVersion();
        if (PluginManagerCore.isDevelopedByJetBrains((PluginDescriptor)plugin)) {
            PluginType pluginType = plugin.isBundled() ? PluginType.JB_BUNDLED : (PluginManagerCore.isUpdatedBundledPlugin((PluginDescriptor)plugin) ? PluginType.JB_UPDATED_BUNDLED : PluginType.JB_NOT_BUNDLED);
            return new PluginInfo(pluginType, id, version);
        }
        boolean listed = !plugin.isBundled() && !PluginManagerCore.isUpdatedBundledPlugin((PluginDescriptor)plugin) && PluginInfoDetectorKt.isSafeToReportFrom(plugin, featuredPlugins);
        return listed ? new PluginInfo(PluginType.LISTED, id, version) : notListedPlugin;
    }

    @Nullable
    public static final PluginType findPluginTypeByValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        for (PluginType type : PluginType.values()) {
            if (!Intrinsics.areEqual((Object)type.name(), (Object)value)) continue;
            return type;
        }
        return null;
    }

    @NotNull
    public static final PluginInfo getPlatformPlugin() {
        return platformPlugin;
    }

    @NotNull
    public static final PluginInfo getUnknownPlugin() {
        return unknownPlugin;
    }

    private static final boolean isSafeToReportFrom(PluginDescriptor descriptor, FeaturedPluginsInfoProvider featuredPlugins) {
        return PluginManagerCore.isDevelopedByJetBrains((PluginDescriptor)descriptor) ? true : (descriptor.isBundled() ? false : PluginInfoDetectorKt.isPluginFromOfficialJbPluginRepo(descriptor.getPluginId(), featuredPlugins));
    }

    private static final boolean isPluginFromOfficialJbPluginRepo(PluginId pluginId, FeaturedPluginsInfoProvider featuredPlugins) {
        if (ApplicationInfoEx.getInstanceEx().usesJetBrainsPluginRepository()) {
            if (featuredPlugins != null && PluginInfoDetectorKt.isClassFromCoreOrJetBrainsPlugin(featuredPlugins.getClass()) && CollectionsKt.contains((Iterable)featuredPlugins.getFeaturedPluginsFromMarketplace(), (Object)pluginId)) {
                return true;
            }
            Set<PluginId> set = pluginIdsFromOfficialJbPluginRepo.get();
            Intrinsics.checkNotNullExpressionValue(set, (String)"get(...)");
            return CollectionsKt.contains((Iterable)set, (Object)pluginId);
        }
        return false;
    }

    static /* synthetic */ boolean isPluginFromOfficialJbPluginRepo$default(PluginId pluginId, FeaturedPluginsInfoProvider featuredPluginsInfoProvider, int n, Object object) {
        if ((n & 2) != 0) {
            featuredPluginsInfoProvider = null;
        }
        return PluginInfoDetectorKt.isPluginFromOfficialJbPluginRepo(pluginId, featuredPluginsInfoProvider);
    }

    private static final boolean isClassFromCoreOrJetBrainsPlugin(Class<?> clazz) {
        ClassLoader loader = clazz.getClassLoader();
        if (loader instanceof PluginAwareClassLoader) {
            PluginDescriptor pluginDescriptor = ((PluginAwareClassLoader)loader).getPluginDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)pluginDescriptor, (String)"getPluginDescriptor(...)");
            return PluginInfoDetectorKt.isCoreOrJetBrainsPlugin(pluginDescriptor);
        }
        String string = clazz.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        PluginDescriptor descriptor = PluginUtils.getPluginDescriptorOrPlatformByClassName((String)string);
        return descriptor != null && PluginInfoDetectorKt.isCoreOrJetBrainsPlugin(descriptor);
    }

    private static final boolean isCoreOrJetBrainsPlugin(PluginDescriptor descriptor) {
        return Intrinsics.areEqual((Object)PluginManagerCore.CORE_ID, (Object)descriptor.getPluginId()) || PluginManagerCore.isDevelopedByJetBrains((PluginDescriptor)descriptor);
    }

    private static final Set pluginIdsFromOfficialJbPluginRepo$lambda$0() {
        PluginInfoProvider infoProvider = PluginInfoProvider.getInstance();
        Set set = infoProvider.loadCachedPlugins();
        if (set == null) {
            Set set2;
            Set it = set2 = SetsKt.emptySet();
            boolean bl = false;
            infoProvider.loadPlugins(null);
            set = set2;
        }
        return set;
    }

    public static final /* synthetic */ Set access$getAllowedPlugins$p() {
        return allowedPlugins;
    }

    static {
        Object[] objectArray = new String[]{tbePluginId, aeExperimentsPluginId, aeDatabasePluginId, jcpAnalyticsPluginId};
        allowedPlugins = SetsKt.setOf((Object[])objectArray);
        jvmCore = new PluginInfo(PluginType.JVM_CORE, null, null);
        platformPlugin = new PluginInfo(PluginType.PLATFORM, null, null);
        unknownPlugin = new PluginInfo(PluginType.UNKNOWN, null, null);
        notListedPlugin = new PluginInfo(PluginType.NOT_LISTED, null, null);
        builtFromSources = new PluginInfo(PluginType.FROM_SOURCES, null, null);
        pluginIdsFromOfficialJbPluginRepo = (Supplier)new TimeoutCachedValue(1L, TimeUnit.HOURS, PluginInfoDetectorKt::pluginIdsFromOfficialJbPluginRepo$lambda$0);
    }
}

