/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class LowMemoryWatcherManager {
    private static final Logger LOG = Logger.getInstance(LowMemoryWatcherManager.class);
    private static final long MIN_MEMORY_MARGIN = 0x500000L;
    private static final float MEMORY_NOTIFICATION_THRESHOLD = SystemProperties.getFloatProperty("low.memory.watcher.notification.threshold", 0.95f);
    private static final boolean USE_EXPONENTIALLY_SMOOTHING_GC_TRACKING = SystemProperties.getBooleanProperty("LowMemoryWatcherManager.USE_EXPONENTIALLY_SMOOTHING_GC_TRACKING", false);
    private static final long WINDOW_SIZE_MS = SystemProperties.getLongProperty("LowMemoryWatcherManager.WINDOW_SIZE_MS", TimeUnit.SECONDS.toMillis(60L));
    private static final float GC_LOAD_THRESHOLD = SystemProperties.getFloatProperty("LowMemoryWatcherManager.GC_LOAD_THRESHOLD", 0.1f);
    private static final long REGULAR_TRACKER_UPDATE_PERIOD_MS = SystemProperties.getLongProperty("LowMemoryWatcherManager.REGULAR_TRACKER_UPDATE_PERIOD_MS", TimeUnit.SECONDS.toMillis(5L));
    private final ExecutorService watcherNotificationPool;
    private Future<?> watcherNotificationTaskSubmitted;
    private final Consumer<Boolean> watcherNotificationTask;
    private final Future<?> memoryPoolMXBeansInitializationFuture;
    private ScheduledFuture<?> gcTimeTrackingFuture;
    private final GcTracker gcTracker;
    private final NotificationListener lowMemoryListener;

    public LowMemoryWatcherManager(@NotNull ExecutorService backendExecutorService) {
        if (backendExecutorService == null) {
            LowMemoryWatcherManager.$$$reportNull$$$0(0);
        }
        this.watcherNotificationTask = new Consumer<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(@NotNull Boolean afterGc) {
                if (afterGc == null) {
                    1.$$$reportNull$$$0(0);
                }
                Consumer consumer = LowMemoryWatcherManager.this.watcherNotificationTask;
                synchronized (consumer) {
                    LowMemoryWatcherManager.this.watcherNotificationTaskSubmitted = null;
                }
                LowMemoryWatcher.onLowMemorySignalReceived(afterGc);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterGc", "com/intellij/openapi/util/LowMemoryWatcherManager$1", "accept"));
            }
        };
        this.lowMemoryListener = new NotificationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleNotification(Notification notification, Object __) {
                if (LowMemoryWatcher.notificationsSuppressed()) {
                    return;
                }
                boolean memoryThreshold = "java.management.memory.threshold.exceeded".equals(notification.getType());
                boolean memoryCollectionThreshold = "java.management.memory.collection.threshold.exceeded".equals(notification.getType());
                if (memoryThreshold || memoryCollectionThreshold) {
                    boolean afterGC;
                    long currentGcTime = LowMemoryWatcherManager.fetchMajorGcDurationAccumulated();
                    double gcLoadScore = LowMemoryWatcherManager.this.gcTracker.gcLoadScore(System.currentTimeMillis(), currentGcTime);
                    LOG.info("LowMemoryNotification{gcTime: " + currentGcTime + "ms, GC load: " + gcLoadScore + "}{threshold: " + memoryThreshold + ", collectionThreshold: " + memoryCollectionThreshold + "}");
                    boolean bl = afterGC = gcLoadScore > (double)GC_LOAD_THRESHOLD && memoryCollectionThreshold;
                    if (afterGC) {
                        LowMemoryWatcherManager.this.gcTracker.reset();
                    }
                    Consumer consumer = LowMemoryWatcherManager.this.watcherNotificationTask;
                    synchronized (consumer) {
                        if (LowMemoryWatcherManager.this.watcherNotificationTaskSubmitted == null) {
                            LowMemoryWatcherManager.this.watcherNotificationTaskSubmitted = LowMemoryWatcherManager.this.watcherNotificationPool.submit(() -> LowMemoryWatcherManager.this.watcherNotificationTask.accept(afterGC));
                            if (LowMemoryWatcherManager.this.watcherNotificationTaskSubmitted.isDone()) {
                                LowMemoryWatcherManager.this.watcherNotificationTaskSubmitted = null;
                            }
                        }
                    }
                }
            }
        };
        long gcDurationMs = LowMemoryWatcherManager.fetchMajorGcDurationAccumulated();
        if (USE_EXPONENTIALLY_SMOOTHING_GC_TRACKING) {
            LOG.info("Use ExponentiallySmoothingTracker(" + WINDOW_SIZE_MS + " ms)");
            this.gcTracker = new ExponentiallySmoothingTracker(gcDurationMs, System.currentTimeMillis(), WINDOW_SIZE_MS);
        } else {
            LOG.info("Use WindowedSumTracker(" + WINDOW_SIZE_MS + " ms)");
            this.gcTracker = new WindowedSumTracker(gcDurationMs, System.currentTimeMillis(), WINDOW_SIZE_MS);
        }
        this.watcherNotificationPool = Boolean.getBoolean("low.memory.watcher.sync") ? ConcurrencyUtil.newSameThreadExecutorService() : SequentialTaskExecutor.createSequentialApplicationPoolExecutor("LowMemoryWatcherManager", backendExecutorService);
        this.memoryPoolMXBeansInitializationFuture = this.initializeMXBeanListenersLater(backendExecutorService);
    }

    private static long fetchMajorGcDurationAccumulated() {
        for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (!gc.getName().toLowerCase().contains("g1 old generation")) continue;
            return gc.getCollectionTime();
        }
        return 0L;
    }

    @NotNull
    private Future<?> initializeMXBeanListenersLater(final @NotNull ExecutorService backendExecutorService) {
        if (backendExecutorService == null) {
            LowMemoryWatcherManager.$$$reportNull$$$0(1);
        }
        Future<?> future = backendExecutorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    for (MemoryPoolMXBean bean : ManagementFactory.getMemoryPoolMXBeans()) {
                        if (bean.getType() != MemoryType.HEAP || !bean.isCollectionUsageThresholdSupported() || !bean.isUsageThresholdSupported()) continue;
                        long maxPoolCapacity = bean.getUsage().getMax();
                        long threshold = Math.min((long)((float)maxPoolCapacity * MEMORY_NOTIFICATION_THRESHOLD), maxPoolCapacity - 0x500000L);
                        LOG.info("Subscribing to MemoryPool[" + bean.getName() + "]{max: " + maxPoolCapacity + ", threshold: " + threshold + "}");
                        if (threshold <= 0L) continue;
                        bean.setUsageThreshold(threshold);
                        bean.setCollectionUsageThreshold(threshold);
                    }
                    ((NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean())).addNotificationListener(LowMemoryWatcherManager.this.lowMemoryListener, null, null);
                    if (REGULAR_TRACKER_UPDATE_PERIOD_MS > 0L && backendExecutorService instanceof ScheduledExecutorService) {
                        ScheduledExecutorService scheduler = (ScheduledExecutorService)backendExecutorService;
                        LOG.info("Schedule GC time updating: each " + REGULAR_TRACKER_UPDATE_PERIOD_MS + "ms:");
                        LowMemoryWatcherManager.this.gcTimeTrackingFuture = scheduler.scheduleWithFixedDelay(() -> {
                            long currentGcTime = LowMemoryWatcherManager.fetchMajorGcDurationAccumulated();
                            double gcLoadScore = LowMemoryWatcherManager.this.gcTracker.gcLoadScore(System.currentTimeMillis(), currentGcTime);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("GcTracker update: {gcTime: " + currentGcTime + "ms, GC load: " + gcLoadScore + "}");
                            }
                        }, 10000L, REGULAR_TRACKER_UPDATE_PERIOD_MS, TimeUnit.MILLISECONDS);
                    }
                }
                catch (Throwable e) {
                    LOG.info("Errors initializing LowMemoryWatcher: ", e);
                }
            }

            public String toString() {
                return "initializeMXBeanListeners runnable";
            }
        });
        if (future == null) {
            LowMemoryWatcherManager.$$$reportNull$$$0(2);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            this.memoryPoolMXBeansInitializationFuture.get();
            ((NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean())).removeNotificationListener(this.lowMemoryListener);
            if (this.gcTimeTrackingFuture != null) {
                this.gcTimeTrackingFuture.cancel(false);
                this.gcTimeTrackingFuture = null;
            }
        }
        catch (Exception e) {
            LOG.error(e);
        }
        Consumer<Boolean> consumer = this.watcherNotificationTask;
        synchronized (consumer) {
            if (this.watcherNotificationTaskSubmitted != null) {
                this.watcherNotificationTaskSubmitted.cancel(false);
                this.watcherNotificationTaskSubmitted = null;
            }
        }
        LowMemoryWatcher.stopAll();
    }

    @TestOnly
    public void waitForInitComplete(int timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.memoryPoolMXBeansInitializationFuture.get(timeout, unit);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backendExecutorService";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/LowMemoryWatcherManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/LowMemoryWatcherManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "initializeMXBeanListenersLater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "initializeMXBeanListenersLater";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.Internal
    @VisibleForTesting
    public static interface GcTracker {
        public double gcLoadScore(long var1, long var3);

        public void reset();
    }

    @ApiStatus.Internal
    @VisibleForTesting
    public static class ExponentiallySmoothingTracker
    implements GcTracker {
        private final long windowSizeMs;
        private long previousAccumulatedGcDurationMs;
        private long previousUpdateTimestampMs;
        private double ema;

        public ExponentiallySmoothingTracker(long initialGcDurationMs, long initialTimeMs, long windowSizeMs) {
            this.windowSizeMs = windowSizeMs;
            this.previousAccumulatedGcDurationMs = initialGcDurationMs;
            this.ema = initialGcDurationMs;
            this.previousUpdateTimestampMs = initialTimeMs;
        }

        @Override
        public synchronized double gcLoadScore(long currentTimeMs, long accumulatedGcDurationMs) {
            long gcDurationInLastMs = accumulatedGcDurationMs - this.previousAccumulatedGcDurationMs;
            if (gcDurationInLastMs > 0L) {
                long sinceLastUpdateMs = currentTimeMs - this.previousUpdateTimestampMs;
                double decayFactor = Math.exp(-1.0 * (double)sinceLastUpdateMs / (double)this.windowSizeMs);
                this.ema = this.ema * decayFactor + (double)gcDurationInLastMs;
            }
            this.previousUpdateTimestampMs = currentTimeMs;
            this.previousAccumulatedGcDurationMs = accumulatedGcDurationMs;
            return this.ema / (double)this.windowSizeMs;
        }

        @Override
        public synchronized void reset() {
            this.ema = 0.0;
        }
    }

    @ApiStatus.Internal
    @VisibleForTesting
    public static class WindowedSumTracker
    implements GcTracker {
        private final long windowSizeMs;
        private long previousAccumulatedGcDurationMs;
        private long previousUpdateTimestampMs;
        private final Queue<GcPeriod> gcDurations = new LinkedList<GcPeriod>();

        public WindowedSumTracker(long initialGcDurationMs, long initialTimestampMs, long windowSizeMs) {
            this.previousAccumulatedGcDurationMs = initialGcDurationMs;
            this.windowSizeMs = windowSizeMs;
            this.previousUpdateTimestampMs = initialTimestampMs;
        }

        @Override
        public synchronized double gcLoadScore(long currentTimeMs, long accumulatedGcDurationMs) {
            if (this.previousUpdateTimestampMs < currentTimeMs - this.windowSizeMs) {
                this.previousUpdateTimestampMs = currentTimeMs;
                this.previousAccumulatedGcDurationMs = accumulatedGcDurationMs;
                this.gcDurations.clear();
                return 0.0;
            }
            long gcDurationDeltaMs = accumulatedGcDurationMs - this.previousAccumulatedGcDurationMs;
            this.previousAccumulatedGcDurationMs = accumulatedGcDurationMs;
            this.previousUpdateTimestampMs = currentTimeMs;
            if (gcDurationDeltaMs > 0L) {
                this.gcDurations.offer(new GcPeriod(currentTimeMs, gcDurationDeltaMs));
            }
            while (!this.gcDurations.isEmpty() && this.gcDurations.peek().timestamp < currentTimeMs - this.windowSizeMs) {
                this.gcDurations.poll();
            }
            long gcDurationInWindow = this.gcDurations.stream().mapToLong(period -> period.gcDurationMs).sum();
            return (double)gcDurationInWindow * 1.0 / (double)this.windowSizeMs;
        }

        @Override
        public synchronized void reset() {
            this.gcDurations.clear();
        }

        private static class GcPeriod {
            final long timestamp;
            final long gcDurationMs;

            GcPeriod(long timestamp, long gcDurationMs) {
                this.timestamp = timestamp;
                this.gcDurationMs = gcDurationMs;
            }
        }
    }
}

