/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.system;

import com.intellij.execution.Platform;
import com.intellij.jna.JnaLoader;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.WinBuildNumber;
import com.intellij.util.ArrayUtil;
import com.sun.jna.Library;
import com.sun.jna.Native;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum OS {
    Windows,
    macOS,
    Linux,
    FreeBSD,
    Other;

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public final String version = VersionHolder.access$000();
    public static final OS CURRENT;

    @NotNull
    public final String version() {
        String string = VersionHolder.STR;
        if (string == null) {
            OS.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public final Version parsedVersion() {
        Version version = VersionHolder.VAL;
        if (version == null) {
            OS.$$$reportNull$$$0(1);
        }
        return version;
    }

    public final boolean isAtLeast(int major, int minor) {
        if (major <= 0 || minor < 0) {
            throw new IllegalArgumentException();
        }
        return VersionHolder.VAL.compareTo(new Version(major, minor, 0)) >= 0;
    }

    @NotNull
    public final OsInfo getOsInfo() {
        OsInfo osInfo = this == Windows ? WindowsInfo.INSTANCE : (this == macOS ? MacOsInfo.INSTANCE : (this == Linux ? LinuxInfo.INSTANCE : UnixInfo.INSTANCE));
        if (osInfo == null) {
            OS.$$$reportNull$$$0(2);
        }
        return osInfo;
    }

    @NotNull
    public static OS fromString(@Nullable String os) {
        if (os != null) {
            if ((os = os.toLowerCase(Locale.ENGLISH)).startsWith("windows")) {
                OS oS = Windows;
                if (oS == null) {
                    OS.$$$reportNull$$$0(3);
                }
                return oS;
            }
            if (os.startsWith("mac")) {
                OS oS = macOS;
                if (oS == null) {
                    OS.$$$reportNull$$$0(4);
                }
                return oS;
            }
            if (os.startsWith("linux")) {
                OS oS = Linux;
                if (oS == null) {
                    OS.$$$reportNull$$$0(5);
                }
                return oS;
            }
            if (os.startsWith("freebsd")) {
                OS oS = FreeBSD;
                if (oS == null) {
                    OS.$$$reportNull$$$0(6);
                }
                return oS;
            }
        }
        OS oS = Other;
        if (oS == null) {
            OS.$$$reportNull$$$0(7);
        }
        return oS;
    }

    @NotNull
    public Platform getPlatform() {
        Platform platform = this == Windows ? Platform.WINDOWS : Platform.UNIX;
        if (platform == null) {
            OS.$$$reportNull$$$0(8);
        }
        return platform;
    }

    public static boolean isGenericUnix() {
        return CURRENT != Windows && CURRENT != macOS;
    }

    static {
        CURRENT = OS.fromString(System.getProperty("os.name"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/util/system/OS";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "version";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parsedVersion";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOsInfo";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "fromString";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatform";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static final class VersionHolder {
        private static final String STR;
        private static final Version VAL;

        private VersionHolder() {
        }

        static {
            String name = System.getProperty("os.name");
            String version = System.getProperty("os.version", "unknown").toLowerCase(Locale.ENGLISH);
            if (name.startsWith("Windows") && name.matches("Windows \\d+")) {
                try {
                    String version2 = name.substring("Windows".length() + 1) + ".0";
                    if (Float.parseFloat(version2) > Float.parseFloat(version)) {
                        version = version2;
                    }
                }
                catch (NumberFormatException version2) {
                    // empty catch block
                }
            }
            STR = version;
            Version parsed = Version.parseVersion(version);
            VAL = parsed != null ? parsed : new Version(0, 0, 0);
        }
    }

    public static final class WindowsInfo
    implements OsInfo {
        private static final WindowsInfo INSTANCE = new WindowsInfo();

        private WindowsInfo() {
        }

        @Nullable
        public Long getBuildNumber() {
            return WinBuildNumber.getWinBuildNumber();
        }
    }

    public static final class MacOsInfo
    implements OsInfo {
        private static final MacOsInfo INSTANCE = new MacOsInfo();

        private MacOsInfo() {
        }
    }

    public static final class LinuxInfo
    extends UnixInfo {
        private static final LinuxInfo INSTANCE = new LinuxInfo();
        private volatile Boolean isUnderWsl = null;
        private volatile String glibcVersion = "not-initialized";

        private LinuxInfo() {
        }

        public boolean isUnderWsl() {
            if (this.isUnderWsl == null) {
                try {
                    Path dataFile = Paths.get("/proc/sys/kernel/osrelease", new String[0]);
                    this.isUnderWsl = new String(Files.readAllBytes(dataFile), StandardCharsets.US_ASCII).contains("-microsoft-");
                }
                catch (Exception ignored) {
                    this.isUnderWsl = false;
                }
            }
            return this.isUnderWsl;
        }

        @ApiStatus.Internal
        @Nullable
        public String getGlibcVersion() {
            if ("not-initialized".equals(this.glibcVersion)) {
                String version = null;
                if (JnaLoader.isLoaded()) {
                    try {
                        String str;
                        byte[] buf = new byte[64];
                        long res = LibC.INSTANCE.confstr(2, buf, buf.length);
                        if (res > 6L && (str = new String(buf, 0, (int)res - 1, StandardCharsets.US_ASCII)).startsWith("glibc ")) {
                            version = str.substring(6);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                this.glibcVersion = version;
            }
            return this.glibcVersion;
        }

        private static interface LibC
        extends Library {
            public static final LibC INSTANCE = Native.load(LibC.class);
            public static final int _CS_GNU_LIBC_VERSION = 2;

            public long confstr(int var1, byte[] var2, long var3);
        }
    }

    public static class UnixInfo
    implements OsInfo {
        private static final UnixInfo INSTANCE = new UnixInfo();
        private volatile Map<String, String> releaseData = null;

        private UnixInfo() {
        }

        @Nullable
        public String getDistro() {
            return this.getReleaseData().get("ID");
        }

        @Nullable
        public String getRelease() {
            return this.getReleaseData().get("VERSION_ID");
        }

        @Nullable
        public String getPrettyName() {
            return this.getReleaseData().get("PRETTY_NAME");
        }

        private Map<String, String> getReleaseData() {
            if (this.releaseData == null) {
                try (Stream<String> lines = Files.lines(Paths.get("/etc/os-release", new String[0]));){
                    String[] fields2 = new String[]{"ID", "PRETTY_NAME", "VERSION_ID"};
                    this.releaseData = lines.map(line -> line.split("=")).filter(parts -> ((String[])parts).length == 2 && ArrayUtil.contains(parts[0], fields2)).collect(Collectors.toMap(parts -> parts[0], parts -> parts[1].replace("\"", "")));
                }
                catch (Exception ignored) {
                    this.releaseData = Collections.emptyMap();
                }
            }
            return this.releaseData;
        }
    }

    public static interface OsInfo {
    }
}

