/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.util.io.storages.DataExternalizerEx;
import com.intellij.platform.util.io.storages.KeyDescriptorEx;
import com.intellij.platform.util.io.storages.enumerator.DurableEnumerator;
import com.intellij.platform.util.io.storages.enumerator.DurableEnumeratorFactory;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DurableDataEnumerator;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentEnumerator;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.storage.AbstractStorage;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.ChangeKind;
import com.intellij.vcs.log.data.index.LightFilePath;
import com.intellij.vcs.log.data.index.VcsLogFullDetailsIndex;
import com.intellij.vcs.log.impl.VcsLogErrorHandler;
import com.intellij.vcs.log.impl.VcsLogIndexer;
import com.intellij.vcs.log.util.StorageId;
import com.intellij.vcsUtil.VcsUtil;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class VcsLogPathsIndex
extends VcsLogFullDetailsIndex<List<ChangeKind>, VcsLogIndexer.CompressedDetails> {
    private static final Logger LOG = Logger.getInstance(VcsLogPathsIndex.class);
    public static final String PATHS = "paths";
    public static final String INDEX_PATHS_IDS = "paths-ids";
    public static final String RENAMES_MAP = "renames-map";
    @NotNull
    private final PathIndexer myPathsIndexer;

    VcsLogPathsIndex(@NotNull StorageId.Directory storageId, @Nullable StorageLockContext storageLockContext, @NotNull PathIndexer pathIndexer, @NotNull VcsLogErrorHandler errorHandler, @NotNull Disposable disposableParent) throws IOException {
        if (storageId == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(0);
        }
        if (pathIndexer == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(1);
        }
        if (errorHandler == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(2);
        }
        if (disposableParent == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(3);
        }
        super(VcsLogPathsIndex.createMapReduceIndex(PATHS, storageId, pathIndexer, new ChangeKindListKeyDescriptor(), storageLockContext, null, null, errorHandler), disposableParent);
        this.myPathsIndexer = pathIndexer;
    }

    @NotNull
    private static DurableDataEnumerator<LightFilePath> createPathsEnumerator(@NotNull Collection<VirtualFile> roots, @NotNull StorageId.Directory storageId, @Nullable StorageLockContext storageLockContext, boolean useDurableEnumerator) throws IOException {
        if (roots == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(4);
        }
        if (storageId == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(5);
        }
        Path storageFile = storageId.getStorageFile(INDEX_PATHS_IDS);
        if (useDurableEnumerator) {
            DurableEnumerator durableEnumerator = DurableEnumeratorFactory.defaultWithDurableMap((KeyDescriptorEx)new LightFilePathKeyDescriptorEx(roots)).open(storageFile);
            if (durableEnumerator == null) {
                VcsLogPathsIndex.$$$reportNull$$$0(6);
            }
            return durableEnumerator;
        }
        return new PersistentEnumerator(storageFile, (KeyDescriptor)new LightFilePathKeyDescriptor(roots), AbstractStorage.PAGE_SIZE, storageLockContext, storageId.getVersion());
    }

    @Nullable
    FilePath getPath(int pathId, boolean isDirectory) {
        try {
            return VcsLogPathsIndex.toFilePath(this.getPath(pathId), isDirectory);
        }
        catch (IOException e) {
            this.myPathsIndexer.myFatalErrorConsumer.accept(e);
            return null;
        }
    }

    int getPathId(@NotNull LightFilePath path) throws IOException {
        if (path == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(7);
        }
        try {
            return this.myPathsIndexer.myPathsEnumerator.enumerate((Object)path);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    @Nullable
    LightFilePath getPath(int pathId) throws IOException {
        return (LightFilePath)this.myPathsIndexer.myPathsEnumerator.valueOf(pathId);
    }

    @Override
    public void flush() throws StorageException, IOException {
        super.flush();
        this.myPathsIndexer.myRenamesMap.force();
        this.myPathsIndexer.myPathsEnumerator.force();
    }

    @Contract(value="null,_ -> null; !null,_ -> !null")
    @Nullable
    static FilePath toFilePath(@Nullable LightFilePath lightFilePath, boolean isDirectory) {
        if (lightFilePath == null) {
            return null;
        }
        return VcsUtil.getFilePath((String)(lightFilePath.getRoot().getPath() + "/" + lightFilePath.getRelativePath()), (boolean)isDirectory);
    }

    @NotNull
    static VcsLogPathsIndex create(@NotNull StorageId.Directory storageId, @Nullable StorageLockContext storageLockContext, @NotNull VcsLogStorage storage, @NotNull Set<VirtualFile> roots, @NotNull PersistentHashMap<int[], int[]> renamesMap, boolean useDurableEnumerator, @NotNull VcsLogErrorHandler errorHandler, @NotNull Disposable disposableParent) throws IOException {
        if (storageId == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(8);
        }
        if (storage == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(9);
        }
        if (roots == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(10);
        }
        if (renamesMap == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(11);
        }
        if (errorHandler == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(12);
        }
        if (disposableParent == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(13);
        }
        Disposable disposable = Disposer.newDisposable((Disposable)disposableParent);
        try {
            DurableDataEnumerator<LightFilePath> pathsEnumerator = VcsLogPathsIndex.createPathsEnumerator(roots, storageId, storageLockContext, useDurableEnumerator);
            Disposer.register((Disposable)disposable, () -> VcsLogPathsIndex.catchAndWarn(LOG, (ThrowableRunnable<IOException>)((ThrowableRunnable)() -> pathsEnumerator.close())));
            PathIndexer pathsIndex = new PathIndexer(storage, pathsEnumerator, renamesMap, e -> errorHandler.handleError(VcsLogErrorHandler.Source.Index, (Throwable)e));
            return new VcsLogPathsIndex(storageId, storageLockContext, pathsIndex, errorHandler, disposable);
        }
        catch (Throwable t) {
            Disposer.dispose((Disposable)disposable);
            throw t;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathIndexer";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposableParent";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renamesMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createPathsEnumerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPathsEnumerator";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPathId";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    private static class ChangeKindListKeyDescriptor
    implements DataExternalizer<List<ChangeKind>> {
        private ChangeKindListKeyDescriptor() {
        }

        public void save(@NotNull DataOutput out, List<ChangeKind> value) throws IOException {
            if (out == null) {
                ChangeKindListKeyDescriptor.$$$reportNull$$$0(0);
            }
            DataInputOutputUtil.writeINT((DataOutput)out, (int)value.size());
            for (ChangeKind data2 : value) {
                out.writeByte(data2.id);
            }
        }

        public List<ChangeKind> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                ChangeKindListKeyDescriptor.$$$reportNull$$$0(1);
            }
            SmartList value = new SmartList();
            int size = DataInputOutputUtil.readINT((DataInput)in);
            for (int i = 0; i < size; ++i) {
                value.add(ChangeKind.getChangeKindById(in.readByte()));
            }
            return value;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$ChangeKindListKeyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class PathIndexer
    implements DataIndexer<Integer, List<ChangeKind>, VcsLogIndexer.CompressedDetails> {
        @NotNull
        private final VcsLogStorage myStorage;
        @NotNull
        private final DurableDataEnumerator<LightFilePath> myPathsEnumerator;
        @NotNull
        private final PersistentHashMap<int[], int[]> myRenamesMap;
        @NotNull
        private final Consumer<? super Exception> myFatalErrorConsumer;

        private PathIndexer(@NotNull VcsLogStorage storage, @NotNull DurableDataEnumerator<LightFilePath> pathsEnumerator, @NotNull PersistentHashMap<int[], int[]> renamesMap, @NotNull Consumer<? super Exception> fatalErrorConsumer) {
            if (storage == null) {
                PathIndexer.$$$reportNull$$$0(0);
            }
            if (pathsEnumerator == null) {
                PathIndexer.$$$reportNull$$$0(1);
            }
            if (renamesMap == null) {
                PathIndexer.$$$reportNull$$$0(2);
            }
            if (fatalErrorConsumer == null) {
                PathIndexer.$$$reportNull$$$0(3);
            }
            this.myStorage = storage;
            this.myPathsEnumerator = pathsEnumerator;
            this.myRenamesMap = renamesMap;
            this.myFatalErrorConsumer = fatalErrorConsumer;
        }

        @NotNull
        public Map<Integer, List<ChangeKind>> map(@NotNull VcsLogIndexer.CompressedDetails inputData) {
            if (inputData == null) {
                PathIndexer.$$$reportNull$$$0(4);
            }
            HashMap<Integer, List<ChangeKind>> result = new HashMap<Integer, List<ChangeKind>>();
            int parentsCount = inputData.getParents().isEmpty() ? 1 : inputData.getParents().size();
            for (int parentIndex = 0; parentIndex < parentsCount; ++parentIndex) {
                try {
                    ObjectSet entries = inputData.getRenamedPaths(parentIndex).int2IntEntrySet();
                    if (!entries.isEmpty()) {
                        int[] renames = new int[entries.size() * 2];
                        int index = 0;
                        for (Int2IntMap.Entry entry : entries) {
                            renames[index++] = entry.getIntKey();
                            renames[index++] = entry.getIntValue();
                            PathIndexer.getOrCreateChangeKindList(result, entry.getIntKey(), parentsCount).set(parentIndex, ChangeKind.REMOVED);
                            PathIndexer.getOrCreateChangeKindList(result, entry.getIntValue(), parentsCount).set(parentIndex, ChangeKind.ADDED);
                        }
                        int commit = this.myStorage.getCommitIndex((Hash)inputData.getId(), inputData.getRoot());
                        int parent = this.myStorage.getCommitIndex((Hash)inputData.getParents().get(parentIndex), inputData.getRoot());
                        this.myRenamesMap.put((Object)new int[]{parent, commit}, (Object)renames);
                    }
                    for (Int2ObjectMap.Entry entry : inputData.getModifiedPaths(parentIndex).int2ObjectEntrySet()) {
                        PathIndexer.getOrCreateChangeKindList(result, entry.getIntKey(), parentsCount).set(parentIndex, PathIndexer.createChangeData((Change.Type)entry.getValue()));
                    }
                    continue;
                }
                catch (IOException e) {
                    this.myFatalErrorConsumer.accept(e);
                }
            }
            HashMap<Integer, List<ChangeKind>> hashMap = result;
            if (hashMap == null) {
                PathIndexer.$$$reportNull$$$0(5);
            }
            return hashMap;
        }

        @NotNull
        static List<ChangeKind> getOrCreateChangeKindList(@NotNull Map<Integer, List<ChangeKind>> pathIdToChangeDataListsMap, int pathId, int parentsCount) {
            Object changeDataList;
            if (pathIdToChangeDataListsMap == null) {
                PathIndexer.$$$reportNull$$$0(6);
            }
            if ((changeDataList = pathIdToChangeDataListsMap.get(pathId)) == null) {
                if (parentsCount == 1) {
                    changeDataList = new SmartList((Object)ChangeKind.NOT_CHANGED);
                } else {
                    changeDataList = new ArrayList(parentsCount);
                    for (int i = 0; i < parentsCount; ++i) {
                        changeDataList.add(ChangeKind.NOT_CHANGED);
                    }
                }
                pathIdToChangeDataListsMap.put(pathId, (List<ChangeKind>)changeDataList);
            }
            SmartList smartList = changeDataList;
            if (smartList == null) {
                PathIndexer.$$$reportNull$$$0(7);
            }
            return smartList;
        }

        @NotNull
        static ChangeKind createChangeData(@NotNull Change.Type type) {
            if (type == null) {
                PathIndexer.$$$reportNull$$$0(8);
            }
            ChangeKind changeKind = switch (type) {
                default -> throw new MatchException(null, null);
                case Change.Type.NEW -> ChangeKind.ADDED;
                case Change.Type.DELETED -> ChangeKind.REMOVED;
                case Change.Type.MOVED, Change.Type.MODIFICATION -> ChangeKind.MODIFIED;
            };
            if (changeKind == null) {
                PathIndexer.$$$reportNull$$$0(9);
            }
            return changeKind;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 7, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathsEnumerator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renamesMap";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fatalErrorConsumer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 5: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$PathIndexer";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathIdToChangeDataListsMap";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$PathIndexer";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "map";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrCreateChangeKindList";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createChangeData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "map";
                    break;
                }
                case 5: 
                case 7: 
                case 9: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getOrCreateChangeKindList";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createChangeData";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 7, 9 -> new IllegalStateException(string);
            };
        }
    }

    private static final class LightFilePathKeyDescriptorEx
    extends LightFilePathEqualityPolicy
    implements KeyDescriptorEx<LightFilePath> {
        private LightFilePathKeyDescriptorEx(@NotNull Collection<VirtualFile> roots) {
            if (roots == null) {
                LightFilePathKeyDescriptorEx.$$$reportNull$$$0(0);
            }
            super(roots);
        }

        public LightFilePath read(@NotNull ByteBuffer input) throws IOException {
            int rootIndex;
            VirtualFile root;
            if (input == null) {
                LightFilePathKeyDescriptorEx.$$$reportNull$$$0(1);
            }
            if ((root = (VirtualFile)this.myRoots.get(rootIndex = input.getInt())) == null) {
                throw new IOException("Can not read root for index " + rootIndex + ". All roots " + String.valueOf(this.myRoots));
            }
            byte[] dst = new byte[input.remaining()];
            input.get(dst);
            String path = new String(dst, StandardCharsets.UTF_8);
            return new LightFilePath(root, path);
        }

        public DataExternalizerEx.KnownSizeRecordWriter writerFor(@NotNull LightFilePath key) throws IOException {
            VirtualFile root;
            if (key == null) {
                LightFilePathKeyDescriptorEx.$$$reportNull$$$0(2);
            }
            if (!this.myRootsReversed.containsKey((Object)(root = key.getRoot()))) {
                throw new IOException("Unknown root " + root.getPath() + " for path " + key.getRelativePath() + ". All roots " + String.valueOf(this.myRoots));
            }
            final byte[] relativePathBytes = key.getRelativePath().getBytes(StandardCharsets.UTF_8);
            final int rootIndex = this.myRootsReversed.getInt((Object)root);
            return new DataExternalizerEx.KnownSizeRecordWriter(){

                public ByteBuffer write(@NotNull ByteBuffer data2) {
                    if (data2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return data2.putInt(rootIndex).put(relativePathBytes);
                }

                public int recordSize() {
                    return relativePathBytes.length + 4;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/vcs/log/data/index/VcsLogPathsIndex$LightFilePathKeyDescriptorEx$1", "write"));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$LightFilePathKeyDescriptorEx";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writerFor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class LightFilePathKeyDescriptor
    extends LightFilePathEqualityPolicy
    implements KeyDescriptor<LightFilePath> {
        private LightFilePathKeyDescriptor(@NotNull Collection<VirtualFile> roots) {
            if (roots == null) {
                LightFilePathKeyDescriptor.$$$reportNull$$$0(0);
            }
            super(roots);
        }

        public void save(@NotNull DataOutput out, LightFilePath value) throws IOException {
            if (out == null) {
                LightFilePathKeyDescriptor.$$$reportNull$$$0(1);
            }
            out.writeInt(this.myRootsReversed.getInt((Object)value.getRoot()));
            IOUtil.writeUTF((DataOutput)out, (String)value.getRelativePath());
        }

        public LightFilePath read(@NotNull DataInput in) throws IOException {
            int rootIndex;
            VirtualFile root;
            if (in == null) {
                LightFilePathKeyDescriptor.$$$reportNull$$$0(2);
            }
            if ((root = (VirtualFile)this.myRoots.get(rootIndex = in.readInt())) == null) {
                throw new IOException("Can not read root for index " + rootIndex + ". All roots " + String.valueOf(this.myRoots));
            }
            String path = IOUtil.readUTF((DataInput)in);
            return new LightFilePath(root, path);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$LightFilePathKeyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LightFilePathEqualityPolicy
    implements EqualityPolicy<LightFilePath> {
        @NotNull
        protected final List<VirtualFile> myRoots;
        @NotNull
        protected final Object2IntMap<VirtualFile> myRootsReversed;

        private LightFilePathEqualityPolicy(@NotNull Collection<VirtualFile> roots) {
            if (roots == null) {
                LightFilePathEqualityPolicy.$$$reportNull$$$0(0);
            }
            this.myRoots = ContainerUtil.sorted(roots, Comparator.comparing(VirtualFile::getPath));
            this.myRootsReversed = new Object2IntOpenHashMap();
            for (int i = 0; i < this.myRoots.size(); ++i) {
                this.myRootsReversed.put((Object)this.myRoots.get(i), i);
            }
        }

        public int getHashCode(@NotNull LightFilePath path) {
            if (path == null) {
                LightFilePathEqualityPolicy.$$$reportNull$$$0(1);
            }
            return 31 * this.myRootsReversed.getInt((Object)path.getRoot()) + path.getRelativePath().hashCode();
        }

        public boolean isEqual(@Nullable LightFilePath path1, @Nullable LightFilePath path2) {
            if (path1 == null || path2 == null) {
                return path1 == path2;
            }
            return this.myRootsReversed.getInt((Object)path1.getRoot()) == this.myRootsReversed.getInt((Object)path2.getRoot()) && path1.getRelativePath().equals(path2.getRelativePath());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$LightFilePathEqualityPolicy";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getHashCode";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

