/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.vcs.log.data.index.VcsLogPersistentIndex;
import com.intellij.vcs.log.impl.VcsLogIndexer;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000eH\u0016J\u000e\u0010\u000f\u001a\u00020\tH\u0096\u0002\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/intellij/vcs/log/ui/VcsLogIndexAvailabilityPredicate;", "Lcom/intellij/ui/layout/ComponentPredicate;", "project", "Lcom/intellij/openapi/project/Project;", "disposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "isVcsLogIndexAvailable", "", "()Z", "addListener", "", "listener", "Lkotlin/Function1;", "invoke", "()Ljava/lang/Boolean;", "intellij.platform.vcs.log.impl"})
final class VcsLogIndexAvailabilityPredicate
extends ComponentPredicate {
    @NotNull
    private final Project project;
    @NotNull
    private final Disposable disposable;

    public VcsLogIndexAvailabilityPredicate(@NotNull Project project, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.project = project;
        this.disposable = disposable;
    }

    private final boolean isVcsLogIndexAvailable() {
        Collection<VcsLogIndexer> collection = VcsLogPersistentIndex.getAvailableIndexers(this.project);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getAvailableIndexers(...)");
        return !collection.isEmpty();
    }

    public void addListener(@NotNull Function1<? super Boolean, Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.project.getMessageBus().connect(this.disposable).subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, () -> VcsLogIndexAvailabilityPredicate.addListener$lambda$0(listener2, this));
    }

    @NotNull
    public Boolean invoke() {
        return this.isVcsLogIndexAvailable();
    }

    private static final void addListener$lambda$0(Function1 $listener, VcsLogIndexAvailabilityPredicate this$0) {
        $listener.invoke((Object)this$0.isVcsLogIndexAvailable());
    }
}

