/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table.column;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.util.EventDispatcher;
import com.intellij.vcs.log.ui.frame.VcsCommitExternalStatusProvider;
import com.intellij.vcs.log.ui.table.column.Author;
import com.intellij.vcs.log.ui.table.column.Commit;
import com.intellij.vcs.log.ui.table.column.Date;
import com.intellij.vcs.log.ui.table.column.Hash;
import com.intellij.vcs.log.ui.table.column.Root;
import com.intellij.vcs.log.ui.table.column.VcsLogColumn;
import com.intellij.vcs.log.ui.table.column.VcsLogColumnProperties;
import com.intellij.vcs.log.ui.table.column.VcsLogCustomColumn;
import com.intellij.vcs.log.ui.table.column.VcsLogDefaultColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\r\b\u0001\u0018\u0000 (2\u00020\u0001:\u0003()*B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\u0012\u0010\u0018\u001a\u00020\u00072\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\nJ\u0012\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u001b\u001a\u00020\u0007J\u0006\u0010\u001c\u001a\u00020\u0007J\u0010\u0010\u001d\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u001eJ\u0010\u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u001eJ\u0012\u0010 \u001a\u00020\u00142\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\nJ\u0014\u0010!\u001a\u00020\u00162\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\nH\u0002J\u0014\u0010\"\u001a\u00020\u00162\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\nH\u0002J\u0016\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\u000eJ\u0016\u0010&\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\u0012J\b\u0010'\u001a\u00020\u0016H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\f\u001a\u0015\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e0\r\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0011\u001a\u0015\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00120\u00120\r\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u00140\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/vcs/log/ui/table/column/VcsLogColumnManager;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "modelIndices", "Ljava/util/HashMap;", "", "", "currentColumns", "Ljava/util/ArrayList;", "Lcom/intellij/vcs/log/ui/table/column/VcsLogColumn;", "currentColumnIndices", "columnModelListeners", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/vcs/log/ui/table/column/VcsLogColumnManager$ColumnModelListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "currentColumnsListeners", "Lcom/intellij/vcs/log/ui/table/column/VcsLogColumnManager$CurrentColumnsListener;", "currentColumnsProperties", "Lcom/intellij/vcs/log/ui/table/column/VcsLogColumnProperties;", "registerCustomColumns", "", "registerProvidersColumns", "getModelIndex", "column", "getColumn", "modelIndex", "getModelColumnsCount", "getCurrentColumns", "", "getCurrentDynamicColumns", "getProperties", "newColumn", "forgetColumn", "addColumnModelListener", "disposable", "listener", "addCurrentColumnsListener", "dispose", "Companion", "ColumnModelListener", "CurrentColumnsListener", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsLogColumnManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogColumnManager.kt\ncom/intellij/vcs/log/ui/table/column/VcsLogColumnManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,151:1\n1869#2,2:152\n774#2:154\n865#2,2:155\n382#3,7:157\n*S KotlinDebug\n*F\n+ 1 VcsLogColumnManager.kt\ncom/intellij/vcs/log/ui/table/column/VcsLogColumnManager\n*L\n50#1:152,2\n97#1:154\n97#1:155,2\n103#1:157,7\n*E\n"})
public final class VcsLogColumnManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<String, Integer> modelIndices = new HashMap();
    @NotNull
    private final ArrayList<VcsLogColumn<?>> currentColumns = new ArrayList();
    @NotNull
    private final HashMap<Integer, VcsLogColumn<?>> currentColumnIndices = new HashMap();
    @NotNull
    private final EventDispatcher<ColumnModelListener> columnModelListeners;
    @NotNull
    private final EventDispatcher<CurrentColumnsListener> currentColumnsListeners;
    @NotNull
    private final HashMap<VcsLogColumn<?>, VcsLogColumnProperties> currentColumnsProperties;
    @NotNull
    private static final List<VcsLogDefaultColumn<? extends Object>> defaultColumns;

    public VcsLogColumnManager() {
        EventDispatcher eventDispatcher = EventDispatcher.create(ColumnModelListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.columnModelListeners = eventDispatcher;
        EventDispatcher eventDispatcher2 = EventDispatcher.create(CurrentColumnsListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher2, (String)"create(...)");
        this.currentColumnsListeners = eventDispatcher2;
        this.currentColumnsProperties = new HashMap();
        Iterable $this$forEach$iv = defaultColumns;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VcsLogDefaultColumn column = (VcsLogDefaultColumn)element$iv;
            boolean bl = false;
            this.newColumn(column);
        }
        this.registerCustomColumns();
        this.registerProvidersColumns();
    }

    private final void registerCustomColumns() {
        ExtensionPointListener customColumnListener2 = new ExtensionPointListener<VcsLogCustomColumn<?>>(this){
            final /* synthetic */ VcsLogColumnManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void extensionAdded(VcsLogCustomColumn<?> extension, PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter(extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                VcsLogColumnManager.access$newColumn(this.this$0, extension);
            }

            public void extensionRemoved(VcsLogCustomColumn<?> extension, PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter(extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                VcsLogColumnManager.access$forgetColumn(this.this$0, extension);
            }
        };
        VcsLogCustomColumn.KEY.getPoint().addExtensionPointListener(customColumnListener2, true, (Disposable)this);
    }

    private final void registerProvidersColumns() {
        ExtensionPointListener customColumnListener2 = new ExtensionPointListener<VcsCommitExternalStatusProvider<?>>(this){
            final /* synthetic */ VcsLogColumnManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void extensionAdded(VcsCommitExternalStatusProvider<?> extension, PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter(extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                if (extension instanceof VcsCommitExternalStatusProvider.WithColumn) {
                    VcsLogColumnManager.access$newColumn(this.this$0, ((VcsCommitExternalStatusProvider.WithColumn)extension).getLogColumn());
                }
            }

            public void extensionRemoved(VcsCommitExternalStatusProvider<?> extension, PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter(extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                if (extension instanceof VcsCommitExternalStatusProvider.WithColumn) {
                    VcsLogColumnManager.access$forgetColumn(this.this$0, ((VcsCommitExternalStatusProvider.WithColumn)extension).getLogColumn());
                }
            }
        };
        VcsCommitExternalStatusProvider.Companion.getEP$intellij_platform_vcs_log_impl().getPoint().addExtensionPointListener(customColumnListener2, true, (Disposable)this);
    }

    public final int getModelIndex(@NotNull VcsLogColumn<?> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Integer n = this.modelIndices.get(column.getId());
        Intrinsics.checkNotNull((Object)n);
        return ((Number)n).intValue();
    }

    @NotNull
    public final VcsLogColumn<?> getColumn(int modelIndex) {
        VcsLogColumn<?> vcsLogColumn = this.currentColumnIndices.get(modelIndex);
        Intrinsics.checkNotNull(vcsLogColumn);
        return vcsLogColumn;
    }

    public final int getModelColumnsCount() {
        return this.modelIndices.size();
    }

    @NotNull
    public final List<VcsLogColumn<?>> getCurrentColumns() {
        return this.currentColumns;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<VcsLogColumn<?>> getCurrentDynamicColumns() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.currentColumns;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VcsLogColumn it = (VcsLogColumn)element$iv$iv;
            boolean bl = false;
            if (!it.isDynamic()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final VcsLogColumnProperties getProperties(@NotNull VcsLogColumn<?> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        VcsLogColumnProperties vcsLogColumnProperties = this.currentColumnsProperties.get(column);
        Intrinsics.checkNotNull((Object)vcsLogColumnProperties);
        return vcsLogColumnProperties;
    }

    /*
     * WARNING - void declaration
     */
    private final void newColumn(VcsLogColumn<?> column) {
        int modelIndex;
        Object object;
        void $this$getOrPut$iv;
        int newIndex = this.modelIndices.size();
        Map map = this.modelIndices;
        String key$iv = column.getId();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Integer answer$iv = newIndex;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        if (!((Map)this.currentColumnIndices).containsKey(modelIndex = ((Number)object).intValue())) {
            this.currentColumns.add(column);
            ((Map)this.currentColumnIndices).put(modelIndex, column);
            ((Map)this.currentColumnsProperties).put(column, VcsLogColumnProperties.Companion.create(column));
            ((CurrentColumnsListener)this.currentColumnsListeners.getMulticaster()).columnAdded(column);
        }
        if (modelIndex == newIndex) {
            ((ColumnModelListener)this.columnModelListeners.getMulticaster()).newColumn(column, modelIndex);
        }
    }

    private final void forgetColumn(VcsLogColumn<?> column) {
        int modelIndex = this.getModelIndex(column);
        this.currentColumns.remove(column);
        this.currentColumnIndices.remove(modelIndex);
        this.currentColumnsProperties.remove(column);
        ((CurrentColumnsListener)this.currentColumnsListeners.getMulticaster()).columnRemoved(column);
    }

    public final void addColumnModelListener(@NotNull Disposable disposable, @NotNull ColumnModelListener listener2) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.columnModelListeners.addListener((EventListener)listener2, disposable);
    }

    public final void addCurrentColumnsListener(@NotNull Disposable disposable, @NotNull CurrentColumnsListener listener2) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.currentColumnsListeners.addListener((EventListener)listener2, disposable);
    }

    public void dispose() {
    }

    @JvmStatic
    @NotNull
    public static final VcsLogColumnManager getInstance() {
        return Companion.getInstance();
    }

    public static final /* synthetic */ void access$newColumn(VcsLogColumnManager $this, VcsLogColumn column) {
        $this.newColumn(column);
    }

    public static final /* synthetic */ void access$forgetColumn(VcsLogColumnManager $this, VcsLogColumn column) {
        $this.forgetColumn(column);
    }

    static {
        Object[] objectArray = new VcsLogDefaultColumn[]{Root.INSTANCE, Commit.INSTANCE, Author.INSTANCE, Date.INSTANCE, Hash.INSTANCE};
        defaultColumns = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\bf\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/vcs/log/ui/table/column/VcsLogColumnManager$ColumnModelListener;", "Ljava/util/EventListener;", "newColumn", "", "column", "Lcom/intellij/vcs/log/ui/table/column/VcsLogColumn;", "modelIndex", "", "intellij.platform.vcs.log.impl"})
    public static interface ColumnModelListener
    extends EventListener {
        public void newColumn(@NotNull VcsLogColumn<?> var1, int var2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0007R\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/vcs/log/ui/table/column/VcsLogColumnManager$Companion;", "", "<init>", "()V", "defaultColumns", "", "Lcom/intellij/vcs/log/ui/table/column/VcsLogDefaultColumn;", "getInstance", "Lcom/intellij/vcs/log/ui/table/column/VcsLogColumnManager;", "intellij.platform.vcs.log.impl"})
    @SourceDebugExtension(value={"SMAP\nVcsLogColumnManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogColumnManager.kt\ncom/intellij/vcs/log/ui/table/column/VcsLogColumnManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,151:1\n42#2,3:152\n*S KotlinDebug\n*F\n+ 1 VcsLogColumnManager.kt\ncom/intellij/vcs/log/ui/table/column/VcsLogColumnManager$Companion\n*L\n34#1:152,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final VcsLogColumnManager getInstance() {
            boolean $i$f$service = false;
            Class<VcsLogColumnManager> serviceClass$iv = VcsLogColumnManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (VcsLogColumnManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016J\u0014\u0010\u0006\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/intellij/vcs/log/ui/table/column/VcsLogColumnManager$CurrentColumnsListener;", "Ljava/util/EventListener;", "columnAdded", "", "column", "Lcom/intellij/vcs/log/ui/table/column/VcsLogColumn;", "columnRemoved", "intellij.platform.vcs.log.impl"})
    public static interface CurrentColumnsListener
    extends EventListener {
        default public void columnAdded(@NotNull VcsLogColumn<?> column) {
            Intrinsics.checkNotNullParameter(column, (String)"column");
        }

        default public void columnRemoved(@NotNull VcsLogColumn<?> column) {
            Intrinsics.checkNotNullParameter(column, (String)"column");
        }
    }
}

