/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.rules;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.ide.impl.ProjectUtilKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.VirtualFilePointerTracker;
import com.intellij.testFramework.DisposableRule;
import com.intellij.testFramework.IndexingTestUtil;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.RuleChain;
import com.intellij.testFramework.rules.TempDirectory;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.junit.rules.ExternalResource;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001:\u0001tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020&H\u0016J\u001c\u0010'\u001a\u00020(2\b\b\u0002\u0010)\u001a\u00020*2\b\b\u0002\u0010+\u001a\u00020\u0013H\u0007J\u0016\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010,\u001a\u00020-J\"\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020(2\u0006\u00101\u001a\u00020*2\n\u00102\u001a\u0006\u0012\u0002\b\u000303J\u001a\u00104\u001a\u00020\u00132\u0006\u0010)\u001a\u00020*2\b\b\u0002\u00105\u001a\u00020\u0013H\u0002J&\u00106\u001a\u0002072\b\b\u0002\u0010)\u001a\u00020*2\u0014\b\u0002\u00108\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020;09J\"\u0010<\u001a\u00020;2\u0006\u0010=\u001a\u0002072\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020;09J&\u0010>\u001a\u0002072\b\b\u0002\u0010)\u001a\u00020*2\u0014\b\u0002\u00108\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020;09J\u000e\u0010>\u001a\u00020;2\u0006\u0010=\u001a\u000207J$\u0010?\u001a\u00020@2\u0006\u0010)\u001a\u00020*2\u0014\b\u0002\u00108\u001a\u000e\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020;09J,\u0010B\u001a\u00020@2\u0006\u00100\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0014\b\u0002\u00108\u001a\u000e\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020;09J,\u0010C\u001a\u00020@2\u0006\u0010)\u001a\u00020*2\u0006\u0010D\u001a\u00020E2\u0014\b\u0002\u00108\u001a\u000e\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020;09J$\u0010F\u001a\u00020@2\u0006\u0010)\u001a\u00020*2\u0014\b\u0002\u00108\u001a\u000e\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020;09J\u0010\u0010G\u001a\u00020;2\u0006\u0010H\u001a\u00020@H\u0002J\u0016\u0010I\u001a\u00020@2\u0006\u0010)\u001a\u00020*2\u0006\u0010J\u001a\u00020KJ\u0016\u0010L\u001a\u00020;2\u0006\u0010H\u001a\u00020M2\u0006\u0010N\u001a\u00020*J\"\u0010O\u001a\u00020;2\u0006\u0010H\u001a\u00020M2\u0012\u0010P\u001a\u000e\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020;09J\u0016\u0010Q\u001a\u00020;2\u0006\u00100\u001a\u00020(2\u0006\u0010N\u001a\u00020*J\u000e\u0010R\u001a\u00020;2\u0006\u00100\u001a\u00020(J\u001f\u0010S\u001a\u00020;2\u0012\u0010T\u001a\n\u0012\u0006\b\u0001\u0012\u00020*0U\"\u00020*\u00a2\u0006\u0002\u0010VJK\u0010W\u001a\u0002HX\"\u000e\b\u0000\u0010X*\b\u0012\u0004\u0012\u0002HZ0Y\"\b\b\u0001\u0010Z*\u00020[2\u0006\u00100\u001a\u00020(2\u0012\u0010\\\u001a\u000e\u0012\u0004\u0012\u0002HX\u0012\u0004\u0012\u0002HZ0]2\b\b\u0002\u0010^\u001a\u0002HZ\u00a2\u0006\u0002\u0010_J\u0012\u0010`\u001a\u00020;2\n\u0010a\u001a\u0006\u0012\u0002\b\u00030YJ\u0010\u0010b\u001a\u00020;2\u0006\u0010c\u001a\u00020*H\u0004J\b\u0010d\u001a\u00020;H\u0004R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0012\u0010\u001e\u001a\u00060\u001fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010e\u001a\u00020f8F\u00a2\u0006\u0006\u001a\u0004\bg\u0010hR\u0011\u0010i\u001a\u00020j8F\u00a2\u0006\u0006\u001a\u0004\bk\u0010lR\u0011\u0010m\u001a\u00020n8F\u00a2\u0006\u0006\u001a\u0004\bo\u0010pR\u0011\u0010q\u001a\u00020E8F\u00a2\u0006\u0006\u001a\u0004\br\u0010s\u00a8\u0006u"}, d2={"Lcom/intellij/testFramework/rules/ProjectModelRule;", "Lorg/junit/rules/TestRule;", "<init>", "()V", "baseProjectDir", "Lcom/intellij/testFramework/rules/TempDirectory;", "getBaseProjectDir", "()Lcom/intellij/testFramework/rules/TempDirectory;", "disposableRule", "Lcom/intellij/testFramework/DisposableRule;", "getDisposableRule", "()Lcom/intellij/testFramework/DisposableRule;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "setProject", "(Lcom/intellij/openapi/project/Project;)V", "projectRootDir", "Ljava/nio/file/Path;", "getProjectRootDir", "()Ljava/nio/file/Path;", "setProjectRootDir", "(Ljava/nio/file/Path;)V", "filePointerTracker", "Lcom/intellij/openapi/vfs/impl/VirtualFilePointerTracker;", "getFilePointerTracker", "()Lcom/intellij/openapi/vfs/impl/VirtualFilePointerTracker;", "setFilePointerTracker", "(Lcom/intellij/openapi/vfs/impl/VirtualFilePointerTracker;)V", "projectResource", "Lcom/intellij/testFramework/rules/ProjectModelRule$ProjectResource;", "ruleChain", "Lcom/intellij/testFramework/RuleChain;", "apply", "Lorg/junit/runners/model/Statement;", "base", "description", "Lorg/junit/runner/Description;", "createModule", "Lcom/intellij/openapi/module/Module;", "name", "", "moduleBaseDir", "moduleModel", "Lcom/intellij/openapi/module/ModifiableModuleModel;", "addSourceRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "module", "relativePath", "rootType", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "generateImlPath", "rootDir", "createSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "setup", "Lkotlin/Function1;", "Lcom/intellij/openapi/projectRoots/SdkModificator;", "", "modifySdk", "sdk", "addSdk", "addProjectLevelLibrary", "Lcom/intellij/openapi/roots/impl/libraries/LibraryEx;", "Lcom/intellij/openapi/roots/impl/libraries/LibraryEx$ModifiableModelEx;", "addModuleLevelLibrary", "addLibrary", "libraryTable", "Lcom/intellij/openapi/roots/libraries/LibraryTable;", "addApplicationLevelLibrary", "disposeOnTearDown", "library", "createLibraryAndDisposeOnTearDown", "model", "Lcom/intellij/openapi/roots/libraries/LibraryTable$ModifiableModel;", "renameLibrary", "Lcom/intellij/openapi/roots/libraries/Library;", "newName", "modifyLibrary", "action", "renameModule", "removeModule", "setUnloadedModules", "moduleName", "", "([Ljava/lang/String;)V", "addFacet", "F", "Lcom/intellij/facet/Facet;", "C", "Lcom/intellij/facet/FacetConfiguration;", "type", "Lcom/intellij/facet/FacetType;", "configuration", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/facet/FacetType;Lcom/intellij/facet/FacetConfiguration;)Lcom/intellij/facet/Facet;", "removeFacet", "facet", "setUp", "methodName", "tearDown", "sdkType", "Lcom/intellij/openapi/projectRoots/SdkTypeId;", "getSdkType", "()Lcom/intellij/openapi/projectRoots/SdkTypeId;", "projectRootManager", "Lcom/intellij/openapi/roots/ProjectRootManager;", "getProjectRootManager", "()Lcom/intellij/openapi/roots/ProjectRootManager;", "moduleManager", "Lcom/intellij/openapi/module/ModuleManager;", "getModuleManager", "()Lcom/intellij/openapi/module/ModuleManager;", "projectLibraryTable", "getProjectLibraryTable", "()Lcom/intellij/openapi/roots/libraries/LibraryTable;", "ProjectResource", "intellij.platform.testFramework"})
@SourceDebugExtension(value={"SMAP\nProjectModelRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectModelRule.kt\ncom/intellij/testFramework/rules/ProjectModelRule\n+ 2 readWriteActionsInTests.kt\ncom/intellij/openapi/application/ReadWriteActionsInTestsKt\n+ 3 FixtureRule.kt\ncom/intellij/testFramework/DisposableRule\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,283:1\n11#2:284\n11#2:285\n11#2:286\n11#2:293\n11#2:294\n11#2:295\n11#2:296\n585#3,6:287\n1#4:297\n19985#5,2:298\n*S KotlinDebug\n*F\n+ 1 ProjectModelRule.kt\ncom/intellij/testFramework/rules/ProjectModelRule\n*L\n78#1:284\n138#1:285\n162#1:286\n203#1:293\n210#1:294\n215#1:295\n231#1:296\n179#1:287,6\n96#1:298,2\n*E\n"})
public class ProjectModelRule
implements TestRule {
    @NotNull
    private final TempDirectory baseProjectDir = new TempDirectory();
    @NotNull
    private final DisposableRule disposableRule = new DisposableRule();
    public Project project;
    public Path projectRootDir;
    public VirtualFilePointerTracker filePointerTracker;
    @NotNull
    private final ProjectResource projectResource = new ProjectResource();
    @NotNull
    private final RuleChain ruleChain;

    public ProjectModelRule() {
        TestRule[] testRuleArray = new TestRule[]{this.baseProjectDir, this.projectResource, this.disposableRule};
        this.ruleChain = new RuleChain(testRuleArray);
    }

    @NotNull
    public final TempDirectory getBaseProjectDir() {
        return this.baseProjectDir;
    }

    @NotNull
    public final DisposableRule getDisposableRule() {
        return this.disposableRule;
    }

    @NotNull
    public final Project getProject() {
        Project project = this.project;
        if (project != null) {
            return project;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        return null;
    }

    public final void setProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"<set-?>");
        this.project = project;
    }

    @NotNull
    public final Path getProjectRootDir() {
        Path path = this.projectRootDir;
        if (path != null) {
            return path;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"projectRootDir");
        return null;
    }

    public final void setProjectRootDir(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.projectRootDir = path;
    }

    @NotNull
    public final VirtualFilePointerTracker getFilePointerTracker() {
        VirtualFilePointerTracker virtualFilePointerTracker = this.filePointerTracker;
        if (virtualFilePointerTracker != null) {
            return virtualFilePointerTracker;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"filePointerTracker");
        return null;
    }

    public final void setFilePointerTracker(@NotNull VirtualFilePointerTracker virtualFilePointerTracker) {
        Intrinsics.checkNotNullParameter((Object)virtualFilePointerTracker, (String)"<set-?>");
        this.filePointerTracker = virtualFilePointerTracker;
    }

    @NotNull
    public Statement apply(@NotNull Statement base, @NotNull Description description) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        return this.ruleChain.apply(base, description);
    }

    @JvmOverloads
    @NotNull
    public final Module createModule(@NotNull String name, @NotNull Path moduleBaseDir) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)moduleBaseDir, (String)"moduleBaseDir");
        Path imlFile = this.generateImlPath(name, moduleBaseDir);
        ModuleManager manager = this.getModuleManager();
        boolean $i$f$runWriteActionAndWait = false;
        Object object = WriteAction.computeAndWait((ThrowableComputable)new ThrowableComputable(manager, imlFile){
            final /* synthetic */ ModuleManager $manager$inlined;
            final /* synthetic */ Path $imlFile$inlined;
            {
                this.$manager$inlined = moduleManager;
                this.$imlFile$inlined = path;
            }

            public final T compute() {
                boolean bl = false;
                return (T)this.$manager$inlined.newModule(this.$imlFile$inlined, "EMPTY_MODULE");
            }
        });
        Module it = (Module)object;
        boolean bl = false;
        IndexingTestUtil.Companion.waitUntilIndexesAreReady$default(IndexingTestUtil.Companion, this.getProject(), null, 2, null);
        return (Module)object;
    }

    public static /* synthetic */ Module createModule$default(ProjectModelRule projectModelRule, String string, Path path, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createModule");
        }
        if ((n & 1) != 0) {
            string = "module";
        }
        if ((n & 2) != 0) {
            path = projectModelRule.getProjectRootDir();
        }
        return projectModelRule.createModule(string, path);
    }

    @NotNull
    public final Module createModule(@NotNull String name, @NotNull ModifiableModuleModel moduleModel) {
        Module module2;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)moduleModel, (String)"moduleModel");
        Module module3 = moduleModel.newModule(ProjectModelRule.generateImlPath$default(this, name, null, 2, null), "EMPTY_MODULE");
        Intrinsics.checkNotNullExpressionValue((Object)module3, (String)"newModule(...)");
        Module it = module2 = module3;
        boolean bl = false;
        IndexingTestUtil.Companion.waitUntilIndexesAreReady$default(IndexingTestUtil.Companion, this.getProject(), null, 2, null);
        return module2;
    }

    @NotNull
    public final VirtualFile addSourceRoot(@NotNull Module module2, @NotNull String relativePath, @NotNull JpsModuleSourceRootType<?> rootType) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter(rootType, (String)"rootType");
        VirtualFile srcRoot = this.baseProjectDir.newVirtualDirectory(module2.getName() + "/" + relativePath);
        ModuleRootModificationUtil.updateModel((Module)module2, arg_0 -> ProjectModelRule.addSourceRoot$lambda$1(arg_0 -> ProjectModelRule.addSourceRoot$lambda$0(this, module2, srcRoot, rootType, arg_0), arg_0));
        IndexingTestUtil.Companion.waitUntilIndexesAreReady$default(IndexingTestUtil.Companion, this.getProject(), null, 2, null);
        return srcRoot;
    }

    private final Path generateImlPath(String name, Path rootDir) {
        Path path = rootDir.resolve(name + "/" + name + ".iml");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    static /* synthetic */ Path generateImlPath$default(ProjectModelRule projectModelRule, String string, Path path, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: generateImlPath");
        }
        if ((n & 2) != 0) {
            path = projectModelRule.getProjectRootDir();
        }
        return projectModelRule.generateImlPath(string, path);
    }

    @NotNull
    public final Sdk createSdk(@NotNull String name, @NotNull Function1<? super SdkModificator, Unit> setup) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(setup, (String)"setup");
        Sdk sdk = ProjectJdkTable.getInstance().createSdk(name, this.getSdkType());
        Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"createSdk(...)");
        Sdk sdk2 = sdk;
        this.modifySdk(sdk2, setup);
        IndexingTestUtil.Companion.waitUntilIndexesAreReady$default(IndexingTestUtil.Companion, this.getProject(), null, 2, null);
        return sdk2;
    }

    public static /* synthetic */ Sdk createSdk$default(ProjectModelRule projectModelRule, String string, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createSdk");
        }
        if ((n & 1) != 0) {
            string = "sdk";
        }
        if ((n & 2) != 0) {
            function1 = ProjectModelRule::createSdk$lambda$0;
        }
        return projectModelRule.createSdk(string, (Function1<? super SdkModificator, Unit>)function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void modifySdk(@NotNull Sdk sdk, @NotNull Function1<? super SdkModificator, Unit> setup) {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        Intrinsics.checkNotNullParameter(setup, (String)"setup");
        SdkModificator sdkModificator = sdk.getSdkModificator();
        Intrinsics.checkNotNullExpressionValue((Object)sdkModificator, (String)"getSdkModificator(...)");
        SdkModificator sdkModificator2 = sdkModificator;
        try {
            setup.invoke((Object)sdkModificator2);
        }
        finally {
            Application application = ApplicationManager.getApplication();
            Function0 runnable = () -> ProjectModelRule.modifySdk$lambda$0(sdkModificator2);
            if (application.isDispatchThread()) {
                ActionsKt.runWriteAction((Function0)runnable);
            } else {
                application.invokeAndWait(() -> ProjectModelRule.modifySdk$lambda$1(runnable));
            }
        }
        IndexingTestUtil.Companion.waitUntilIndexesAreReady$default(IndexingTestUtil.Companion, this.getProject(), null, 2, null);
    }

    @NotNull
    public final Sdk addSdk(@NotNull String name, @NotNull Function1<? super SdkModificator, Unit> setup) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(setup, (String)"setup");
        Sdk sdk = this.createSdk(name, setup);
        this.addSdk(sdk);
        return sdk;
    }

    public static /* synthetic */ Sdk addSdk$default(ProjectModelRule projectModelRule, String string, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addSdk");
        }
        if ((n & 1) != 0) {
            string = "sdk";
        }
        if ((n & 2) != 0) {
            function1 = ProjectModelRule::addSdk$lambda$0;
        }
        return projectModelRule.addSdk(string, (Function1<? super SdkModificator, Unit>)function1);
    }

    public final void addSdk(@NotNull Sdk sdk) {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        boolean $i$f$runWriteActionAndWait = false;
        WriteAction.computeAndWait((ThrowableComputable)new ThrowableComputable(sdk, this){
            final /* synthetic */ Sdk $sdk$inlined;
            final /* synthetic */ ProjectModelRule this$0;
            {
                this.$sdk$inlined = sdk;
                this.this$0 = projectModelRule;
            }

            public final T compute() {
                boolean bl = false;
                ProjectJdkTable.getInstance().addJdk(this.$sdk$inlined, this.this$0.getDisposableRule().getDisposable());
                return (T)Unit.INSTANCE;
            }
        });
        IndexingTestUtil.Companion.waitUntilIndexesAreReady$default(IndexingTestUtil.Companion, this.getProject(), null, 2, null);
    }

    @NotNull
    public final LibraryEx addProjectLevelLibrary(@NotNull String name, @NotNull Function1<? super LibraryEx.ModifiableModelEx, Unit> setup) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(setup, (String)"setup");
        return this.addLibrary(name, this.getProjectLibraryTable(), setup);
    }

    public static /* synthetic */ LibraryEx addProjectLevelLibrary$default(ProjectModelRule projectModelRule, String string, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addProjectLevelLibrary");
        }
        if ((n & 2) != 0) {
            function1 = ProjectModelRule::addProjectLevelLibrary$lambda$0;
        }
        return projectModelRule.addProjectLevelLibrary(string, (Function1<? super LibraryEx.ModifiableModelEx, Unit>)function1);
    }

    @NotNull
    public final LibraryEx addModuleLevelLibrary(@NotNull Module module2, @NotNull String name, @NotNull Function1<? super LibraryEx.ModifiableModelEx, Unit> setup) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(setup, (String)"setup");
        Ref ref = Ref.create();
        Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"create(...)");
        Ref library = ref;
        ModuleRootModificationUtil.updateModel((Module)module2, arg_0 -> ProjectModelRule.addModuleLevelLibrary$lambda$2(arg_0 -> ProjectModelRule.addModuleLevelLibrary$lambda$1(library, this, name, setup, arg_0), arg_0));
        IndexingTestUtil.Companion.waitUntilIndexesAreReady$default(IndexingTestUtil.Companion, this.getProject(), null, 2, null);
        Object object = library.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (LibraryEx)object;
    }

    public static /* synthetic */ LibraryEx addModuleLevelLibrary$default(ProjectModelRule projectModelRule, Module module2, String string, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addModuleLevelLibrary");
        }
        if ((n & 4) != 0) {
            function1 = ProjectModelRule::addModuleLevelLibrary$lambda$0;
        }
        return projectModelRule.addModuleLevelLibrary(module2, string, (Function1<? super LibraryEx.ModifiableModelEx, Unit>)function1);
    }

    @NotNull
    public final LibraryEx addLibrary(@NotNull String name, @NotNull LibraryTable libraryTable, @NotNull Function1<? super LibraryEx.ModifiableModelEx, Unit> setup) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)libraryTable, (String)"libraryTable");
        Intrinsics.checkNotNullParameter(setup, (String)"setup");
        LibraryTable.ModifiableModel modifiableModel = libraryTable.getModifiableModel();
        Intrinsics.checkNotNullExpressionValue((Object)modifiableModel, (String)"getModifiableModel(...)");
        LibraryTable.ModifiableModel model = modifiableModel;
        Library library = model.createLibrary(name);
        Intrinsics.checkNotNull((Object)library, (String)"null cannot be cast to non-null type com.intellij.openapi.roots.impl.libraries.LibraryEx");
        LibraryEx library2 = (LibraryEx)library;
        LibraryEx.ModifiableModelEx modifiableModelEx = library2.getModifiableModel();
        Intrinsics.checkNotNullExpressionValue((Object)modifiableModelEx, (String)"getModifiableModel(...)");
        LibraryEx.ModifiableModelEx libraryModel = modifiableModelEx;
        setup.invoke((Object)libraryModel);
        boolean $i$f$runWriteActionAndWait = false;
        WriteAction.computeAndWait((ThrowableComputable)new ThrowableComputable(libraryModel, model){
            final /* synthetic */ LibraryEx.ModifiableModelEx $libraryModel$inlined;
            final /* synthetic */ LibraryTable.ModifiableModel $model$inlined;
            {
                this.$libraryModel$inlined = modifiableModelEx;
                this.$model$inlined = modifiableModel;
            }

            public final T compute() {
                boolean bl = false;
                this.$libraryModel$inlined.commit();
                this.$model$inlined.commit();
                return (T)Unit.INSTANCE;
            }
        });
        Object[] objectArray = new String[]{"module", "project"};
        if (!SetsKt.setOf((Object[])objectArray).contains(libraryTable.getTableLevel())) {
            this.disposeOnTearDown(library2);
        }
        IndexingTestUtil.Companion.waitUntilIndexesAreReady$default(IndexingTestUtil.Companion, this.getProject(), null, 2, null);
        return library2;
    }

    public static /* synthetic */ LibraryEx addLibrary$default(ProjectModelRule projectModelRule, String string, LibraryTable libraryTable, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addLibrary");
        }
        if ((n & 4) != 0) {
            function1 = ProjectModelRule::addLibrary$lambda$0;
        }
        return projectModelRule.addLibrary(string, libraryTable, (Function1<? super LibraryEx.ModifiableModelEx, Unit>)function1);
    }

    @NotNull
    public final LibraryEx addApplicationLevelLibrary(@NotNull String name, @NotNull Function1<? super LibraryEx.ModifiableModelEx, Unit> setup) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(setup, (String)"setup");
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable();
        Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"getLibraryTable(...)");
        LibraryTable libraryTable2 = libraryTable;
        return this.addLibrary(name, libraryTable2, setup);
    }

    public static /* synthetic */ LibraryEx addApplicationLevelLibrary$default(ProjectModelRule projectModelRule, String string, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addApplicationLevelLibrary");
        }
        if ((n & 2) != 0) {
            function1 = ProjectModelRule::addApplicationLevelLibrary$lambda$0;
        }
        return projectModelRule.addApplicationLevelLibrary(string, (Function1<? super LibraryEx.ModifiableModelEx, Unit>)function1);
    }

    private final void disposeOnTearDown(LibraryEx library) {
        DisposableRule this_$iv = this.disposableRule;
        boolean $i$f$register = false;
        Disposer.register((Disposable)this_$iv.getDisposable(), (Disposable)new Disposable(library){
            final /* synthetic */ LibraryEx $library$inlined;
            {
                this.$library$inlined = libraryEx;
            }

            public void dispose() {
                boolean bl = false;
                boolean $i$f$runWriteActionAndWait = false;
                WriteAction.computeAndWait((ThrowableComputable)new ThrowableComputable(this.$library$inlined){
                    final /* synthetic */ LibraryEx $library$inlined;
                    {
                        this.$library$inlined = libraryEx;
                    }

                    public final T compute() {
                        boolean bl = false;
                        if (!this.$library$inlined.isDisposed()) {
                            LibraryTable libraryTable = this.$library$inlined.getTable();
                            String string = this.$library$inlined.getName();
                            Intrinsics.checkNotNull((Object)string);
                            if (Intrinsics.areEqual((Object)libraryTable.getLibraryByName(string), (Object)this.$library$inlined)) {
                                this.$library$inlined.getTable().removeLibrary((Library)this.$library$inlined);
                            }
                        }
                        return (T)Unit.INSTANCE;
                    }
                });
            }
        });
    }

    @NotNull
    public final LibraryEx createLibraryAndDisposeOnTearDown(@NotNull String name, @NotNull LibraryTable.ModifiableModel model) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Library library = model.createLibrary(name);
        Intrinsics.checkNotNull((Object)library, (String)"null cannot be cast to non-null type com.intellij.openapi.roots.impl.libraries.LibraryEx");
        LibraryEx library2 = (LibraryEx)library;
        this.disposeOnTearDown(library2);
        return library2;
    }

    public final void renameLibrary(@NotNull Library library, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        this.modifyLibrary(library, (Function1<? super LibraryEx.ModifiableModelEx, Unit>)((Function1)arg_0 -> ProjectModelRule.renameLibrary$lambda$0(newName, arg_0)));
    }

    public final void modifyLibrary(@NotNull Library library, @NotNull Function1<? super LibraryEx.ModifiableModelEx, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Library.ModifiableModel modifiableModel = library.getModifiableModel();
        Intrinsics.checkNotNull((Object)modifiableModel, (String)"null cannot be cast to non-null type com.intellij.openapi.roots.impl.libraries.LibraryEx.ModifiableModelEx");
        LibraryEx.ModifiableModelEx model = (LibraryEx.ModifiableModelEx)modifiableModel;
        action.invoke((Object)model);
        boolean $i$f$runWriteActionAndWait = false;
        WriteAction.computeAndWait((ThrowableComputable)new ThrowableComputable(model){
            final /* synthetic */ LibraryEx.ModifiableModelEx $model$inlined;
            {
                this.$model$inlined = modifiableModelEx;
            }

            public final T compute() {
                boolean bl = false;
                this.$model$inlined.commit();
                return (T)Unit.INSTANCE;
            }
        });
        IndexingTestUtil.Companion.waitUntilIndexesAreReady$default(IndexingTestUtil.Companion, this.getProject(), null, 2, null);
    }

    public final void renameModule(@NotNull Module module2, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        ModifiableModuleModel model = (ModifiableModuleModel)ActionsKt.runReadAction(() -> ProjectModelRule.renameModule$lambda$0(this));
        model.renameModule(module2, newName);
        boolean $i$f$runWriteActionAndWait = false;
        WriteAction.computeAndWait((ThrowableComputable)new ThrowableComputable(model){
            final /* synthetic */ ModifiableModuleModel $model$inlined;
            {
                this.$model$inlined = modifiableModuleModel;
            }

            public final T compute() {
                boolean bl = false;
                this.$model$inlined.commit();
                return (T)Unit.INSTANCE;
            }
        });
        IndexingTestUtil.Companion.waitUntilIndexesAreReady$default(IndexingTestUtil.Companion, this.getProject(), null, 2, null);
    }

    public final void removeModule(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        boolean $i$f$runWriteActionAndWait = false;
        WriteAction.computeAndWait((ThrowableComputable)new ThrowableComputable(this, module2){
            final /* synthetic */ ProjectModelRule this$0;
            final /* synthetic */ Module $module$inlined;
            {
                this.this$0 = projectModelRule;
                this.$module$inlined = module2;
            }

            public final T compute() {
                boolean bl = false;
                this.this$0.getModuleManager().disposeModule(this.$module$inlined);
                return (T)Unit.INSTANCE;
            }
        });
        IndexingTestUtil.Companion.waitUntilIndexesAreReady$default(IndexingTestUtil.Companion, this.getProject(), null, 2, null);
    }

    public final void setUnloadedModules(String ... moduleName) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        ProjectUtilKt.runUnderModalProgressIfIsEdt((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, moduleName, null){
            int label;
            final /* synthetic */ ProjectModelRule this$0;
            final /* synthetic */ String[] $moduleName;
            {
                this.this$0 = $receiver;
                this.$moduleName = $moduleName;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.getModuleManager().setUnloadedModules(ArraysKt.toList((Object[])this.$moduleName), (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        IndexingTestUtil.Companion.waitUntilIndexesAreReady$default(IndexingTestUtil.Companion, this.getProject(), null, 2, null);
    }

    @NotNull
    public final <F extends Facet<C>, C extends FacetConfiguration> F addFacet(@NotNull Module module2, @NotNull FacetType<F, C> type, @NotNull C configuration) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        FacetManager facetManager = FacetManager.getInstance((Module)module2);
        Intrinsics.checkNotNullExpressionValue((Object)facetManager, (String)"getInstance(...)");
        FacetManager facetManager2 = facetManager;
        ModifiableFacetModel modifiableFacetModel = facetManager2.createModifiableModel();
        Intrinsics.checkNotNullExpressionValue((Object)modifiableFacetModel, (String)"createModifiableModel(...)");
        ModifiableFacetModel model = modifiableFacetModel;
        Facet facet = facetManager2.createFacet(type, type.getDefaultFacetName(), configuration, null);
        Intrinsics.checkNotNullExpressionValue((Object)facet, (String)"createFacet(...)");
        Facet facet2 = facet;
        model.addFacet(facet2);
        boolean $i$f$runWriteActionAndWait = false;
        WriteAction.computeAndWait((ThrowableComputable)new ThrowableComputable(model){
            final /* synthetic */ ModifiableFacetModel $model$inlined;
            {
                this.$model$inlined = modifiableFacetModel;
            }

            public final T compute() {
                boolean bl = false;
                this.$model$inlined.commit();
                return (T)Unit.INSTANCE;
            }
        });
        IndexingTestUtil.Companion.waitUntilIndexesAreReady$default(IndexingTestUtil.Companion, this.getProject(), null, 2, null);
        return (F)facet2;
    }

    public static /* synthetic */ Facet addFacet$default(ProjectModelRule projectModelRule, Module module2, FacetType facetType, FacetConfiguration facetConfiguration, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addFacet");
        }
        if ((n & 4) != 0) {
            FacetConfiguration facetConfiguration2 = facetType.createDefaultConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)facetConfiguration2, (String)"createDefaultConfiguration(...)");
            facetConfiguration = facetConfiguration2;
        }
        return projectModelRule.addFacet(module2, facetType, facetConfiguration);
    }

    public final void removeFacet(@NotNull Facet<?> facet) {
        Intrinsics.checkNotNullParameter(facet, (String)"facet");
        FacetUtil.deleteFacet(facet);
        IndexingTestUtil.Companion.waitUntilIndexesAreReady$default(IndexingTestUtil.Companion, this.getProject(), null, 2, null);
    }

    protected final void setUp(@NotNull String methodName) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        this.baseProjectDir.before(methodName);
        this.projectResource.before();
    }

    protected final void tearDown() {
        this.disposableRule.after();
        this.projectResource.after();
        this.baseProjectDir.after();
    }

    @NotNull
    public final SdkTypeId getSdkType() {
        SimpleJavaSdkType simpleJavaSdkType = SimpleJavaSdkType.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)simpleJavaSdkType, (String)"getInstance(...)");
        return (SdkTypeId)simpleJavaSdkType;
    }

    @NotNull
    public final ProjectRootManager getProjectRootManager() {
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"getInstance(...)");
        return projectRootManager;
    }

    @NotNull
    public final ModuleManager getModuleManager() {
        return ModuleManager.Companion.getInstance(this.getProject());
    }

    @NotNull
    public final LibraryTable getProjectLibraryTable() {
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"getLibraryTable(...)");
        return libraryTable;
    }

    @JvmOverloads
    @NotNull
    public final Module createModule(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return ProjectModelRule.createModule$default(this, name, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final Module createModule() {
        return ProjectModelRule.createModule$default(this, null, null, 3, null);
    }

    private static final Unit addSourceRoot$lambda$0(ProjectModelRule this$0, Module $module, VirtualFile $srcRoot, JpsModuleSourceRootType $rootType, ModifiableRootModel model) {
        boolean bl;
        ContentEntry contentEntry;
        block5: {
            ContentEntry contentEntry2;
            Object object;
            String contentRootUrl;
            block4: {
                Path path = this$0.getProjectRootDir().resolve($module.getName());
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                String string = VfsUtil.pathToUrl((String)PathsKt.getInvariantSeparatorsPathString((Path)path));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathToUrl(...)");
                contentRootUrl = string;
                ContentEntry[] contentEntryArray = model.getContentEntries();
                Intrinsics.checkNotNullExpressionValue((Object)contentEntryArray, (String)"getContentEntries(...)");
                for (Object object2 : (Object[])contentEntryArray) {
                    ContentEntry it = (ContentEntry)object2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getUrl(), (Object)contentRootUrl)) continue;
                    object = object2;
                    break block4;
                }
                object = null;
            }
            if ((contentEntry2 = (ContentEntry)object) == null) {
                ContentEntry contentEntry3 = model.addContentEntry(contentRootUrl);
                contentEntry2 = contentEntry3;
                Intrinsics.checkNotNullExpressionValue((Object)contentEntry3, (String)"addContentEntry(...)");
            }
            contentEntry = contentEntry2;
            SourceFolder[] sourceFolderArray = contentEntry.getSourceFolders();
            Intrinsics.checkNotNullExpressionValue((Object)sourceFolderArray, (String)"getSourceFolders(...)");
            Object[] $this$none$iv = sourceFolderArray;
            boolean $i$f$none = false;
            for (Object element$iv : $this$none$iv) {
                SourceFolder it = (SourceFolder)element$iv;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getUrl(), (Object)$srcRoot.getUrl())) continue;
                bl = false;
                break block5;
            }
            bl = true;
        }
        if (!bl) {
            boolean bl4 = false;
            String string = "Source folder " + $srcRoot + " already exists";
            throw new IllegalArgumentException(string.toString());
        }
        contentEntry.addSourceFolder($srcRoot, $rootType);
        return Unit.INSTANCE;
    }

    private static final void addSourceRoot$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit createSdk$lambda$0(SdkModificator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit modifySdk$lambda$0(SdkModificator $sdkModificator) {
        $sdkModificator.commitChanges();
        return Unit.INSTANCE;
    }

    private static final void modifySdk$lambda$1(Function0 $runnable) {
        ActionsKt.runWriteAction((Function0)$runnable);
    }

    private static final Unit addSdk$lambda$0(SdkModificator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit addProjectLevelLibrary$lambda$0(LibraryEx.ModifiableModelEx it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit addModuleLevelLibrary$lambda$0(LibraryEx.ModifiableModelEx it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit addModuleLevelLibrary$lambda$1(Ref $library, ProjectModelRule this$0, String $name, Function1 $setup, ModifiableRootModel model) {
        LibraryTable libraryTable = model.getModuleLibraryTable();
        Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"getModuleLibraryTable(...)");
        $library.set((Object)this$0.addLibrary($name, libraryTable, (Function1<? super LibraryEx.ModifiableModelEx, Unit>)$setup));
        return Unit.INSTANCE;
    }

    private static final void addModuleLevelLibrary$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit addLibrary$lambda$0(LibraryEx.ModifiableModelEx it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit addApplicationLevelLibrary$lambda$0(LibraryEx.ModifiableModelEx it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit renameLibrary$lambda$0(String $newName, LibraryEx.ModifiableModelEx it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setName($newName);
        return Unit.INSTANCE;
    }

    private static final ModifiableModuleModel renameModule$lambda$0(ProjectModelRule this$0) {
        return this$0.getModuleManager().getModifiableModel();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/testFramework/rules/ProjectModelRule$ProjectResource;", "Lorg/junit/rules/ExternalResource;", "<init>", "(Lcom/intellij/testFramework/rules/ProjectModelRule;)V", "before", "", "after", "intellij.platform.testFramework"})
    public final class ProjectResource
    extends ExternalResource {
        public void before() {
            Path path = ProjectModelRule.this.getBaseProjectDir().getRoot().toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            ProjectModelRule.this.setProjectRootDir(path);
            Project project = PlatformTestUtil.loadAndOpenProject(ProjectModelRule.this.getProjectRootDir(), ProjectModelRule.this.getDisposableRule().getDisposable());
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"loadAndOpenProject(...)");
            ProjectModelRule.this.setProject(project);
            ProjectModelRule.this.setFilePointerTracker(new VirtualFilePointerTracker());
        }

        public void after() {
            PlatformTestUtil.forceCloseProjectWithoutSaving(ProjectModelRule.this.getProject());
            ProjectModelRule.this.getFilePointerTracker().assertPointersAreDisposed();
        }
    }
}

