/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tests;

import com.intellij.tests.JUnit5TeamCityRunnerForTestAllSuite;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import jetbrains.buildServer.messages.serviceMessages.Message;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.EngineFilter;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.PostDiscoveryFilter;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;

public final class JUnit5TeamCityRunnerForTestsOnClasspath {
    private static final String ourCollectTestsFile = System.getProperty("intellij.build.test.list.classes");

    public static void reportFailureAsBuildProblem(Throwable e) {
        int messageSplitThreshold = 4000;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        String stackTrace = sw.toString();
        for (int i = 0; i < stackTrace.length(); i += messageSplitThreshold) {
            int endIndex = Math.min(i + messageSplitThreshold, stackTrace.length());
            String chunk = stackTrace.substring(i, endIndex);
            System.out.println(new Message(chunk, "FAILURE", null).asString());
        }
        System.out.println(ServiceMessage.asString((String)"buildProblem", Collections.singletonMap("description", stackTrace.substring(0, messageSplitThreshold))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            Set<Path> classPathRoots;
            PostDiscoveryFilter postDiscoveryFilter;
            ClassNameFilter nameFilter;
            Launcher launcher = LauncherFactory.create();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                nameFilter = JUnit5TeamCityRunnerForTestsOnClasspath.createClassNameFilter(classLoader);
                postDiscoveryFilter = JUnit5TeamCityRunnerForTestsOnClasspath.createPostDiscoveryFilter(classLoader);
                classPathRoots = JUnit5TeamCityRunnerForTestsOnClasspath.getClassPathRoots(classLoader);
            }
            catch (Throwable e) {
                e.printStackTrace();
                System.exit(1);
                System.exit(0);
                return;
            }
            System.out.println("Number of test engines: " + ServiceLoader.load(TestEngine.class).stream().count());
            List<PackageSelector> selectors = classPathRoots != null ? DiscoverySelectors.selectClasspathRoots(classPathRoots) : Collections.singletonList(DiscoverySelectors.selectPackage((String)""));
            LauncherDiscoveryRequest discoveryRequest = LauncherDiscoveryRequestBuilder.request().configurationParameter("junit.jupiter.extensions.autodetection.enabled", "true").selectors(selectors).filters(new Filter[]{nameFilter, postDiscoveryFilter, EngineFilter.excludeEngines((String[])new String[]{"junit-vintage"})}).build();
            TestPlan testPlan = launcher.discover(discoveryRequest);
            if (testPlan.containsTests()) {
                if (ourCollectTestsFile != null) {
                    JUnit5TeamCityRunnerForTestsOnClasspath.saveListOfTestClasses(testPlan);
                    return;
                }
                launcher.execute(testPlan, new TestExecutionListener[]{new JUnit5TeamCityRunnerForTestAllSuite.TCExecutionListener()});
            } else {
                System.exit(42);
            }
        }
        catch (Throwable e) {
            JUnit5TeamCityRunnerForTestsOnClasspath.reportFailureAsBuildProblem(e);
            System.exit(1);
        }
        finally {
            System.exit(0);
        }
    }

    private static Set<Path> getClassPathRoots(ClassLoader classLoader) throws Throwable {
        List paths = MethodHandles.publicLookup().findStatic(Class.forName("com.intellij.TestAll", false, classLoader), "getClassRoots", MethodType.methodType(List.class)).invokeExact();
        if (paths == null) {
            return null;
        }
        String relevantJarsRoot = System.getProperty("intellij.test.jars.location");
        return paths.stream().filter(path -> Files.isDirectory(path, new LinkOption[0]) || relevantJarsRoot != null && path.getFileName().toString().endsWith(".jar") && path.startsWith(relevantJarsRoot)).collect(Collectors.toSet());
    }

    private static ClassNameFilter createClassNameFilter(ClassLoader classLoader) throws NoSuchMethodException, ClassNotFoundException, IllegalAccessException {
        final MethodHandle included = MethodHandles.publicLookup().findStatic(Class.forName("com.intellij.TestCaseLoader", true, classLoader), "isClassNameIncluded", MethodType.methodType(Boolean.TYPE, String.class));
        return new ClassNameFilter(){

            public FilterResult apply(String className) {
                try {
                    if (included.invokeExact(className)) {
                        return FilterResult.included(null);
                    }
                    return FilterResult.excluded(null);
                }
                catch (Throwable e) {
                    return FilterResult.excluded((String)e.getMessage());
                }
            }
        };
    }

    private static PostDiscoveryFilter createPostDiscoveryFilter(ClassLoader classLoader) throws NoSuchMethodException, ClassNotFoundException, IllegalAccessException {
        final MethodHandle included = MethodHandles.publicLookup().findStatic(Class.forName("com.intellij.TestCaseLoader", true, classLoader), "isClassIncluded", MethodType.methodType(Boolean.TYPE, String.class));
        return new PostDiscoveryFilter(){
            private LastCheckResult myLastResult = null;

            private FilterResult isIncluded(String className) {
                if (this.myLastResult == null || !this.myLastResult.className.equals(className)) {
                    this.myLastResult = new LastCheckResult(className, this.isIncludedImpl(className));
                }
                return this.myLastResult.result;
            }

            private FilterResult isIncludedImpl(String className) {
                try {
                    if (included.invokeExact(className)) {
                        return FilterResult.included(null);
                    }
                    return FilterResult.excluded(null);
                }
                catch (Throwable e) {
                    return FilterResult.excluded((String)e.getMessage());
                }
            }

            public FilterResult apply(TestDescriptor descriptor) {
                if (descriptor instanceof EngineDescriptor) {
                    return FilterResult.included(null);
                }
                TestSource source = descriptor.getSource().orElse(null);
                if (source == null) {
                    return FilterResult.included((String)"No source for descriptor");
                }
                if (source instanceof MethodSource) {
                    MethodSource methodSource = (MethodSource)source;
                    return this.isIncluded(methodSource.getClassName());
                }
                if (source instanceof ClassSource) {
                    ClassSource classSource = (ClassSource)source;
                    return this.isIncluded(classSource.getClassName());
                }
                return FilterResult.included((String)("Unknown source type " + String.valueOf(source.getClass())));
            }

            record LastCheckResult(String className, FilterResult result) {
            }
        };
    }

    private static void saveListOfTestClasses(TestPlan testPlan) {
        ArrayList testClasses = new ArrayList(0);
        for (TestIdentifier root : testPlan.getRoots()) {
            Set firstLevel = testPlan.getChildren(root);
            for (TestIdentifier identifier : firstLevel) {
                identifier.getSource().filter(source -> source instanceof ClassSource).map(source -> ((ClassSource)source).getClassName()).ifPresent(name -> testClasses.add(name));
            }
        }
        Path path = Path.of(ourCollectTestsFile, new String[0]);
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, testClasses, new OpenOption[0]);
        }
        catch (IOException e) {
            System.err.printf("Cannot save list of test classes to '%s': %s%n", path.toAbsolutePath(), e);
            e.printStackTrace();
            System.exit(1);
        }
    }
}

