/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.platform.testFramework.core.FileComparisonFailedError;
import com.intellij.util.io.ContentMismatchReporter;
import com.intellij.util.io.FileTextMatcher;
import com.intellij.util.io.ZipUtil;
import com.intellij.util.io.impl.DirectoryContentSpecImpl;
import com.intellij.util.io.impl.DirectorySpec;
import com.intellij.util.io.impl.DirectorySpecBase;
import com.intellij.util.io.impl.FileSpec;
import com.intellij.util.io.impl.JarSpec;
import com.intellij.util.io.impl.ZipSpec;
import com.intellij.util.io.impl.ZipSpecBase;
import java.io.Closeable;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.ComparisonFailure;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\b\u001a \u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u001aB\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u001aF\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0000\u001a$\u0010\u0017\u001a\u00020\u0007*\u00020\u00152\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u0005H\u0002\u001aL\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0002\u001a\u000e\u0010\u001c\u001a\u0004\u0018\u00010\u0001*\u00020\u001dH\u0002\u001aL\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0002\u001a\"\u0010\u001f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u00102\b\u0010!\u001a\u0004\u0018\u00010\u0010H\u0000\u001a\u001a\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u00102\b\u0010$\u001a\u0004\u0018\u00010\u0010H\u0002\u00a8\u0006%"}, d2={"toString", "", "Lcom/intellij/util/io/impl/DirectorySpecBase;", "filePathFilter", "Lkotlin/Function1;", "", "appendToString", "", "spec", "result", "", "indent", "", "relativePath", "assertContentUnderFileMatches", "file", "Ljava/nio/file/Path;", "Lcom/intellij/util/io/impl/DirectoryContentSpecImpl;", "fileTextMatcher", "Lcom/intellij/util/io/FileTextMatcher;", "customErrorReporter", "Lcom/intellij/util/io/ContentMismatchReporter;", "expectedDataIsInSpec", "assertTrue", "errorMessage", "condition", "assertDirectoryContentMatches", "errorReporter", "convertToText", "", "assertDirectoryMatches", "fillSpecFromDirectory", "dir", "originalDir", "createSpecByPath", "path", "originalFile", "intellij.platform.testFramework"})
@SourceDebugExtension(value={"SMAP\nDirectoryContentSpecImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectoryContentSpecImpl.kt\ncom/intellij/util/io/impl/DirectoryContentSpecImplKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 path.kt\ncom/intellij/util/io/PathKt\n*L\n1#1,322:1\n1#2:323\n774#3:324\n865#3,2:325\n1869#3,2:327\n774#3:331\n865#3,2:332\n1563#3:334\n1634#3,3:335\n774#3:341\n865#3,2:342\n1563#3:344\n1634#3,3:345\n1869#3,2:350\n152#4,2:329\n155#4,3:338\n152#4,2:348\n155#4,3:352\n*S KotlinDebug\n*F\n+ 1 DirectoryContentSpecImpl.kt\ncom/intellij/util/io/impl/DirectoryContentSpecImplKt\n*L\n171#1:324\n171#1:325,2\n173#1:327,2\n281#1:331\n281#1:332,2\n282#1:334\n282#1:335,3\n285#1:341\n285#1:342,2\n286#1:344\n286#1:345,3\n302#1:350,2\n280#1:329,2\n280#1:338,3\n301#1:348,2\n301#1:352,3\n*E\n"})
public final class DirectoryContentSpecImplKt {
    private static final String toString(DirectorySpecBase $this$toString, Function1<? super String, Boolean> filePathFilter) {
        ArrayList arrayList;
        ArrayList it = arrayList = new ArrayList();
        boolean bl = false;
        DirectoryContentSpecImplKt.appendToString($this$toString, it, 0, ".", filePathFilter);
        return CollectionsKt.joinToString$default((Iterable)arrayList, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final void appendToString(DirectorySpecBase spec, List<String> result, int indent, String relativePath, Function1<? super String, Boolean> filePathFilter) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Object $this$filter$iv;
        Iterable iterable = spec.getChildren().entrySet();
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!(!(it.getValue() instanceof FileSpec) || (Boolean)filePathFilter.invoke((Object)(relativePath + "/" + it.getKey())) != false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE);
        $this$filter$iv = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)new Comparator((Comparator)$this$filter$iv){
            final /* synthetic */ Comparator $comparator;
            {
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                Map.Entry entry = (Map.Entry)a;
                Comparator comparator = this.$comparator;
                boolean bl = false;
                Map.Entry it = (Map.Entry)b;
                String string = (String)it.getKey();
                bl = false;
                String string2 = (String)it.getKey();
                return comparator.compare(string, string2);
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            result.add(StringsKt.repeat((CharSequence)" ", (int)indent) + it.getKey());
            DirectoryContentSpecImpl child = (DirectoryContentSpecImpl)it.getValue();
            if (!(child instanceof DirectorySpec)) continue;
            DirectoryContentSpecImplKt.appendToString((DirectorySpecBase)child, result, indent + 2, relativePath + "/" + it.getKey(), filePathFilter);
        }
    }

    public static final void assertContentUnderFileMatches(@NotNull Path file, @NotNull DirectoryContentSpecImpl spec, @NotNull FileTextMatcher fileTextMatcher, @NotNull Function1<? super String, Boolean> filePathFilter, @Nullable ContentMismatchReporter customErrorReporter, boolean expectedDataIsInSpec) {
        DirectoryContentSpecImpl actualSpec;
        ContentMismatchReporter errorReporter;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        Intrinsics.checkNotNullParameter((Object)fileTextMatcher, (String)"fileTextMatcher");
        Intrinsics.checkNotNullParameter(filePathFilter, (String)"filePathFilter");
        ContentMismatchReporter contentMismatchReporter = customErrorReporter;
        if (contentMismatchReporter == null) {
            contentMismatchReporter = errorReporter = DirectoryContentSpecImplKt::assertContentUnderFileMatches$lambda$0;
        }
        if (spec instanceof DirectorySpecBase && (actualSpec = DirectoryContentSpecImplKt.createSpecByPath(file, file)) instanceof DirectorySpecBase) {
            String specString = DirectoryContentSpecImplKt.toString((DirectorySpecBase)spec, filePathFilter);
            String dirString = DirectoryContentSpecImplKt.toString((DirectorySpecBase)actualSpec, filePathFilter);
            Pair pair = expectedDataIsInSpec ? TuplesKt.to((Object)specString, (Object)dirString) : TuplesKt.to((Object)dirString, (Object)specString);
            String expected = (String)pair.component1();
            String actual = (String)pair.component2();
            if (!Intrinsics.areEqual((Object)actual, (Object)expected)) {
                String message = "Expected equal strings: expected <" + expected + ">, but got: <" + actual + ">";
                errorReporter.reportError(".", (Throwable)((Object)new FileComparisonFailedError(message, expected, actual, null, null, 24, null)));
            }
        }
        DirectoryContentSpecImplKt.assertDirectoryContentMatches(file, spec, ".", fileTextMatcher, filePathFilter, errorReporter, expectedDataIsInSpec);
    }

    private static final void assertTrue(ContentMismatchReporter $this$assertTrue, String relativePath, String errorMessage, boolean condition) {
        if (!condition) {
            $this$assertTrue.reportError(relativePath, (Throwable)((Object)new AssertionError((Object)errorMessage)));
        }
    }

    private static final void assertDirectoryContentMatches(Path file, DirectoryContentSpecImpl spec, String relativePath, FileTextMatcher fileTextMatcher, Function1<? super String, Boolean> filePathFilter, ContentMismatchReporter errorReporter, boolean expectedDataIsInSpec) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        DirectoryContentSpecImplKt.assertTrue(errorReporter, relativePath, file + " doesn't exist", Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length)));
        DirectoryContentSpecImpl directoryContentSpecImpl = spec;
        if (directoryContentSpecImpl instanceof DirectorySpec) {
            DirectoryContentSpecImplKt.assertDirectoryMatches(file, (DirectorySpecBase)spec, relativePath, fileTextMatcher, filePathFilter, errorReporter, expectedDataIsInSpec);
        } else if (directoryContentSpecImpl instanceof ZipSpecBase) {
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            DirectoryContentSpecImplKt.assertTrue(errorReporter, relativePath, file + " is not a file", Files.isRegularFile(file, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)));
            Path dirForExtracted = FileUtil.createTempDirectory((String)("extracted-" + PathsKt.getName((Path)file)), null, (boolean)false).toPath();
            ZipUtil.extract((Path)file, (Path)dirForExtracted, null);
            Intrinsics.checkNotNull((Object)dirForExtracted);
            DirectoryContentSpecImplKt.assertDirectoryMatches(dirForExtracted, (DirectorySpecBase)spec, relativePath, fileTextMatcher, filePathFilter, errorReporter, expectedDataIsInSpec);
            FileUtil.delete((Path)dirForExtracted);
        } else if (directoryContentSpecImpl instanceof FileSpec) {
            LinkOption[] linkOptionArray3 = new LinkOption[]{};
            DirectoryContentSpecImplKt.assertTrue(errorReporter, relativePath, file + " is not a file", Files.isRegularFile(file, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length)));
            if (((FileSpec)spec).getContent() != null) {
                byte[] byArray = Files.readAllBytes(file);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
                byte[] fileBytes = byArray;
                if (!Arrays.equals(fileBytes, ((FileSpec)spec).getContent())) {
                    Object place;
                    String fileString = DirectoryContentSpecImplKt.convertToText(fileBytes);
                    String specString = DirectoryContentSpecImplKt.convertToText(((FileSpec)spec).getContent());
                    Object object = place = !Intrinsics.areEqual((Object)relativePath, (Object)".") ? " at " + relativePath : "";
                    if (fileString != null && specString != null) {
                        if (!fileTextMatcher.matches(fileString, specString)) {
                            Comparable<Path> comparable = ((FileSpec)spec).getOriginalFile();
                            String specFilePath = comparable != null && (comparable = comparable.toFile()) != null ? ((File)comparable).getAbsolutePath() : null;
                            Pair pair = expectedDataIsInSpec ? TuplesKt.to((Object)specString, (Object)fileString) : TuplesKt.to((Object)fileString, (Object)specString);
                            String expected = (String)pair.component1();
                            String actual = (String)pair.component2();
                            Pair pair2 = expectedDataIsInSpec ? TuplesKt.to((Object)specFilePath, null) : TuplesKt.to(null, (Object)specFilePath);
                            String expectedPath = (String)pair2.component1();
                            String actualPath = (String)pair2.component2();
                            String message = !Intrinsics.areEqual((Object)StringUtil.convertLineSeparators((String)fileString), (Object)StringUtil.convertLineSeparators((String)specString)) ? "File content mismatch" + (String)place + ": expected:\n " + fileString + "\n but was\n" + specString : "Different line separators" + (String)place + ", expected " + StringUtil.detectSeparators((CharSequence)specString) + ", but " + StringUtil.detectSeparators((CharSequence)fileString) + " found:";
                            errorReporter.reportError(relativePath, (Throwable)((Object)new FileComparisonFailedError(message, expected, actual, expectedPath, actualPath)));
                        }
                    } else {
                        errorReporter.reportError(relativePath, (Throwable)((Object)new AssertionError((Object)("Binary file content mismatch" + (String)place))));
                    }
                }
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final String convertToText(byte[] $this$convertToText) {
        Charset charset;
        if ($this$convertToText.length == 0) {
            return "";
        }
        switch (WhenMappings.$EnumSwitchMapping$0[new CharsetToolkit($this$convertToText, Charsets.UTF_8, false).guessFromContent($this$convertToText.length).ordinal()]) {
            case 1: {
                charset = Charsets.US_ASCII;
                break;
            }
            case 2: {
                charset = Charsets.UTF_8;
                break;
            }
            default: {
                return null;
            }
        }
        Charset charset2 = charset;
        return new String($this$convertToText, charset2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final void assertDirectoryMatches(Path file, DirectorySpecBase spec, String relativePath, FileTextMatcher fileTextMatcher, Function1<? super String, Boolean> filePathFilter, ContentMismatchReporter errorReporter, boolean expectedDataIsInSpec) {
        String dirString;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map.Entry it;
        void $this$filterTo$iv$iv;
        Object object;
        Closeable closeable;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        DirectoryContentSpecImplKt.assertTrue(errorReporter, relativePath, file + " is not a directory", Files.isDirectory(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length)));
        Path $this$directoryStreamIfExists$iv = file;
        boolean $i$f$directoryStreamIfExists = false;
        try {
            Iterable children;
            closeable = Files.newDirectoryStream($this$directoryStreamIfExists$iv);
            object = null;
            try {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                Path it2;
                void $this$filterTo$iv$iv2;
                children = (DirectoryStream)closeable;
                boolean bl = false;
                Iterable $this$filter$iv = children;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    it2 = (Path)element$iv$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it2);
                    LinkOption[] linkOptionArray2 = new LinkOption[]{};
                    if (!(Files.isDirectory(it2, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) || DirectoryContentSpecImplKt.assertDirectoryMatches$childNameFilter(filePathFilter, relativePath, PathsKt.getName((Path)it2)))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv2 = $this$map$iv2;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    it2 = (Path)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)it2);
                    collection.add(PathsKt.getName((Path)it2));
                }
                children = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
            }
            catch (Throwable bl) {
                object = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
            closeable = children;
        }
        catch (NoSuchFileException noSuchFileException) {
            closeable = null;
        }
        Closeable closeable2 = closeable;
        Object object2 = closeable2;
        if (closeable2 == null) {
            object2 = CollectionsKt.emptyList();
        }
        Closeable childrenNamesInDir = object2;
        Map<String, DirectoryContentSpecImpl> children = spec.getChildren();
        Iterable $this$filter$iv = children.entrySet();
        boolean $i$f$filter = false;
        Iterable noSuchFileException = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!(it.getValue() instanceof DirectorySpec || DirectoryContentSpecImplKt.assertDirectoryMatches$childNameFilter(filePathFilter, relativePath, (String)it.getKey()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getKey());
        }
        List childrenNamesInSpec = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        String specString = CollectionsKt.joinToString$default((Iterable)childrenNamesInSpec, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        if (!Intrinsics.areEqual((Object)specString, (Object)(dirString = CollectionsKt.joinToString$default((Iterable)((Iterable)((Object)childrenNamesInDir)), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)))) {
            object = expectedDataIsInSpec ? TuplesKt.to((Object)specString, (Object)dirString) : TuplesKt.to((Object)dirString, (Object)specString);
            String expected = (String)object.component1();
            String actual = (String)object.component2();
            errorReporter.reportError(relativePath, (Throwable)new ComparisonFailure("Directory content mismatch" + (String)(!Intrinsics.areEqual((Object)relativePath, (Object)"") ? " at " + relativePath : "") + ":", expected, actual));
        }
        object = childrenNamesInDir.iterator();
        while (object.hasNext()) {
            String child = (String)object.next();
            Path path = file.resolve(child);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            DirectoryContentSpecImplKt.assertDirectoryContentMatches(path, (DirectoryContentSpecImpl)MapsKt.getValue(children, (Object)child), relativePath + "/" + child, fileTextMatcher, filePathFilter, errorReporter, expectedDataIsInSpec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void fillSpecFromDirectory(@NotNull DirectorySpecBase spec, @NotNull Path dir, @Nullable Path originalDir) {
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Path $this$directoryStreamIfExists$iv = dir;
        boolean $i$f$directoryStreamIfExists = false;
        try {
            Unit unit;
            Closeable closeable = Files.newDirectoryStream($this$directoryStreamIfExists$iv);
            Throwable throwable = null;
            try {
                DirectoryStream children = (DirectoryStream)closeable;
                boolean bl = false;
                Iterable $this$forEach$iv = children;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Path it = (Path)element$iv;
                    boolean bl2 = false;
                    String string = ((Object)it.getFileName()).toString();
                    Intrinsics.checkNotNull((Object)it);
                    Path path = originalDir;
                    spec.addChild(string, DirectoryContentSpecImplKt.createSpecByPath(it, path != null ? path.resolve(it.getFileName()) : null));
                }
                unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            closeable = unit;
        }
        catch (NoSuchFileException noSuchFileException) {
            Object var5_6 = null;
        }
    }

    private static final DirectoryContentSpecImpl createSpecByPath(Path path, Path originalFile) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isDirectory(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            DirectorySpec directorySpec;
            DirectorySpec it = directorySpec = new DirectorySpec(originalFile);
            boolean bl = false;
            DirectoryContentSpecImplKt.fillSpecFromDirectory(it, path, originalFile);
            return directorySpec;
        }
        Object[] objectArray = new String[]{"zip", "jar"};
        if (SetsKt.setOf((Object[])objectArray).contains(PathsKt.getExtension((Path)path))) {
            Path dirForExtracted = FileUtil.createTempDirectory((String)("extracted-" + PathsKt.getName((Path)path)), null, (boolean)false).toPath();
            ZipUtil.extract((Path)path, (Path)dirForExtracted, null);
            ZipSpecBase spec = Intrinsics.areEqual((Object)PathsKt.getExtension((Path)path), (Object)"jar") ? (ZipSpecBase)new JarSpec() : (ZipSpecBase)new ZipSpec(0, 1, null);
            DirectorySpecBase directorySpecBase = spec;
            Intrinsics.checkNotNull((Object)dirForExtracted);
            DirectoryContentSpecImplKt.fillSpecFromDirectory(directorySpecBase, dirForExtracted, null);
            FileUtil.delete((Path)dirForExtracted);
            return spec;
        }
        return new FileSpec(Files.readAllBytes(path), originalFile);
    }

    private static final void assertContentUnderFileMatches$lambda$0(String string, Throwable error) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        throw error;
    }

    private static final boolean assertDirectoryMatches$childNameFilter(Function1<? super String, Boolean> $filePathFilter, String $relativePath, String name) {
        return (Boolean)$filePathFilter.invoke((Object)($relativePath + "/" + name));
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CharsetToolkit.GuessedEncoding.values().length];
            try {
                nArray[CharsetToolkit.GuessedEncoding.SEVEN_BIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CharsetToolkit.GuessedEncoding.VALID_UTF8.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

