/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff.lst;

import com.intellij.codeWithMe.ClientId;
import com.intellij.diff.DiffContext;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.simple.SimpleDiffChange;
import com.intellij.diff.tools.simple.SimpleDiffChangeUi;
import com.intellij.diff.tools.simple.SimpleDiffViewer;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.base.DiffViewerBase;
import com.intellij.diff.tools.util.text.TwosideTextDiffProvider;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffRequest;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffTool;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalTrackerDiffUtil;
import com.intellij.openapi.vcs.ex.DocumentTrackerKt;
import com.intellij.openapi.vcs.ex.LineStatusClientIdTrackerKt;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.RangeExclusionState;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001:\u0005789:;B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0014J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0014H\u0014J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u000f\u0010\u001c\u001a\t\u0018\u00010\u001d\u00a2\u0006\u0002\b\u001eH\u0014J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0014J\b\u0010$\u001a\u00020%H\u0014J\b\u0010&\u001a\u00020%H\u0014J\u001e\u0010'\u001a\u00020 2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u00142\u0006\u0010*\u001a\u00020\tH\u0002J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00120\u00142\u0006\u0010,\u001a\u00020)H\u0002J\u0010\u0010-\u001a\u00020\u00122\u0006\u0010,\u001a\u00020)H\u0002J \u0010.\u001a\u00020\u00122\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\tH\u0002J\u0018\u00104\u001a\u00020\u00122\u0006\u0010,\u001a\u00020)2\u0006\u00101\u001a\u000202H\u0002J\u0012\u00105\u001a\u0004\u0018\u00010\u00122\u0006\u00106\u001a\u00020)H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00060\u000fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer;", "Lcom/intellij/diff/tools/simple/SimpleDiffViewer;", "context", "Lcom/intellij/diff/DiffContext;", "localRequest", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalChangeListDiffRequest;", "<init>", "(Lcom/intellij/diff/DiffContext;Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalChangeListDiffRequest;)V", "isAllowExcludeChangesFromCommit", "", "trackerActionProvider", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$LocalTrackerActionProvider;", "excludeAllCheckboxPanel", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$ExcludeAllCheckboxPanel;", "gutterCheckboxMouseMotionListener", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$GutterCheckboxMouseMotionListener;", "localHighlighters", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "createTitles", "", "Ljavax/swing/JComponent;", "createEditorPopupActions", "Lcom/intellij/openapi/actionSystem/AnAction;", "createUi", "Lcom/intellij/diff/tools/simple/SimpleDiffChangeUi;", "change", "Lcom/intellij/diff/tools/simple/SimpleDiffChange;", "getStatusTextMessage", "", "Lorg/jetbrains/annotations/Nls;", "superComputeDifferences", "Ljava/lang/Runnable;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "computeDifferences", "onAfterRediff", "", "clearDiffPresentation", "applyGutterOperations", "toggleableLineRanges", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$ToggleableLineRange;", "areVCSBoundedActionsDisabled", "createGutterToggleRenderers", "toggleableLineRange", "createBlockCheckboxToggleHighlighter", "createLineCheckboxToggleHighlighter", "line", "", "side", "Lcom/intellij/diff/util/Side;", "isExcludedFromCommit", "createToggleAreaThumb", "createClientIdHighlighter", "range", "MyLocalTrackerDiffHandler", "MySimpleDiffChange", "MySimpleDiffChangeUi", "MyLocalTrackerActionProvider", "GutterCheckboxMouseMotionListener", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
public final class SimpleLocalChangeListDiffViewer
extends SimpleDiffViewer {
    @NotNull
    private final LocalChangeListDiffRequest localRequest;
    private final boolean isAllowExcludeChangesFromCommit;
    @NotNull
    private final LocalTrackerDiffUtil.LocalTrackerActionProvider trackerActionProvider;
    @NotNull
    private final LocalTrackerDiffUtil.ExcludeAllCheckboxPanel excludeAllCheckboxPanel;
    @NotNull
    private final GutterCheckboxMouseMotionListener gutterCheckboxMouseMotionListener;
    @NotNull
    private final List<RangeHighlighter> localHighlighters;

    public SimpleLocalChangeListDiffViewer(@NotNull DiffContext context, @NotNull LocalChangeListDiffRequest localRequest) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)localRequest), (String)"localRequest");
        super(context, (DiffRequest)localRequest.getRequest());
        this.localRequest = localRequest;
        UserDataHolder[] userDataHolderArray = new UserDataHolder[]{context};
        this.isAllowExcludeChangesFromCommit = DiffUtil.isUserDataFlagSet(LocalChangeListDiffTool.ALLOW_EXCLUDE_FROM_COMMIT, (UserDataHolder[])userDataHolderArray);
        this.localHighlighters = new ArrayList();
        this.trackerActionProvider = new MyLocalTrackerActionProvider(this, this.localRequest, this.isAllowExcludeChangesFromCommit);
        DiffViewerBase diffViewerBase = (DiffViewerBase)this;
        EditorEx editorEx = this.getEditor2();
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"getEditor2(...)");
        this.excludeAllCheckboxPanel = new LocalTrackerDiffUtil.ExcludeAllCheckboxPanel(diffViewerBase, editorEx);
        this.excludeAllCheckboxPanel.init(this.localRequest, this.isAllowExcludeChangesFromCommit);
        LocalTrackerDiffUtil.installTrackerListener((DiffViewerBase)this, this.localRequest);
        this.gutterCheckboxMouseMotionListener = new GutterCheckboxMouseMotionListener();
        this.gutterCheckboxMouseMotionListener.install();
        for (AnAction action : LocalTrackerDiffUtil.createTrackerShortcutOnlyActions(this.trackerActionProvider)) {
            DiffUtil.registerAction((AnAction)action, (JComponent)((JComponent)this.myPanel));
        }
    }

    @NotNull
    protected List<JComponent> createTitles() {
        boolean bl;
        List list = super.createTitles();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createTitles(...)");
        List titles = list;
        boolean bl2 = bl = titles.size() == 2;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel();
        Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel, (String)"simplePanel(...)");
        BorderLayoutPanel titleWithCheckbox = borderLayoutPanel;
        if (titles.get(1) != null) {
            titleWithCheckbox.addToCenter((Component)titles.get(1));
        }
        titleWithCheckbox.addToLeft((Component)this.excludeAllCheckboxPanel);
        JComponent[] jComponentArray = new JComponent[]{titles.get(0), titleWithCheckbox};
        List<JComponent> list2 = Arrays.asList(jComponentArray);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"asList(...)");
        return list2;
    }

    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        List list = super.createEditorPopupActions();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createEditorPopupActions(...)");
        return CollectionsKt.plus((Collection)list, (Iterable)LocalTrackerDiffUtil.createTrackerEditorPopupActions(this.trackerActionProvider));
    }

    @NotNull
    protected SimpleDiffChangeUi createUi(@NotNull SimpleDiffChange change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        if (change instanceof MySimpleDiffChange) {
            return new MySimpleDiffChangeUi(this, (MySimpleDiffChange)change);
        }
        SimpleDiffChangeUi simpleDiffChangeUi = super.createUi(change);
        Intrinsics.checkNotNullExpressionValue((Object)simpleDiffChangeUi, (String)"createUi(...)");
        return simpleDiffChangeUi;
    }

    @Nullable
    protected String getStatusTextMessage() {
        if (this.isAllowExcludeChangesFromCommit) {
            int totalCount = 0;
            int includedIntoCommitCount = 0;
            int excludedCount = 0;
            for (SimpleDiffChange change : this.getDiffChanges()) {
                RangeExclusionState exclusionState = change instanceof MySimpleDiffChange ? ((MySimpleDiffChange)change).getExclusionState() : (RangeExclusionState)RangeExclusionState.Included.INSTANCE;
                totalCount += DocumentTrackerKt.countAffectedVisibleChanges((RangeExclusionState)exclusionState, (boolean)false);
                if (change.isSkipped()) {
                    excludedCount += DocumentTrackerKt.countAffectedVisibleChanges((RangeExclusionState)exclusionState, (boolean)false);
                    continue;
                }
                includedIntoCommitCount += DocumentTrackerKt.countAffectedVisibleChanges((RangeExclusionState)exclusionState, (boolean)true);
            }
            ThreeState threeState = this.myModel.isContentsEqual();
            Intrinsics.checkNotNullExpressionValue((Object)threeState, (String)"isContentsEqual(...)");
            return LocalTrackerDiffUtil.getStatusText(totalCount, includedIntoCommitCount, excludedCount, threeState);
        }
        return super.getStatusTextMessage();
    }

    private final Runnable superComputeDifferences(ProgressIndicator indicator) {
        Runnable runnable = super.computeDifferences(indicator);
        Intrinsics.checkNotNullExpressionValue((Object)runnable, (String)"computeDifferences(...)");
        return runnable;
    }

    @NotNull
    protected Runnable computeDifferences(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        LineStatusTracker lineStatusTracker = this.localRequest.getLineStatusTracker();
        Document document = this.getContent1().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = this.getContent2().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
        String string = this.localRequest.getChangelistId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getChangelistId(...)");
        TwosideTextDiffProvider twosideTextDiffProvider = this.myTextDiffProvider;
        Intrinsics.checkNotNullExpressionValue((Object)twosideTextDiffProvider, (String)"myTextDiffProvider");
        return LocalTrackerDiffUtil.computeDifferences(lineStatusTracker, document, document2, string, this.isAllowExcludeChangesFromCommit, twosideTextDiffProvider, indicator, new MyLocalTrackerDiffHandler(indicator));
    }

    protected void onAfterRediff() {
        super.onAfterRediff();
        this.excludeAllCheckboxPanel.refresh();
    }

    protected void clearDiffPresentation() {
        super.clearDiffPresentation();
        for (RangeHighlighter operation : this.localHighlighters) {
            operation.dispose();
        }
        this.localHighlighters.clear();
        this.gutterCheckboxMouseMotionListener.destroyHoverHighlighter();
    }

    private final Runnable applyGutterOperations(List<LocalTrackerDiffUtil.ToggleableLineRange> toggleableLineRanges, boolean areVCSBoundedActionsDisabled) {
        return () -> SimpleLocalChangeListDiffViewer.applyGutterOperations$lambda$0(areVCSBoundedActionsDisabled, this, toggleableLineRanges);
    }

    private final List<RangeHighlighter> createGutterToggleRenderers(LocalTrackerDiffUtil.ToggleableLineRange toggleableLineRange) {
        LocalTrackerDiffUtil.LineFragmentData fragmentData = toggleableLineRange.getFragmentData();
        if (!fragmentData.isFromActiveChangelist()) {
            return CollectionsKt.emptyList();
        }
        List result2 = new ArrayList();
        RangeExclusionState exclusionState = fragmentData.getExclusionState();
        if (fragmentData.isPartiallyExcluded()) {
            Intrinsics.checkNotNull((Object)exclusionState, (String)"null cannot be cast to non-null type com.intellij.openapi.vcs.ex.RangeExclusionState.Partial");
            RangeExclusionState.Partial partialExclusionState = (RangeExclusionState.Partial)exclusionState;
            Range lineRange = toggleableLineRange.getLineRange();
            partialExclusionState.iterateDeletionOffsets((arg_0, arg_1, arg_2) -> SimpleLocalChangeListDiffViewer.createGutterToggleRenderers$lambda$0(result2, this, lineRange, arg_0, arg_1, arg_2));
            partialExclusionState.iterateAdditionOffsets((arg_0, arg_1, arg_2) -> SimpleLocalChangeListDiffViewer.createGutterToggleRenderers$lambda$1(result2, this, lineRange, arg_0, arg_1, arg_2));
        } else {
            result2.add(this.createBlockCheckboxToggleHighlighter(toggleableLineRange));
        }
        if (LocalTrackerDiffUtil.shouldShowToggleAreaThumb(toggleableLineRange)) {
            result2.add(this.createToggleAreaThumb(toggleableLineRange, Side.LEFT));
            result2.add(this.createToggleAreaThumb(toggleableLineRange, Side.RIGHT));
        }
        return result2;
    }

    private final RangeHighlighter createBlockCheckboxToggleHighlighter(LocalTrackerDiffUtil.ToggleableLineRange toggleableLineRange) {
        Side side = Side.RIGHT;
        int line = LocalTrackerDiffUtil.getSingleCheckBoxLine(toggleableLineRange, side);
        boolean isExcludedFromCommit = toggleableLineRange.getFragmentData().getExclusionState() instanceof RangeExclusionState.Excluded;
        EditorEx editorEx = this.getEditor(side);
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"getEditor(...)");
        return LocalTrackerDiffUtil.createCheckboxToggle(editorEx, line, isExcludedFromCommit, () -> SimpleLocalChangeListDiffViewer.createBlockCheckboxToggleHighlighter$lambda$0(this, line, isExcludedFromCommit));
    }

    private final RangeHighlighter createLineCheckboxToggleHighlighter(int line, Side side, boolean isExcludedFromCommit) {
        EditorEx editorEx = this.getEditor(side);
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"getEditor(...)");
        return LocalTrackerDiffUtil.createCheckboxToggle(editorEx, line, isExcludedFromCommit, () -> SimpleLocalChangeListDiffViewer.createLineCheckboxToggleHighlighter$lambda$0(this, line, side, isExcludedFromCommit));
    }

    private final RangeHighlighter createToggleAreaThumb(LocalTrackerDiffUtil.ToggleableLineRange toggleableLineRange, Side side) {
        EditorEx editorEx = this.getEditor(side);
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"getEditor(...)");
        EditorEx editor = editorEx;
        Range lineRange = toggleableLineRange.getLineRange();
        int line1 = side.select(lineRange.start1, lineRange.start2);
        int line2 = side.select(lineRange.end1, lineRange.end2);
        boolean isExcludedFromCommit = toggleableLineRange.getFragmentData().getExclusionState() instanceof RangeExclusionState.Excluded;
        return LocalTrackerDiffUtil.createToggleAreaThumb(editor, line1, line2, () -> SimpleLocalChangeListDiffViewer.createToggleAreaThumb$lambda$0(this, lineRange, isExcludedFromCommit));
    }

    private final RangeHighlighter createClientIdHighlighter(LocalTrackerDiffUtil.ToggleableLineRange range) {
        List<ClientId> clientIds = range.getFragmentData().getClientIds();
        if (clientIds.isEmpty()) {
            return null;
        }
        Project project = this.localRequest.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        GutterIconRenderer iconRenderer = LineStatusClientIdTrackerKt.createClientIdGutterIconRenderer(project, clientIds);
        if (iconRenderer == null) {
            return null;
        }
        Range lineRange = range.getLineRange();
        Side side = Side.Companion.fromLeft(lineRange.start2 == lineRange.end2);
        int line1 = side.select(lineRange.start1, lineRange.start2);
        int line2 = side.select(lineRange.end1, lineRange.end2);
        EditorEx editorEx = this.getEditor(side);
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"getEditor(...)");
        EditorEx editor = editorEx;
        TextRange textRange = DiffUtil.getLinesRange((Document)((Document)editor.getDocument()), (int)line1, (int)line2);
        return (RangeHighlighter)editor.getMarkupModel().addRangeHighlighterAndChangeAttributes(null, textRange.getStartOffset(), textRange.getEndOffset(), 5999, HighlighterTargetArea.LINES_IN_RANGE, false, arg_0 -> SimpleLocalChangeListDiffViewer.createClientIdHighlighter$lambda$1(arg_0 -> SimpleLocalChangeListDiffViewer.createClientIdHighlighter$lambda$0(iconRenderer, arg_0), arg_0));
    }

    private static final void applyGutterOperations$lambda$0(boolean $areVCSBoundedActionsDisabled, SimpleLocalChangeListDiffViewer this$0, List $toggleableLineRanges) {
        if ($areVCSBoundedActionsDisabled) {
            return;
        }
        if (this$0.isAllowExcludeChangesFromCommit) {
            for (LocalTrackerDiffUtil.ToggleableLineRange toggleableLineRange : $toggleableLineRanges) {
                this$0.localHighlighters.addAll((Collection<RangeHighlighter>)this$0.createGutterToggleRenderers(toggleableLineRange));
            }
        }
        for (LocalTrackerDiffUtil.ToggleableLineRange range : $toggleableLineRanges) {
            UtilKt.addIfNotNull(this$0.localHighlighters, (Object)this$0.createClientIdHighlighter(range));
        }
        if (!this$0.localHighlighters.isEmpty()) {
            this$0.getEditor1().getGutterComponentEx().revalidateMarkup();
            this$0.getEditor2().getGutterComponentEx().revalidateMarkup();
        }
    }

    private static final Unit createGutterToggleRenderers$lambda$0(List $result, SimpleLocalChangeListDiffViewer this$0, Range $lineRange, int start2, int end, boolean isIncluded) {
        for (int i = start2; i < end; ++i) {
            $result.add(this$0.createLineCheckboxToggleHighlighter(i + $lineRange.start1, Side.LEFT, !isIncluded));
        }
        return Unit.INSTANCE;
    }

    private static final Unit createGutterToggleRenderers$lambda$1(List $result, SimpleLocalChangeListDiffViewer this$0, Range $lineRange, int start2, int end, boolean isIncluded) {
        for (int i = start2; i < end; ++i) {
            $result.add(this$0.createLineCheckboxToggleHighlighter(i + $lineRange.start2, Side.RIGHT, !isIncluded));
        }
        return Unit.INSTANCE;
    }

    private static final void createBlockCheckboxToggleHighlighter$lambda$0(SimpleLocalChangeListDiffViewer this$0, int $line, boolean $isExcludedFromCommit) {
        LocalTrackerDiffUtil.toggleBlockExclusion(this$0.trackerActionProvider, $line, $isExcludedFromCommit);
    }

    private static final void createLineCheckboxToggleHighlighter$lambda$0(SimpleLocalChangeListDiffViewer this$0, int $line, Side $side, boolean $isExcludedFromCommit) {
        LocalTrackerDiffUtil.toggleLinePartialExclusion(this$0.trackerActionProvider, $line, $side, $isExcludedFromCommit);
    }

    private static final void createToggleAreaThumb$lambda$0(SimpleLocalChangeListDiffViewer this$0, Range $lineRange, boolean $isExcludedFromCommit) {
        LocalTrackerDiffUtil.toggleBlockExclusion(this$0.trackerActionProvider, $lineRange.start1, $isExcludedFromCommit);
    }

    private static final Unit createClientIdHighlighter$lambda$0(GutterIconRenderer $iconRenderer, RangeHighlighterEx rangeHighlighterEx) {
        Intrinsics.checkNotNullParameter((Object)rangeHighlighterEx, (String)"rangeHighlighterEx");
        rangeHighlighterEx.setGreedyToLeft(true);
        rangeHighlighterEx.setGreedyToRight(true);
        rangeHighlighterEx.setGutterIconRenderer($iconRenderer);
        return Unit.INSTANCE;
    }

    private static final void createClientIdHighlighter$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\u0018\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$GutterCheckboxMouseMotionListener;", "", "<init>", "(Lcom/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer;)V", "myHighlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "install", "", "destroyHoverHighlighter", "updateHoverHighlighter", "side", "Lcom/intellij/diff/util/Side;", "line", "", "MyGutterMouseListener", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nSimpleLocalChangeListDiffViewer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleLocalChangeListDiffViewer.kt\ncom/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$GutterCheckboxMouseMotionListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,544:1\n1#2:545\n*E\n"})
    private final class GutterCheckboxMouseMotionListener {
        @Nullable
        private RangeHighlighter myHighlighter;

        public final void install() {
            for (Side side : Side.getEntries()) {
                MyGutterMouseListener listener2 = new MyGutterMouseListener(side);
                SimpleLocalChangeListDiffViewer.this.getEditor(side).getGutterComponentEx().addMouseListener((MouseListener)listener2);
                SimpleLocalChangeListDiffViewer.this.getEditor(side).getGutterComponentEx().addMouseMotionListener((MouseMotionListener)listener2);
            }
        }

        public final void destroyHoverHighlighter() {
            if (this.myHighlighter != null) {
                RangeHighlighter rangeHighlighter = this.myHighlighter;
                Intrinsics.checkNotNull((Object)rangeHighlighter);
                rangeHighlighter.dispose();
                this.myHighlighter = null;
            }
        }

        private final void updateHoverHighlighter(Side side, int line) {
            MySimpleDiffChange change;
            Object v1;
            block5: {
                List list = SimpleLocalChangeListDiffViewer.this.getDiffChanges();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDiffChanges(...)");
                Iterable iterable = list;
                for (Object t : iterable) {
                    SimpleDiffChange it = (SimpleDiffChange)t;
                    boolean bl = false;
                    if (!(it.getStartLine(side) <= line && it.getEndLine(side) > line)) continue;
                    v1 = t;
                    break block5;
                }
                v1 = null;
            }
            Object var4_8 = v1;
            MySimpleDiffChange mySimpleDiffChange = change = var4_8 instanceof MySimpleDiffChange ? (MySimpleDiffChange)var4_8 : null;
            if (change == null || change.isPartiallyExcluded() || !Intrinsics.areEqual((Object)SimpleLocalChangeListDiffViewer.this.localRequest.getChangelistId(), (Object)change.getChangelistId())) {
                this.destroyHoverHighlighter();
                return;
            }
            EditorEx editorEx = SimpleLocalChangeListDiffViewer.this.getEditor(side);
            Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"getEditor(...)");
            EditorEx editor = editorEx;
            if (LocalTrackerDiffUtil.hasIconHighlighters(SimpleLocalChangeListDiffViewer.this.myProject, editor, line)) {
                if (this.myHighlighter != null) {
                    DocumentEx documentEx = editor.getDocument();
                    RangeHighlighter rangeHighlighter = this.myHighlighter;
                    Intrinsics.checkNotNull((Object)rangeHighlighter);
                    if (documentEx.getLineNumber(rangeHighlighter.getStartOffset()) != line) {
                        this.destroyHoverHighlighter();
                    }
                }
                return;
            }
            this.destroyHoverHighlighter();
            boolean isExcludedFromCommit = change.getExclusionState() instanceof RangeExclusionState.Excluded;
            this.myHighlighter = LocalTrackerDiffUtil.createCheckboxToggle(editor, line, isExcludedFromCommit, () -> GutterCheckboxMouseMotionListener.updateHoverHighlighter$lambda$1(SimpleLocalChangeListDiffViewer.this, line, side, isExcludedFromCommit, this));
        }

        private static final void updateHoverHighlighter$lambda$1(SimpleLocalChangeListDiffViewer this$0, int $line, Side $side, boolean $isExcludedFromCommit, GutterCheckboxMouseMotionListener this$1) {
            LocalTrackerDiffUtil.toggleLinePartialExclusion(this$0.trackerActionProvider, $line, $side, $isExcludedFromCommit);
            this$1.destroyHoverHighlighter();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$GutterCheckboxMouseMotionListener$MyGutterMouseListener;", "Ljava/awt/event/MouseAdapter;", "mySide", "Lcom/intellij/diff/util/Side;", "<init>", "(Lcom/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$GutterCheckboxMouseMotionListener;Lcom/intellij/diff/util/Side;)V", "mouseMoved", "", "e", "Ljava/awt/event/MouseEvent;", "mouseExited", "intellij.platform.vcs.impl"})
        private final class MyGutterMouseListener
        extends MouseAdapter {
            @NotNull
            private final Side mySide;

            public MyGutterMouseListener(Side mySide) {
                Intrinsics.checkNotNullParameter((Object)mySide, (String)"mySide");
                this.mySide = mySide;
            }

            @Override
            public void mouseMoved(@NotNull MouseEvent e) {
                int xOffset;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!SimpleLocalChangeListDiffViewer.this.isAllowExcludeChangesFromCommit || SimpleLocalChangeListDiffViewer.this.myTextDiffProvider.noFitnessForParticularPurposePromised()) {
                    GutterCheckboxMouseMotionListener.this.destroyHoverHighlighter();
                    return;
                }
                EditorEx editorEx = SimpleLocalChangeListDiffViewer.this.getEditor(this.mySide);
                Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"getEditor(...)");
                EditorEx editor = editorEx;
                EditorGutterComponentEx editorGutterComponentEx = editor.getGutterComponentEx();
                Intrinsics.checkNotNullExpressionValue((Object)editorGutterComponentEx, (String)"getGutterComponentEx(...)");
                EditorGutterComponentEx gutter = editorGutterComponentEx;
                int n = xOffset = DiffUtil.isMirrored((Editor)((Editor)editor)) ? gutter.getWidth() - e.getX() : e.getX();
                if (xOffset < gutter.getIconAreaOffset() || xOffset > gutter.getIconAreaOffset() + gutter.getIconsAreaWidth()) {
                    GutterCheckboxMouseMotionListener.this.destroyHoverHighlighter();
                    return;
                }
                LogicalPosition logicalPosition = editor.xyToLogicalPosition(e.getPoint());
                Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"xyToLogicalPosition(...)");
                LogicalPosition position = logicalPosition;
                GutterCheckboxMouseMotionListener.this.updateHoverHighlighter(this.mySide, position.line);
            }

            @Override
            public void mouseExited(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                GutterCheckboxMouseMotionListener.this.destroyHoverHighlighter();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MyLocalTrackerActionProvider;", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$LocalTrackerActionProvider;", "viewer", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer;", "localRequest", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalChangeListDiffRequest;", "allowExcludeChangesFromCommit", "", "<init>", "(Lcom/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer;Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalChangeListDiffRequest;Z)V", "getViewer", "()Lcom/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer;", "getLocalRequest", "()Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalChangeListDiffRequest;", "getAllowExcludeChangesFromCommit", "()Z", "getSelectedTrackerChanges", "", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$LocalTrackerChange;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getSelectedTrackerLines", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$SelectedTrackerLine;", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nSimpleLocalChangeListDiffViewer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleLocalChangeListDiffViewer.kt\ncom/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MyLocalTrackerActionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,544:1\n808#2,11:545\n1563#2:556\n1634#2,3:557\n*S KotlinDebug\n*F\n+ 1 SimpleLocalChangeListDiffViewer.kt\ncom/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MyLocalTrackerActionProvider\n*L\n450#1:545,11\n451#1:556\n451#1:557,3\n*E\n"})
    private static final class MyLocalTrackerActionProvider
    implements LocalTrackerDiffUtil.LocalTrackerActionProvider {
        @NotNull
        private final SimpleLocalChangeListDiffViewer viewer;
        @NotNull
        private final LocalChangeListDiffRequest localRequest;
        private final boolean allowExcludeChangesFromCommit;

        public MyLocalTrackerActionProvider(@NotNull SimpleLocalChangeListDiffViewer viewer, @NotNull LocalChangeListDiffRequest localRequest, boolean allowExcludeChangesFromCommit) {
            Intrinsics.checkNotNullParameter((Object)((Object)viewer), (String)"viewer");
            Intrinsics.checkNotNullParameter((Object)((Object)localRequest), (String)"localRequest");
            this.viewer = viewer;
            this.localRequest = localRequest;
            this.allowExcludeChangesFromCommit = allowExcludeChangesFromCommit;
        }

        @NotNull
        public SimpleLocalChangeListDiffViewer getViewer() {
            return this.viewer;
        }

        @Override
        @NotNull
        public LocalChangeListDiffRequest getLocalRequest() {
            return this.localRequest;
        }

        @Override
        public boolean getAllowExcludeChangesFromCommit() {
            return this.allowExcludeChangesFromCommit;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public List<LocalTrackerDiffUtil.LocalTrackerChange> getSelectedTrackerChanges(@NotNull AnActionEvent e) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            List list = this.getViewer().getEditors();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEditors(...)");
            Side side = Side.Companion.fromValue(list, (Object)editor);
            if (side == null) {
                return null;
            }
            List list2 = this.getViewer().getSelectedChanges(side);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"access$getSelectedChanges(...)");
            Iterable iterable = list2;
            boolean $i$f$filterIsInstance = false;
            void var6_6 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof MySimpleDiffChange)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MySimpleDiffChange mySimpleDiffChange = (MySimpleDiffChange)((Object)item$iv$iv);
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new LocalTrackerDiffUtil.LocalTrackerChange(it.getStartLine(Side.RIGHT), it.getEndLine(Side.RIGHT), it.getChangelistId(), it.getExclusionState()));
            }
            return (List)destination$iv$iv;
        }

        @Override
        @Nullable
        public LocalTrackerDiffUtil.SelectedTrackerLine getSelectedTrackerLines(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            List list = this.getViewer().getEditors();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEditors(...)");
            Side side = Side.Companion.fromValue(list, (Object)editor);
            if (editor == null || side == null) {
                return null;
            }
            BitSet bitSet = DiffUtil.getSelectedLines((Editor)editor);
            Intrinsics.checkNotNullExpressionValue((Object)bitSet, (String)"getSelectedLines(...)");
            BitSet selectedLines = bitSet;
            if (side.isLeft()) {
                return new LocalTrackerDiffUtil.SelectedTrackerLine(selectedLines, null);
            }
            return new LocalTrackerDiffUtil.SelectedTrackerLine(null, selectedLines);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\r\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J9\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0007H\u0016J\b\u0010\u0013\u001a\u00020\u0007H\u0016J\b\u0010\u0014\u001a\u00020\u0007H\u0016J\b\u0010\u0015\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MyLocalTrackerDiffHandler;", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$LocalTrackerDiffHandler;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "<init>", "(Lcom/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "done", "Ljava/lang/Runnable;", "isContentsEqual", "", "areVCSBoundedActionsDisabled", "texts", "", "", "toggleableLineRanges", "", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$ToggleableLineRange;", "(ZZ[Ljava/lang/CharSequence;Ljava/util/List;)Ljava/lang/Runnable;", "retryLater", "fallback", "fallbackWithProgress", "error", "intellij.platform.vcs.impl"})
    private final class MyLocalTrackerDiffHandler
    implements LocalTrackerDiffUtil.LocalTrackerDiffHandler {
        @NotNull
        private final ProgressIndicator progressIndicator;

        public MyLocalTrackerDiffHandler(ProgressIndicator progressIndicator) {
            Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
            this.progressIndicator = progressIndicator;
        }

        @Override
        @NotNull
        public Runnable done(boolean isContentsEqual, boolean areVCSBoundedActionsDisabled, @NotNull CharSequence[] texts, @NotNull List<LocalTrackerDiffUtil.ToggleableLineRange> toggleableLineRanges) {
            Intrinsics.checkNotNullParameter((Object)texts, (String)"texts");
            Intrinsics.checkNotNullParameter(toggleableLineRanges, (String)"toggleableLineRanges");
            List changes = new ArrayList();
            for (LocalTrackerDiffUtil.ToggleableLineRange toggleableLineRange : toggleableLineRanges) {
                LocalTrackerDiffUtil.LineFragmentData data = toggleableLineRange.getFragmentData();
                boolean isSkipped = data.isSkipped();
                boolean isExcluded = data.isExcluded(SimpleLocalChangeListDiffViewer.this.isAllowExcludeChangesFromCommit);
                for (LineFragment fragment : toggleableLineRange.getFragments()) {
                    changes.add(new MySimpleDiffChange(changes.size(), fragment, isExcluded, isSkipped, data.getChangelistId(), data.isPartiallyExcluded(), data.getExclusionState()));
                }
            }
            Runnable runnable = SimpleLocalChangeListDiffViewer.this.apply(changes, isContentsEqual);
            Intrinsics.checkNotNullExpressionValue((Object)runnable, (String)"access$apply(...)");
            Runnable applyChanges = runnable;
            Runnable applyGutterExcludeOperations = SimpleLocalChangeListDiffViewer.this.applyGutterOperations(toggleableLineRanges, areVCSBoundedActionsDisabled);
            return () -> MyLocalTrackerDiffHandler.done$lambda$0(applyChanges, applyGutterExcludeOperations);
        }

        @Override
        @NotNull
        public Runnable retryLater() {
            ApplicationManager.getApplication().invokeLater(() -> MyLocalTrackerDiffHandler.retryLater$lambda$0(SimpleLocalChangeListDiffViewer.this));
            throw new ProcessCanceledException();
        }

        @Override
        @NotNull
        public Runnable fallback() {
            return SimpleLocalChangeListDiffViewer.this.superComputeDifferences(this.progressIndicator);
        }

        @Override
        @NotNull
        public Runnable fallbackWithProgress() {
            Runnable callback = SimpleLocalChangeListDiffViewer.this.superComputeDifferences(this.progressIndicator);
            return () -> MyLocalTrackerDiffHandler.fallbackWithProgress$lambda$0(callback, SimpleLocalChangeListDiffViewer.this);
        }

        @Override
        @NotNull
        public Runnable error() {
            Runnable runnable = SimpleLocalChangeListDiffViewer.this.applyNotification(DiffNotifications.createError());
            Intrinsics.checkNotNullExpressionValue((Object)runnable, (String)"access$applyNotification(...)");
            return runnable;
        }

        private static final void done$lambda$0(Runnable $applyChanges, Runnable $applyGutterExcludeOperations) {
            $applyChanges.run();
            $applyGutterExcludeOperations.run();
        }

        private static final void retryLater$lambda$0(SimpleLocalChangeListDiffViewer this$0) {
            this$0.scheduleRediff();
        }

        private static final void fallbackWithProgress$lambda$0(Runnable $callback, SimpleLocalChangeListDiffViewer this$0) {
            $callback.run();
            this$0.getStatusPanel().setBusy(true);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001BF\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u000b\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b\u0012\u0006\u0010\f\u001a\u00020\u0007\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0016\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0013R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MySimpleDiffChange;", "Lcom/intellij/diff/tools/simple/SimpleDiffChange;", "index", "", "fragment", "Lcom/intellij/diff/fragments/LineFragment;", "isExcluded", "", "isSkipped", "changelistId", "", "Lorg/jetbrains/annotations/NonNls;", "isPartiallyExcluded", "exclusionState", "Lcom/intellij/openapi/vcs/ex/RangeExclusionState;", "<init>", "(ILcom/intellij/diff/fragments/LineFragment;ZZLjava/lang/String;ZLcom/intellij/openapi/vcs/ex/RangeExclusionState;)V", "getChangelistId", "()Ljava/lang/String;", "()Z", "getExclusionState", "()Lcom/intellij/openapi/vcs/ex/RangeExclusionState;", "intellij.platform.vcs.impl"})
    public static final class MySimpleDiffChange
    extends SimpleDiffChange {
        @NotNull
        private final String changelistId;
        private final boolean isPartiallyExcluded;
        @NotNull
        private final RangeExclusionState exclusionState;

        public MySimpleDiffChange(int index, @NotNull LineFragment fragment, boolean isExcluded, boolean isSkipped, @NotNull String changelistId, boolean isPartiallyExcluded, @NotNull RangeExclusionState exclusionState) {
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            Intrinsics.checkNotNullParameter((Object)changelistId, (String)"changelistId");
            Intrinsics.checkNotNullParameter((Object)exclusionState, (String)"exclusionState");
            super(index, fragment, isExcluded, isSkipped);
            this.changelistId = changelistId;
            this.isPartiallyExcluded = isPartiallyExcluded;
            this.exclusionState = exclusionState;
        }

        @NotNull
        public final String getChangelistId() {
            return this.changelistId;
        }

        public final boolean isPartiallyExcluded() {
            return this.isPartiallyExcluded;
        }

        @NotNull
        public final RangeExclusionState getExclusionState() {
            return this.exclusionState;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MySimpleDiffChangeUi;", "Lcom/intellij/diff/tools/simple/SimpleDiffChangeUi;", "viewer", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer;", "change", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MySimpleDiffChange;", "<init>", "(Lcom/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer;Lcom/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MySimpleDiffChange;)V", "getViewer", "()Lcom/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer;", "getChange", "()Lcom/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MySimpleDiffChange;", "installHighlighter", "", "previousChange", "Lcom/intellij/diff/tools/simple/SimpleDiffChange;", "drawDivider", "", "handler", "Lcom/intellij/diff/util/DiffDividerDrawUtil$DividerPaintable$Handler;", "intellij.platform.vcs.impl"})
    private static final class MySimpleDiffChangeUi
    extends SimpleDiffChangeUi {
        @NotNull
        private final SimpleLocalChangeListDiffViewer viewer;
        @NotNull
        private final MySimpleDiffChange change;

        public MySimpleDiffChangeUi(@NotNull SimpleLocalChangeListDiffViewer viewer, @NotNull MySimpleDiffChange change) {
            Intrinsics.checkNotNullParameter((Object)((Object)viewer), (String)"viewer");
            Intrinsics.checkNotNullParameter((Object)((Object)change), (String)"change");
            super((SimpleDiffViewer)viewer, (SimpleDiffChange)change);
            this.viewer = viewer;
            this.change = change;
        }

        @NotNull
        public final SimpleLocalChangeListDiffViewer getViewer() {
            return this.viewer;
        }

        @NotNull
        public final MySimpleDiffChange getChange() {
            return this.change;
        }

        public void installHighlighter(@Nullable SimpleDiffChange previousChange) {
            if (this.change.isPartiallyExcluded() && this.viewer.isAllowExcludeChangesFromCommit) {
                boolean bl;
                boolean bl2 = bl = this.myHighlighters.isEmpty() && this.myOperations.isEmpty();
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                int changeStart1 = this.change.getStartLine(Side.LEFT);
                int changeStart2 = this.change.getStartLine(Side.RIGHT);
                RangeExclusionState rangeExclusionState = this.change.getExclusionState();
                Intrinsics.checkNotNull((Object)rangeExclusionState, (String)"null cannot be cast to non-null type com.intellij.openapi.vcs.ex.RangeExclusionState.Partial");
                RangeExclusionState.Partial exclusionState = (RangeExclusionState.Partial)rangeExclusionState;
                exclusionState.iterateDeletionOffsets((arg_0, arg_1, arg_2) -> MySimpleDiffChangeUi.installHighlighter$lambda$0(this, changeStart1, arg_0, arg_1, arg_2));
                exclusionState.iterateAdditionOffsets((arg_0, arg_1, arg_2) -> MySimpleDiffChangeUi.installHighlighter$lambda$1(this, changeStart2, arg_0, arg_1, arg_2));
                if (exclusionState.getDeletionsCount() == 0) {
                    List list = new DiffDrawUtil.LineHighlighterBuilder((Editor)this.viewer.getEditor(Side.LEFT), changeStart1, changeStart1, TextDiffType.INSERTED).withExcludedInEditor(this.change.isSkipped()).withExcludedInGutter(false).withAlignedSides(this.viewer.needAlignChanges()).done();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"done(...)");
                    this.myHighlighters.addAll(list);
                }
                if (exclusionState.getAdditionsCount() == 0) {
                    List list = new DiffDrawUtil.LineHighlighterBuilder((Editor)this.viewer.getEditor(Side.RIGHT), changeStart2, changeStart2, TextDiffType.DELETED).withExcludedInEditor(this.change.isSkipped()).withExcludedInGutter(false).withAlignedSides(this.viewer.needAlignChanges()).done();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"done(...)");
                    this.myHighlighters.addAll(list);
                }
            } else {
                super.installHighlighter(previousChange);
            }
        }

        public boolean drawDivider(@NotNull DiffDividerDrawUtil.DividerPaintable.Handler handler) {
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            if (this.change.isPartiallyExcluded() && this.viewer.isAllowExcludeChangesFromCommit) {
                int startLine1 = this.change.getStartLine(Side.LEFT);
                int endLine1 = this.change.getEndLine(Side.LEFT);
                int startLine2 = this.change.getStartLine(Side.RIGHT);
                int endLine2 = this.change.getEndLine(Side.RIGHT);
                if (this.viewer.needAlignChanges()) {
                    if (startLine1 != endLine1 && !handler.processAligned(startLine1, endLine1, startLine2, startLine2, TextDiffType.DELETED)) {
                        return false;
                    }
                    return startLine2 == endLine2 || handler.processAligned(endLine1, endLine1, startLine2, endLine2, TextDiffType.INSERTED);
                }
                if (startLine1 != endLine1 && !handler.processExcludable(startLine1, endLine1, startLine2, startLine2, TextDiffType.DELETED, this.change.isExcluded(), this.change.isSkipped())) {
                    return false;
                }
                return startLine2 == endLine2 || handler.processExcludable(endLine1, endLine1, startLine2, endLine2, TextDiffType.INSERTED, this.change.isExcluded(), this.change.isSkipped());
            }
            return super.drawDivider(handler);
        }

        private static final Unit installHighlighter$lambda$0(MySimpleDiffChangeUi this$0, int $changeStart1, int start2, int end, boolean isIncluded) {
            List list = this$0.myHighlighters;
            List list2 = new DiffDrawUtil.LineHighlighterBuilder((Editor)this$0.viewer.getEditor(Side.LEFT), start2 + $changeStart1, end + $changeStart1, TextDiffType.DELETED).withExcludedInEditor(this$0.change.isSkipped()).withExcludedInGutter(!isIncluded).withAlignedSides(this$0.viewer.needAlignChanges()).done();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"done(...)");
            list.addAll(list2);
            return Unit.INSTANCE;
        }

        private static final Unit installHighlighter$lambda$1(MySimpleDiffChangeUi this$0, int $changeStart2, int start2, int end, boolean isIncluded) {
            List list = this$0.myHighlighters;
            List list2 = new DiffDrawUtil.LineHighlighterBuilder((Editor)this$0.viewer.getEditor(Side.RIGHT), start2 + $changeStart2, end + $changeStart2, TextDiffType.INSERTED).withExcludedInEditor(this$0.change.isSkipped()).withExcludedInGutter(!isIncluded).withAlignedSides(this$0.viewer.needAlignChanges()).done();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"done(...)");
            list.addAll(list2);
            return Unit.INSTANCE;
        }
    }
}

