/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.bcpg.AEADAlgorithmTags;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.bcpg.SymmetricKeyAlgorithmTags;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.TeeInputStream;

public abstract class PGPEncryptedData
implements SymmetricKeyAlgorithmTags,
AEADAlgorithmTags {
    InputStreamPacket encData;
    InputStream encStream;
    TruncatedStream truncStream;
    PGPDigestCalculator integrityCalculator;

    PGPEncryptedData(InputStreamPacket inputStreamPacket) {
        this.encData = inputStreamPacket;
    }

    public InputStream getInputStream() {
        return this.encData.getInputStream();
    }

    public boolean isIntegrityProtected() {
        return this.encData instanceof SymmetricEncIntegrityPacket;
    }

    public InputStreamPacket getEncData() {
        return this.encData;
    }

    public boolean isAEAD() {
        if (this.encData instanceof AEADEncDataPacket) {
            return true;
        }
        if (this.encData instanceof SymmetricEncIntegrityPacket) {
            return ((SymmetricEncIntegrityPacket)this.encData).getVersion() == 2;
        }
        return false;
    }

    public boolean verify() throws PGPException, IOException {
        if (!this.isIntegrityProtected()) {
            throw new PGPException("data not integrity protected.");
        }
        while (this.encStream.read() >= 0) {
        }
        if (this.isAEAD()) {
            return true;
        }
        int[] nArray = this.truncStream.getLookAhead();
        OutputStream outputStream = this.integrityCalculator.getOutputStream();
        outputStream.write((byte)nArray[0]);
        outputStream.write((byte)nArray[1]);
        byte[] byArray = this.integrityCalculator.getDigest();
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i != byArray2.length; ++i) {
            byArray2[i] = (byte)nArray[i + 2];
        }
        return Arrays.constantTimeAreEqual(byArray, byArray2);
    }

    public int getVersion() {
        throw new UnsupportedOperationException("not supported - override required");
    }

    public int getAlgorithm() {
        throw new UnsupportedOperationException("not supported - override required");
    }

    boolean processSymmetricEncIntegrityPacketDataStream(boolean bl, PGPDataDecryptor pGPDataDecryptor, BCPGInputStream bCPGInputStream) throws IOException {
        int n;
        int n2;
        this.encStream = new BCPGInputStream(pGPDataDecryptor.getInputStream(bCPGInputStream));
        if (bl) {
            this.truncStream = new TruncatedStream(this.encStream);
            this.integrityCalculator = pGPDataDecryptor.getIntegrityCalculator();
            this.encStream = new TeeInputStream(this.truncStream, this.integrityCalculator.getOutputStream());
        }
        byte[] byArray = new byte[pGPDataDecryptor.getBlockSize()];
        for (n2 = 0; n2 != byArray.length; ++n2) {
            n = this.encStream.read();
            if (n < 0) {
                throw new EOFException("unexpected end of stream.");
            }
            byArray[n2] = (byte)n;
        }
        n2 = this.encStream.read();
        n = this.encStream.read();
        if (n2 < 0 || n < 0) {
            throw new EOFException("unexpected end of stream.");
        }
        boolean bl2 = byArray[byArray.length - 2] == (byte)n2 && byArray[byArray.length - 1] == (byte)n;
        boolean bl3 = n2 == 0 && n == 0;
        return !bl2 && !bl3;
    }

    protected static class TruncatedStream
    extends InputStream {
        int[] lookAhead = new int[22];
        int bufPtr;
        InputStream in;
        byte[] readBuffer = new byte[8192];

        TruncatedStream(InputStream inputStream) throws IOException {
            for (int i = 0; i != this.lookAhead.length; ++i) {
                this.lookAhead[i] = inputStream.read();
                if (this.lookAhead[i] >= 0) continue;
                throw new EOFException();
            }
            this.bufPtr = 0;
            this.in = inputStream;
        }

        @Override
        public int read() throws IOException {
            int n = this.in.read();
            if (n >= 0) {
                int n2 = this.lookAhead[this.bufPtr];
                this.lookAhead[this.bufPtr] = n;
                this.bufPtr = (this.bufPtr + 1) % this.lookAhead.length;
                return n2;
            }
            return -1;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            if ((n | n2 | n + n2 | byArray.length - (n + n2)) < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            int n4 = Math.min(this.readBuffer.length, n2);
            int n5 = this.in.read(this.readBuffer, 0, n4);
            if (n5 < 0) {
                return -1;
            }
            int n6 = Math.min(n5, this.lookAhead.length);
            for (n3 = 0; n3 < n6; ++n3) {
                byArray[n + n3] = (byte)this.lookAhead[(this.bufPtr + n3) % this.lookAhead.length];
            }
            for (int i = n3 = n5 - n6; i < n5; ++i) {
                this.lookAhead[this.bufPtr] = this.readBuffer[i] & 0xFF;
                this.bufPtr = (this.bufPtr + 1) % this.lookAhead.length;
            }
            if (n3 != 0) {
                System.arraycopy(this.readBuffer, 0, byArray, n + n6, n3);
            }
            return n5;
        }

        int[] getLookAhead() {
            int n;
            int[] nArray = new int[this.lookAhead.length];
            int n2 = 0;
            for (n = this.bufPtr; n != this.lookAhead.length; ++n) {
                nArray[n2++] = this.lookAhead[n];
            }
            for (n = 0; n != this.bufPtr; ++n) {
                nArray[n2++] = this.lookAhead[n];
            }
            return nArray;
        }
    }
}

