/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.serviceView;

import com.intellij.execution.services.ServiceViewActionUtils;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.services.ServiceViewDefaultDeleteProvider;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewDescriptorId;
import com.intellij.execution.services.ServiceViewOptions;
import com.intellij.execution.services.ServiceViewUIUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.platform.execution.serviceView.ServiceModel;
import com.intellij.platform.execution.serviceView.ServiceSingleView;
import com.intellij.platform.execution.serviceView.ServiceTreeView;
import com.intellij.platform.execution.serviceView.ServiceViewActionProvider;
import com.intellij.platform.execution.serviceView.ServiceViewCopyProvider;
import com.intellij.platform.execution.serviceView.ServiceViewDragHelper;
import com.intellij.platform.execution.serviceView.ServiceViewManagerImpl;
import com.intellij.platform.execution.serviceView.ServiceViewModel;
import com.intellij.platform.execution.serviceView.ServiceViewSingleUi;
import com.intellij.platform.execution.serviceView.ServiceViewState;
import com.intellij.platform.execution.serviceView.ServiceViewTreeUi;
import com.intellij.platform.execution.serviceView.ServiceViewUi;
import com.intellij.pom.Navigatable;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.concurrency.Promise;

abstract class ServiceView
extends JPanel
implements UiDataProvider,
Disposable {
    private final Project myProject;
    private final ServiceViewModel myModel;
    protected final ServiceViewUi myUi;
    private final ServiceViewOptions myViewOptions;
    private AutoScrollToSourceHandler myAutoScrollToSourceHandler;

    protected ServiceView(LayoutManager layout, @NotNull Project project, @NotNull ServiceViewModel model, @NotNull ServiceViewUi ui) {
        if (project == null) {
            ServiceView.$$$reportNull$$$0(0);
        }
        if (model == null) {
            ServiceView.$$$reportNull$$$0(1);
        }
        if (ui == null) {
            ServiceView.$$$reportNull$$$0(2);
        }
        super(layout);
        this.myViewOptions = new ServiceViewOptions(){

            public boolean isGroupByContributor() {
                return ServiceView.this.isGroupByContributor();
            }
        };
        this.myProject = project;
        this.myModel = model;
        this.myUi = ui;
    }

    public void dispose() {
    }

    Project getProject() {
        return this.myProject;
    }

    ServiceViewModel getModel() {
        return this.myModel;
    }

    ServiceViewUi getUi() {
        return this.myUi;
    }

    void saveState(@NotNull ServiceViewState state) {
        if (state == null) {
            ServiceView.$$$reportNull$$$0(3);
        }
        this.myModel.saveState(state);
    }

    @NotNull
    abstract @Unmodifiable List<ServiceModel.ServiceViewItem> getSelectedItems();

    abstract Promise<Void> select(@NotNull Object var1, @NotNull Class<?> var2);

    abstract Promise<Void> expand(@NotNull Object var1, @NotNull Class<?> var2);

    abstract Promise<Void> extract(@NotNull Object var1, @NotNull Class<?> var2);

    abstract void onViewSelected();

    abstract void onViewUnselected();

    boolean isGroupByContributor() {
        return this.myModel.isGroupByContributor();
    }

    void setGroupByContributor(boolean value) {
        this.myModel.setGroupByContributor(value);
    }

    abstract @Unmodifiable List<Object> getChildrenSafe(@NotNull List<Object> var1, @NotNull Class<?> var2);

    void setAutoScrollToSourceHandler(@NotNull AutoScrollToSourceHandler autoScrollToSourceHandler) {
        if (autoScrollToSourceHandler == null) {
            ServiceView.$$$reportNull$$$0(4);
        }
        this.myAutoScrollToSourceHandler = autoScrollToSourceHandler;
    }

    void onViewSelected(@NotNull ServiceViewDescriptor descriptor) {
        if (descriptor == null) {
            ServiceView.$$$reportNull$$$0(5);
        }
        descriptor.onNodeSelected(ContainerUtil.map(this.getSelectedItems(), ServiceModel.ServiceViewItem::getValue));
        if (this.myAutoScrollToSourceHandler != null) {
            this.myAutoScrollToSourceHandler.onMouseClicked((Component)this);
        }
    }

    abstract void jumpToServices();

    static ServiceView createView(@NotNull Project project, @NotNull ServiceViewModel viewModel, @NotNull ServiceViewState viewState) {
        if (project == null) {
            ServiceView.$$$reportNull$$$0(6);
        }
        if (viewModel == null) {
            ServiceView.$$$reportNull$$$0(7);
        }
        if (viewState == null) {
            ServiceView.$$$reportNull$$$0(8);
        }
        ServiceView.setViewModelState(viewModel, viewState);
        return viewModel instanceof ServiceViewModel.SingeServiceModel ? ServiceView.createSingleView(project, viewModel) : ServiceView.createTreeView(project, viewModel, viewState);
    }

    private static ServiceView createTreeView(@NotNull Project project, @NotNull ServiceViewModel model, @NotNull ServiceViewState state) {
        if (project == null) {
            ServiceView.$$$reportNull$$$0(9);
        }
        if (model == null) {
            ServiceView.$$$reportNull$$$0(10);
        }
        if (state == null) {
            ServiceView.$$$reportNull$$$0(11);
        }
        return new ServiceTreeView(project, model, new ServiceViewTreeUi(state), state);
    }

    private static ServiceView createSingleView(@NotNull Project project, @NotNull ServiceViewModel model) {
        if (project == null) {
            ServiceView.$$$reportNull$$$0(12);
        }
        if (model == null) {
            ServiceView.$$$reportNull$$$0(13);
        }
        return new ServiceSingleView(project, model, new ServiceViewSingleUi());
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        ServiceViewDescriptor descriptor;
        ServiceViewDescriptor contributorDescriptor;
        if (sink == null) {
            ServiceView.$$$reportNull$$$0(14);
        }
        List<ServiceModel.ServiceViewItem> selection = this.getSelectedItems();
        ServiceModel.ServiceViewItem onlyItem = (ServiceModel.ServiceViewItem)ContainerUtil.getOnlyItem(selection);
        sink.set(PlatformCoreDataKeys.HELP_ID, (Object)ServiceViewManagerImpl.getToolWindowContextHelpId());
        sink.set(PlatformCoreDataKeys.SELECTED_ITEMS, (Object)ContainerUtil.map2Array(selection, ServiceModel.ServiceViewItem::getValue));
        sink.set(PlatformCoreDataKeys.SELECTED_ITEM, onlyItem != null ? onlyItem.getValue() : null);
        sink.set(ServiceViewActionProvider.SERVICES_SELECTED_ITEMS, selection);
        ServiceViewContributor contributor = ServiceViewDragHelper.getTheOnlyRootContributor(selection);
        sink.set(PlatformDataKeys.DELETE_ELEMENT_PROVIDER, (Object)ServiceViewDefaultDeleteProvider.getInstance());
        ServiceViewDescriptor serviceViewDescriptor = contributorDescriptor = contributor != null ? contributor.getViewDescriptor(this.myProject) : null;
        if (contributorDescriptor instanceof UiDataProvider) {
            UiDataProvider uiDataProvider = (UiDataProvider)contributorDescriptor;
            sink.uiDataSnapshot(uiDataProvider);
        } else {
            DataSink.uiDataSnapshot((DataSink)sink, (DataProvider)(contributorDescriptor != null ? contributorDescriptor.getDataProvider() : null));
        }
        sink.set(PlatformDataKeys.COPY_PROVIDER, (Object)new ServiceViewCopyProvider(this));
        sink.set(ServiceViewActionUtils.CONTRIBUTORS_KEY, this.getModel().getRoots().stream().map(item -> item.getRootContributor()).collect(Collectors.toSet()));
        sink.set(ServiceViewActionUtils.OPTIONS_KEY, (Object)this.myViewOptions);
        List navigatables = ContainerUtil.mapNotNull(selection, item -> item.getViewDescriptor().getNavigatable());
        if (!navigatables.isEmpty()) {
            sink.set(CommonDataKeys.NAVIGATABLE_ARRAY, (Object)navigatables.toArray(Navigatable.EMPTY_NAVIGATABLE_ARRAY));
        }
        List selectedDescriptorIds = ContainerUtil.mapNotNull(selection, item -> {
            String contributorId = item.getRootContributor().getViewDescriptor(this.myProject).getId();
            if (contributorId == null) {
                return null;
            }
            String descriptorId = item.getViewDescriptor().getUniqueId();
            if (descriptorId == null) {
                return null;
            }
            return new ServiceViewDescriptorId(contributorId, descriptorId);
        });
        sink.set(ServiceViewUIUtils.SERVICES_SELECTED_DESCRIPTOR_IDS, (Object)selectedDescriptorIds);
        ServiceViewDescriptor serviceViewDescriptor2 = descriptor = onlyItem == null || onlyItem.isRemoved() ? null : onlyItem.getViewDescriptor();
        if (descriptor instanceof UiDataProvider) {
            UiDataProvider uiDataProvider = (UiDataProvider)descriptor;
            sink.uiDataSnapshot(uiDataProvider);
        } else {
            DataSink.uiDataSnapshot((DataSink)sink, (DataProvider)(descriptor != null ? descriptor.getDataProvider() : null));
        }
    }

    private static void setViewModelState(@NotNull ServiceViewModel viewModel, @NotNull ServiceViewState viewState) {
        if (viewModel == null) {
            ServiceView.$$$reportNull$$$0(15);
        }
        if (viewState == null) {
            ServiceView.$$$reportNull$$$0(16);
        }
        viewModel.setGroupByContributor(viewState.groupByContributor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "autoScrollToSourceHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewModel";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewState";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        objectArray2[1] = "com/intellij/platform/execution/serviceView/ServiceView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "saveState";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setAutoScrollToSourceHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "onViewSelected";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createView";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "createTreeView";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "createSingleView";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "uiDataSnapshot";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "setViewModelState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

