/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.view.completion;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupBottomPanelProvider;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.PrefixChangeListener;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.terminal.frontend.view.completion.ShortcutHintTextState;
import com.intellij.terminal.frontend.view.completion.TerminalCommandCompletionSettingsAction;
import com.intellij.terminal.frontend.view.completion.TerminalCompletionPopupPromotion;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBHtmlPane;
import com.intellij.ui.components.JBHtmlPaneConfiguration;
import com.intellij.ui.components.JBHtmlPaneStyleConfiguration;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.EmptySpacingConfiguration;
import com.intellij.ui.dsl.builder.ExtensionsKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.SpacingConfiguration;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsKt;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.block.util.TerminalDataContextUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0002J\u0014\u0010\f\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/intellij/terminal/frontend/view/completion/TerminalLookupBottomPanelProvider;", "Lcom/intellij/codeInsight/lookup/LookupBottomPanelProvider;", "<init>", "()V", "createBottomPanel", "Ljavax/swing/JComponent;", "lookup", "Lcom/intellij/codeInsight/lookup/Lookup;", "doCreatePanel", "promotion", "", "Lcom/intellij/ui/dsl/builder/Row;", "shortcutHint", "createHintComponent", "Ljavax/swing/text/JTextComponent;", "createCustomPaneConfiguration", "Lcom/intellij/ui/components/JBHtmlPaneConfiguration;", "getInsertionShortcutText", "", "getInsertionPresets", "", "Lcom/intellij/terminal/frontend/view/completion/TerminalLookupBottomPanelProvider$ShortcutPreset;", "ShortcutPreset", "intellij.terminal.frontend"})
@SourceDebugExtension(value={"SMAP\nTerminalLookupBottomPanelProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalLookupBottomPanelProvider.kt\ncom/intellij/terminal/frontend/view/completion/TerminalLookupBottomPanelProvider\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,241:1\n11879#2,9:242\n13805#2:251\n13806#2:253\n11888#2:254\n1#3:252\n1#3:255\n*S KotlinDebug\n*F\n+ 1 TerminalLookupBottomPanelProvider.kt\ncom/intellij/terminal/frontend/view/completion/TerminalLookupBottomPanelProvider\n*L\n132#1:242,9\n132#1:251\n132#1:253\n132#1:254\n132#1:252\n*E\n"})
public final class TerminalLookupBottomPanelProvider
implements LookupBottomPanelProvider {
    @Nullable
    public JComponent createBottomPanel(@NotNull Lookup lookup) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        Editor editor = lookup.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        return TerminalDataContextUtils.INSTANCE.isOutputModelEditor(editor) ? this.doCreatePanel(lookup) : null;
    }

    private final JComponent doCreatePanel(Lookup lookup) {
        boolean shouldShowPromotion = TerminalCompletionPopupPromotion.INSTANCE.shouldShowPromotion();
        DialogPanel panel = BuilderKt.panel(arg_0 -> TerminalLookupBottomPanelProvider.doCreatePanel$lambda$0(shouldShowPromotion, this, lookup, arg_0));
        panel.setBackground(JBUI.CurrentTheme.CompletionPopup.Advertiser.background());
        panel.setBorder((Border)JBUI.Borders.empty((int)0, (int)12, (int)0, (int)5));
        int prefWidth = shouldShowPromotion ? 300 : 240;
        panel.setPreferredSize((Dimension)new JBDimension(prefWidth, 28));
        return (JComponent)panel;
    }

    private final void promotion(Row $this$promotion) {
        Icon icon = AllIcons.General.New_badge;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"New_badge");
        $this$promotion.icon(icon).align((Align)AlignY.CENTER.INSTANCE).customize(UnscaledGapsKt.UnscaledGaps$default((int)0, (int)0, (int)0, (int)6, (int)7, null));
        String string = TerminalBundle.message("terminal.command.completion.popup.promotion", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        JComponent jComponent = $this$promotion.label(string).align((Align)AlignY.CENTER.INSTANCE).getComponent();
        JLabel $this$promotion_u24lambda_u240 = (JLabel)jComponent;
        boolean bl = false;
        $this$promotion_u24lambda_u240.setForeground(JBUI.CurrentTheme.CompletionPopup.Advertiser.foreground());
        $this$promotion_u24lambda_u240.setFont((Font)JBUI.Fonts.label().lessOn(1.0f));
    }

    private final void shortcutHint(Row $this$shortcutHint, Lookup lookup) {
        String shortcutText = this.getInsertionShortcutText();
        if (shortcutText == null || !(lookup instanceof LookupImpl)) {
            return;
        }
        ShortcutHintTextState textState = new ShortcutHintTextState(lookup, shortcutText);
        ((LookupImpl)lookup).addPrefixChangeListener((PrefixChangeListener)textState, (Disposable)lookup);
        TextFieldKt.bindText((Cell)$this$shortcutHint.cell((JComponent)this.createHintComponent()).align((Align)AlignY.CENTER.INSTANCE), textState.getValue());
    }

    private final JTextComponent createHintComponent() {
        JBHtmlPane hint = new JBHtmlPane(new JBHtmlPaneStyleConfiguration(), this.createCustomPaneConfiguration());
        hint.setOpaque(false);
        hint.setForeground(JBUI.CurrentTheme.CompletionPopup.Advertiser.foreground());
        hint.setFont((Font)JBUI.Fonts.label().lessOn(1.0f));
        return (JTextComponent)hint;
    }

    private final JBHtmlPaneConfiguration createCustomPaneConfiguration() {
        Color color = JBUI.CurrentTheme.CompletionPopup.Advertiser.foreground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"foreground(...)");
        Color foreground = color;
        JBColor jBColor = JBColor.namedColor((String)"Component.borderColor", (Color)((Color)new JBColor(13225174, 5132631)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        JBColor borderColor = jBColor;
        return JBHtmlPaneConfiguration.Companion.builder().customStyleSheet(StringsKt.trimIndent((String)("\n        kbd {\n          color: #" + ColorUtil.toHex((Color)foreground) + ";\n          border-color: #" + ColorUtil.toHex((Color)((Color)borderColor)) + ";\n          font-weight: bold;\n          font-size: 90%;\n        }\n      "))).build();
    }

    /*
     * WARNING - void declaration
     */
    private final String getInsertionShortcutText() {
        Object v1;
        String actionId;
        block4: {
            void $this$mapNotNullTo$iv$iv;
            actionId = "Terminal.EnterCommandCompletion";
            Shortcut[] shortcutArray = KeymapManager.getInstance().getActiveKeymap().getShortcuts(actionId);
            Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"getShortcuts(...)");
            Object[] $this$mapNotNull$iv = shortcutArray;
            boolean $i$f$mapNotNull = false;
            Object[] objectArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                KeyboardShortcut it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                Shortcut it = (Shortcut)element$iv$iv;
                boolean bl2 = false;
                if ((it instanceof KeyboardShortcut ? (KeyboardShortcut)it : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List shortcuts = (List)destination$iv$iv;
            if (shortcuts.isEmpty()) {
                return null;
            }
            List<ShortcutPreset> presents = this.getInsertionPresets();
            Iterable iterable = presents;
            for (Object t : iterable) {
                ShortcutPreset preset = (ShortcutPreset)t;
                boolean bl = false;
                if (!CollectionsKt.contains((Iterable)shortcuts, (Object)preset.getShortcut())) continue;
                v1 = t;
                break block4;
            }
            v1 = null;
        }
        ShortcutPreset chosenPreset = v1;
        if (chosenPreset != null) {
            return "<kbd>" + chosenPreset.getText() + "</kbd>";
        }
        return "<shortcut actionId=\"" + actionId + "\"/>";
    }

    private final List<ShortcutPreset> getInsertionPresets() {
        Object[] objectArray = new ShortcutPreset[]{new ShortcutPreset((Shortcut)new KeyboardShortcut(KeyStroke.getKeyStroke(10, 0), null), "Enter"), new ShortcutPreset((Shortcut)new KeyboardShortcut(KeyStroke.getKeyStroke(9, 0), null), "Tab")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final Unit doCreatePanel$lambda$0(boolean $shouldShowPromotion, TerminalLookupBottomPanelProvider this$0, Lookup $lookup, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.customizeSpacingConfiguration((SpacingConfiguration)new EmptySpacingConfiguration(), TerminalLookupBottomPanelProvider::doCreatePanel$lambda$0$0);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> TerminalLookupBottomPanelProvider.doCreatePanel$lambda$0$1($shouldShowPromotion, this$0, $lookup, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit doCreatePanel$lambda$0$0(Panel $this$customizeSpacingConfiguration) {
        Intrinsics.checkNotNullParameter((Object)$this$customizeSpacingConfiguration, (String)"$this$customizeSpacingConfiguration");
        return Unit.INSTANCE;
    }

    private static final Unit doCreatePanel$lambda$0$1(boolean $shouldShowPromotion, TerminalLookupBottomPanelProvider this$0, Lookup $lookup, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.resizableRow();
        if ($shouldShowPromotion) {
            this$0.promotion($this$row);
            TerminalCompletionPopupPromotion.INSTANCE.promotionShown();
        } else {
            this$0.shortcutHint($this$row, $lookup);
        }
        ExtensionsKt.actionButton$default((Row)$this$row, (AnAction)((AnAction)new TerminalCommandCompletionSettingsAction()), null, (int)2, null).align((Align)AlignY.CENTER.INSTANCE).align((Align)AlignX.RIGHT.INSTANCE).customize(UnscaledGapsKt.UnscaledGaps$default((int)0, (int)6, (int)0, (int)0, (int)13, null));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/terminal/frontend/view/completion/TerminalLookupBottomPanelProvider$ShortcutPreset;", "", "shortcut", "Lcom/intellij/openapi/actionSystem/Shortcut;", "text", "", "<init>", "(Lcom/intellij/openapi/actionSystem/Shortcut;Ljava/lang/String;)V", "getShortcut", "()Lcom/intellij/openapi/actionSystem/Shortcut;", "getText", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.terminal.frontend"})
    private static final class ShortcutPreset {
        @NotNull
        private final Shortcut shortcut;
        @NotNull
        private final String text;

        public ShortcutPreset(@NotNull Shortcut shortcut, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)shortcut, (String)"shortcut");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.shortcut = shortcut;
            this.text = text;
        }

        @NotNull
        public final Shortcut getShortcut() {
            return this.shortcut;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final Shortcut component1() {
            return this.shortcut;
        }

        @NotNull
        public final String component2() {
            return this.text;
        }

        @NotNull
        public final ShortcutPreset copy(@NotNull Shortcut shortcut, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)shortcut, (String)"shortcut");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return new ShortcutPreset(shortcut, text);
        }

        public static /* synthetic */ ShortcutPreset copy$default(ShortcutPreset shortcutPreset, Shortcut shortcut, String string, int n, Object object) {
            if ((n & 1) != 0) {
                shortcut = shortcutPreset.shortcut;
            }
            if ((n & 2) != 0) {
                string = shortcutPreset.text;
            }
            return shortcutPreset.copy(shortcut, string);
        }

        @NotNull
        public String toString() {
            return "ShortcutPreset(shortcut=" + this.shortcut + ", text=" + this.text + ")";
        }

        public int hashCode() {
            int result2 = this.shortcut.hashCode();
            result2 = result2 * 31 + this.text.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ShortcutPreset)) {
                return false;
            }
            ShortcutPreset shortcutPreset = (ShortcutPreset)other;
            if (!Intrinsics.areEqual((Object)this.shortcut, (Object)shortcutPreset.shortcut)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.text, (Object)shortcutPreset.text);
        }
    }
}

