/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.execution.process.LocalProcessService;
import com.intellij.execution.process.LocalPtyOptions;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.CollectionFactory;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.TtyConnector;
import com.pty4j.PtyProcess;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import kotlin.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.LocalTerminalCustomizer;
import org.jetbrains.plugins.terminal.LocalTerminalTtyConnector;
import org.jetbrains.plugins.terminal.ShellProcessHolder;
import org.jetbrains.plugins.terminal.ShellStartupOptions;
import org.jetbrains.plugins.terminal.ShellStartupOptionsKt;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalProjectOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalStartupKt;
import org.jetbrains.plugins.terminal.fus.ReworkedTerminalUsageCollector;
import org.jetbrains.plugins.terminal.fus.TerminalUsageTriggerCollector;
import org.jetbrains.plugins.terminal.runner.LocalOptionsConfigurer;
import org.jetbrains.plugins.terminal.runner.LocalShellIntegrationInjector;
import org.jetbrains.plugins.terminal.runner.LocalTerminalStartCommandBuilder;
import org.jetbrains.plugins.terminal.shell_integration.TerminalPSReadLineUpdateUtil;
import org.jetbrains.plugins.terminal.util.ShellIntegration;

public class LocalTerminalDirectRunner
extends AbstractTerminalRunner<PtyProcess> {
    private static final Logger LOG = Logger.getInstance(LocalTerminalDirectRunner.class);
    @ApiStatus.Internal
    public static final String LOGIN_CLI_OPTION = "--login";
    @ApiStatus.Internal
    public static final List<String> LOGIN_CLI_OPTIONS = List.of("--login", "-l");
    protected final Charset myDefaultCharset;
    private final Map<PtyProcess, ShellProcessHolder> myProcessHolderMap = CollectionFactory.createConcurrentWeakMap();

    public LocalTerminalDirectRunner(Project project) {
        super(project);
        this.myDefaultCharset = StandardCharsets.UTF_8;
    }

    @NotNull
    public static LocalTerminalDirectRunner createTerminalRunner(Project project) {
        return new LocalTerminalDirectRunner(project);
    }

    @Override
    @NotNull
    public ShellStartupOptions configureStartupOptions(@NotNull ShellStartupOptions baseOptions) {
        if (baseOptions == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(0);
        }
        ShellStartupOptions updatedOptions = LocalOptionsConfigurer.configureStartupOptions(baseOptions, this.myProject);
        if (this.enableShellIntegration()) {
            updatedOptions = LocalShellIntegrationInjector.injectShellIntegration(updatedOptions, this.isGenOneTerminalEnabled(), this.isGenTwoTerminalEnabled());
        }
        updatedOptions = TerminalPSReadLineUpdateUtil.configureOptions(updatedOptions);
        return this.applyTerminalCustomizers(updatedOptions);
    }

    @NotNull
    private ShellStartupOptions applyTerminalCustomizers(@NotNull ShellStartupOptions options) {
        if (options == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(1);
        }
        String[] command2 = ArrayUtil.toStringArray(options.getShellCommand());
        Map<String, String> envs = ShellStartupOptionsKt.createEnvVariablesMap(options.getEnvVariables());
        for (LocalTerminalCustomizer customizer : (LocalTerminalCustomizer[])LocalTerminalCustomizer.EP_NAME.getExtensions()) {
            try {
                command2 = customizer.customizeCommandAndEnvironment(this.myProject, options.getWorkingDirectory(), command2, envs);
            }
            catch (Exception e) {
                LOG.error("Exception during customization of the terminal session", (Throwable)e);
            }
        }
        ShellStartupOptions shellStartupOptions = options.builder().shellCommand(Arrays.asList(command2)).envVariables(envs).build();
        if (shellStartupOptions == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(2);
        }
        return shellStartupOptions;
    }

    @Override
    @NotNull
    public PtyProcess createProcess(@NotNull ShellStartupOptions options) throws ExecutionException {
        PtyProcess ptyProcess;
        boolean isBlockTerminal;
        if (options == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(3);
        }
        String[] command2 = ArrayUtil.toStringArray(options.getShellCommand());
        Map<String, String> envs = options.getEnvVariables();
        TermSize initialTermSize = options.getInitialTermSize();
        String workingDir = options.getWorkingDirectory();
        if (workingDir == null) {
            throw new IllegalStateException("Working directory must not be null, startup options: " + String.valueOf(options));
        }
        ShellIntegration shellIntegration = options.getShellIntegration();
        boolean bl = isBlockTerminal = this.isGenOneTerminalEnabled() && shellIntegration != null && shellIntegration.getCommandBlocks();
        if (this.isGenTwoTerminalEnabled()) {
            ReworkedTerminalUsageCollector.logLocalShellStarted(this.myProject, command2);
        } else {
            TerminalUsageTriggerCollector.triggerLocalShellStarted(this.myProject, command2, isBlockTerminal);
        }
        Path workingDirPath = null;
        try {
            workingDirPath = Path.of(workingDir, new String[0]);
        }
        catch (InvalidPathException invalidPathException) {
            // empty catch block
        }
        try {
            PtyProcess process;
            long startNano = System.nanoTime();
            if (workingDirPath != null && TerminalStartupKt.shouldUseEelApi()) {
                Pair<PtyProcess, ShellProcessHolder> processPair = TerminalStartupKt.startProcess(List.of(command2), envs, workingDirPath, Objects.requireNonNull(initialTermSize));
                this.myProcessHolderMap.put((PtyProcess)processPair.getFirst(), (ShellProcessHolder)processPair.getSecond());
                process = (PtyProcess)processPair.getFirst();
            } else {
                process = (PtyProcess)LocalProcessService.getInstance().startPtyProcess(List.of(command2), workingDir, envs, LocalPtyOptions.defaults().builder().initialColumns(initialTermSize != null ? initialTermSize.getColumns() : -1).initialRows(initialTermSize != null ? initialTermSize.getRows() : -1).build(), false);
            }
            LOG.info("Started " + process.getClass().getName() + " in " + TimeoutUtil.getDurationMillis((long)startNano) + " ms from " + LocalTerminalDirectRunner.stringifyProcessInfo(command2, workingDir, initialTermSize, envs, !LOG.isDebugEnabled()));
            ptyProcess = process;
        }
        catch (Exception e) {
            throw new ExecutionException("Failed to start " + LocalTerminalDirectRunner.stringifyProcessInfo(command2, workingDir, initialTermSize, envs, false), e);
        }
        if (ptyProcess == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(4);
        }
        return ptyProcess;
    }

    protected boolean enableShellIntegration() {
        return TerminalOptionsProvider.getInstance().getShellIntegration();
    }

    @NotNull
    private static String stringifyProcessInfo(String @NotNull [] command2, @NotNull String workingDirectory, @Nullable TermSize initialTermSize, @NotNull Map<String, String> environment, boolean envDiff) {
        if (workingDirectory == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(5);
        }
        if (environment == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(6);
        }
        if (command2 == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(7);
        }
        String info = Arrays.toString(command2) + " in " + workingDirectory + (LocalTerminalDirectRunner.isDirectory(workingDirectory) ? "" : " [no such directory]") + ", [" + String.valueOf(initialTermSize) + "]";
        if (envDiff) {
            String string = info + ", diff_envs=" + String.valueOf(LocalTerminalDirectRunner.getEnvironmentDiff(environment, System.getenv()));
            if (string == null) {
                LocalTerminalDirectRunner.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = info + ", envs=" + String.valueOf(environment);
        if (string == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private static Map<String, String> getEnvironmentDiff(@NotNull Map<String, String> environment, @NotNull Map<String, String> baseEnvironment) {
        if (environment == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(10);
        }
        if (baseEnvironment == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(11);
        }
        Map map2 = environment.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> Objects.equals(entry.getValue(), baseEnvironment.get(entry.getKey())) ? null : entry).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1, LinkedHashMap::new));
        if (map2 == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(12);
        }
        return map2;
    }

    @ApiStatus.Internal
    public static boolean isDirectory(@NotNull String directory) {
        if (directory == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(13);
        }
        try {
            boolean ok = Files.isDirectory(Path.of(directory, new String[0]), new LinkOption[0]);
            if (!ok) {
                LOG.info("Cannot start local terminal in " + directory + ": no such directory");
            }
            return ok;
        }
        catch (InvalidPathException e) {
            LOG.info("Cannot start local terminal in " + directory + ": invalid path", (Throwable)e);
            return false;
        }
    }

    @ApiStatus.Internal
    @Nullable
    protected ShellProcessHolder getHolder(@NotNull PtyProcess process) {
        if (process == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(14);
        }
        return this.myProcessHolderMap.remove(process);
    }

    @Override
    @NotNull
    public TtyConnector createTtyConnector(@NotNull PtyProcess process) {
        if (process == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(15);
        }
        return new LocalTerminalTtyConnector(process, this.myDefaultCharset, this.getHolder(process));
    }

    @Override
    @NotNull
    public String getDefaultTabTitle() {
        String string = TerminalOptionsProvider.getInstance().getTabName();
        if (string == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Deprecated(since="2024.3", forRemoval=true)
    @NotNull
    public List<String> getInitialCommand(@NotNull Map<String, String> envs) {
        if (envs == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(17);
        }
        List<String> list = LocalTerminalStartCommandBuilder.convertShellPathToCommand(this.getShellPath());
        if (list == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(18);
        }
        return list;
    }

    @ApiStatus.Internal
    protected boolean isGenOneTerminalEnabled() {
        return false;
    }

    @ApiStatus.Internal
    protected boolean isGenTwoTerminalEnabled() {
        return false;
    }

    @NotNull
    private String getShellPath() {
        String string = TerminalProjectOptionsProvider.getInstance(this.myProject).getShellPath();
        if (string == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(19);
        }
        return string;
    }

    @ApiStatus.Internal
    @VisibleForTesting
    @NotNull
    public ShellStartupOptions injectShellIntegration(@NotNull List<String> shellCommand, @NotNull Map<String, String> envs) {
        if (shellCommand == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(20);
        }
        if (envs == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(21);
        }
        ShellStartupOptions options = new ShellStartupOptions.Builder().shellCommand(shellCommand).envVariables(envs).build();
        ShellStartupOptions shellStartupOptions = LocalShellIntegrationInjector.injectShellIntegration(options, this.isGenOneTerminalEnabled(), this.isGenTwoTerminalEnabled());
        if (shellStartupOptions == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(22);
        }
        return shellStartupOptions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 8, 9, 12, 16, 18, 19, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseOptions";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 12: 
            case 16: 
            case 18: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/LocalTerminalDirectRunner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseEnvironment";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/LocalTerminalDirectRunner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "applyTerminalCustomizers";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcess";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "stringifyProcessInfo";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironmentDiff";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTabTitle";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialCommand";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getShellPath";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "injectShellIntegration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "configureStartupOptions";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyTerminalCustomizers";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 12: 
            case 16: 
            case 18: 
            case 19: 
            case 22: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "stringifyProcessInfo";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getEnvironmentDiff";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isDirectory";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getHolder";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createTtyConnector";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getInitialCommand";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "injectShellIntegration";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 8, 9, 12, 16, 18, 19, 22 -> new IllegalStateException(string);
        };
    }
}

