/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.impl;

import com.intellij.docker.agent.DockerRepoTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005\u001a\f\u0010\b\u001a\u00020\u0003*\u00020\u0003H\u0000\u001a\f\u0010\n\u001a\u00020\u0005*\u00020\u0005H\u0002\u001a\f\u0010\u000b\u001a\u00020\u0005*\u00020\u0005H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"DIGEST_REGEXP", "Lkotlin/text/Regex;", "validDockerRepoTagFromString", "Lcom/intellij/docker/agent/DockerRepoTag;", "reference", "", "isValidRepoTag", "", "toValidDockerRepoTag", "DELIMITER", "toValidTagPiece", "toValidLowerCasePiece", "intellij.clouds.docker.agent"})
@SourceDebugExtension(value={"SMAP\ndockerRepoTags.kt\nKotlin\n*S Kotlin\n*F\n+ 1 dockerRepoTags.kt\ncom/intellij/docker/agent/impl/DockerRepoTagsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1563#2:52\n1634#2,3:53\n1#3:56\n*S KotlinDebug\n*F\n+ 1 dockerRepoTags.kt\ncom/intellij/docker/agent/impl/DockerRepoTagsKt\n*L\n26#1:52\n26#1:53,3\n*E\n"})
public final class DockerRepoTagsKt {
    @NotNull
    private static final Regex DIGEST_REGEXP = new Regex("[A-Za-z][A-Za-z0-9]*(?:[-_+.][A-Za-z][A-Za-z0-9]*)*[:][0-9a-f]{64,}");
    @NotNull
    public static final String DELIMITER = "[\\-_.]";

    @NotNull
    public static final DockerRepoTag validDockerRepoTagFromString(@NotNull String reference) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        DockerRepoTag dockerRepoTag = DockerRepoTag.fromString(reference);
        Intrinsics.checkNotNullExpressionValue((Object)dockerRepoTag, (String)"fromString(...)");
        return DockerRepoTagsKt.toValidDockerRepoTag(dockerRepoTag);
    }

    public static final boolean isValidRepoTag(@NotNull String reference) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        return DockerRepoTag.fromString(reference).isValidReferenceFormat();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DockerRepoTag toValidDockerRepoTag(@NotNull DockerRepoTag $this$toValidDockerRepoTag) {
        DockerRepoTag validTag;
        block4: {
            Object object;
            void $this$mapTo$iv$iv;
            Object it;
            Intrinsics.checkNotNullParameter((Object)$this$toValidDockerRepoTag, (String)"<this>");
            DockerRepoTag dockerRepoTag = $this$toValidDockerRepoTag.clone();
            Intrinsics.checkNotNullExpressionValue((Object)dockerRepoTag, (String)"clone(...)");
            validTag = dockerRepoTag;
            String string = $this$toValidDockerRepoTag.getNamespace();
            if (string != null) {
                it = string;
                boolean bl = false;
                validTag.setNamespace(DockerRepoTagsKt.toValidLowerCasePiece((String)it));
            }
            String string2 = $this$toValidDockerRepoTag.getSimpleRepositoryName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSimpleRepositoryName(...)");
            String[] stringArray = new String[]{"/"};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)string2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                String string3 = (String)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(DockerRepoTagsKt.toValidLowerCasePiece((String)it2));
            }
            String it3 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
            boolean bl2 = false;
            validTag.setRepository(it3);
            if ($this$toValidDockerRepoTag.hasCustomTag()) {
                String string4;
                String bl2 = string4 = $this$toValidDockerRepoTag.getTagNotNull();
                object = validTag;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)it);
                boolean bl4 = !StringsKt.isBlank((CharSequence)((CharSequence)it));
                String string5 = bl4 ? string4 : null;
                ((DockerRepoTag)object).setTag(string5 != null ? DockerRepoTagsKt.toValidTagPiece(string5) : null);
            }
            String string6 = $this$toValidDockerRepoTag.getDigest();
            if (string6 == null) break block4;
            String it2 = string6;
            boolean bl5 = false;
            if (!StringsKt.isBlank((CharSequence)it2) && !DIGEST_REGEXP.matches((CharSequence)it2)) {
                validTag.setDigest(null);
            }
        }
        return validTag;
    }

    private static final String toValidTagPiece(String $this$toValidTagPiece) {
        CharSequence charSequence = $this$toValidTagPiece;
        Regex regex = new Regex("[^\\w.-]");
        String string = "_";
        charSequence = regex.replace(charSequence, string);
        regex = new Regex("([\\-_.])[\\-_.]*");
        string = "$1";
        return StringsKt.removeSuffix((String)regex.replace(charSequence, string), (CharSequence)"_");
    }

    private static final String toValidLowerCasePiece(String $this$toValidLowerCasePiece) {
        String string = DockerRepoTagsKt.toValidTagPiece($this$toValidLowerCasePiece);
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return string2;
    }
}

