/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.impl;

import com.github.dockerjava.api.model.ResponseItem;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ResponseItemAggregator {
    private final Map<ProgressKey, ProgressInfo> myProgresses = new ConcurrentHashMap<ProgressKey, ProgressInfo>();

    ResponseItemAggregator() {
    }

    public void updateProgress(@NotNull ResponseItem item) {
        if (item == null) {
            ResponseItemAggregator.$$$reportNull$$$0(0);
        }
        String status2 = item.getStatus();
        ResponseItem.ProgressDetail progressDetail = item.getProgressDetail();
        String id2 = item.getId();
        if (id2 != null && status2 != null && progressDetail != null && progressDetail.getCurrent() != null && progressDetail.getTotal() != null) {
            long current = progressDetail.getCurrent();
            long total = progressDetail.getTotal();
            this.myProgresses.put(new ProgressKey(status2, id2), new ProgressInfo(current, total));
        }
    }

    public void completeProgress(@NotNull String id2) {
        if (id2 == null) {
            ResponseItemAggregator.$$$reportNull$$$0(1);
        }
        List<ProgressKey> allMatchedKeys = this.myProgresses.keySet().stream().filter(key -> key.matchesId(id2)).toList();
        for (ProgressKey nextMatchedKey : allMatchedKeys) {
            ProgressInfo previousInfo = this.myProgresses.get(nextMatchedKey);
            if (previousInfo == null) continue;
            this.myProgresses.put(nextMatchedKey, ProgressInfo.complete(previousInfo));
        }
    }

    @Nullable
    public ProgressInfo computeAggregatedProgress() {
        long current = 0L;
        long total = 0L;
        for (ProgressInfo info : this.myProgresses.values()) {
            current += info.getCurrent();
            total += info.getTotal();
        }
        return total > 0L ? new ProgressInfo(current, total) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/agent/impl/ResponseItemAggregator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateProgress";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "completeProgress";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class ProgressKey {
        private final String myStatus;
        private final String myId;

        private ProgressKey(String status2, String id2) {
            this.myStatus = status2;
            this.myId = id2;
        }

        public boolean matchesId(String id2) {
            return this.myId.equals(id2);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProgressKey key = (ProgressKey)o;
            if (!this.myStatus.equals(key.myStatus)) {
                return false;
            }
            return this.myId.equals(key.myId);
        }

        public int hashCode() {
            int result2 = this.myStatus.hashCode();
            result2 = 31 * result2 + this.myId.hashCode();
            return result2;
        }
    }

    public static final class ProgressInfo {
        private final long myCurrent;
        private final long myTotal;

        private ProgressInfo(long current, long total) {
            this.myCurrent = current;
            this.myTotal = total;
        }

        public long getCurrent() {
            return this.myCurrent;
        }

        public long getTotal() {
            return this.myTotal;
        }

        public boolean isCompleted() {
            return this.myCurrent == this.myTotal;
        }

        public static ProgressInfo complete(ProgressInfo progressInfo) {
            return new ProgressInfo(progressInfo.getTotal(), progressInfo.getTotal());
        }
    }
}

