/*
 * Decompiled with CFR 0.152.
 */
package andel.intervals.impl;

import andel.intervals.Interval;
import andel.intervals.IntervalsIterator;
import andel.intervals.impl.IntervalsImpl;
import andel.intervals.impl.MergingIterator;
import fleet.fastutil.longs.LongArrayList;
import fleet.fastutil.longs.LongListExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0007defghijB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\f\u001a\b\u0012\u0004\u0012\u0002H\r0\n\"\b\b\u0000\u0010\r*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J(\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\r0\n\"\b\b\u0000\u0010\r*\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J@\u0010\u0013\u001a\u00020\u00142\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00170\u0016j\b\u0012\u0004\u0012\u00020\u0017`\u00182\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0012H\u0002J(\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00170\u0016j\b\u0012\u0004\u0012\u00020\u0017`\u00182\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0012H\u0002J\u0018\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0012H\u0002J:\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050!2\u0006\u0010#\u001a\u00020\u00052\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J\u001a\u0010&\u001a\u00020\u00172\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u001d\u001a\u00020\u0017H\u0002J\u0018\u0010)\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\u0012H\u0002J(\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u00172\u0006\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u0017H\u0002J\u001a\u00100\u001a\u00020\u00172\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u001d\u001a\u00020\u0017H\u0002J\u0018\u00101\u001a\u00020\u00172\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u001d\u001a\u00020\u0017J(\u00102\u001a\u00020\u000f2\u0006\u00103\u001a\u00020\u00052\u0006\u00104\u001a\u00020\u00052\u0006\u00105\u001a\u00020\u00052\u0006\u00106\u001a\u00020\u0005H\u0002J \u00107\u001a\u00020\u00172\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u00108\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0017J \u00109\u001a\u00020\u00172\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u00108\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\u0017J\u0010\u0010;\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0017H\u0002J$\u0010<\u001a\b\u0012\u0004\u0012\u0002H\r0=\"\b\b\u0000\u0010\r*\u00020\u00012\f\u0010>\u001a\b\u0012\u0004\u0012\u0002H\r0\nJ\u001c\u0010?\u001a\u0004\u0018\u00010@2\b\u0010A\u001a\u0004\u0018\u00010@2\u0006\u0010B\u001a\u00020\u0005H\u0002J \u0010C\u001a\u0004\u0018\u00010@2\u0006\u0010D\u001a\u00020@2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005J \u0010E\u001a\u0004\u0018\u00010@2\u0006\u0010D\u001a\u00020@2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005J4\u0010F\u001a\b\u0012\u0004\u0012\u0002H\r0G\"\b\b\u0000\u0010\r*\u00020\u00012\f\u0010>\u001a\b\u0012\u0004\u0012\u0002H\r0\n2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005J4\u0010H\u001a\b\u0012\u0004\u0012\u0002H\r0G\"\b\b\u0000\u0010\r*\u00020\u00012\f\u0010>\u001a\b\u0012\u0004\u0012\u0002H\r0\n2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005J\u001e\u0010I\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010B\u001a\u00020\u00052\u0006\u0010J\u001a\u00020\u0005J4\u0010I\u001a\b\u0012\u0004\u0012\u0002H\r0\n\"\b\b\u0000\u0010\r*\u00020\u00012\f\u0010>\u001a\b\u0012\u0004\u0012\u0002H\r0\n2\u0006\u0010K\u001a\u00020\u00052\u0006\u0010J\u001a\u00020\u0005J8\u0010L\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050!2\u0006\u0010M\u001a\u00020\u00052\u0006\u0010N\u001a\u00020\u0001H\u0002J.\u0010O\u001a\u00020\u00172\u0006\u0010'\u001a\u00020(2\u0006\u0010P\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010B\u001a\u00020\u00052\u0006\u0010J\u001a\u00020\u0005J4\u0010O\u001a\b\u0012\u0004\u0012\u0002H\r0\n\"\b\b\u0000\u0010\r*\u00020\u00012\f\u0010>\u001a\b\u0012\u0004\u0012\u0002H\r0\n2\u0006\u0010K\u001a\u00020\u00052\u0006\u0010J\u001a\u00020\u0005Jd\u0010Q\u001a\u00020\u00172\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010R\u001a\u00020\u00052B\u0010S\u001a>\u0012\u0004\u0012\u00020\u0005\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00050Uj\b\u0012\u0004\u0012\u00020\u0005`V0Tj\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00050Uj\b\u0012\u0004\u0012\u00020\u0005`V`WH\u0002J2\u0010Q\u001a\b\u0012\u0004\u0012\u0002H\r0\n\"\b\b\u0000\u0010\r*\u00020\u00012\f\u0010>\u001a\b\u0012\u0004\u0012\u0002H\r0\n2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020\u00050YJ&\u0010Z\u001a\u0004\u0018\u00010%2\u0012\u0010[\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\\2\u0006\u0010M\u001a\u00020\u0005H\u0002J\u001c\u0010]\u001a\u00020\u00172\n\u0010>\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010M\u001a\u00020\u0005H\u0002J4\u0010^\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\r\u0018\u00010_\"\b\b\u0000\u0010\r*\u00020\u00012\f\u0010>\u001a\b\u0012\u0004\u0012\u0002H\r0\n2\u0006\u0010M\u001a\u00020\u0005Jf\u0010`\u001a>\u0012\u0004\u0012\u00020\u0005\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00050Uj\b\u0012\u0004\u0012\u00020\u0005`V0Tj\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00050Uj\b\u0012\u0004\u0012\u00020\u0005`V`W2\u0012\u0010[\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\\2\f\u0010a\u001a\b\u0012\u0004\u0012\u00020\u00050YH\u0002J\u0012\u0010b\u001a\u00020\u00052\b\u0010c\u001a\u0004\u0018\u00010%H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006k"}, d2={"Landel/intervals/impl/Impl;", "", "<init>", "()V", "OPEN_ROOT_ID", "", "CLOSED_ROOT_ID", "FIRST_ID", "MAX_VALUE", "EMPTY_DROPPING", "Landel/intervals/impl/IntervalsImpl;", "EMPTY_KEEPING", "empty", "T", "dropEmpty", "", "emptyImpl", "maxChildren", "", "splitNode", "", "result", "Ljava/util/ArrayList;", "Landel/intervals/impl/Impl$Node;", "Lkotlin/collections/ArrayList;", "source", "from", "to", "thresh", "node", "splitThreshold", "childrenNeedSplitting", "adopt", "Lkotlinx/collections/immutable/PersistentMap$Builder;", "parentsMap", "parentId", "childrenIds", "Lfleet/fastutil/longs/LongArrayList;", "splitChildren", "ctx", "Landel/intervals/impl/Impl$EditingContext;", "childrenNeedMerging", "threshold", "mergeNodes", "leftDelta", "left", "rightDelta", "right", "mergeChildren", "balanceChildren", "intersects", "s1", "e1", "s2", "e2", "growTree", "rootId", "shrinkTree", "root", "normalize", "batch", "Landel/intervals/impl/Impl$Batch;", "tree", "skipToOffset", "Landel/intervals/impl/Impl$Zipper;", "z", "offset", "nextIntersection", "zipper", "prevIntersection", "query", "Landel/intervals/IntervalsIterator;", "queryReverse", "expand", "len", "start", "extinct", "id", "child", "collapse", "d", "remove", "nodeId", "subtree", "Ljava/util/HashMap;", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "Lkotlin/collections/HashMap;", "ids", "", "resolvePath", "parents", "Lkotlinx/collections/immutable/PersistentMap;", "chooseRoot", "getById", "Landel/intervals/Interval;", "deletionSubtree", "toBeDeleted", "max", "arr", "Node", "Zipper", "EditingContext", "Batch", "AbstractIterator", "ForwardIterator", "BackwardIterator", "fleet.andel"})
@SourceDebugExtension(value={"SMAP\nImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Impl.kt\nandel/intervals/impl/Impl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1016:1\n1#2:1017\n*E\n"})
public final class Impl {
    @NotNull
    public static final Impl INSTANCE = new Impl();
    private static final long OPEN_ROOT_ID = -1L;
    private static final long CLOSED_ROOT_ID = -2L;
    private static final long FIRST_ID = -3L;
    public static final long MAX_VALUE = 0x3FFFFFFFFFFFFFFEL;
    @NotNull
    private static final IntervalsImpl<?> EMPTY_DROPPING = Impl.emptyImpl(32, true);
    @NotNull
    private static final IntervalsImpl<?> EMPTY_KEEPING = Impl.emptyImpl(32, false);

    private Impl() {
    }

    @JvmStatic
    @NotNull
    public static final <T> IntervalsImpl<T> empty(boolean dropEmpty) {
        IntervalsImpl<?> intervalsImpl;
        if (dropEmpty) {
            IntervalsImpl<?> intervalsImpl2 = EMPTY_DROPPING;
            intervalsImpl = intervalsImpl2;
            Intrinsics.checkNotNull(intervalsImpl2, (String)"null cannot be cast to non-null type andel.intervals.impl.IntervalsImpl<T of andel.intervals.impl.Impl.empty>");
        } else {
            IntervalsImpl<?> intervalsImpl3 = EMPTY_KEEPING;
            intervalsImpl = intervalsImpl3;
            Intrinsics.checkNotNull(intervalsImpl3, (String)"null cannot be cast to non-null type andel.intervals.impl.IntervalsImpl<T of andel.intervals.impl.Impl.empty>");
        }
        return intervalsImpl;
    }

    @JvmStatic
    @NotNull
    public static final <T> IntervalsImpl<T> emptyImpl(int maxChildren, boolean dropEmpty) {
        Node openRoot = Node.Companion.empty(maxChildren / 2);
        Node closedRoot = Node.Companion.empty(maxChildren / 2);
        return new IntervalsImpl(maxChildren, openRoot, closedRoot, ExtensionsKt.persistentHashMapOf(), -3L, dropEmpty);
    }

    private final void splitNode(ArrayList<Node> result2, Node source2, int from, int to, int thresh) {
        int length = to - from;
        if (length <= thresh) {
            ArrayList<Object> children = new ArrayList<Object>(to - from);
            children.addAll((Collection)source2.getChildren().subList(from, to));
            result2.add(new Node(new LongArrayList(source2.getIds().elements(), from, to - from), new LongArrayList(source2.getStarts().elements(), from, to - from), new LongArrayList(source2.getEnds().elements(), from, to - from), children));
        } else {
            int half = length / 2;
            this.splitNode(result2, source2, from, from + half, thresh);
            this.splitNode(result2, source2, from + half, to, thresh);
        }
    }

    private final ArrayList<Node> splitNode(Node node, int splitThreshold) {
        ArrayList<Node> result2 = new ArrayList<Node>();
        this.splitNode(result2, node, 0, node.getChildren().size(), splitThreshold);
        return result2;
    }

    private final boolean childrenNeedSplitting(Node node, int splitThreshold) {
        Iterator<Object> iterator2 = node.getChildren().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<Object> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object child;
            Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
            if (child instanceof Node) {
                if (((Node)child).getChildren().size() <= splitThreshold) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private final PersistentMap.Builder<Long, Long> adopt(PersistentMap.Builder<Long, Long> parentsMap, long parentId, LongArrayList childrenIds) {
        PersistentMap.Builder<Long, Long> parentsMap2 = parentsMap;
        LongArrayList longArrayList = childrenIds;
        Intrinsics.checkNotNull((Object)longArrayList);
        IntRange intRange = LongListExtensionsKt.getIndices(longArrayList);
        int k2 = intRange.getFirst();
        int n2 = intRange.getLast();
        if (k2 <= n2) {
            while (true) {
                parentsMap2.put(childrenIds.get(k2), parentId);
                if (k2 == n2) break;
                ++k2;
            }
        }
        return parentsMap2;
    }

    private final Node splitChildren(EditingContext ctx, Node node) {
        Node node2;
        EditingContext editingContext = ctx;
        Intrinsics.checkNotNull((Object)editingContext);
        int splitThreshold = editingContext.getMaxChildren();
        if (this.childrenNeedSplitting(node, splitThreshold)) {
            Node result2 = Node.Companion.empty(splitThreshold / 2);
            PersistentMap.Builder<Long, Long> m2 = ctx.getParentsMap();
            long nextId = ctx.getNextId();
            int n2 = ((Collection)node.getChildren()).size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object = node.getChildren().get(i2);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type andel.intervals.impl.Impl.Node");
                Node child = (Node)object;
                long childDelta = node.getStarts().get(i2);
                long childId = node.getIds().get(i2);
                Long parentId = (Long)m2.get(childId);
                if (child.getChildren().size() > splitThreshold) {
                    ArrayList<Node> partition = this.splitNode(child, splitThreshold);
                    int n3 = ((Collection)partition).size();
                    for (int j2 = 0; j2 < n3; ++j2) {
                        Node p2;
                        Intrinsics.checkNotNullExpressionValue((Object)partition.get(j2), (String)"get(...)");
                        long delta = this.normalize(p2);
                        result2.getChildren().add(p2);
                        result2.getStarts().add(delta + childDelta);
                        result2.getEnds().add(this.max(p2.getEnds()) + childDelta + delta);
                        if (j2 == 0) {
                            result2.getIds().add(childId);
                            continue;
                        }
                        long l2 = nextId;
                        nextId = l2 + -1L;
                        long newId = l2;
                        m2 = this.adopt(m2, newId, p2.getIds());
                        Long l3 = newId;
                        Long l4 = parentId;
                        Intrinsics.checkNotNull((Object)l4);
                        m2.put(l3, l4);
                        result2.getIds().add(newId);
                    }
                    continue;
                }
                result2.add(childId, node.getStarts().get(i2), node.getEnds().get(i2), child);
            }
            ctx.setNextId(nextId);
            ctx.setParentsMap(m2);
            node2 = result2;
        } else {
            node2 = node;
        }
        return node2;
    }

    private final boolean childrenNeedMerging(Node node, int threshold) {
        Iterator<Object> iterator2 = node.getChildren().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<Object> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object child;
            Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
            if (child instanceof Node) {
                if (((Node)child).getChildren().size() >= threshold) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private final Node mergeNodes(long leftDelta, Node left, long rightDelta, Node right) {
        int i2;
        int capacity = left.getChildren().size() + right.getChildren().size();
        long delta = rightDelta - leftDelta;
        Node n2 = Node.Companion.empty(capacity);
        int leftc = left.getChildren().size();
        int rightc = right.getChildren().size();
        for (i2 = 0; i2 < leftc; ++i2) {
            n2.getChildren().add(left.getChildren().get(i2));
            n2.getStarts().add(left.getStarts().get(i2));
            n2.getEnds().add(left.getEnds().get(i2));
            n2.getIds().add(left.getIds().get(i2));
        }
        for (i2 = 0; i2 < rightc; ++i2) {
            n2.getChildren().add(right.getChildren().get(i2));
            n2.getStarts().add(right.getStarts().get(i2) + delta);
            n2.getEnds().add(right.getEnds().get(i2) + delta);
            n2.getIds().add(right.getIds().get(i2));
        }
        return n2;
    }

    private final Node mergeChildren(EditingContext ctx, Node node) {
        Node node2;
        EditingContext editingContext = ctx;
        Intrinsics.checkNotNull((Object)editingContext);
        int splitThreshold = editingContext.getMaxChildren();
        int mergeThreshold = splitThreshold / 2;
        if (this.childrenNeedMerging(node, mergeThreshold)) {
            Node result2 = Node.Companion.empty(mergeThreshold);
            Object object = node.getChildren().get(0);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type andel.intervals.impl.Impl.Node");
            Node left = (Node)object;
            long leftDelta = node.getStarts().get(0);
            long leftId = node.getIds().get(0);
            long leftEnd = node.getEnds().get(0);
            int n2 = node.getChildren().size();
            for (int i2 = 1; i2 < n2; ++i2) {
                Object object2 = node.getChildren().get(i2);
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type andel.intervals.impl.Impl.Node");
                Node right = (Node)object2;
                long rightDelta = node.getStarts().get(i2);
                long rightId = node.getIds().get(i2);
                long rightEnd = node.getEnds().get(i2);
                if (left.getChildren().size() < mergeThreshold || right.getChildren().size() < mergeThreshold) {
                    Node merged = this.mergeChildren(ctx, this.mergeNodes(leftDelta, left, rightDelta, right));
                    if (merged.getChildren().size() > splitThreshold) {
                        ArrayList<Node> split = this.splitNode(merged, splitThreshold);
                        if (!(split.size() == 2)) {
                            String string2 = "Failed requirement.";
                            throw new IllegalArgumentException(string2.toString());
                        }
                        ctx.setParentsMap(this.adopt(ctx.getParentsMap(), leftId, split.get(0).getIds()));
                        long l2 = leftDelta + this.max(split.get(0).getEnds());
                        Node node3 = split.get(0);
                        Intrinsics.checkNotNullExpressionValue((Object)node3, (String)"get(...)");
                        result2.add(leftId, leftDelta, l2, node3);
                        ctx.setParentsMap(this.adopt(ctx.getParentsMap(), rightId, split.get(1).getIds()));
                        Intrinsics.checkNotNullExpressionValue((Object)split.get(1), (String)"get(...)");
                        Node node4 = split.get(1);
                        Intrinsics.checkNotNullExpressionValue((Object)node4, (String)"get(...)");
                        leftEnd = (leftDelta += this.normalize(node4)) + this.max(split.get(1).getEnds());
                        leftId = rightId;
                        continue;
                    }
                    left = merged;
                    leftEnd = leftDelta + this.max(merged.getEnds());
                    ctx.setParentsMap(this.adopt(ctx.getParentsMap(), leftId, right.getIds()));
                    continue;
                }
                result2.add(leftId, leftDelta, leftEnd, left);
                left = right;
                leftDelta = rightDelta;
                leftId = rightId;
                leftEnd = rightEnd;
            }
            result2.add(leftId, leftDelta, leftEnd, left);
            node2 = result2;
        } else {
            node2 = node;
        }
        return node2;
    }

    @NotNull
    public final Node balanceChildren(@Nullable EditingContext ctx, @NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.mergeChildren(ctx, this.splitChildren(ctx, node));
    }

    private final boolean intersects(long s1, long e1, long s2, long e2) {
        return s1 <= s2 ? s2 <= e1 : s1 <= e2;
    }

    @NotNull
    public final Node growTree(@Nullable EditingContext ctx, long rootId, @NotNull Node node) {
        Node node2;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Node balanced = this.balanceChildren(ctx, node);
        int n2 = balanced.getChildren().size();
        EditingContext editingContext = ctx;
        Intrinsics.checkNotNull((Object)editingContext);
        if (n2 > editingContext.getMaxChildren()) {
            ArrayList<Object> newChildren = new ArrayList<Object>();
            newChildren.add(balanced);
            EditingContext editingContext2 = ctx;
            long l2 = editingContext2.getNextId();
            editingContext2.setNextId(l2 + -1L);
            long newLevelId = l2;
            ctx.setParentsMap(this.adopt(ctx.getParentsMap(), newLevelId, balanced.getIds()));
            ctx.getParentsMap().put(newLevelId, rootId);
            long[] lArray = new long[]{newLevelId};
            LongArrayList longArrayList = new LongArrayList(lArray, 0, 0, 6, null);
            lArray = new long[]{0L};
            LongArrayList longArrayList2 = new LongArrayList(lArray, 0, 0, 6, null);
            lArray = new long[]{Long.MAX_VALUE};
            Node newRoot = new Node(longArrayList, longArrayList2, new LongArrayList(lArray, 0, 0, 6, null), newChildren);
            node2 = this.growTree(ctx, rootId, newRoot);
        } else {
            node2 = balanced;
        }
        return node2;
    }

    @NotNull
    public final Node shrinkTree(@Nullable EditingContext ctx, long rootId, @NotNull Node root) {
        Node node;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        if (root.getChildren().size() == 1 && root.getChildren().get(0) instanceof Node) {
            long delta = root.getStarts().get(0);
            Object object = root.getChildren().get(0);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type andel.intervals.impl.Impl.Node");
            Node child = (Node)object;
            IntRange intRange = LongListExtensionsKt.getIndices(child.getStarts());
            int i2 = intRange.getFirst();
            int n2 = intRange.getLast();
            if (i2 <= n2) {
                while (true) {
                    child.getStarts().set(i2, child.getStarts().get(i2) + delta);
                    child.getEnds().set(i2, child.getEnds().get(i2) + delta);
                    if (i2 == n2) break;
                    ++i2;
                }
            }
            EditingContext editingContext = ctx;
            Intrinsics.checkNotNull((Object)editingContext);
            editingContext.setParentsMap(this.adopt(ctx.getParentsMap(), rootId, child.getIds()));
            node = this.shrinkTree(ctx, rootId, child);
        } else {
            node = root;
        }
        return node;
    }

    /*
     * WARNING - void declaration
     */
    private final long normalize(Node node) {
        long l2;
        if (node.getStarts().getSize() == 0) {
            l2 = 0L;
        } else {
            void var2_2;
            int n2;
            IntRange intRange;
            int i2;
            long delta = node.getStarts().get(0);
            if (delta != 0L && (i2 = (intRange = LongListExtensionsKt.getIndices(node.getStarts())).getFirst()) <= (n2 = intRange.getLast())) {
                while (true) {
                    node.getStarts().set(i2, node.getStarts().get(i2) - delta);
                    node.getEnds().set(i2, node.getEnds().get(i2) - delta);
                    if (i2 == n2) break;
                    ++i2;
                }
            }
            l2 = var2_2;
        }
        return l2;
    }

    @NotNull
    public final <T> Batch<T> batch(@NotNull IntervalsImpl<T> tree) {
        Intrinsics.checkNotNullParameter(tree, (String)"tree");
        EditingContext ctx = new EditingContext(tree.getNextInnerId(), tree.getMaxChildren(), tree.getDropEmpty(), tree.getParentsMap().builder());
        return new Batch(Zipper.Companion.create(tree.getOpenRoot(), ctx, true), Zipper.Companion.create(tree.getClosedRoot(), ctx, false), ctx);
    }

    private final Zipper skipToOffset(Zipper z2, long offset) {
        Zipper zipper;
        Intrinsics.checkNotNull((Object)z2);
        int n2 = z2.getStarts().getSize();
        for (int i2 = (v1716977).getIdx(); i2 < n2; ++i2) {
            Zipper zipper2;
            if (z2.getStarts().get(i2) + z2.getDelta() < offset) continue;
            if (Zipper.Companion.isBranch(z2)) {
                Zipper down;
                Zipper zipper3 = down = Zipper.Companion.downLeft(z2);
                zipper2 = zipper3 == null ? z2 : this.skipToOffset(zipper3, offset);
            } else {
                z2.setIdx(i2 - 1);
                zipper2 = z2;
            }
            return zipper2;
        }
        if (z2.getHasRightCousin()) {
            zipper = this.skipToOffset(Zipper.Companion.up(z2), offset);
        } else {
            z2.setIdx(z2.getStarts().getSize() - 1);
            if (Zipper.Companion.isBranch(z2)) {
                Zipper down;
                Zipper zipper4 = down = Zipper.Companion.downLeft(z2);
                zipper = zipper4 == null ? z2 : this.skipToOffset(zipper4, offset);
            } else {
                zipper = z2;
            }
        }
        return zipper;
    }

    @Nullable
    public final Zipper nextIntersection(@NotNull Zipper zipper, long from, long to) {
        Zipper skip;
        Intrinsics.checkNotNullParameter((Object)zipper, (String)"zipper");
        int n2 = zipper.getStarts().getSize();
        for (int i2 = zipper.getIdx(); i2 < n2; ++i2) {
            Zipper down;
            if (!this.intersects(from, to, zipper.getStarts().get(i2) + zipper.getDelta(), zipper.getEnds().get(i2) + zipper.getDelta())) continue;
            zipper.setIdx(i2);
            return Zipper.Companion.isBranch(zipper) ? ((down = Zipper.Companion.downLeft(zipper)) != null ? this.nextIntersection(down, from, to) : null) : zipper;
        }
        Zipper zipper2 = Zipper.Companion.up(zipper);
        if (zipper2 == null) {
            return null;
        }
        Zipper up = zipper2;
        Zipper zipper3 = skip = Zipper.Companion.skipRight(up);
        return zipper3 == null ? null : this.nextIntersection(zipper3, from, to);
    }

    @Nullable
    public final Zipper prevIntersection(@NotNull Zipper zipper, long from, long to) {
        Zipper skip;
        Intrinsics.checkNotNullParameter((Object)zipper, (String)"zipper");
        for (int i2 = zipper.getIdx(); -1 < i2; --i2) {
            Zipper down;
            if (!this.intersects(from, to, zipper.getStarts().get(i2) + zipper.getDelta(), zipper.getEnds().get(i2) + zipper.getDelta())) continue;
            zipper.setIdx(i2);
            return Zipper.Companion.isBranch(zipper) ? ((down = Zipper.Companion.downRight(zipper)) != null ? this.prevIntersection(down, from, to) : null) : zipper;
        }
        Zipper zipper2 = Zipper.Companion.up(zipper);
        if (zipper2 == null) {
            return null;
        }
        Zipper up = zipper2;
        Zipper zipper3 = skip = Zipper.Companion.skipLeft(up);
        return zipper3 == null ? null : this.prevIntersection(zipper3, from, to);
    }

    @NotNull
    public final <T> IntervalsIterator<T> query(@NotNull IntervalsImpl<T> tree, long from, long to) {
        Intrinsics.checkNotNullParameter(tree, (String)"tree");
        long from2 = 0L;
        from2 = from;
        long to2 = 0L;
        to2 = to;
        if (!(from2 <= to2)) {
            boolean bl2 = false;
            String string2 = "Not " + from2 + " <= " + to2;
            throw new IllegalArgumentException(string2.toString());
        }
        from2 = Math.min(0x3FFFFFFFFFFFFFFEL, from2);
        to2 = Math.min(0x3FFFFFFFFFFFFFFEL, to2);
        return new MergingIterator(new ForwardIterator(Zipper.Companion.create(tree.getOpenRoot(), null, true), from2 * (long)2, to2 * (long)2), new ForwardIterator(Zipper.Companion.create(tree.getClosedRoot(), null, false), from2 * (long)2, to2 * (long)2), IntervalsIterator.FORWARD_COMPARATOR);
    }

    @NotNull
    public final <T> IntervalsIterator<T> queryReverse(@NotNull IntervalsImpl<T> tree, long from, long to) {
        Intrinsics.checkNotNullParameter(tree, (String)"tree");
        long from2 = from;
        long to2 = to;
        if (!(from2 <= to2)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        from2 = Math.min(0x3FFFFFFFFFFFFFFEL, from2);
        to2 = Math.min(0x3FFFFFFFFFFFFFFEL, to2);
        IntervalsIterator intervalsIterator = new BackwardIterator(Zipper.Companion.create(tree.getOpenRoot(), null, true), from2 * (long)2, to2 * (long)2);
        IntervalsIterator intervalsIterator2 = new BackwardIterator(Zipper.Companion.create(tree.getClosedRoot(), null, false), from2 * (long)2, to2 * (long)2);
        Comparator<IntervalsIterator<?>> comparator = IntervalsIterator.BACKWARD_COMPARATOR;
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"BACKWARD_COMPARATOR");
        return new MergingIterator(intervalsIterator, intervalsIterator2, comparator);
    }

    @NotNull
    public final Node expand(@NotNull Node node, long offset, long len) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Node result2 = Node.Companion.empty(node.getChildren().size());
        int n2 = ((Collection)node.getChildren()).size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object child;
            long id = node.getIds().get(i2);
            long start = node.getStarts().get(i2);
            long end = node.getEnds().get(i2);
            Intrinsics.checkNotNullExpressionValue((Object)node.getChildren().get(i2), (String)"get(...)");
            if (start < offset && offset < end) {
                Object c2 = child instanceof Node ? this.expand((Node)child, offset - start, len) : child;
                result2.add(id, start, end + len, c2);
                continue;
            }
            if (offset <= start) {
                result2.add(id, start + len, end + len, child);
                continue;
            }
            result2.add(id, start, end, child);
        }
        return result2;
    }

    @NotNull
    public final <T> IntervalsImpl<T> expand(@NotNull IntervalsImpl<T> tree, long start, long len) {
        Intrinsics.checkNotNullParameter(tree, (String)"tree");
        return len == 0L ? tree : new IntervalsImpl(tree.getMaxChildren(), this.expand(tree.getOpenRoot(), start * (long)2, len * (long)2), this.expand(tree.getClosedRoot(), start * (long)2, len * (long)2), tree.getParentsMap(), tree.getNextInnerId(), tree.getDropEmpty());
    }

    private final PersistentMap.Builder<Long, Long> extinct(PersistentMap.Builder<Long, Long> parentsMap, long id, Object child) {
        int n2;
        IntRange intRange;
        int i2;
        PersistentMap.Builder<Long, Long> parentsMap2 = parentsMap;
        parentsMap2.remove(id);
        if (child instanceof Node && (i2 = (intRange = LongListExtensionsKt.getIndices(((Node)child).getIds())).getFirst()) <= (n2 = intRange.getLast())) {
            while (true) {
                long l2 = ((Node)child).getIds().get(i2);
                Object object = ((Node)child).getChildren().get(i2);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                parentsMap2 = this.extinct(parentsMap2, l2, object);
                if (i2 == n2) break;
                ++i2;
            }
        }
        return parentsMap2;
    }

    @NotNull
    public final Node collapse(@NotNull EditingContext ctx, long d2, @NotNull Node node, long offset, long len) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Node result2 = Node.Companion.empty(node.getChildren().size());
        int n2 = ((Collection)node.getChildren()).size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object child;
            long start = node.getStarts().get(i2);
            long end = node.getEnds().get(i2);
            Intrinsics.checkNotNullExpressionValue((Object)node.getChildren().get(i2), (String)"get(...)");
            long id = node.getIds().get(i2);
            if (end <= offset) {
                result2.add(id, start, end, child);
                continue;
            }
            if (offset + len <= start) {
                result2.add(id, start - len, end - len, child);
                continue;
            }
            if (ctx.getDropEmpty() && offset <= start && end <= offset + len) {
                ctx.setParentsMap(this.extinct(ctx.getParentsMap(), id, child));
                continue;
            }
            if (child instanceof Node) {
                Object c2 = child;
                c2 = this.collapse(ctx, d2 + start, (Node)c2, offset - start, len);
                long delta = this.normalize((Node)c2);
                long newStart = start + delta;
                result2.add(id, newStart, newStart + this.max(((Node)c2).getEnds()), c2);
                continue;
            }
            long newStart = offset < start ? Math.max(offset - (d2 + start) % (long)2, start - len) : start;
            long newEnd = Math.max(offset + (d2 + end) % (long)2, end - len);
            if (ctx.getDropEmpty() && newEnd - newStart < 2L) {
                ctx.setParentsMap(this.extinct(ctx.getParentsMap(), id, child));
                continue;
            }
            result2.add(id, newStart, newEnd, child);
        }
        return this.balanceChildren(ctx, result2);
    }

    @NotNull
    public final <T> IntervalsImpl<T> collapse(@NotNull IntervalsImpl<T> tree, long start, long len) {
        Intrinsics.checkNotNullParameter(tree, (String)"tree");
        if (len == 0L) {
            return tree;
        }
        EditingContext ctx = new EditingContext(tree.getNextInnerId(), tree.getMaxChildren(), tree.getDropEmpty(), tree.getParentsMap().builder());
        Node openRoot = this.shrinkTree(ctx, -1L, this.growTree(ctx, -1L, this.collapse(ctx, 0L, tree.getOpenRoot(), start * (long)2, len * (long)2)));
        Node closedRoot = this.shrinkTree(ctx, -2L, this.growTree(ctx, -2L, this.collapse(ctx, 0L, tree.getClosedRoot(), start * (long)2, len * (long)2)));
        return new IntervalsImpl(tree.getMaxChildren(), openRoot, closedRoot, ctx.getParentsMap().build(), ctx.getNextId(), tree.getDropEmpty());
    }

    private final Node remove(EditingContext ctx, Node node, long nodeId, HashMap<Long, HashSet<Long>> subtree) {
        HashSet<Long> hashSet = subtree.get(nodeId);
        if (hashSet == null) {
            return node;
        }
        HashSet<Long> victims = hashSet;
        Node copy = node.copy();
        Iterator<Long> iterator2 = victims.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<Long> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object victim;
            Long l2 = iterator3.next();
            Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"next(...)");
            long vid = ((Number)l2).longValue();
            int vidx = LongListExtensionsKt.indexOf(copy.getIds(), vid);
            Intrinsics.checkNotNullExpressionValue((Object)copy.getChildren().get(vidx), (String)"get(...)");
            if (victim instanceof Node) {
                Node newNode = this.remove(ctx, (Node)victim, vid, subtree);
                long delta = this.normalize(newNode);
                copy.getChildren().set(vidx, newNode);
                long start = copy.getStarts().get(vidx) + delta;
                copy.getStarts().set(vidx, start);
                copy.getEnds().set(vidx, this.max(newNode.getEnds()) + start);
                continue;
            }
            copy.getChildren().remove(vidx);
            copy.getStarts().removeAt(vidx);
            copy.getEnds().removeAt(vidx);
            copy.getIds().removeAt(vidx);
            ctx.getParentsMap().remove(vid);
        }
        return this.balanceChildren(ctx, copy);
    }

    @NotNull
    public final <T> IntervalsImpl<T> remove(@NotNull IntervalsImpl<T> tree, @NotNull Iterable<Long> ids) {
        Intrinsics.checkNotNullParameter(tree, (String)"tree");
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        if (!CollectionsKt.any(ids)) {
            return tree;
        }
        HashMap<Long, HashSet<Long>> deletionSubtree = this.deletionSubtree(tree.getParentsMap(), ids);
        EditingContext ctx = new EditingContext(tree.getNextInnerId(), tree.getMaxChildren(), tree.getDropEmpty(), tree.getParentsMap().builder());
        Node openRoot = this.shrinkTree(ctx, -1L, this.remove(ctx, tree.getOpenRoot(), -1L, deletionSubtree));
        Node closedRoot = this.shrinkTree(ctx, -2L, this.remove(ctx, tree.getClosedRoot(), -2L, deletionSubtree));
        return new IntervalsImpl(tree.getMaxChildren(), openRoot, closedRoot, ctx.getParentsMap().build(), ctx.getNextId(), tree.getDropEmpty());
    }

    private final LongArrayList resolvePath(PersistentMap<Long, Long> parents, long id) {
        LongArrayList path = new LongArrayList(4);
        long p2 = id;
        do {
            Long l2 = (Long)parents.get(p2);
            if (l2 == null) {
                return null;
            }
            p2 = l2;
            path.add(p2);
        } while (p2 != -1L && p2 != -2L);
        return path;
    }

    private final Node chooseRoot(IntervalsImpl<?> tree, long id) {
        Node node;
        long l2 = id;
        if (l2 == -1L) {
            node = tree.getOpenRoot();
        } else if (l2 == -2L) {
            node = tree.getClosedRoot();
        } else {
            throw new IllegalArgumentException("given id:" + id);
        }
        return node;
    }

    @Nullable
    public final <T> Interval<Long, T> getById(@NotNull IntervalsImpl<T> tree, long id) {
        Interval<Long, Object> interval;
        Intrinsics.checkNotNullParameter(tree, (String)"tree");
        LongArrayList longArrayList = this.resolvePath(tree.getParentsMap(), id);
        if (longArrayList == null) {
            return null;
        }
        LongArrayList path = longArrayList;
        Node n2 = this.chooseRoot(tree, path.get(path.getSize() - 1));
        int delta = 0;
        for (int i2 = path.getSize() - 2; -1 < i2; --i2) {
            int idx = LongListExtensionsKt.indexOf(n2.getIds(), path.get(i2));
            if (idx == -1) {
                return null;
            }
            delta += (int)n2.getStarts().get(idx);
            Object object = n2.getChildren().get(idx);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type andel.intervals.impl.Impl.Node");
            n2 = (Node)object;
        }
        int idx = LongListExtensionsKt.indexOf(n2.getIds(), id);
        if (idx == -1) {
            interval = null;
        } else {
            long from = n2.getStarts().get(idx) + (long)delta;
            long to = n2.getEnds().get(idx) + (long)delta;
            Long l2 = n2.getIds().get(idx);
            long l3 = from / (long)2 + Math.max(0L, from % (long)2);
            long l4 = to / (long)2;
            boolean bl2 = from % (long)2 != 0L;
            boolean bl3 = to % (long)2 != 0L;
            Object object = n2.getChildren().get(idx);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type T of andel.intervals.impl.Impl.getById");
            interval = new Interval<Long, Object>(l2, l3, l4, bl2, bl3, object);
        }
        return interval;
    }

    private final HashMap<Long, HashSet<Long>> deletionSubtree(PersistentMap<Long, Long> parents, Iterable<Long> toBeDeleted) {
        HashMap<Long, HashSet<Long>> subtree = new HashMap<Long, HashSet<Long>>();
        Iterator<Long> iterator2 = toBeDeleted.iterator();
        while (iterator2.hasNext()) {
            long id = ((Number)iterator2.next()).longValue();
            if (!(id >= 0L)) {
                boolean bl2 = false;
                String string2 = "id:" + id;
                throw new IllegalArgumentException(string2.toString());
            }
            long cid = id;
            if (parents.get(cid) == null) continue;
            while (cid != -1L && cid != -2L) {
                Long l2 = (Long)parents.get(cid);
                if (l2 == null) {
                    throw new NoSuchElementException("id:" + cid);
                }
                long pid = l2;
                Map map2 = subtree;
                Object object = map2.get(pid);
                if (object == null) {
                    boolean bl3 = false;
                    object = new HashSet();
                }
                HashSet sibs = (HashSet)object;
                sibs.add(cid);
                map2 = subtree;
                map2.put(pid, sibs);
                cid = pid;
            }
        }
        return subtree;
    }

    private final long max(LongArrayList arr) {
        long m2 = Long.MIN_VALUE;
        LongArrayList longArrayList = arr;
        Intrinsics.checkNotNull((Object)longArrayList);
        IntRange intRange = LongListExtensionsKt.getIndices(longArrayList);
        int i2 = intRange.getFirst();
        int n2 = intRange.getLast();
        if (i2 <= n2) {
            while (true) {
                long l2;
                if ((l2 = arr.get(i2)) > m2) {
                    m2 = l2;
                }
                if (i2 == n2) break;
                ++i2;
            }
        }
        return m2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\b \u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\r\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0006\u00a8\u0006\u0013"}, d2={"Landel/intervals/impl/Impl$AbstractIterator;", "T", "Landel/intervals/IntervalsIterator;", "z", "Landel/intervals/impl/Impl$Zipper;", "<init>", "(Landel/intervals/impl/Impl$Zipper;)V", "getZ", "()Landel/intervals/impl/Impl$Zipper;", "setZ", "greedyLeft", "", "greedyRight", "from", "", "to", "id", "data", "()Ljava/lang/Object;", "fleet.andel"})
    public static abstract class AbstractIterator<T>
    implements IntervalsIterator<T> {
        @Nullable
        private Zipper z;

        public AbstractIterator(@Nullable Zipper z2) {
            this.z = z2;
        }

        @Nullable
        public final Zipper getZ() {
            return this.z;
        }

        public final void setZ(@Nullable Zipper zipper) {
            this.z = zipper;
        }

        @Override
        public boolean greedyLeft() {
            Zipper zipper = this.z;
            Intrinsics.checkNotNull((Object)zipper);
            long l2 = zipper.getDelta();
            Zipper zipper2 = this.z;
            Intrinsics.checkNotNull((Object)zipper2);
            LongArrayList longArrayList = zipper2.getStarts();
            Zipper zipper3 = this.z;
            Intrinsics.checkNotNull((Object)zipper3);
            return (l2 + longArrayList.get(zipper3.getIdx())) % (long)2 != 0L;
        }

        @Override
        public boolean greedyRight() {
            Zipper zipper = this.z;
            Intrinsics.checkNotNull((Object)zipper);
            long l2 = zipper.getDelta();
            Zipper zipper2 = this.z;
            Intrinsics.checkNotNull((Object)zipper2);
            LongArrayList longArrayList = zipper2.getEnds();
            Zipper zipper3 = this.z;
            Intrinsics.checkNotNull((Object)zipper3);
            return (l2 + longArrayList.get(zipper3.getIdx())) % (long)2 != 0L;
        }

        @Override
        public long from() {
            Zipper zipper = this.z;
            Intrinsics.checkNotNull((Object)zipper);
            return Zipper.Companion.from(zipper);
        }

        @Override
        public long to() {
            Zipper zipper = this.z;
            Intrinsics.checkNotNull((Object)zipper);
            return Zipper.Companion.to(zipper);
        }

        @Override
        public long id() {
            Zipper zipper = this.z;
            Intrinsics.checkNotNull((Object)zipper);
            return Zipper.Companion.id(zipper);
        }

        @Override
        public T data() {
            Zipper zipper = this.z;
            Intrinsics.checkNotNull((Object)zipper);
            return Zipper.Companion.data(zipper);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B!\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\n\u001a\u00020\u000bH\u0096\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Landel/intervals/impl/Impl$BackwardIterator;", "T", "Landel/intervals/impl/Impl$AbstractIterator;", "z", "Landel/intervals/impl/Impl$Zipper;", "queryFrom", "", "queryTo", "<init>", "(Landel/intervals/impl/Impl$Zipper;JJ)V", "next", "", "fleet.andel"})
    public static final class BackwardIterator<T>
    extends AbstractIterator<T> {
        private final long queryFrom;
        private final long queryTo;

        public BackwardIterator(@Nullable Zipper z2, long queryFrom, long queryTo) {
            super(z2);
            this.queryFrom = queryFrom;
            this.queryTo = queryTo;
        }

        @Override
        public boolean next() {
            Zipper next2;
            Zipper zipper;
            Zipper zipper2 = this.getZ();
            Intrinsics.checkNotNull((Object)zipper2);
            if (Zipper.Companion.isRoot(zipper2)) {
                zipper = this.getZ();
            } else {
                Zipper zipper3 = this.getZ();
                Intrinsics.checkNotNull((Object)zipper3);
                zipper = Zipper.Companion.skipLeft(zipper3);
            }
            Zipper zipper4 = next2 = zipper;
            this.setZ(zipper4 == null ? null : INSTANCE.prevIntersection(zipper4, this.queryFrom, this.queryTo));
            return this.getZ() != null;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B!\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ;\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0015J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Landel/intervals/impl/Impl$Batch;", "T", "", "openZipper", "Landel/intervals/impl/Impl$Zipper;", "closedZipper", "editingContext", "Landel/intervals/impl/Impl$EditingContext;", "<init>", "(Landel/intervals/impl/Impl$Zipper;Landel/intervals/impl/Impl$Zipper;Landel/intervals/impl/Impl$EditingContext;)V", "lastSeenFrom", "", "add", "", "id", "from", "to", "closedLeft", "", "closedRight", "data", "(JJJZZLjava/lang/Object;)V", "commit", "Landel/intervals/impl/IntervalsImpl;", "fleet.andel"})
    @SourceDebugExtension(value={"SMAP\nImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Impl.kt\nandel/intervals/impl/Impl$Batch\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1016:1\n1#2:1017\n*E\n"})
    public static final class Batch<T> {
        @NotNull
        private Zipper openZipper;
        @NotNull
        private Zipper closedZipper;
        @NotNull
        private EditingContext editingContext;
        private long lastSeenFrom;

        public Batch(@NotNull Zipper openZipper, @NotNull Zipper closedZipper, @NotNull EditingContext editingContext) {
            Intrinsics.checkNotNullParameter((Object)openZipper, (String)"openZipper");
            Intrinsics.checkNotNullParameter((Object)closedZipper, (String)"closedZipper");
            Intrinsics.checkNotNullParameter((Object)editingContext, (String)"editingContext");
            this.openZipper = openZipper;
            this.closedZipper = closedZipper;
            this.editingContext = editingContext;
            this.lastSeenFrom = Long.MIN_VALUE;
        }

        public final void add(long id, long from, long to, boolean closedLeft, boolean closedRight, @NotNull T data) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            if (!(from >= this.lastSeenFrom)) {
                boolean bl2 = false;
                String string2 = "batch is not sorted";
                throw new IllegalArgumentException(string2.toString());
            }
            this.lastSeenFrom = from;
            if (from * (long)2 < from || to * (long)2 < to) {
                throw new ArithmeticException("from: " + from + ", to: " + to);
            }
            if (closedLeft) {
                this.closedZipper = Zipper.Companion.insert(this.closedZipper, id, from, to, true, closedRight, data);
            } else {
                this.openZipper = Zipper.Companion.insert(this.openZipper, id, from, to, false, closedRight, data);
            }
        }

        @NotNull
        public final IntervalsImpl<T> commit() {
            return new IntervalsImpl(this.editingContext.getMaxChildren(), Zipper.Companion.root(this.openZipper), Zipper.Companion.root(this.closedZipper), this.editingContext.getParentsMap().build(), this.editingContext.getNextId(), this.editingContext.getDropEmpty());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R&\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Landel/intervals/impl/Impl$EditingContext;", "", "nextId", "", "maxChildren", "", "dropEmpty", "", "parentsMap", "Lkotlinx/collections/immutable/PersistentMap$Builder;", "<init>", "(JIZLkotlinx/collections/immutable/PersistentMap$Builder;)V", "getNextId", "()J", "setNextId", "(J)V", "getMaxChildren", "()I", "getDropEmpty", "()Z", "getParentsMap", "()Lkotlinx/collections/immutable/PersistentMap$Builder;", "setParentsMap", "(Lkotlinx/collections/immutable/PersistentMap$Builder;)V", "fleet.andel"})
    public static final class EditingContext {
        private long nextId;
        private final int maxChildren;
        private final boolean dropEmpty;
        @NotNull
        private PersistentMap.Builder<Long, Long> parentsMap;

        public EditingContext(long nextId, int maxChildren, boolean dropEmpty, @NotNull PersistentMap.Builder<Long, Long> parentsMap) {
            Intrinsics.checkNotNullParameter(parentsMap, (String)"parentsMap");
            this.nextId = nextId;
            this.maxChildren = maxChildren;
            this.dropEmpty = dropEmpty;
            this.parentsMap = parentsMap;
        }

        public final long getNextId() {
            return this.nextId;
        }

        public final void setNextId(long l2) {
            this.nextId = l2;
        }

        public final int getMaxChildren() {
            return this.maxChildren;
        }

        public final boolean getDropEmpty() {
            return this.dropEmpty;
        }

        @NotNull
        public final PersistentMap.Builder<Long, Long> getParentsMap() {
            return this.parentsMap;
        }

        public final void setParentsMap(@NotNull PersistentMap.Builder<Long, Long> builder) {
            Intrinsics.checkNotNullParameter(builder, (String)"<set-?>");
            this.parentsMap = builder;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B!\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\n\u001a\u00020\u000bH\u0096\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Landel/intervals/impl/Impl$ForwardIterator;", "T", "Landel/intervals/impl/Impl$AbstractIterator;", "z", "Landel/intervals/impl/Impl$Zipper;", "queryFrom", "", "queryTo", "<init>", "(Landel/intervals/impl/Impl$Zipper;JJ)V", "next", "", "fleet.andel"})
    public static final class ForwardIterator<T>
    extends AbstractIterator<T> {
        private final long queryFrom;
        private final long queryTo;

        public ForwardIterator(@Nullable Zipper z2, long queryFrom, long queryTo) {
            super(z2);
            this.queryFrom = queryFrom;
            this.queryTo = queryTo;
        }

        @Override
        public boolean next() {
            Zipper next2;
            Zipper zipper;
            Zipper zipper2 = this.getZ();
            Intrinsics.checkNotNull((Object)zipper2);
            if (Zipper.Companion.isRoot(zipper2)) {
                zipper = this.getZ();
            } else {
                Zipper zipper3 = this.getZ();
                Intrinsics.checkNotNull((Object)zipper3);
                zipper = Zipper.Companion.skipRight(zipper3);
            }
            Zipper zipper4 = next2 = zipper;
            this.setZ(zipper4 == null ? null : INSTANCE.nextIntersection(zipper4, this.queryFrom, this.queryTo));
            return this.getZ() != null;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\u00010\u0007j\b\u0012\u0004\u0012\u00020\u0001`\b\u00a2\u0006\u0004\b\t\u0010\nJ&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0001J\u0006\u0010\u0018\u001a\u00020\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR!\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\u00010\u0007j\b\u0012\u0004\u0012\u00020\u0001`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Landel/intervals/impl/Impl$Node;", "", "ids", "Lfleet/fastutil/longs/LongArrayList;", "starts", "ends", "children", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "<init>", "(Lfleet/fastutil/longs/LongArrayList;Lfleet/fastutil/longs/LongArrayList;Lfleet/fastutil/longs/LongArrayList;Ljava/util/ArrayList;)V", "getIds", "()Lfleet/fastutil/longs/LongArrayList;", "getStarts", "getEnds", "getChildren", "()Ljava/util/ArrayList;", "add", "", "id", "", "start", "end", "child", "copy", "Companion", "fleet.andel"})
    public static final class Node {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final LongArrayList ids;
        @NotNull
        private final LongArrayList starts;
        @NotNull
        private final LongArrayList ends;
        @NotNull
        private final ArrayList<Object> children;

        public Node(@NotNull LongArrayList ids, @NotNull LongArrayList starts, @NotNull LongArrayList ends, @NotNull ArrayList<Object> children) {
            Intrinsics.checkNotNullParameter((Object)ids, (String)"ids");
            Intrinsics.checkNotNullParameter((Object)starts, (String)"starts");
            Intrinsics.checkNotNullParameter((Object)ends, (String)"ends");
            Intrinsics.checkNotNullParameter(children, (String)"children");
            this.ids = ids;
            this.starts = starts;
            this.ends = ends;
            this.children = children;
        }

        @NotNull
        public final LongArrayList getIds() {
            return this.ids;
        }

        @NotNull
        public final LongArrayList getStarts() {
            return this.starts;
        }

        @NotNull
        public final LongArrayList getEnds() {
            return this.ends;
        }

        @NotNull
        public final ArrayList<Object> getChildren() {
            return this.children;
        }

        public final void add(long id, long start, long end, @NotNull Object child) {
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            this.ids.add(id);
            this.starts.add(start);
            this.ends.add(end);
            this.children.add(child);
        }

        @NotNull
        public final Node copy() {
            LongArrayList longArrayList = this.ids.clone();
            LongArrayList longArrayList2 = this.starts.clone();
            LongArrayList longArrayList3 = this.ends.clone();
            List list = CollectionsKt.toMutableList((Collection)this.children);
            Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type java.util.ArrayList<kotlin.Any>");
            return new Node(longArrayList, longArrayList2, longArrayList3, (ArrayList)list);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Landel/intervals/impl/Impl$Node$Companion;", "", "<init>", "()V", "empty", "Landel/intervals/impl/Impl$Node;", "capacity", "", "fleet.andel"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Node empty(int capacity) {
                return new Node(new LongArrayList(capacity), new LongArrayList(capacity), new LongArrayList(capacity), new ArrayList<Object>(capacity));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\"\u0018\u0000 62\u00020\u0001:\u00016B\u0083\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u0012\u0016\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00010\u0010j\b\u0012\u0004\u0012\u00020\u0001`\u0011\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001bR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001bR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0019R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0019R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010\r\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010%\"\u0004\b)\u0010'R\u001a\u0010\u000e\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010%\"\u0004\b+\u0010'R*\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00010\u0010j\b\u0012\u0004\u0012\u00020\u0001`\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105\u00a8\u00067"}, d2={"Landel/intervals/impl/Impl$Zipper;", "", "rootId", "", "changed", "", "hasRightCousin", "hasLeftCousin", "delta", "parent", "rightCousinStart", "starts", "Lfleet/fastutil/longs/LongArrayList;", "ends", "ids", "children", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "editingContext", "Landel/intervals/impl/Impl$EditingContext;", "idx", "", "<init>", "(JZZZJLandel/intervals/impl/Impl$Zipper;JLfleet/fastutil/longs/LongArrayList;Lfleet/fastutil/longs/LongArrayList;Lfleet/fastutil/longs/LongArrayList;Ljava/util/ArrayList;Landel/intervals/impl/Impl$EditingContext;I)V", "getRootId", "()J", "getChanged", "()Z", "setChanged", "(Z)V", "getHasRightCousin", "getHasLeftCousin", "getDelta", "getParent", "()Landel/intervals/impl/Impl$Zipper;", "getRightCousinStart", "getStarts", "()Lfleet/fastutil/longs/LongArrayList;", "setStarts", "(Lfleet/fastutil/longs/LongArrayList;)V", "getEnds", "setEnds", "getIds", "setIds", "getChildren", "()Ljava/util/ArrayList;", "setChildren", "(Ljava/util/ArrayList;)V", "getEditingContext", "()Landel/intervals/impl/Impl$EditingContext;", "getIdx", "()I", "setIdx", "(I)V", "Companion", "fleet.andel"})
    public static final class Zipper {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final long rootId;
        private boolean changed;
        private final boolean hasRightCousin;
        private final boolean hasLeftCousin;
        private final long delta;
        @Nullable
        private final Zipper parent;
        private final long rightCousinStart;
        @NotNull
        private LongArrayList starts;
        @NotNull
        private LongArrayList ends;
        @NotNull
        private LongArrayList ids;
        @NotNull
        private ArrayList<Object> children;
        @Nullable
        private final EditingContext editingContext;
        private int idx;
        @NotNull
        private static final LongArrayList ROOT_ENDS;
        @NotNull
        private static final LongArrayList ROOT_STARTS;
        @NotNull
        private static final LongArrayList OPEN_ROOT_IDS;
        @NotNull
        private static final LongArrayList CLOSED_ROOT_IDS;

        public Zipper(long rootId, boolean changed, boolean hasRightCousin, boolean hasLeftCousin, long delta, @Nullable Zipper parent, long rightCousinStart, @NotNull LongArrayList starts, @NotNull LongArrayList ends, @NotNull LongArrayList ids, @NotNull ArrayList<Object> children, @Nullable EditingContext editingContext, int idx) {
            Intrinsics.checkNotNullParameter((Object)starts, (String)"starts");
            Intrinsics.checkNotNullParameter((Object)ends, (String)"ends");
            Intrinsics.checkNotNullParameter((Object)ids, (String)"ids");
            Intrinsics.checkNotNullParameter(children, (String)"children");
            this.rootId = rootId;
            this.changed = changed;
            this.hasRightCousin = hasRightCousin;
            this.hasLeftCousin = hasLeftCousin;
            this.delta = delta;
            this.parent = parent;
            this.rightCousinStart = rightCousinStart;
            this.starts = starts;
            this.ends = ends;
            this.ids = ids;
            this.children = children;
            this.editingContext = editingContext;
            this.idx = idx;
        }

        public final long getRootId() {
            return this.rootId;
        }

        public final boolean getChanged() {
            return this.changed;
        }

        public final void setChanged(boolean bl2) {
            this.changed = bl2;
        }

        public final boolean getHasRightCousin() {
            return this.hasRightCousin;
        }

        public final boolean getHasLeftCousin() {
            return this.hasLeftCousin;
        }

        public final long getDelta() {
            return this.delta;
        }

        @Nullable
        public final Zipper getParent() {
            return this.parent;
        }

        public final long getRightCousinStart() {
            return this.rightCousinStart;
        }

        @NotNull
        public final LongArrayList getStarts() {
            return this.starts;
        }

        public final void setStarts(@NotNull LongArrayList longArrayList) {
            Intrinsics.checkNotNullParameter((Object)longArrayList, (String)"<set-?>");
            this.starts = longArrayList;
        }

        @NotNull
        public final LongArrayList getEnds() {
            return this.ends;
        }

        public final void setEnds(@NotNull LongArrayList longArrayList) {
            Intrinsics.checkNotNullParameter((Object)longArrayList, (String)"<set-?>");
            this.ends = longArrayList;
        }

        @NotNull
        public final LongArrayList getIds() {
            return this.ids;
        }

        public final void setIds(@NotNull LongArrayList longArrayList) {
            Intrinsics.checkNotNullParameter((Object)longArrayList, (String)"<set-?>");
            this.ids = longArrayList;
        }

        @NotNull
        public final ArrayList<Object> getChildren() {
            return this.children;
        }

        public final void setChildren(@NotNull ArrayList<Object> arrayList) {
            Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
            this.children = arrayList;
        }

        @Nullable
        public final EditingContext getEditingContext() {
            return this.editingContext;
        }

        public final int getIdx() {
            return this.idx;
        }

        public final void setIdx(int n2) {
            this.idx = n2;
        }

        static {
            long[] lArray = new long[]{Long.MAX_VALUE};
            ROOT_ENDS = new LongArrayList(lArray, 0, 0, 6, null);
            lArray = new long[]{0L};
            ROOT_STARTS = new LongArrayList(lArray, 0, 0, 6, null);
            lArray = new long[]{-1L};
            OPEN_ROOT_IDS = new LongArrayList(lArray, 0, 0, 6, null);
            lArray = new long[]{-2L};
            CLOSED_ROOT_IDS = new LongArrayList(lArray, 0, 0, 6, null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0017\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nJ\u000e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nJ\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nJ\u0019\u0010\u0016\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\u0006\u0010\u0013\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\nJ\u000e\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\nJ\u000e\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\nJ\u0018\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\nJ\u0010\u0010 \u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\nJ\u001e\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u0012J\u0010\u0010%\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\nJ\u0010\u0010&\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\nJ\u0010\u0010'\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\nJ\u0010\u0010(\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\nJ\u0010\u0010)\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\nJ\u000e\u0010*\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nJ\u000e\u0010+\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nJ\u0010\u0010,\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\nJ\u001a\u0010-\u001a\u00020\u001e2\b\u0010.\u001a\u0004\u0018\u00010\u00052\u0006\u0010/\u001a\u00020\u0012H\u0002JE\u00100\u001a\u00020\n\"\b\b\u0000\u0010\u0017*\u00020\u00012\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u00101\u001a\u00020\u00102\u0006\u00102\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u0002H\u0017\u00a2\u0006\u0002\u00103JM\u00100\u001a\u00020\n\"\b\b\u0000\u0010\u0017*\u00020\u00012\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u00101\u001a\u00020\u00102\u0006\u00102\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u0002H\u0017\u00a2\u0006\u0002\u00104R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Landel/intervals/impl/Impl$Zipper$Companion;", "", "<init>", "()V", "ROOT_ENDS", "Lfleet/fastutil/longs/LongArrayList;", "ROOT_STARTS", "OPEN_ROOT_IDS", "CLOSED_ROOT_IDS", "create", "Landel/intervals/impl/Impl$Zipper;", "root", "Landel/intervals/impl/Impl$Node;", "editingContext", "Landel/intervals/impl/Impl$EditingContext;", "rootIsOpen", "", "id", "", "z", "from", "to", "data", "T", "(Landel/intervals/impl/Impl$Zipper;)Ljava/lang/Object;", "isRoot", "isBranch", "node", "down", "idx", "", "downLeft", "downRight", "replace", "p", "n", "delta", "left", "right", "skipRight", "skipLeft", "hasNext", "next", "remove", "up", "findInsertionPoint", "ss", "o", "insert", "closedLeft", "closedRight", "(Landel/intervals/impl/Impl$Zipper;JJZZLjava/lang/Object;)Landel/intervals/impl/Impl$Zipper;", "(Landel/intervals/impl/Impl$Zipper;JJJZZLjava/lang/Object;)Landel/intervals/impl/Impl$Zipper;", "fleet.andel"})
        @SourceDebugExtension(value={"SMAP\nImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Impl.kt\nandel/intervals/impl/Impl$Zipper$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1016:1\n1#2:1017\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Zipper create(@NotNull Node root, @Nullable EditingContext editingContext, boolean rootIsOpen) {
                Intrinsics.checkNotNullParameter((Object)root, (String)"root");
                long l2 = rootIsOpen ? -1L : -2L;
                LongArrayList longArrayList = ROOT_STARTS;
                LongArrayList longArrayList2 = ROOT_ENDS;
                LongArrayList longArrayList3 = rootIsOpen ? OPEN_ROOT_IDS : CLOSED_ROOT_IDS;
                Object[] objectArray = new Object[]{root};
                ArrayList arrayList = CollectionsKt.arrayListOf((Object[])objectArray);
                return new Zipper(l2, false, false, false, 0L, null, Long.MAX_VALUE, longArrayList, longArrayList2, longArrayList3, arrayList, editingContext, 0);
            }

            public final long id(@NotNull Zipper z2) {
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                return z2.getIds().get(z2.getIdx());
            }

            public final long from(@NotNull Zipper z2) {
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                long from = z2.getDelta() + z2.getStarts().get(z2.getIdx());
                return from / (long)2 + Math.max(0L, from % (long)2);
            }

            public final long to(@NotNull Zipper z2) {
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                return (z2.getDelta() + z2.getEnds().get(z2.getIdx())) / (long)2;
            }

            public final <T> T data(@NotNull Zipper z2) {
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                return (T)z2.getChildren().get(z2.getIdx());
            }

            public final boolean isRoot(@NotNull Zipper z2) {
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                return z2.getParent() == null;
            }

            public final boolean isBranch(@NotNull Zipper z2) {
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                return z2.getChildren().size() > 0 && z2.getChildren().get(0) instanceof Node;
            }

            @NotNull
            public final Node node(@NotNull Zipper z2) {
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                Object object = z2.getChildren().get(z2.getIdx());
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type andel.intervals.impl.Impl.Node");
                return (Node)object;
            }

            private final Zipper down(Zipper z2, int idx) {
                long rightCousinStart;
                Object object = z2.getChildren().get(z2.getIdx());
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type andel.intervals.impl.Impl.Node");
                Node child = (Node)object;
                if (!(0 <= idx && idx < child.getChildren().size())) {
                    String string2 = "Failed requirement.";
                    throw new IllegalArgumentException(string2.toString());
                }
                boolean hasRightCousin = z2.getHasRightCousin() || z2.getIdx() < z2.getChildren().size() - 1;
                long l2 = hasRightCousin ? (z2.getIdx() + 1 < z2.getStarts().getSize() ? z2.getStarts().get(z2.getIdx() + 1) : z2.getRightCousinStart()) - z2.getStarts().get(z2.getIdx()) : (rightCousinStart = Long.MAX_VALUE);
                if (!(rightCousinStart >= 0L)) {
                    boolean bl2 = false;
                    String string3 = "rightCousinStart:" + rightCousinStart;
                    throw new IllegalArgumentException(string3.toString());
                }
                LongArrayList longArrayList = child.getStarts();
                LongArrayList longArrayList2 = child.getEnds();
                LongArrayList longArrayList3 = child.getIds();
                long l3 = z2.getDelta() + z2.getStarts().get(z2.getIdx());
                boolean bl3 = z2.getHasLeftCousin() || z2.getIdx() > 0;
                ArrayList<Object> arrayList = child.getChildren();
                EditingContext editingContext = z2.getEditingContext();
                return new Zipper(0L, false, hasRightCousin, bl3, l3, z2, rightCousinStart, longArrayList, longArrayList2, longArrayList3, arrayList, editingContext, idx);
            }

            @Nullable
            public final Zipper downLeft(@NotNull Zipper z2) {
                Node child;
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                if (this.isBranch(z2)) {
                    Object object = z2.getChildren().get(z2.getIdx());
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type andel.intervals.impl.Impl.Node");
                    child = (Node)object;
                } else {
                    throw new IllegalArgumentException();
                }
                return child.getChildren().size() == 0 ? null : this.down(z2, 0);
            }

            @Nullable
            public final Zipper downRight(@NotNull Zipper z2) {
                Node child;
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                if (this.isBranch(z2)) {
                    Object object = z2.getChildren().get(z2.getIdx());
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type andel.intervals.impl.Impl.Node");
                    child = (Node)object;
                } else {
                    throw new IllegalArgumentException();
                }
                return child.getChildren().size() == 0 ? null : this.down(z2, child.getChildren().size() - 1);
            }

            @NotNull
            public final Zipper replace(@NotNull Zipper p2, @NotNull Node n2, long delta) {
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p");
                Intrinsics.checkNotNullParameter((Object)n2, (String)"n");
                if (!p2.getChanged()) {
                    p2.setIds(p2.getIds().clone());
                    p2.setStarts(p2.getStarts().clone());
                    p2.setEnds(p2.getEnds().clone());
                    p2.setChildren(new ArrayList<Object>((Collection)p2.getChildren()));
                }
                p2.getChildren().set(p2.getIdx(), n2);
                long newStart = p2.getStarts().get(p2.getIdx()) + delta;
                p2.getStarts().set(p2.getIdx(), newStart);
                p2.getEnds().set(p2.getIdx(), newStart + INSTANCE.max(n2.getEnds()));
                p2.setChanged(true);
                return p2;
            }

            @Nullable
            public final Zipper left(@NotNull Zipper z2) {
                Zipper zipper;
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                if (z2.getIdx() - 1 >= 0) {
                    z2.setIdx(z2.getIdx() - 1);
                    zipper = z2;
                } else {
                    zipper = null;
                }
                return zipper;
            }

            @Nullable
            public final Zipper right(@NotNull Zipper z2) {
                Zipper zipper;
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                if (z2.getIdx() + 1 < z2.getChildren().size()) {
                    z2.setIdx(z2.getIdx() + 1);
                    zipper = z2;
                } else {
                    zipper = null;
                }
                return zipper;
            }

            @Nullable
            public final Zipper skipRight(@NotNull Zipper z2) {
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                Zipper right = this.right(z2);
                Zipper zipper = right;
                if (zipper == null) {
                    if (z2.getHasRightCousin()) {
                        Zipper zipper2 = this.up(z2);
                        Intrinsics.checkNotNull((Object)zipper2);
                        zipper = this.skipRight(zipper2);
                    } else {
                        zipper = null;
                    }
                }
                return zipper;
            }

            @Nullable
            public final Zipper skipLeft(@NotNull Zipper z2) {
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                Zipper left = this.left(z2);
                Zipper zipper = left;
                if (zipper == null) {
                    if (z2.getHasLeftCousin()) {
                        Zipper zipper2 = this.up(z2);
                        Intrinsics.checkNotNull((Object)zipper2);
                        zipper = this.skipLeft(zipper2);
                    } else {
                        zipper = null;
                    }
                }
                return zipper;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean hasNext(@Nullable Zipper z2) {
                Zipper zipper = z2;
                Intrinsics.checkNotNull((Object)zipper);
                if (zipper.getIdx() + 1 < z2.getChildren().size()) return true;
                if (z2.getHasRightCousin()) return true;
                if (!this.isBranch(z2)) return false;
                Object object = z2.getChildren().get(z2.getIdx());
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type andel.intervals.impl.Impl.Node");
                if (((Node)object).getChildren().size() <= 0) return false;
                return true;
            }

            @NotNull
            public final Zipper next(@NotNull Zipper z2) {
                Zipper zipper;
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                Zipper z3 = z2;
                if (!this.hasNext(z3)) {
                    String string2 = "Failed requirement.";
                    throw new IllegalArgumentException(string2.toString());
                }
                do {
                    if (this.isBranch(z3)) {
                        Zipper zipper2 = this.downLeft(z3);
                        zipper = zipper2;
                        Intrinsics.checkNotNull((Object)zipper2);
                        continue;
                    }
                    Zipper zipper3 = this.skipRight(z3);
                    zipper = zipper3;
                    Intrinsics.checkNotNull((Object)zipper3);
                } while (this.isBranch(z3 = zipper));
                return z3;
            }

            @NotNull
            public final Zipper remove(@NotNull Zipper z2) {
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                if (!z2.getChanged()) {
                    z2.setIds(z2.getIds().clone());
                    z2.setStarts(z2.getStarts().clone());
                    z2.setEnds(z2.getEnds().clone());
                    z2.setChildren(new ArrayList<Object>((Collection)z2.getChildren()));
                }
                z2.setChanged(true);
                z2.getIds().removeAt(z2.getIdx());
                z2.getStarts().removeAt(z2.getIdx());
                z2.getEnds().removeAt(z2.getIdx());
                z2.getChildren().remove(z2.getIdx());
                int n2 = z2.getIdx();
                z2.setIdx(n2 + -1);
                return z2;
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Zipper up(@NotNull Zipper z2) {
                Zipper zipper;
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                if (z2.getChanged()) {
                    void var2_2;
                    Zipper p2 = z2.getParent();
                    Node n2 = new Node(z2.getIds(), z2.getStarts(), z2.getEnds(), z2.getChildren());
                    Zipper zipper2 = p2;
                    Intrinsics.checkNotNull((Object)zipper2);
                    long delta = zipper2.getParent() == null ? 0L : INSTANCE.normalize(n2);
                    n2 = INSTANCE.balanceChildren(z2.getEditingContext(), n2);
                    this.replace(p2, n2, delta);
                    zipper = var2_2;
                } else {
                    zipper = z2.getParent();
                }
                return zipper;
            }

            @NotNull
            public final Node root(@NotNull Zipper z2) {
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                Zipper z3 = z2;
                while (!this.isRoot(z3)) {
                    Intrinsics.checkNotNull((Object)this.up(z3));
                }
                return INSTANCE.shrinkTree(z3.getEditingContext(), z3.getRootId(), INSTANCE.growTree(z3.getEditingContext(), z3.getRootId(), this.node(z3)));
            }

            private final int findInsertionPoint(LongArrayList ss, long o2) {
                int i2 = 0;
                while (true) {
                    LongArrayList longArrayList = ss;
                    Intrinsics.checkNotNull((Object)longArrayList);
                    if (i2 >= longArrayList.getSize() || ss.get(i2) > o2) break;
                    ++i2;
                }
                return i2;
            }

            @NotNull
            public final <T> Zipper insert(@NotNull Zipper z2, long from, long to, boolean closedLeft, boolean closedRight, @NotNull T data) {
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                Intrinsics.checkNotNullParameter(data, (String)"data");
                EditingContext editingContext = z2.getEditingContext();
                Intrinsics.checkNotNull((Object)editingContext);
                EditingContext editingContext2 = editingContext;
                editingContext2.setNextId(editingContext2.getNextId() + -1L);
                return this.insert(z2, editingContext2.getNextId(), from, to, closedLeft, closedRight, data);
            }

            @NotNull
            public final <T> Zipper insert(@NotNull Zipper z2, long id, long from, long to, boolean closedLeft, boolean closedRight, @NotNull T data) {
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                Intrinsics.checkNotNullParameter(data, (String)"data");
                Zipper z3 = z2;
                long from2 = from;
                long to2 = to;
                from2 = from2 * (long)2 - (long)(closedLeft ? 1 : 0);
                to2 = to2 * (long)2 + (long)(closedRight ? 1 : 0);
                int retries = 0;
                while (true) {
                    if (!(++retries < 1000)) {
                        String string2 = "Failed requirement.";
                        throw new IllegalArgumentException(string2.toString());
                    }
                    Zipper zipper = z3;
                    Intrinsics.checkNotNull((Object)zipper);
                    if (from2 - zipper.getDelta() <= z3.getRightCousinStart()) {
                        int insertIdx = this.findInsertionPoint(z3.getStarts(), from2 - z3.getDelta());
                        if (this.isBranch(z3)) {
                            z3.setIdx(Math.max(0, insertIdx - 1));
                            Zipper down = this.downLeft(z3);
                            if (down == null) {
                                if (!this.isRoot(z3)) {
                                    String string3 = "Failed requirement.";
                                    throw new IllegalArgumentException(string3.toString());
                                }
                                EditingContext editingContext = z3.getEditingContext();
                                Intrinsics.checkNotNull((Object)editingContext);
                                Node newRoot = Node.Companion.empty(editingContext.getMaxChildren());
                                newRoot.add(id, from2, to2, data);
                                EditingContext editingContext2 = z3.getEditingContext();
                                Intrinsics.checkNotNull((Object)editingContext2);
                                editingContext2.getParentsMap().put(id, z3.getRootId());
                                return this.replace(z3, newRoot, 0L);
                            }
                            z3 = down;
                            continue;
                        }
                        if (!z3.getChanged()) {
                            z3.setIds(z3.getIds().clone());
                            z3.setStarts(z3.getStarts().clone());
                            z3.setEnds(z3.getEnds().clone());
                            z3.setChildren(new ArrayList<Object>((Collection)z3.getChildren()));
                        }
                        EditingContext editingContext = z3.getEditingContext();
                        Intrinsics.checkNotNull((Object)editingContext);
                        if (!(editingContext.getParentsMap().get(id) == null)) {
                            boolean bl2 = false;
                            String string4 = "id is not unique:" + id;
                            throw new IllegalArgumentException(string4.toString());
                        }
                        z3.getStarts().add(insertIdx, from2 - z3.getDelta());
                        z3.getEnds().add(insertIdx, to2 - z3.getDelta());
                        z3.getIds().add(insertIdx, id);
                        z3.getChildren().add(insertIdx, data);
                        Zipper zipper2 = z3.getParent();
                        Intrinsics.checkNotNull((Object)zipper2);
                        LongArrayList longArrayList = zipper2.getIds();
                        Zipper zipper3 = z3.getParent();
                        Intrinsics.checkNotNull((Object)zipper3);
                        long currentId = longArrayList.get(zipper3.getIdx());
                        EditingContext editingContext3 = z3.getEditingContext();
                        Intrinsics.checkNotNull((Object)editingContext3);
                        editingContext3.getParentsMap().put(id, currentId);
                        z3.setChanged(true);
                        z3.setIdx(insertIdx <= z3.getIdx() ? z3.getIdx() + 1 : z3.getIdx());
                        return z3;
                    }
                    z3 = this.up(z3);
                }
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

