/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

class ByteOrderMarkReader {
    private static final int[][] BOMs = new int[][]{{239, 187, 191}, {254, 255}, {255, 254}, {0, 0, 254, 255}, {255, 254, 0, 0}};
    private static final String[] Charsets = new String[]{"UTF-8", "UTF-16BE", "UTF-16LE", "UTF-32BE", "UTF-32LE"};
    private final boolean[] charsetPossible = new boolean[]{true, true, true, true, true};
    private int offset;
    private String charset;

    ByteOrderMarkReader() {
    }

    public String getDetectedCharset() {
        return this.charset;
    }

    public boolean readByte(int b2) {
        boolean matchingCharset = false;
        for (int c2 = 0; c2 < Charsets.length; ++c2) {
            boolean match2;
            if (!this.charsetPossible[c2]) continue;
            int[] bom = BOMs[c2];
            boolean bl2 = match2 = this.offset < bom.length && bom[this.offset] == b2;
            if (match2) {
                matchingCharset = true;
                if (this.offset + 1 != bom.length) continue;
                this.charset = Charsets[c2];
                continue;
            }
            this.charsetPossible[c2] = false;
        }
        ++this.offset;
        return matchingCharset;
    }

    public static String detect(byte[] bytes) {
        if (bytes.length > 2) {
            if (bytes[0] == -2 && bytes[1] == -1) {
                return "UTF-16";
            }
            if (bytes[0] == -1 && bytes[1] == -2) {
                if (bytes.length > 4 && bytes[2] == 0 && bytes[3] == 0) {
                    return "UTF-32";
                }
                return "UTF-16";
            }
            if (bytes.length > 3) {
                if (bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65) {
                    return "UTF-8";
                }
                if (bytes.length > 4 && bytes[0] == 0 && bytes[1] == 0 && bytes[2] == -2 && bytes[3] == -1) {
                    return "UTF-32";
                }
            }
        }
        return null;
    }
}

