/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.Base64;
import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.NSObject;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;

public class NSData
extends NSObject {
    private final byte[] bytes;

    public NSData(byte[] bytes) {
        this.bytes = bytes;
    }

    public NSData(String base64) throws IOException {
        String data = base64.replaceAll("\\s+", "");
        this.bytes = Base64.decode(data, 4);
    }

    public NSData(File file) throws IOException {
        this.bytes = new byte[(int)file.length()];
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        raf.read(this.bytes);
        raf.close();
    }

    public byte[] bytes() {
        return this.bytes;
    }

    public int length() {
        return this.bytes.length;
    }

    public void getBytes(ByteBuffer buf, int length) {
        buf.put(this.bytes, 0, Math.min(this.bytes.length, length));
    }

    public void getBytes(ByteBuffer buf, int rangeStart, int rangeStop) {
        buf.put(this.bytes, rangeStart, Math.min(this.bytes.length, rangeStop));
    }

    public String getBase64EncodedData() {
        return Base64.encodeBytes(this.bytes);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj.getClass().equals(this.getClass()) && Arrays.equals(((NSData)obj).bytes, this.bytes);
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + Arrays.hashCode(this.bytes);
        return hash;
    }

    @Override
    public NSData clone() {
        return new NSData((byte[])this.bytes.clone());
    }

    @Override
    public Object toJavaObject() {
        return this.bytes.clone();
    }

    @Override
    public int compareTo(NSObject o2) {
        Objects.requireNonNull(o2);
        if (o2 == this) {
            return 0;
        }
        if (o2 instanceof NSData) {
            NSData other = (NSData)o2;
            if (other.length() != this.length()) {
                return Integer.compare(this.length(), other.length());
            }
            for (int i2 = 0; i2 < this.bytes.length; ++i2) {
                int itemDiff = Byte.compare(this.bytes[i2], other.bytes[i2]);
                if (itemDiff == 0) continue;
                return itemDiff;
            }
            return 0;
        }
        return this.getClass().getName().compareTo(o2.getClass().getName());
    }

    @Override
    void toXML(StringBuilder xml, int level) {
        this.indent(xml, level);
        xml.append("<data>");
        xml.append(NSObject.NEWLINE);
        String base64 = this.getBase64EncodedData();
        for (String line : base64.split("\n")) {
            this.indent(xml, level + 1);
            xml.append(line);
            xml.append(NSObject.NEWLINE);
        }
        this.indent(xml, level);
        xml.append("</data>");
    }

    @Override
    void toBinary(BinaryPropertyListWriter out) throws IOException {
        out.writeIntHeader(4, this.bytes.length);
        out.write(this.bytes);
    }

    @Override
    protected void toASCII(StringBuilder ascii, int level) {
        this.indent(ascii, level);
        ascii.append('<');
        int indexOfLastNewLine = ascii.lastIndexOf(NEWLINE);
        for (int i2 = 0; i2 < this.bytes.length; ++i2) {
            int b2 = this.bytes[i2] & 0xFF;
            if (b2 < 16) {
                ascii.append('0');
            }
            ascii.append(Integer.toHexString(b2));
            if (ascii.length() - indexOfLastNewLine > 80) {
                ascii.append(NEWLINE);
                indexOfLastNewLine = ascii.length();
                continue;
            }
            if ((i2 + 1) % 2 != 0 || i2 == this.bytes.length - 1) continue;
            ascii.append(' ');
        }
        ascii.append('>');
    }

    @Override
    protected void toASCIIGnuStep(StringBuilder ascii, int level) {
        this.toASCII(ascii, level);
    }
}

