/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.serializers;

import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.KryoException;
import com.esotericsoftware.kryo.kryo5.Registration;
import com.esotericsoftware.kryo.kryo5.Serializer;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.io.Output;
import com.esotericsoftware.kryo.kryo5.serializers.FieldSerializer;
import com.esotericsoftware.kryo.kryo5.util.Generics;
import com.esotericsoftware.kryo.kryo5.util.Util;
import java.lang.reflect.Field;

class ReflectField
extends FieldSerializer.CachedField {
    final FieldSerializer fieldSerializer;
    final Generics.GenericType genericType;

    ReflectField(Field field, FieldSerializer fieldSerializer, Generics.GenericType genericType) {
        super(field);
        this.fieldSerializer = fieldSerializer;
        this.genericType = genericType;
    }

    public Object get(Object object) throws IllegalAccessException {
        return this.field.get(object);
    }

    public void set(Object object, Object value) throws IllegalAccessException {
        this.field.set(object, value);
    }

    @Override
    public void write(Output output2, Object object) {
        Kryo kryo = this.fieldSerializer.kryo;
        try {
            Object value = this.get(object);
            Serializer serializer2 = this.serializer;
            Class concreteType = this.resolveFieldClass();
            if (concreteType == null) {
                if (value == null) {
                    kryo.writeClass(output2, null);
                    return;
                }
                Registration registration = kryo.writeClass(output2, value.getClass());
                if (serializer2 == null) {
                    serializer2 = registration.getSerializer();
                }
                kryo.getGenerics().pushGenericType(this.genericType);
                kryo.writeObject(output2, value, serializer2);
            } else {
                if (serializer2 == null) {
                    serializer2 = kryo.getSerializer(concreteType);
                    if (this.valueClass != null && this.reuseSerializer) {
                        this.serializer = serializer2;
                    }
                }
                kryo.getGenerics().pushGenericType(this.genericType);
                if (this.canBeNull) {
                    kryo.writeObjectOrNull(output2, value, serializer2);
                } else {
                    if (value == null) {
                        throw new KryoException("Field value cannot be null when canBeNull is false: " + this.name + " (" + object.getClass().getName() + ")");
                    }
                    kryo.writeObject(output2, value, serializer2);
                }
            }
            kryo.getGenerics().popGenericType();
        }
        catch (IllegalAccessException ex2) {
            throw new KryoException("Error accessing field: " + this.name + " (" + object.getClass().getName() + ")", ex2);
        }
        catch (KryoException ex3) {
            ex3.addTrace(this.name + " (" + object.getClass().getName() + ")");
            throw ex3;
        }
        catch (StackOverflowError ex4) {
            throw new KryoException("A StackOverflow occurred. The most likely cause is that your data has a circular reference resulting in infinite recursion. Try enabling references with Kryo.setReferences(true). If your data structure is really more than " + kryo.getDepth() + " levels deep then try increasing your Java stack size.", ex4);
        }
        catch (Throwable t2) {
            KryoException ex5 = new KryoException(t2);
            ex5.addTrace(this.name + " (" + object.getClass().getName() + ")");
            throw ex5;
        }
    }

    @Override
    public void read(Input input2, Object object) {
        Kryo kryo = this.fieldSerializer.kryo;
        try {
            Object value;
            Serializer serializer2 = this.serializer;
            Class concreteType = this.resolveFieldClass();
            if (concreteType == null) {
                Registration registration = kryo.readClass(input2);
                if (registration == null) {
                    this.set(object, null);
                    return;
                }
                if (serializer2 == null) {
                    serializer2 = registration.getSerializer();
                }
                kryo.getGenerics().pushGenericType(this.genericType);
                value = kryo.readObject(input2, registration.getType(), serializer2);
            } else {
                if (serializer2 == null) {
                    serializer2 = kryo.getSerializer(concreteType);
                    if (this.valueClass != null && this.reuseSerializer) {
                        this.serializer = serializer2;
                    }
                }
                kryo.getGenerics().pushGenericType(this.genericType);
                value = this.canBeNull ? kryo.readObjectOrNull(input2, concreteType, serializer2) : kryo.readObject(input2, concreteType, serializer2);
            }
            kryo.getGenerics().popGenericType();
            this.set(object, value);
        }
        catch (IllegalAccessException ex2) {
            throw new KryoException("Error accessing field: " + this.name + " (" + this.fieldSerializer.type.getName() + ")", ex2);
        }
        catch (KryoException ex3) {
            ex3.addTrace(this.name + " (" + this.fieldSerializer.type.getName() + ")");
            throw ex3;
        }
        catch (Throwable t2) {
            KryoException ex4 = new KryoException(t2);
            ex4.addTrace(this.name + " (" + this.fieldSerializer.type.getName() + ")");
            throw ex4;
        }
    }

    Class resolveFieldClass() {
        Class fieldClass;
        if (this.valueClass == null && (fieldClass = this.genericType.resolve(this.fieldSerializer.kryo.getGenerics())) != null && this.fieldSerializer.kryo.isFinal(fieldClass)) {
            return this.field.getType().isArray() ? Util.getArrayType(fieldClass) : fieldClass;
        }
        return this.valueClass;
    }

    @Override
    public void copy(Object original, Object copy) {
        try {
            this.set(copy, this.fieldSerializer.kryo.copy(this.get(original)));
        }
        catch (IllegalAccessException ex2) {
            throw new KryoException("Error accessing field: " + this.name + " (" + this.fieldSerializer.type.getName() + ")", ex2);
        }
        catch (KryoException ex3) {
            ex3.addTrace(this.name + " (" + this.fieldSerializer.type.getName() + ")");
            throw ex3;
        }
        catch (Throwable t2) {
            KryoException ex4 = new KryoException(t2);
            ex4.addTrace(this.name + " (" + this.fieldSerializer.type.getName() + ")");
            throw ex4;
        }
    }

    static final class DoubleReflectField
    extends FieldSerializer.CachedField {
        public DoubleReflectField(Field field) {
            super(field);
        }

        @Override
        public void write(Output output2, Object object) {
            try {
                output2.writeDouble(this.field.getDouble(object));
            }
            catch (Throwable t2) {
                KryoException ex2 = new KryoException(t2);
                ex2.addTrace(this.name + " (double)");
                throw ex2;
            }
        }

        @Override
        public void read(Input input2, Object object) {
            try {
                this.field.setDouble(object, input2.readDouble());
            }
            catch (Throwable t2) {
                KryoException ex2 = new KryoException(t2);
                ex2.addTrace(this.name + " (double)");
                throw ex2;
            }
        }

        @Override
        public void copy(Object original, Object copy) {
            try {
                this.field.setDouble(copy, this.field.getDouble(original));
            }
            catch (Throwable t2) {
                KryoException ex2 = new KryoException(t2);
                ex2.addTrace(this.name + " (double)");
                throw ex2;
            }
        }
    }

    static final class LongReflectField
    extends FieldSerializer.CachedField {
        public LongReflectField(Field field) {
            super(field);
        }

        @Override
        public void write(Output output2, Object object) {
            try {
                if (this.varEncoding) {
                    output2.writeVarLong(this.field.getLong(object), false);
                } else {
                    output2.writeLong(this.field.getLong(object));
                }
            }
            catch (Throwable t2) {
                KryoException ex2 = new KryoException(t2);
                ex2.addTrace(this.name + " (long)");
                throw ex2;
            }
        }

        @Override
        public void read(Input input2, Object object) {
            try {
                if (this.varEncoding) {
                    this.field.setLong(object, input2.readVarLong(false));
                } else {
                    this.field.setLong(object, input2.readLong());
                }
            }
            catch (Throwable t2) {
                KryoException ex2 = new KryoException(t2);
                ex2.addTrace(this.name + " (long)");
                throw ex2;
            }
        }

        @Override
        public void copy(Object original, Object copy) {
            try {
                this.field.setLong(copy, this.field.getLong(original));
            }
            catch (Throwable t2) {
                KryoException ex2 = new KryoException(t2);
                ex2.addTrace(this.name + " (long)");
                throw ex2;
            }
        }
    }

    static final class CharReflectField
    extends FieldSerializer.CachedField {
        public CharReflectField(Field field) {
            super(field);
        }

        @Override
        public void write(Output output2, Object object) {
            try {
                output2.writeChar(this.field.getChar(object));
            }
            catch (Throwable t2) {
                KryoException ex2 = new KryoException(t2);
                ex2.addTrace(this.name + " (char)");
                throw ex2;
            }
        }

        @Override
        public void read(Input input2, Object object) {
            try {
                this.field.setChar(object, input2.readChar());
            }
            catch (Throwable t2) {
                KryoException ex2 = new KryoException(t2);
                ex2.addTrace(this.name + " (char)");
                throw ex2;
            }
        }

        @Override
        public void copy(Object original, Object copy) {
            try {
                this.field.setChar(copy, this.field.getChar(original));
            }
            catch (Throwable t2) {
                KryoException ex2 = new KryoException(t2);
                ex2.addTrace(this.name + " (char)");
                throw ex2;
            }
        }
    }

    static final class BooleanReflectField
    extends FieldSerializer.CachedField {
        public BooleanReflectField(Field field) {
            super(field);
        }

        @Override
        public void write(Output output2, Object object) {
            try {
                output2.writeBoolean(this.field.getBoolean(object));
            }
            catch (Throwable t2) {
                KryoException ex2 = new KryoException(t2);
                ex2.addTrace(this.name + " (boolean)");
                throw ex2;
            }
        }

        @Override
        public void read(Input input2, Object object) {
            try {
                this.field.setBoolean(object, input2.readBoolean());
            }
            catch (Throwable t2) {
                KryoException ex2 = new KryoException(t2);
                ex2.addTrace(this.name + " (boolean)");
                throw ex2;
            }
        }

        @Override
        public void copy(Object original, Object copy) {
            try {
                this.field.setBoolean(copy, this.field.getBoolean(original));
            }
            catch (Throwable t2) {
                KryoException ex2 = new KryoException(t2);
                ex2.addTrace(this.name + " (boolean)");
                throw ex2;
            }
        }
    }

    static final class ByteReflectField
    extends FieldSerializer.CachedField {
        public ByteReflectField(Field field) {
            super(field);
        }

        @Override
        public void write(Output output2, Object object) {
            try {
                output2.writeByte(this.field.getByte(object));
            }
            catch (Throwable t2) {
                KryoException ex2 = new KryoException(t2);
                ex2.addTrace(this.name + " (byte)");
                throw ex2;
            }
        }

        @Override
        public void read(Input input2, Object object) {
            try {
                this.field.setByte(object, input2.readByte());
            }
            catch (Throwable t2) {
                KryoException ex2 = new KryoException(t2);
                ex2.addTrace(this.name + " (byte)");
                throw ex2;
            }
        }

        @Override
        public void copy(Object original, Object copy) {
            try {
                this.field.setByte(copy, this.field.getByte(original));
            }
            catch (Throwable t2) {
                KryoException ex2 = new KryoException(t2);
                ex2.addTrace(this.name + " (byte)");
                throw ex2;
            }
        }
    }

    static final class ShortReflectField
    extends FieldSerializer.CachedField {
        public ShortReflectField(Field field) {
            super(field);
        }

        @Override
        public void write(Output output2, Object object) {
            try {
                output2.writeShort(this.field.getShort(object));
            }
            catch (Throwable t2) {
                KryoException ex2 = new KryoException(t2);
                ex2.addTrace(this.name + " (short)");
                throw ex2;
            }
        }

        @Override
        public void read(Input input2, Object object) {
            try {
                this.field.setShort(object, input2.readShort());
            }
            catch (Throwable t2) {
                KryoException ex2 = new KryoException(t2);
                ex2.addTrace(this.name + " (short)");
                throw ex2;
            }
        }

        @Override
        public void copy(Object original, Object copy) {
            try {
                this.field.setShort(copy, this.field.getShort(original));
            }
            catch (Throwable t2) {
                KryoException ex2 = new KryoException(t2);
                ex2.addTrace(this.name + " (short)");
                throw ex2;
            }
        }
    }

    static final class FloatReflectField
    extends FieldSerializer.CachedField {
        public FloatReflectField(Field field) {
            super(field);
        }

        @Override
        public void write(Output output2, Object object) {
            try {
                output2.writeFloat(this.field.getFloat(object));
            }
            catch (Throwable t2) {
                KryoException ex2 = new KryoException(t2);
                ex2.addTrace(this.name + " (float)");
                throw ex2;
            }
        }

        @Override
        public void read(Input input2, Object object) {
            try {
                this.field.setFloat(object, input2.readFloat());
            }
            catch (Throwable t2) {
                KryoException ex2 = new KryoException(t2);
                ex2.addTrace(this.name + " (float)");
                throw ex2;
            }
        }

        @Override
        public void copy(Object original, Object copy) {
            try {
                this.field.setFloat(copy, this.field.getFloat(original));
            }
            catch (Throwable t2) {
                KryoException ex2 = new KryoException(t2);
                ex2.addTrace(this.name + " (float)");
                throw ex2;
            }
        }
    }

    static final class IntReflectField
    extends FieldSerializer.CachedField {
        public IntReflectField(Field field) {
            super(field);
        }

        @Override
        public void write(Output output2, Object object) {
            try {
                if (this.varEncoding) {
                    output2.writeVarInt(this.field.getInt(object), false);
                } else {
                    output2.writeInt(this.field.getInt(object));
                }
            }
            catch (Throwable t2) {
                KryoException ex2 = new KryoException(t2);
                ex2.addTrace(this.name + " (int)");
                throw ex2;
            }
        }

        @Override
        public void read(Input input2, Object object) {
            try {
                if (this.varEncoding) {
                    this.field.setInt(object, input2.readVarInt(false));
                } else {
                    this.field.setInt(object, input2.readInt());
                }
            }
            catch (Throwable t2) {
                KryoException ex2 = new KryoException(t2);
                ex2.addTrace(this.name + " (int)");
                throw ex2;
            }
        }

        @Override
        public void copy(Object original, Object copy) {
            try {
                this.field.setInt(copy, this.field.getInt(original));
            }
            catch (Throwable t2) {
                KryoException ex2 = new KryoException(t2);
                ex2.addTrace(this.name + " (int)");
                throw ex2;
            }
        }
    }
}

