/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.util;

import com.esotericsoftware.kryo.kryo5.util.GenericsUtil;
import com.esotericsoftware.kryo.kryo5.util.IntArray;
import com.esotericsoftware.kryo.kryo5.util.Util;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;

public interface Generics {
    public GenericsHierarchy buildHierarchy(Class var1);

    public void pushGenericType(GenericType var1);

    public void popGenericType();

    public GenericType[] nextGenericTypes();

    public Class nextGenericClass();

    public int pushTypeVariables(GenericsHierarchy var1, GenericType[] var2);

    public void popTypeVariables(int var1);

    public Class resolveTypeVariable(TypeVariable var1);

    public int getGenericTypesSize();

    public static class GenericType {
        Type type;
        GenericType[] arguments;

        public GenericType(Class fromClass, Class toClass, Type context) {
            this.initialize(fromClass, toClass, context);
        }

        private void initialize(Class fromClass, Class toClass, Type context) {
            if (context instanceof ParameterizedType) {
                ParameterizedType paramType = (ParameterizedType)context;
                Class rawType = (Class)paramType.getRawType();
                this.type = rawType;
                Type[] actualArgs = paramType.getActualTypeArguments();
                int n2 = actualArgs.length;
                this.arguments = new GenericType[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.arguments[i2] = new GenericType(fromClass, toClass, actualArgs[i2]);
                }
            } else if (context instanceof GenericArrayType) {
                int dimensions = 1;
                while ((context = ((GenericArrayType)context).getGenericComponentType()) instanceof GenericArrayType) {
                    ++dimensions;
                }
                this.initialize(fromClass, toClass, context);
                Type componentType = GenericsUtil.resolveType(fromClass, toClass, context);
                if (componentType instanceof Class) {
                    this.type = dimensions == 1 ? Array.newInstance((Class)componentType, 0).getClass() : Array.newInstance((Class)componentType, new int[dimensions]).getClass();
                }
            } else {
                this.type = GenericsUtil.resolveType(fromClass, toClass, context);
            }
        }

        public Class resolve(Generics generics) {
            if (this.type instanceof Class) {
                return (Class)this.type;
            }
            return generics.resolveTypeVariable((TypeVariable)this.type);
        }

        public Type getType() {
            return this.type;
        }

        public GenericType[] getTypeParameters() {
            return this.arguments;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(32);
            boolean array = false;
            if (this.type instanceof Class) {
                Class c2 = (Class)this.type;
                array = c2.isArray();
                buffer.append((array ? Util.getElementClass(c2) : c2).getSimpleName());
                if (this.arguments != null) {
                    buffer.append('<');
                    int n2 = this.arguments.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        if (i2 > 0) {
                            buffer.append(", ");
                        }
                        buffer.append(this.arguments[i2].toString());
                    }
                    buffer.append('>');
                }
            } else {
                buffer.append(this.type.toString());
            }
            if (array) {
                int n3 = Util.getDimensionCount((Class)this.type);
                for (int i3 = 0; i3 < n3; ++i3) {
                    buffer.append("[]");
                }
            }
            return buffer.toString();
        }
    }

    public static class GenericsHierarchy {
        static final GenericsHierarchy EMPTY = new GenericsHierarchy(0, 0, new int[0], new TypeVariable[0]);
        final int total;
        final int rootTotal;
        final int[] counts;
        final TypeVariable[] parameters;

        public GenericsHierarchy(Class type) {
            IntArray counts = new IntArray();
            ArrayList parameters = new ArrayList();
            int total = 0;
            Class current = type;
            do {
                for (TypeVariable param2 : current.getTypeParameters()) {
                    parameters.add(param2);
                    counts.add(1);
                    Class currentSuper = current;
                    block2: while (true) {
                        Type genericSuper = currentSuper.getGenericSuperclass();
                        currentSuper = currentSuper.getSuperclass();
                        if (!(genericSuper instanceof ParameterizedType)) break;
                        TypeVariable<Class<T>>[] superParams = currentSuper.getTypeParameters();
                        Type[] superArgs = ((ParameterizedType)genericSuper).getActualTypeArguments();
                        int ii = 0;
                        int nn = superArgs.length;
                        while (true) {
                            if (ii >= nn) continue block2;
                            Type superArg = superArgs[ii];
                            if (superArg == param2) {
                                param2 = superParams[ii];
                                parameters.add(param2);
                                counts.incr(counts.size - 1, 1);
                            }
                            ++ii;
                        }
                        break;
                    }
                    total += counts.peek();
                }
            } while ((current = current.getSuperclass()) != null);
            this.total = total;
            this.rootTotal = type.getTypeParameters().length;
            this.counts = counts.toArray();
            this.parameters = parameters.toArray(new TypeVariable[parameters.size()]);
        }

        GenericsHierarchy(int total, int rootTotal, int[] counts, TypeVariable[] parameters) {
            this.total = total;
            this.rootTotal = rootTotal;
            this.counts = counts;
            this.parameters = parameters;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("[");
            int[] counts = this.counts;
            TypeVariable[] parameters = this.parameters;
            int p2 = 0;
            for (int count : counts) {
                int nn = p2 + count;
                while (p2 < nn) {
                    Object declaration;
                    if (buffer.length() > 1) {
                        buffer.append(", ");
                    }
                    if ((declaration = parameters[p2].getGenericDeclaration()) instanceof Class) {
                        buffer.append(((Class)declaration).getSimpleName());
                    } else {
                        buffer.append(declaration);
                    }
                    buffer.append('<');
                    buffer.append(parameters[p2].getName());
                    buffer.append('>');
                    ++p2;
                }
            }
            buffer.append("]");
            return buffer.toString();
        }
    }
}

