/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.sshj.transport.cipher;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.common.SecurityUtils;
import net.schmizz.sshj.transport.cipher.BaseCipher;
import net.schmizz.sshj.transport.cipher.Cipher;

public class ChachaPolyCipher
extends BaseCipher {
    private static final int CHACHA_KEY_SIZE = 32;
    private static final int AAD_LENGTH = 4;
    private static final int POLY_TAG_LENGTH = 16;
    private static final String CIPHER_CHACHA = "CHACHA";
    private static final String MAC_POLY1305 = "POLY1305";
    private static final byte[] POLY_KEY_INPUT = new byte[32];
    private final int authSize;
    private byte[] encryptedAad;
    protected Cipher.Mode mode;
    protected Cipher aadCipher;
    protected Mac mac;
    protected Key cipherKey;
    protected Key aadCipherKey;

    public ChachaPolyCipher(int authSize, int bsize, String algorithm) {
        super(0, bsize, algorithm, CIPHER_CHACHA);
        this.authSize = authSize;
    }

    @Override
    public int getAuthenticationTagSize() {
        return this.authSize;
    }

    @Override
    public void setSequenceNumber(long seq) {
        byte[] seqAsBytes = this.longToBytes(seq);
        IvParameterSpec ivSpec = new IvParameterSpec(seqAsBytes);
        try {
            this.cipher.init(this.getMode(this.mode), this.cipherKey, ivSpec);
            this.aadCipher.init(this.getMode(this.mode), this.aadCipherKey, ivSpec);
        }
        catch (GeneralSecurityException e2) {
            throw new SSHRuntimeException(e2);
        }
        byte[] polyKeyBytes = this.cipher.update(POLY_KEY_INPUT);
        this.cipher.update(POLY_KEY_INPUT);
        try {
            this.mac.init(this.getKeySpec(polyKeyBytes));
        }
        catch (GeneralSecurityException e3) {
            throw new SSHRuntimeException(e3);
        }
        this.encryptedAad = null;
    }

    @Override
    protected void initCipher(Cipher cipher, Cipher.Mode mode, byte[] key, byte[] iv) {
        this.mode = mode;
        this.cipherKey = this.getKeySpec(Arrays.copyOfRange(key, 0, 32));
        this.aadCipherKey = this.getKeySpec(Arrays.copyOfRange(key, 32, 64));
        try {
            this.aadCipher = SecurityUtils.getCipher(CIPHER_CHACHA);
            this.mac = SecurityUtils.getMAC(MAC_POLY1305);
        }
        catch (GeneralSecurityException e2) {
            cipher = null;
            this.aadCipher = null;
            this.mac = null;
            throw new SSHRuntimeException(e2);
        }
        this.setSequenceNumber(0L);
    }

    @Override
    public void updateAAD(byte[] data, int offset, int length) {
        if (offset != 0 || length != 4) {
            throw new IllegalArgumentException(String.format("updateAAD called with offset %d and length %d", offset, length));
        }
        if (this.mode == Cipher.Mode.Decrypt) {
            this.encryptedAad = Arrays.copyOfRange(data, 0, 4);
        }
        try {
            this.aadCipher.update(data, 0, 4, data, 0);
        }
        catch (GeneralSecurityException e2) {
            throw new SSHRuntimeException("Error updating data through cipher", e2);
        }
    }

    @Override
    public void updateAAD(byte[] data) {
        this.updateAAD(data, 0, 4);
    }

    @Override
    public void update(byte[] input2, int inputOffset, int inputLen) {
        byte[] macInput;
        if (inputOffset != 0 && inputOffset != 4) {
            throw new IllegalArgumentException("updateAAD called with inputOffset " + inputOffset);
        }
        int macInputLength = inputOffset + inputLen;
        if (this.mode == Cipher.Mode.Decrypt) {
            macInput = new byte[macInputLength];
            if (inputOffset == 0) {
                System.arraycopy(input2, 0, macInput, 0, inputLen);
            } else {
                System.arraycopy(this.encryptedAad, 0, macInput, 0, 4);
                System.arraycopy(input2, 4, macInput, 4, inputLen);
            }
            byte[] expectedPolyTag = this.mac.doFinal(macInput);
            byte[] actualPolyTag = Arrays.copyOfRange(input2, macInputLength, macInputLength + 16);
            if (!MessageDigest.isEqual(actualPolyTag, expectedPolyTag)) {
                throw new SSHRuntimeException("MAC Error");
            }
        }
        try {
            this.cipher.update(input2, inputOffset, inputLen, input2, inputOffset);
        }
        catch (GeneralSecurityException e2) {
            throw new SSHRuntimeException("ChaCha20 cipher processing failed", e2);
        }
        if (this.mode == Cipher.Mode.Encrypt) {
            macInput = Arrays.copyOf(input2, macInputLength);
            byte[] polyTag = this.mac.doFinal(macInput);
            System.arraycopy(polyTag, 0, input2, macInputLength, 16);
        }
    }

    private byte[] longToBytes(long lng) {
        return new byte[]{(byte)(lng >> 56), (byte)(lng >> 48), (byte)(lng >> 40), (byte)(lng >> 32), (byte)(lng >> 24), (byte)(lng >> 16), (byte)(lng >> 8), (byte)lng};
    }
}

