/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.core;

import org.jetbrains.annotations.NotNull;

public final class Color {
    private final int value;

    public Color(int r2, int g2, int b2) {
        this(r2, g2, b2, 255);
    }

    public Color(int r2, int g2, int b2, int a2) {
        this.value = (a2 & 0xFF) << 24 | (r2 & 0xFF) << 16 | (g2 & 0xFF) << 8 | b2 & 0xFF;
    }

    public Color(int rgb) {
        this(rgb, false);
    }

    public Color(int rgba, boolean hasAlpha) {
        this.value = hasAlpha ? rgba : 0xFF000000 | rgba;
    }

    public int getRed() {
        return this.value >> 16 & 0xFF;
    }

    public int getGreen() {
        return this.value >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.value & 0xFF;
    }

    public int getAlpha() {
        return this.value >> 24 & 0xFF;
    }

    public int getRGB() {
        return this.value;
    }

    @NotNull
    public String toXParseColor() {
        return "rgb:" + this.toHexString16();
    }

    @NotNull
    private String toHexString16() {
        String red = this.padStart(Integer.toHexString(this.getRed() * 257), 4, '0');
        String green = this.padStart(Integer.toHexString(this.getGreen() * 257), 4, '0');
        String blue = this.padStart(Integer.toHexString(this.getBlue() * 257), 4, '0');
        return red + "/" + green + "/" + blue;
    }

    @NotNull
    private String padStart(@NotNull String str, int totalLength, char ch2) {
        return Character.toString(ch2).repeat(Math.max(0, totalLength - str.length())) + str;
    }

    public boolean equals(Object o2) {
        return this == o2 || o2 instanceof Color && ((Color)o2).value == this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return this.getClass().getName() + "[r=" + this.getRed() + ",g=" + this.getGreen() + ",b=" + this.getBlue() + ", alpha=" + this.getAlpha() + "]";
    }
}

