/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal;

import com.jediterm.core.Color;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TerminalColor {
    public static final TerminalColor BLACK = TerminalColor.index(0);
    public static final TerminalColor WHITE = TerminalColor.index(15);
    private final int myColorIndex;
    private final Color myColor;
    private final Supplier<Color> myColorSupplier;

    public TerminalColor(int colorIndex) {
        this(colorIndex, null, null);
    }

    public TerminalColor(int r2, int g2, int b2) {
        this(-1, new Color(r2, g2, b2), null);
    }

    public TerminalColor(@NotNull Supplier<Color> colorSupplier) {
        this(-1, null, colorSupplier);
    }

    private TerminalColor(int colorIndex, @Nullable Color color, @Nullable Supplier<Color> colorSupplier) {
        if (colorIndex != -1) {
            assert (color == null);
            assert (colorSupplier == null);
        } else if (color != null ? !$assertionsDisabled && colorSupplier != null : !$assertionsDisabled && colorSupplier == null) {
            throw new AssertionError();
        }
        this.myColorIndex = colorIndex;
        this.myColor = color;
        this.myColorSupplier = colorSupplier;
    }

    @NotNull
    public static TerminalColor index(int colorIndex) {
        return new TerminalColor(colorIndex);
    }

    public static TerminalColor rgb(int r2, int g2, int b2) {
        return new TerminalColor(r2, g2, b2);
    }

    public boolean isIndexed() {
        return this.myColorIndex != -1;
    }

    @NotNull
    public Color toColor() {
        if (this.isIndexed()) {
            throw new IllegalArgumentException("Color is indexed color so a palette is needed");
        }
        return this.myColor != null ? this.myColor : Objects.requireNonNull(this.myColorSupplier).get();
    }

    public int getColorIndex() {
        return this.myColorIndex;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        TerminalColor that = (TerminalColor)o2;
        return this.myColorIndex == that.myColorIndex && Objects.equals(this.myColor, that.myColor);
    }

    public int hashCode() {
        return Objects.hash(this.myColorIndex, this.myColor);
    }

    @Nullable
    public static TerminalColor fromColor(@Nullable Color color) {
        if (color == null) {
            return null;
        }
        return TerminalColor.rgb(color.getRed(), color.getGreen(), color.getBlue());
    }
}

