/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.ui;

import com.jediterm.terminal.TerminalExecutorServiceManager;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public final class JediTermExecutorServiceManager
implements TerminalExecutorServiceManager {
    private final ScheduledExecutorService mySingleThreadScheduledExecutor = Executors.newSingleThreadScheduledExecutor(new JediTermThreadFactory("JediTerm-fast-job-"));
    private final ExecutorService myUnboundedExecutor = Executors.newCachedThreadPool(new JediTermThreadFactory("JediTerm-"));

    @Override
    @NotNull
    public ScheduledExecutorService getSingleThreadScheduledExecutor() {
        return this.mySingleThreadScheduledExecutor;
    }

    @Override
    @NotNull
    public ExecutorService getUnboundedExecutorService() {
        return this.myUnboundedExecutor;
    }

    @Override
    public void shutdownWhenAllExecuted() {
        if (!this.mySingleThreadScheduledExecutor.isShutdown()) {
            this.mySingleThreadScheduledExecutor.execute(this.mySingleThreadScheduledExecutor::shutdown);
        }
        this.myUnboundedExecutor.shutdown();
    }

    private static class JediTermThreadFactory
    implements ThreadFactory {
        private final String myThreadNamePrefix;
        private final AtomicInteger myThreadNumber = new AtomicInteger(0);

        JediTermThreadFactory(@NotNull String threadNamePrefix) {
            this.myThreadNamePrefix = threadNamePrefix;
        }

        @Override
        public Thread newThread(@NotNull Runnable r2) {
            Thread t2 = new Thread(r2, this.myThreadNamePrefix + this.myThreadNumber.getAndIncrement());
            if (t2.isDaemon()) {
                t2.setDaemon(false);
            }
            if (t2.getPriority() != 5) {
                t2.setPriority(5);
            }
            return t2;
        }
    }
}

