/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.menu;

import com.jetbrains.cef.remote.thrift_codegen.MenuItem;
import com.jetbrains.cef.remote.thrift_codegen.MenuItemType;
import java.util.ArrayList;
import java.util.List;
import org.cef.callback.CefMenuModel;
import org.cef.misc.BoolRef;
import org.cef.misc.IntRef;

public class RemoteMenuModel
implements CefMenuModel {
    List<MenuItem> myThriftModel;

    public RemoteMenuModel(List<MenuItem> thriftModel) {
        this.myThriftModel = thriftModel;
    }

    @Override
    public boolean clear() {
        this.myThriftModel.clear();
        return true;
    }

    @Override
    public int getCount() {
        return this.myThriftModel.size();
    }

    @Override
    public boolean addSeparator() {
        MenuItem item = new MenuItem();
        item.type = MenuItemType.MENUITEMTYPE_SEPARATOR;
        return this.append(item);
    }

    @Override
    public boolean addItem(int command_id, String label2) {
        MenuItem item = new MenuItem();
        item.type = MenuItemType.MENUITEMTYPE_COMMAND;
        item.command_id = command_id;
        item.label = label2;
        return this.append(item);
    }

    @Override
    public boolean addCheckItem(int command_id, String label2) {
        MenuItem item = new MenuItem();
        item.type = MenuItemType.MENUITEMTYPE_CHECK;
        item.command_id = command_id;
        item.label = label2;
        return this.append(item);
    }

    @Override
    public boolean addRadioItem(int command_id, String label2, int group_id) {
        MenuItem item = new MenuItem();
        item.type = MenuItemType.MENUITEMTYPE_RADIO;
        item.command_id = command_id;
        item.label = label2;
        item.group_id = group_id;
        return this.append(item);
    }

    @Override
    public CefMenuModel addSubMenu(int command_id, String label2) {
        MenuItem item = new MenuItem();
        item.type = MenuItemType.MENUITEMTYPE_SUBMENU;
        item.command_id = command_id;
        item.label = label2;
        item.sub_menu = new ArrayList<MenuItem>();
        this.myThriftModel.add(item);
        return new RemoteMenuModel(item.sub_menu);
    }

    @Override
    public boolean insertSeparatorAt(int index) {
        MenuItem item = new MenuItem();
        item.type = MenuItemType.MENUITEMTYPE_SEPARATOR;
        return this.insert(item, index);
    }

    @Override
    public boolean insertItemAt(int index, int command_id, String label2) {
        index = Math.min(index, this.myThriftModel.size());
        MenuItem i2 = new MenuItem();
        i2.type = MenuItemType.MENUITEMTYPE_COMMAND;
        i2.command_id = command_id;
        i2.label = label2;
        return this.insert(i2, index);
    }

    @Override
    public boolean insertCheckItemAt(int index, int command_id, String label2) {
        MenuItem i2 = new MenuItem();
        i2.type = MenuItemType.MENUITEMTYPE_CHECK;
        i2.command_id = command_id;
        i2.label = label2;
        return this.insert(i2, index);
    }

    @Override
    public boolean insertRadioItemAt(int index, int command_id, String label2, int group_id) {
        MenuItem i2 = new MenuItem();
        i2.type = MenuItemType.MENUITEMTYPE_RADIO;
        i2.command_id = command_id;
        i2.label = label2;
        i2.group_id = group_id;
        return this.insert(i2, index);
    }

    @Override
    public CefMenuModel insertSubMenuAt(int index, int command_id, String label2) {
        MenuItem i2 = new MenuItem();
        i2.type = MenuItemType.MENUITEMTYPE_SUBMENU;
        i2.command_id = command_id;
        i2.label = label2;
        i2.sub_menu = new ArrayList<MenuItem>();
        this.myThriftModel.add(index, i2);
        return new RemoteMenuModel(i2.sub_menu);
    }

    @Override
    public boolean remove(int command_id) {
        return this.myThriftModel.removeIf(i2 -> i2.command_id == command_id);
    }

    @Override
    public boolean removeAt(int index) {
        try {
            this.myThriftModel.remove(index);
        }
        catch (IndexOutOfBoundsException e2) {
            return false;
        }
        return true;
    }

    @Override
    public int getIndexOf(int command_id) {
        for (int i2 = 0; i2 < this.myThriftModel.size(); ++i2) {
            if (this.myThriftModel.get((int)i2).command_id != command_id) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int getCommandIdAt(int index) {
        if (index < 0 || index >= this.myThriftModel.size()) {
            return -1;
        }
        return this.myThriftModel.get((int)index).command_id;
    }

    @Override
    public boolean setCommandIdAt(int index, int command_id) {
        if (index < 0 || index >= this.myThriftModel.size()) {
            return false;
        }
        this.myThriftModel.get((int)index).command_id = command_id;
        return true;
    }

    @Override
    public String getLabel(int command_id) {
        int index = this.getIndexOf(command_id);
        return this.getLabelAt(index);
    }

    @Override
    public String getLabelAt(int index) {
        MenuItem item = this.getItem(index);
        if (item == null) {
            return null;
        }
        return this.myThriftModel.get((int)index).label;
    }

    @Override
    public boolean setLabel(int command_id, String label2) {
        int index = this.getIndexOf(command_id);
        return this.setLabelAt(index, label2);
    }

    @Override
    public boolean setLabelAt(int index, String label2) {
        MenuItem item = this.getItem(index);
        if (item == null) {
            return false;
        }
        item.label = label2;
        return true;
    }

    @Override
    public CefMenuModel.MenuItemType getType(int command_id) {
        MenuItem item = this.getItem(this.getIndexOf(command_id));
        if (item == null) {
            return null;
        }
        return RemoteMenuModel.convert(item.type);
    }

    @Override
    public CefMenuModel.MenuItemType getTypeAt(int index) {
        MenuItem item = this.getItem(index);
        if (item == null) {
            return null;
        }
        return RemoteMenuModel.convert(item.type);
    }

    @Override
    public int getGroupId(int command_id) {
        MenuItem item = this.getItem(this.getIndexOf(command_id));
        if (item == null) {
            return -1;
        }
        return item.group_id;
    }

    @Override
    public int getGroupIdAt(int index) {
        MenuItem item = this.getItem(index);
        if (item == null) {
            return -1;
        }
        return item.group_id;
    }

    @Override
    public boolean setGroupId(int command_id, int group_id) {
        MenuItem item = this.getItem(this.getIndexOf(command_id));
        if (item == null) {
            return false;
        }
        item.group_id = group_id;
        return true;
    }

    @Override
    public boolean setGroupIdAt(int index, int group_id) {
        MenuItem item = this.getItem(index);
        if (item == null) {
            return false;
        }
        item.group_id = group_id;
        return true;
    }

    @Override
    public CefMenuModel getSubMenu(int command_id) {
        int index = this.getIndexOf(command_id);
        return this.getSubMenuAt(index);
    }

    @Override
    public CefMenuModel getSubMenuAt(int index) {
        MenuItem item = this.getItem(index);
        if (item == null) {
            return null;
        }
        return new RemoteMenuModel(item.sub_menu);
    }

    @Override
    public boolean isVisible(int command_id) {
        MenuItem item = this.getItem(this.getIndexOf(command_id));
        if (item == null) {
            return false;
        }
        return item.visible;
    }

    @Override
    public boolean isVisibleAt(int index) {
        MenuItem item = this.getItem(index);
        if (item == null) {
            return false;
        }
        return item.visible;
    }

    @Override
    public boolean setVisible(int command_id, boolean visible) {
        MenuItem item = this.getItem(this.getIndexOf(command_id));
        if (item == null) {
            return false;
        }
        item.visible = visible;
        return true;
    }

    @Override
    public boolean setVisibleAt(int index, boolean visible) {
        MenuItem item = this.getItem(index);
        if (item == null) {
            return false;
        }
        item.visible = visible;
        return true;
    }

    @Override
    public boolean isEnabled(int command_id) {
        MenuItem item = this.getItem(this.getIndexOf(command_id));
        if (item == null) {
            return false;
        }
        return item.enabled;
    }

    @Override
    public boolean isEnabledAt(int index) {
        MenuItem item = this.getItem(index);
        if (item == null) {
            return false;
        }
        return item.enabled;
    }

    @Override
    public boolean setEnabled(int command_id, boolean enabled) {
        MenuItem item = this.getItem(this.getIndexOf(command_id));
        if (item == null) {
            return false;
        }
        item.enabled = enabled;
        return true;
    }

    @Override
    public boolean setEnabledAt(int index, boolean enabled) {
        MenuItem item = this.getItem(index);
        if (item == null) {
            return false;
        }
        item.enabled = enabled;
        return true;
    }

    @Override
    public boolean isChecked(int command_id) {
        MenuItem item = this.getItem(this.getIndexOf(command_id));
        if (item == null) {
            return false;
        }
        return item.checked;
    }

    @Override
    public boolean isCheckedAt(int index) {
        MenuItem item = this.getItem(index);
        if (item == null) {
            return false;
        }
        return item.checked;
    }

    @Override
    public boolean setChecked(int command_id, boolean checked) {
        MenuItem item = this.getItem(this.getIndexOf(command_id));
        if (item == null) {
            return false;
        }
        item.checked = checked;
        return true;
    }

    @Override
    public boolean setCheckedAt(int index, boolean checked) {
        MenuItem item = this.getItem(index);
        if (item == null) {
            return false;
        }
        item.checked = checked;
        return true;
    }

    @Override
    public boolean hasAccelerator(int command_id) {
        return false;
    }

    @Override
    public boolean hasAcceleratorAt(int index) {
        return false;
    }

    @Override
    public boolean setAccelerator(int command_id, int key_code, boolean shift_pressed, boolean ctrl_pressed, boolean alt_pressed) {
        return false;
    }

    @Override
    public boolean setAcceleratorAt(int index, int key_code, boolean shift_pressed, boolean ctrl_pressed, boolean alt_pressed) {
        return false;
    }

    @Override
    public boolean removeAccelerator(int command_id) {
        return false;
    }

    @Override
    public boolean removeAcceleratorAt(int index) {
        return false;
    }

    @Override
    public boolean getAccelerator(int command_id, IntRef key_code, BoolRef shift_pressed, BoolRef ctrl_pressed, BoolRef alt_pressed) {
        return false;
    }

    @Override
    public boolean getAcceleratorAt(int index, IntRef key_code, BoolRef shift_pressed, BoolRef ctrl_pressed, BoolRef alt_pressed) {
        return false;
    }

    private boolean append(MenuItem item) {
        if (!this.validate(item)) {
            return false;
        }
        this.myThriftModel.add(item);
        return true;
    }

    private boolean insert(MenuItem item, int index) {
        if (!this.validate(item) || index < 0 || index > this.myThriftModel.size()) {
            return false;
        }
        this.myThriftModel.add(index, item);
        return true;
    }

    private MenuItem getItem(int index) {
        if (index < 0 || index >= this.myThriftModel.size()) {
            return null;
        }
        return this.myThriftModel.get(index);
    }

    private boolean validate(MenuItem item) {
        if (item.type == MenuItemType.MENUITEMTYPE_NONE) {
            return false;
        }
        if (item.type == MenuItemType.MENUITEMTYPE_SEPARATOR) {
            return item.command_id == -1;
        }
        return item.command_id >= 0;
    }

    public static CefMenuModel.MenuItemType convert(MenuItemType thriftType) {
        if (thriftType == null) {
            return null;
        }
        return switch (thriftType) {
            case MenuItemType.MENUITEMTYPE_NONE -> CefMenuModel.MenuItemType.MENUITEMTYPE_NONE;
            case MenuItemType.MENUITEMTYPE_COMMAND -> CefMenuModel.MenuItemType.MENUITEMTYPE_COMMAND;
            case MenuItemType.MENUITEMTYPE_CHECK -> CefMenuModel.MenuItemType.MENUITEMTYPE_CHECK;
            case MenuItemType.MENUITEMTYPE_RADIO -> CefMenuModel.MenuItemType.MENUITEMTYPE_RADIO;
            case MenuItemType.MENUITEMTYPE_SEPARATOR -> CefMenuModel.MenuItemType.MENUITEMTYPE_SEPARATOR;
            case MenuItemType.MENUITEMTYPE_SUBMENU -> CefMenuModel.MenuItemType.MENUITEMTYPE_SUBMENU;
            default -> null;
        };
    }

    public List<MenuItem> getThriftModel() {
        return this.myThriftModel;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        RemoteMenuModel.buildMenuTree(builder, this, 0);
        return builder.toString();
    }

    private static void buildMenuTree(StringBuilder builder, CefMenuModel menu, int depth) {
        int itemCount = menu.getCount();
        String indent = "  ".repeat(depth);
        for (int i2 = 0; i2 < itemCount; ++i2) {
            String name = menu.getLabelAt(i2) + "(" + menu.getCommandIdAt(i2) + ")";
            CefMenuModel.MenuItemType type = menu.getTypeAt(i2);
            builder.append(indent).append("- ").append(name).append(" (").append((Object)type).append(")").append("\n");
            if (type != CefMenuModel.MenuItemType.MENUITEMTYPE_SUBMENU) continue;
            CefMenuModel subMenu = menu.getSubMenuAt(i2);
            RemoteMenuModel.buildMenuTree(builder, subMenu, depth + 1);
        }
    }
}

