/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.network;

import com.jetbrains.cef.remote.thrift_codegen.PostDataElement;
import java.nio.ByteBuffer;
import org.cef.misc.DebugFormatter;
import org.cef.network.CefPostDataElement;

public class RemotePostDataElement
extends CefPostDataElement {
    private final PostDataElement myElement;

    public RemotePostDataElement(PostDataElement postDataElement) {
        this.myElement = postDataElement;
    }

    public RemotePostDataElement() {
        this.myElement = new PostDataElement(false, RemotePostDataElement.type2int(CefPostDataElement.Type.PDE_TYPE_EMPTY));
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean isReadOnly() {
        return this.myElement.isReadOnly;
    }

    @Override
    public void setToEmpty() {
        this.myElement.file = null;
        this.myElement.bytes = null;
        this.myElement.type = RemotePostDataElement.type2int(CefPostDataElement.Type.PDE_TYPE_EMPTY);
    }

    @Override
    public void setToFile(String fileName) {
        this.myElement.file = fileName;
        this.myElement.bytes = null;
        this.myElement.type = RemotePostDataElement.type2int(CefPostDataElement.Type.PDE_TYPE_FILE);
    }

    @Override
    public void setToBytes(int size, byte[] bytes) {
        this.myElement.file = null;
        this.myElement.bytes = ByteBuffer.wrap(bytes, 0, size);
        this.myElement.type = RemotePostDataElement.type2int(CefPostDataElement.Type.PDE_TYPE_BYTES);
    }

    @Override
    public CefPostDataElement.Type getType() {
        return RemotePostDataElement.int2type(this.myElement.type);
    }

    @Override
    public String getFile() {
        return this.myElement.file;
    }

    @Override
    public int getBytesCount() {
        return this.myElement.bytes == null ? 0 : this.myElement.bytes.capacity();
    }

    @Override
    public int getBytes(int size, byte[] bytes) {
        if (this.myElement.bytes == null) {
            return 0;
        }
        this.myElement.bytes.position(0);
        this.myElement.bytes.get(bytes, 0, size);
        return size;
    }

    static PostDataElement toThriftWithMap(CefPostDataElement postData) {
        if (postData == null) {
            return null;
        }
        CefPostDataElement.Type type = postData.getType();
        PostDataElement e2 = new PostDataElement(postData.isReadOnly(), RemotePostDataElement.type2int(type));
        e2.file = postData.getFile();
        if (postData.getBytesCount() > 0) {
            byte[] buf = new byte[postData.getBytesCount()];
            postData.getBytes(postData.getBytesCount(), buf);
            e2.bytes = ByteBuffer.wrap(buf);
        }
        return e2;
    }

    @Override
    public String toString() {
        return DebugFormatter.toString_PostDataElement(null, this);
    }

    private static CefPostDataElement.Type int2type(int type) {
        switch (type) {
            case 0: {
                return CefPostDataElement.Type.PDE_TYPE_EMPTY;
            }
            case 1: {
                return CefPostDataElement.Type.PDE_TYPE_BYTES;
            }
            case 2: {
                return CefPostDataElement.Type.PDE_TYPE_FILE;
            }
            case 3: {
                return CefPostDataElement.Type.PDF_TYPE_NUM_VALUES;
            }
        }
        return null;
    }

    private static int type2int(CefPostDataElement.Type type) {
        switch (type) {
            case PDE_TYPE_EMPTY: {
                return 0;
            }
            case PDE_TYPE_BYTES: {
                return 1;
            }
            case PDE_TYPE_FILE: {
                return 2;
            }
            case PDF_TYPE_NUM_VALUES: {
                return 3;
            }
        }
        return -1;
    }
}

