/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.network;

import com.jetbrains.cef.remote.RemoteServerObjectLocal;
import com.jetbrains.cef.remote.RpcContext;
import com.jetbrains.cef.remote.thrift_codegen.RObject;
import java.util.Map;
import org.cef.handler.CefLoadHandler;
import org.cef.misc.CefLog;

public class RemoteResponseImpl
extends RemoteServerObjectLocal {
    public RemoteResponseImpl(RpcContext rpcContext, RObject resp) {
        super(rpcContext, resp);
    }

    @Override
    public void flush() {
        this.myRpc.exec(s2 -> s2.Response_Update(this.thriftIdWithCache()));
    }

    public boolean isReadOnly() {
        return this.getBoolVal("IsReadOnly");
    }

    public CefLoadHandler.ErrorCode getError() {
        String sval = (String)this.myCache.get("Error");
        if (sval != null && !sval.isEmpty()) {
            try {
                return CefLoadHandler.ErrorCode.valueOf(sval);
            }
            catch (Throwable e2) {
                CefLog.Error("getError: sval=%s, exception: %s", sval, e2.getMessage());
            }
        }
        return CefLoadHandler.ErrorCode.ERR_NONE;
    }

    public void setError(CefLoadHandler.ErrorCode errorCode) {
        String key = "Error";
        if (errorCode == null) {
            this.setStrVal("Error", null);
        } else {
            this.setLongVal("Error", errorCode.getCode());
        }
    }

    public int getStatus() {
        return (int)this.getLongVal("Status");
    }

    public void setStatus(int status) {
        this.setLongVal("Status", status);
    }

    public String getStatusText() {
        return (String)this.myCache.get("StatusText");
    }

    public void setStatusText(String statusText) {
        this.setStrVal("StatusText", statusText);
    }

    public String getMimeType() {
        return (String)this.myCache.get("MimeType");
    }

    public void setMimeType(String mimeType) {
        this.setStrVal("MimeType", mimeType);
    }

    public String getHeaderByName(String name) {
        return this.myRpc.execObj(s2 -> s2.Response_GetHeaderByName(this.thriftId(), name));
    }

    public void setHeaderByName(String name, String value, boolean overwrite) {
        this.myRpc.exec(s2 -> s2.Response_SetHeaderByName(this.thriftId(), name, value, overwrite));
    }

    public void getHeaderMap(Map<String, String> headerMap) {
        if (headerMap == null) {
            return;
        }
        Map result2 = this.myRpc.execObj(s2 -> s2.Response_GetHeaderMap(this.thriftId()));
        if (result2 != null) {
            headerMap.putAll(result2);
        }
    }

    public void setHeaderMap(Map<String, String> headerMap) {
        this.myRpc.exec(s2 -> s2.Response_SetHeaderMap(this.thriftId(), headerMap));
    }

    public String toString() {
        return this.myCache.toString();
    }
}

