/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.thrift.meta_data;

import com.jetbrains.cef.remote.thrift.TBase;
import com.jetbrains.cef.remote.thrift.TFieldIdEnum;
import com.jetbrains.cef.remote.thrift.meta_data.FieldValueMetaData;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class FieldMetaData
implements Serializable {
    public final String fieldName;
    public final byte requirementType;
    public final FieldValueMetaData valueMetaData;
    private final Map<String, String> fieldAnnotations;
    private static final ConcurrentMap<Class<? extends TBase>, Map<? extends TFieldIdEnum, FieldMetaData>> structMap = new ConcurrentHashMap<Class<? extends TBase>, Map<? extends TFieldIdEnum, FieldMetaData>>();

    public FieldMetaData(String name, byte req, FieldValueMetaData vMetaData) {
        this(name, req, vMetaData, Collections.emptyMap());
    }

    public FieldMetaData(String fieldName, byte requirementType, FieldValueMetaData valueMetaData, Map<String, String> fieldAnnotations) {
        this.fieldName = fieldName;
        this.requirementType = requirementType;
        this.valueMetaData = valueMetaData;
        this.fieldAnnotations = fieldAnnotations;
    }

    public Map<String, String> getFieldAnnotations() {
        return Collections.unmodifiableMap(this.fieldAnnotations);
    }

    public static <T extends TBase<T, F>, F extends TFieldIdEnum> void addStructMetaDataMap(Class<T> sClass, Map<F, FieldMetaData> map2) {
        structMap.put(sClass, map2);
    }

    public static <T extends TBase<T, F>, F extends TFieldIdEnum> Map<F, FieldMetaData> getStructMetaDataMap(Class<T> sClass) {
        if (!structMap.containsKey(sClass)) {
            try {
                sClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e2) {
                throw new RuntimeException(e2.getClass().getSimpleName() + " for TBase class: " + sClass.getName(), e2);
            }
        }
        return (Map)structMap.get(sClass);
    }
}

