/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.thrift.protocol;

import com.jetbrains.cef.remote.thrift.TException;
import com.jetbrains.cef.remote.thrift.protocol.TCompactProtocol;
import com.jetbrains.cef.remote.thrift.protocol.TList;
import com.jetbrains.cef.remote.thrift.protocol.TMap;
import com.jetbrains.cef.remote.thrift.protocol.TProtocol;
import com.jetbrains.cef.remote.thrift.protocol.TProtocolFactory;
import com.jetbrains.cef.remote.thrift.protocol.TSet;
import com.jetbrains.cef.remote.thrift.scheme.IScheme;
import com.jetbrains.cef.remote.thrift.scheme.TupleScheme;
import com.jetbrains.cef.remote.thrift.transport.TTransport;
import java.util.BitSet;

public final class TTupleProtocol
extends TCompactProtocol {
    public TTupleProtocol(TTransport transport) {
        super(transport);
    }

    @Override
    public Class<? extends IScheme> getScheme() {
        return TupleScheme.class;
    }

    public void writeBitSet(BitSet bs2, int vectorWidth) throws TException {
        byte[] bytes;
        for (byte b2 : bytes = TTupleProtocol.toByteArray(bs2, vectorWidth)) {
            this.writeByte(b2);
        }
    }

    public BitSet readBitSet(int i2) throws TException {
        int length = (int)Math.ceil((double)i2 / 8.0);
        byte[] bytes = new byte[length];
        for (int j2 = 0; j2 < length; ++j2) {
            bytes[j2] = this.readByte();
        }
        BitSet bs2 = TTupleProtocol.fromByteArray(bytes);
        return bs2;
    }

    public static BitSet fromByteArray(byte[] bytes) {
        BitSet bits = new BitSet();
        for (int i2 = 0; i2 < bytes.length * 8; ++i2) {
            if ((bytes[bytes.length - i2 / 8 - 1] & 1 << i2 % 8) <= 0) continue;
            bits.set(i2);
        }
        return bits;
    }

    public static byte[] toByteArray(BitSet bits, int vectorWidth) {
        byte[] bytes = new byte[(int)Math.ceil((double)vectorWidth / 8.0)];
        for (int i2 = 0; i2 < bits.length(); ++i2) {
            if (!bits.get(i2)) continue;
            int n2 = bytes.length - i2 / 8 - 1;
            bytes[n2] = (byte)(bytes[n2] | 1 << i2 % 8);
        }
        return bytes;
    }

    public TMap readMapBegin(byte keyType, byte valTyep) throws TException {
        int size = super.readI32();
        TMap map2 = new TMap(keyType, valTyep, size);
        this.checkReadBytesAvailable(map2);
        return map2;
    }

    public TList readListBegin(byte type) throws TException {
        int size = super.readI32();
        TList list = new TList(type, size);
        this.checkReadBytesAvailable(list);
        return list;
    }

    public TSet readSetBegin(byte type) throws TException {
        return new TSet(this.readListBegin(type));
    }

    @Override
    public void readMapEnd() throws TException {
    }

    @Override
    public void readListEnd() throws TException {
    }

    @Override
    public void readSetEnd() throws TException {
    }

    public static class Factory
    implements TProtocolFactory {
        @Override
        public TProtocol getProtocol(TTransport trans) {
            return new TTupleProtocol(trans);
        }
    }
}

