/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.thrift.transport;

import com.jetbrains.cef.remote.thrift.TByteArrayOutputStream;
import com.jetbrains.cef.remote.thrift.TConfiguration;
import com.jetbrains.cef.remote.thrift.transport.TEndpointTransport;
import com.jetbrains.cef.remote.thrift.transport.TTransportException;
import java.nio.charset.Charset;

public class TMemoryBuffer
extends TEndpointTransport {
    private TByteArrayOutputStream arr_;
    private int pos_;

    public TMemoryBuffer(int size) throws TTransportException {
        super(new TConfiguration());
        this.arr_ = new TByteArrayOutputStream(size);
        this.updateKnownMessageSize(size);
    }

    public TMemoryBuffer(TConfiguration config, int size) throws TTransportException {
        super(config);
        this.arr_ = new TByteArrayOutputStream(size);
        this.updateKnownMessageSize(size);
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public int read(byte[] buf, int off, int len) throws TTransportException {
        int amtToRead;
        this.checkReadBytesAvailable(len);
        byte[] src = this.arr_.get();
        int n2 = amtToRead = len > this.arr_.len() - this.pos_ ? this.arr_.len() - this.pos_ : len;
        if (amtToRead > 0) {
            System.arraycopy(src, this.pos_, buf, off, amtToRead);
            this.pos_ += amtToRead;
        }
        return amtToRead;
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.arr_.write(buf, off, len);
    }

    public String toString(Charset charset) {
        return this.arr_.toString(charset);
    }

    public String inspect() {
        StringBuilder buf = new StringBuilder();
        byte[] bytes = this.arr_.toByteArray();
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            buf.append(this.pos_ == i2 ? "==>" : "").append(Integer.toHexString(bytes[i2] & 0xFF)).append(" ");
        }
        return buf.toString();
    }

    public int length() {
        return this.arr_.size();
    }

    public byte[] getArray() {
        return this.arr_.get();
    }
}

