/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core.util;

import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Cloneables {
    public static Object clone(Object o2) {
        if (o2 instanceof Cloneable) {
            if (o2.getClass().isArray()) {
                Class<?> componentType = o2.getClass().getComponentType();
                if (!componentType.isPrimitive()) {
                    return ((Object[])o2).clone();
                }
                int length = Array.getLength(o2);
                Object clone = Array.newInstance(componentType, length);
                while (length-- > 0) {
                    Array.set(clone, length, Array.get(o2, length));
                }
                return clone;
            }
            try {
                Method clone = o2.getClass().getMethod("clone", null);
                return clone.invoke(o2, (Object[])null);
            }
            catch (NoSuchMethodException e2) {
                throw new ObjectAccessException("Cloneable type has no clone method", e2);
            }
            catch (IllegalAccessException e3) {
                throw new ObjectAccessException("Cannot clone Cloneable type", e3);
            }
            catch (InvocationTargetException e4) {
                throw new ObjectAccessException("Exception cloning Cloneable type", e4.getCause());
            }
        }
        return null;
    }

    public static Object cloneIfPossible(Object o2) {
        Object clone = Cloneables.clone(o2);
        return clone == null ? o2 : clone;
    }
}

