/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.persistence;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.persistence.AbstractFilePersistenceStrategy;
import com.thoughtworks.xstream.persistence.StreamStrategy;
import java.io.File;

public class FileStreamStrategy
extends AbstractFilePersistenceStrategy
implements StreamStrategy {
    public FileStreamStrategy(File baseDirectory) {
        this(baseDirectory, new XStream());
    }

    public FileStreamStrategy(File baseDirectory, XStream xstream) {
        super(baseDirectory, xstream, null);
    }

    protected Object extractKey(String name) {
        String key = this.unescape(name.substring(0, name.length() - 4));
        return key.equals("\u0000") ? null : key;
    }

    protected String unescape(String name) {
        StringBuffer buffer = new StringBuffer();
        char lastC = '\uffff';
        int currentValue = -1;
        char[] array = name.toCharArray();
        for (int i2 = 0; i2 < array.length; ++i2) {
            char c2 = array[i2];
            if (c2 == '_' && currentValue != -1) {
                if (lastC == '_') {
                    buffer.append('_');
                } else {
                    buffer.append((char)currentValue);
                }
                currentValue = -1;
            } else if (c2 == '_') {
                currentValue = 0;
            } else if (currentValue != -1) {
                currentValue = currentValue * 16 + Integer.parseInt(String.valueOf(c2), 16);
            } else {
                buffer.append(c2);
            }
            lastC = c2;
        }
        return buffer.toString();
    }

    protected String getName(Object key) {
        return this.escape(key == null ? "\u0000" : key.toString()) + ".xml";
    }

    protected String escape(String key) {
        StringBuffer buffer = new StringBuffer();
        char[] array = key.toCharArray();
        for (int i2 = 0; i2 < array.length; ++i2) {
            char c2 = array[i2];
            if (Character.isDigit(c2) || c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z') {
                buffer.append(c2);
                continue;
            }
            if (c2 == '_') {
                buffer.append("__");
                continue;
            }
            buffer.append("_" + Integer.toHexString(c2) + "_");
        }
        return buffer.toString();
    }
}

