/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.security;

import com.thoughtworks.xstream.security.RegExpTypePermission;

public class WildcardTypePermission
extends RegExpTypePermission {
    public WildcardTypePermission(String[] patterns) {
        this(false, patterns);
    }

    public WildcardTypePermission(boolean allowAnonymous, String[] patterns) {
        super(WildcardTypePermission.getRegExpPatterns(patterns, allowAnonymous));
    }

    private static String[] getRegExpPatterns(String[] wildcards, boolean allowAnonymous) {
        if (wildcards == null) {
            return null;
        }
        String[] regexps = new String[wildcards.length];
        for (int i2 = 0; i2 < wildcards.length; ++i2) {
            String wildcardExpression = wildcards[i2];
            StringBuffer result2 = new StringBuffer(wildcardExpression.length() * 2);
            result2.append("(?u)");
            int length = wildcardExpression.length();
            block6: for (int j2 = 0; j2 < length; ++j2) {
                char ch2 = wildcardExpression.charAt(j2);
                switch (ch2) {
                    case '$': 
                    case '(': 
                    case ')': 
                    case '+': 
                    case '.': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '^': 
                    case '|': {
                        result2.append('\\').append(ch2);
                        continue block6;
                    }
                    case '?': {
                        result2.append('.');
                        continue block6;
                    }
                    case '*': {
                        if (j2 + 1 < length && wildcardExpression.charAt(j2 + 1) == '*') {
                            result2.append(allowAnonymous ? "[\\P{C}]*" : "[\\P{C}&&[^$]]*(?:\\$[^0-9$][\\P{C}&&[^.$]]*)*");
                            ++j2;
                            continue block6;
                        }
                        result2.append(allowAnonymous ? "[\\P{C}&&[^.]]*" : "[\\P{C}&&[^.$]]*(?:\\$[^0-9$][\\P{C}&&[^.$]]*)*");
                        continue block6;
                    }
                    default: {
                        result2.append(ch2);
                    }
                }
            }
            regexps[i2] = result2.toString();
        }
        return regexps;
    }
}

