/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.BasicAutomata;
import dk.brics.automaton.State;
import dk.brics.automaton.StatePair;
import dk.brics.automaton.Transition;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class BasicOperations {
    private BasicOperations() {
    }

    public static Automaton concatenate(Automaton a1, Automaton a2) {
        boolean deterministic;
        if (a1.isSingleton() && a2.isSingleton()) {
            return BasicAutomata.makeString(a1.singleton + a2.singleton);
        }
        if (BasicOperations.isEmpty(a1) || BasicOperations.isEmpty(a2)) {
            return BasicAutomata.makeEmpty();
        }
        boolean bl2 = deterministic = a1.isSingleton() && a2.isDeterministic();
        if (a1 == a2) {
            a1 = a1.cloneExpanded();
            a2 = a2.cloneExpanded();
        } else {
            a1 = a1.cloneExpandedIfRequired();
            a2 = a2.cloneExpandedIfRequired();
        }
        for (State s2 : a1.getAcceptStates()) {
            s2.accept = false;
            s2.addEpsilon(a2.initial);
        }
        a1.deterministic = deterministic;
        a1.clearHashCode();
        a1.checkMinimizeAlways();
        return a1;
    }

    public static Automaton concatenate(List<Automaton> l2) {
        if (l2.isEmpty()) {
            return BasicAutomata.makeEmptyString();
        }
        boolean all_singleton = true;
        for (Automaton automaton : l2) {
            if (automaton.isSingleton()) continue;
            all_singleton = false;
            break;
        }
        if (all_singleton) {
            StringBuilder b2 = new StringBuilder();
            for (Automaton a3 : l2) {
                b2.append(a3.singleton);
            }
            return BasicAutomata.makeString(b2.toString());
        }
        for (Automaton automaton : l2) {
            if (!automaton.isEmpty()) continue;
            return BasicAutomata.makeEmpty();
        }
        HashSet<Integer> ids = new HashSet<Integer>();
        for (Automaton a4 : l2) {
            ids.add(System.identityHashCode(a4));
        }
        boolean bl2 = ids.size() != l2.size();
        Automaton b3 = l2.get(0);
        b3 = bl2 ? b3.cloneExpanded() : b3.cloneExpandedIfRequired();
        Set<State> ac2 = b3.getAcceptStates();
        boolean first2 = true;
        for (Automaton a5 : l2) {
            if (first2) {
                first2 = false;
                continue;
            }
            if (a5.isEmptyString()) continue;
            Automaton aa2 = a5;
            aa2 = bl2 ? aa2.cloneExpanded() : aa2.cloneExpandedIfRequired();
            Set<State> ns = aa2.getAcceptStates();
            for (State s2 : ac2) {
                s2.accept = false;
                s2.addEpsilon(aa2.initial);
                if (!s2.accept) continue;
                ns.add(s2);
            }
            ac2 = ns;
        }
        b3.deterministic = false;
        b3.clearHashCode();
        b3.checkMinimizeAlways();
        return b3;
    }

    public static Automaton optional(Automaton a2) {
        a2 = a2.cloneExpandedIfRequired();
        State s2 = new State();
        s2.addEpsilon(a2.initial);
        s2.accept = true;
        a2.initial = s2;
        a2.deterministic = false;
        a2.clearHashCode();
        a2.checkMinimizeAlways();
        return a2;
    }

    public static Automaton repeat(Automaton a2) {
        a2 = a2.cloneExpanded();
        State s2 = new State();
        s2.accept = true;
        s2.addEpsilon(a2.initial);
        for (State p2 : a2.getAcceptStates()) {
            p2.addEpsilon(s2);
        }
        a2.initial = s2;
        a2.deterministic = false;
        a2.clearHashCode();
        a2.checkMinimizeAlways();
        return a2;
    }

    public static Automaton repeat(Automaton a2, int min) {
        if (min == 0) {
            return BasicOperations.repeat(a2);
        }
        ArrayList<Automaton> as2 = new ArrayList<Automaton>();
        while (min-- > 0) {
            as2.add(a2);
        }
        as2.add(BasicOperations.repeat(a2));
        return BasicOperations.concatenate(as2);
    }

    public static Automaton repeat(Automaton a2, int min, int max) {
        Automaton b2;
        if (min > max) {
            return BasicAutomata.makeEmpty();
        }
        max -= min;
        a2.expandSingleton();
        if (min == 0) {
            b2 = BasicAutomata.makeEmptyString();
        } else if (min == 1) {
            b2 = a2.clone();
        } else {
            ArrayList<Automaton> as2 = new ArrayList<Automaton>();
            while (min-- > 0) {
                as2.add(a2);
            }
            b2 = BasicOperations.concatenate(as2);
        }
        if (max > 0) {
            Automaton d2 = a2.clone();
            while (--max > 0) {
                Automaton c2 = a2.clone();
                for (State p2 : c2.getAcceptStates()) {
                    p2.addEpsilon(d2.initial);
                }
                d2 = c2;
            }
            for (State p3 : b2.getAcceptStates()) {
                p3.addEpsilon(d2.initial);
            }
            b2.deterministic = false;
            b2.clearHashCode();
            b2.checkMinimizeAlways();
        }
        return b2;
    }

    public static Automaton complement(Automaton a2) {
        a2 = a2.cloneExpandedIfRequired();
        a2.determinize();
        a2.totalize();
        for (State p2 : a2.getStates()) {
            p2.accept = !p2.accept;
        }
        a2.removeDeadTransitions();
        return a2;
    }

    public static Automaton minus(Automaton a1, Automaton a2) {
        if (a1.isEmpty() || a1 == a2) {
            return BasicAutomata.makeEmpty();
        }
        if (a2.isEmpty()) {
            return a1.cloneIfRequired();
        }
        if (a1.isSingleton()) {
            if (a2.run(a1.singleton)) {
                return BasicAutomata.makeEmpty();
            }
            return a1.cloneIfRequired();
        }
        return BasicOperations.intersection(a1, a2.complement());
    }

    public static Automaton intersection(Automaton a1, Automaton a2) {
        if (a1.isSingleton()) {
            if (a2.run(a1.singleton)) {
                return a1.cloneIfRequired();
            }
            return BasicAutomata.makeEmpty();
        }
        if (a2.isSingleton()) {
            if (a1.run(a2.singleton)) {
                return a2.cloneIfRequired();
            }
            return BasicAutomata.makeEmpty();
        }
        if (a1 == a2) {
            return a1.cloneIfRequired();
        }
        Transition[][] transitions1 = Automaton.getSortedTransitions(a1.getStates());
        Transition[][] transitions2 = Automaton.getSortedTransitions(a2.getStates());
        Automaton c2 = new Automaton();
        LinkedList<StatePair> worklist = new LinkedList<StatePair>();
        HashMap<StatePair, StatePair> newstates = new HashMap<StatePair, StatePair>();
        StatePair p2 = new StatePair(c2.initial, a1.initial, a2.initial);
        worklist.add(p2);
        newstates.put(p2, p2);
        while (worklist.size() > 0) {
            p2 = (StatePair)worklist.removeFirst();
            p2.s.accept = p2.s1.accept && p2.s2.accept;
            Transition[] t1 = transitions1[p2.s1.number];
            Transition[] t2 = transitions2[p2.s2.number];
            int b2 = 0;
            for (int n1 = 0; n1 < t1.length; ++n1) {
                while (b2 < t2.length && t2[b2].max < t1[n1].min) {
                    ++b2;
                }
                for (int n2 = b2; n2 < t2.length && t1[n1].max >= t2[n2].min; ++n2) {
                    if (t2[n2].max < t1[n1].min) continue;
                    StatePair q2 = new StatePair(t1[n1].to, t2[n2].to);
                    StatePair r2 = (StatePair)newstates.get(q2);
                    if (r2 == null) {
                        q2.s = new State();
                        worklist.add(q2);
                        newstates.put(q2, q2);
                        r2 = q2;
                    }
                    char min = t1[n1].min > t2[n2].min ? t1[n1].min : t2[n2].min;
                    char max = t1[n1].max < t2[n2].max ? t1[n1].max : t2[n2].max;
                    p2.s.transitions.add(new Transition(min, max, r2.s));
                }
            }
        }
        c2.deterministic = a1.deterministic && a2.deterministic;
        c2.removeDeadTransitions();
        c2.checkMinimizeAlways();
        return c2;
    }

    public static boolean subsetOf(Automaton a1, Automaton a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1.isSingleton()) {
            if (a2.isSingleton()) {
                return a1.singleton.equals(a2.singleton);
            }
            return a2.run(a1.singleton);
        }
        a2.determinize();
        Transition[][] transitions1 = Automaton.getSortedTransitions(a1.getStates());
        Transition[][] transitions2 = Automaton.getSortedTransitions(a2.getStates());
        LinkedList<StatePair> worklist = new LinkedList<StatePair>();
        HashSet<StatePair> visited = new HashSet<StatePair>();
        StatePair p2 = new StatePair(a1.initial, a2.initial);
        worklist.add(p2);
        visited.add(p2);
        while (worklist.size() > 0) {
            p2 = (StatePair)worklist.removeFirst();
            if (p2.s1.accept && !p2.s2.accept) {
                return false;
            }
            Transition[] t1 = transitions1[p2.s1.number];
            Transition[] t2 = transitions2[p2.s2.number];
            int b2 = 0;
            for (int n1 = 0; n1 < t1.length; ++n1) {
                while (b2 < t2.length && t2[b2].max < t1[n1].min) {
                    ++b2;
                }
                char min1 = t1[n1].min;
                char max1 = t1[n1].max;
                for (int n2 = b2; n2 < t2.length && t1[n1].max >= t2[n2].min; ++n2) {
                    if (t2[n2].min > min1) {
                        return false;
                    }
                    if (t2[n2].max < '\uffff') {
                        min1 = t2[n2].max + '\u0001';
                    } else {
                        min1 = '\uffff';
                        max1 = '\u0000';
                    }
                    StatePair q2 = new StatePair(t1[n1].to, t2[n2].to);
                    if (visited.contains(q2)) continue;
                    worklist.add(q2);
                    visited.add(q2);
                }
                if (min1 > max1) continue;
                return false;
            }
        }
        return true;
    }

    public static Automaton union(Automaton a1, Automaton a2) {
        if (a1.isSingleton() && a2.isSingleton() && a1.singleton.equals(a2.singleton) || a1 == a2) {
            return a1.cloneIfRequired();
        }
        a1 = a1.cloneExpandedIfRequired();
        a2 = a2.cloneExpandedIfRequired();
        State s2 = new State();
        s2.addEpsilon(a1.initial);
        s2.addEpsilon(a2.initial);
        a1.initial = s2;
        a1.deterministic = false;
        a1.clearHashCode();
        a1.checkMinimizeAlways();
        return a1;
    }

    public static Automaton union(Collection<Automaton> l2) {
        HashSet<Integer> ids = new HashSet<Integer>();
        for (Automaton a2 : l2) {
            ids.add(System.identityHashCode(a2));
        }
        boolean has_aliases = ids.size() != l2.size();
        State s2 = new State();
        for (Automaton b2 : l2) {
            if (b2.isEmpty()) continue;
            Automaton bb2 = b2;
            bb2 = has_aliases ? bb2.cloneExpanded() : bb2.cloneExpandedIfRequired();
            s2.addEpsilon(bb2.initial);
        }
        Automaton a3 = new Automaton();
        a3.initial = s2;
        a3.deterministic = false;
        a3.clearHashCode();
        a3.checkMinimizeAlways();
        return a3;
    }

    public static void determinize(Automaton a2) {
        if (a2.deterministic || a2.isSingleton()) {
            return;
        }
        HashSet<State> initialset = new HashSet<State>();
        initialset.add(a2.initial);
        BasicOperations.determinize(a2, initialset);
    }

    static void determinize(Automaton a2, Set<State> initialset) {
        char[] points = a2.getStartPoints();
        LinkedList<Set<State>> worklist = new LinkedList<Set<State>>();
        HashMap<Set<State>, State> newstate = new HashMap<Set<State>, State>();
        worklist.add(initialset);
        a2.initial = new State();
        newstate.put(initialset, a2.initial);
        while (worklist.size() > 0) {
            Set s2 = (Set)worklist.removeFirst();
            State r2 = (State)newstate.get(s2);
            for (State q2 : s2) {
                if (!q2.accept) continue;
                r2.accept = true;
                break;
            }
            for (int n2 = 0; n2 < points.length; ++n2) {
                HashSet<State> p2 = new HashSet<State>();
                for (State q3 : s2) {
                    for (Transition t2 : q3.transitions) {
                        if (t2.min > points[n2] || points[n2] > t2.max) continue;
                        p2.add(t2.to);
                    }
                }
                if (p2.isEmpty()) continue;
                State q4 = (State)newstate.get(p2);
                if (q4 == null) {
                    worklist.add(p2);
                    q4 = new State();
                    newstate.put(p2, q4);
                }
                char min = points[n2];
                char max = n2 + 1 < points.length ? (char)((char)(points[n2 + 1] - '\u0001')) : (char)'\uffff';
                r2.transitions.add(new Transition(min, max, q4));
            }
        }
        a2.deterministic = true;
        a2.removeDeadTransitions();
    }

    public static void addEpsilons(Automaton a2, Collection<StatePair> pairs) {
        a2.expandSingleton();
        HashMap<State, HashSet<State>> forward = new HashMap<State, HashSet<State>>();
        HashMap<State, HashSet<State>> back = new HashMap<State, HashSet<State>>();
        for (StatePair p2 : pairs) {
            HashSet<State> to = (HashSet<State>)forward.get(p2.s1);
            if (to == null) {
                to = new HashSet<State>();
                forward.put(p2.s1, to);
            }
            to.add(p2.s2);
            HashSet<State> from = (HashSet<State>)back.get(p2.s2);
            if (from == null) {
                from = new HashSet<State>();
                back.put(p2.s2, from);
            }
            from.add(p2.s1);
        }
        LinkedList<StatePair> worklist = new LinkedList<StatePair>(pairs);
        HashSet<StatePair> workset = new HashSet<StatePair>(pairs);
        while (!worklist.isEmpty()) {
            StatePair p3 = worklist.removeFirst();
            workset.remove(p3);
            HashSet to = (HashSet)forward.get(p3.s2);
            HashSet from = (HashSet)back.get(p3.s1);
            if (to == null) continue;
            for (State s2 : to) {
                StatePair pp = new StatePair(p3.s1, s2);
                if (pairs.contains(pp)) continue;
                pairs.add(pp);
                ((HashSet)forward.get(p3.s1)).add(s2);
                ((HashSet)back.get(s2)).add(p3.s1);
                worklist.add(pp);
                workset.add(pp);
                if (from == null) continue;
                for (State q2 : from) {
                    StatePair qq = new StatePair(q2, p3.s1);
                    if (workset.contains(qq)) continue;
                    worklist.add(qq);
                    workset.add(qq);
                }
            }
        }
        for (StatePair p4 : pairs) {
            p4.s1.addEpsilon(p4.s2);
        }
        a2.deterministic = false;
        a2.clearHashCode();
        a2.checkMinimizeAlways();
    }

    public static boolean isEmptyString(Automaton a2) {
        if (a2.isSingleton()) {
            return a2.singleton.length() == 0;
        }
        return a2.initial.accept && a2.initial.transitions.isEmpty();
    }

    public static boolean isEmpty(Automaton a2) {
        if (a2.isSingleton()) {
            return false;
        }
        return !a2.initial.accept && a2.initial.transitions.isEmpty();
    }

    public static boolean isTotal(Automaton a2) {
        if (a2.isSingleton()) {
            return false;
        }
        if (a2.initial.accept && a2.initial.transitions.size() == 1) {
            Transition t2 = a2.initial.transitions.iterator().next();
            return t2.to == a2.initial && t2.min == '\u0000' && t2.max == '\uffff';
        }
        return false;
    }

    public static String getShortestExample(Automaton a2, boolean accepted) {
        if (a2.isSingleton()) {
            if (accepted) {
                return a2.singleton;
            }
            if (a2.singleton.length() > 0) {
                return "";
            }
            return "\u0000";
        }
        return BasicOperations.getShortestExample(a2.getInitialState(), accepted);
    }

    static String getShortestExample(State s2, boolean accepted) {
        HashMap<State, String> path = new HashMap<State, String>();
        LinkedList<State> queue = new LinkedList<State>();
        path.put(s2, "");
        queue.add(s2);
        String best = null;
        while (!queue.isEmpty()) {
            State q2 = (State)queue.removeFirst();
            String p2 = (String)path.get(q2);
            if (q2.accept == accepted) {
                if (best != null && p2.length() >= best.length() && (p2.length() != best.length() || p2.compareTo(best) >= 0)) continue;
                best = p2;
                continue;
            }
            for (Transition t2 : q2.getTransitions()) {
                String tp = (String)path.get(t2.to);
                String np = p2 + t2.min;
                if (tp != null && (tp.length() != np.length() || np.compareTo(tp) >= 0)) continue;
                if (tp == null) {
                    queue.addLast(t2.to);
                }
                path.put(t2.to, np);
            }
        }
        return best;
    }

    public static boolean run(Automaton a2, String s2) {
        if (a2.isSingleton()) {
            return s2.equals(a2.singleton);
        }
        if (a2.deterministic) {
            State p2 = a2.initial;
            for (int i2 = 0; i2 < s2.length(); ++i2) {
                State q2 = p2.step(s2.charAt(i2));
                if (q2 == null) {
                    return false;
                }
                p2 = q2;
            }
            return p2.accept;
        }
        Set<State> states = a2.getStates();
        Automaton.setStateNumbers(states);
        LinkedList<State> pp = new LinkedList<State>();
        LinkedList<State> pp_other = new LinkedList<State>();
        BitSet bb2 = new BitSet(states.size());
        BitSet bb_other = new BitSet(states.size());
        pp.add(a2.initial);
        ArrayList<State> dest = new ArrayList<State>();
        boolean accept = a2.initial.accept;
        for (int i3 = 0; i3 < s2.length(); ++i3) {
            char c2 = s2.charAt(i3);
            accept = false;
            pp_other.clear();
            bb_other.clear();
            for (State p3 : pp) {
                dest.clear();
                p3.step(c2, dest);
                for (State q3 : dest) {
                    if (q3.accept) {
                        accept = true;
                    }
                    if (bb_other.get(q3.number)) continue;
                    bb_other.set(q3.number);
                    pp_other.add(q3);
                }
            }
            LinkedList<State> tp = pp;
            pp = pp_other;
            pp_other = tp;
            BitSet tb = bb2;
            bb2 = bb_other;
            bb_other = tb;
        }
        return accept;
    }
}

