/*
 * Decompiled with CFR 0.152.
 */
package fleet.fastutil.longs;

import fleet.fastutil.Arrays;
import fleet.fastutil.HashCommon;
import fleet.fastutil.longs.LongArrayList;
import fleet.fastutil.longs.LongIterator;
import fleet.fastutil.longs.LongList;
import fleet.fastutil.longs.LongListExtensionsKt;
import fleet.fastutil.longs.LongSet;
import fleet.fastutil.longs.LongSetExtensionsKt;
import fleet.fastutil.longs.MutableLongIterator;
import fleet.fastutil.longs.MutableLongSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0012\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 >2\u00020\u0001:\u0002=>B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u001b\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\nB!\b\u0016\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\rB\u001b\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0010B+\b\u0016\u0012\u0006\u0010\u0011\u001a\u00020\t\u0012\u0006\u0010\u0012\u001a\u00020\u0003\u0012\u0006\u0010\u0013\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0014J\b\u0010&\u001a\u00020\u0003H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0003H\u0002J\u0010\u0010*\u001a\u00020(2\u0006\u0010)\u001a\u00020\fH\u0002J\u0014\u0010+\u001a\u00020\u00192\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u000e\u0010+\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\tJ\u0010\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\fH\u0016J\u0010\u0010/\u001a\u00020(2\u0006\u00100\u001a\u00020\u0003H\u0002J\u0010\u00101\u001a\u00020\u00192\u0006\u00100\u001a\u00020\u0003H\u0002J\b\u00102\u001a\u00020\u0019H\u0002J\u0010\u00103\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\fH\u0016J\u0011\u00104\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\fH\u0096\u0002J\u0006\u00105\u001a\u00020(J\u0010\u00106\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u0003J\u0010\u00107\u001a\u00020(2\u0006\u00108\u001a\u00020\u0003H\u0002J\u0013\u00109\u001a\u00020\u00192\b\u0010:\u001a\u0004\u0018\u00010;H\u0096\u0002J\b\u0010<\u001a\u00020\u0003H\u0016R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006?"}, d2={"Lfleet/fastutil/longs/LongOpenHashSet;", "Lfleet/fastutil/longs/MutableLongSet;", "expected", "", "f", "", "<init>", "(IF)V", "c", "Lfleet/fastutil/longs/LongList;", "(Lfleet/fastutil/longs/LongList;F)V", "", "", "(Ljava/util/Collection;F)V", "i", "Lfleet/fastutil/longs/LongIterator;", "(Lfleet/fastutil/longs/LongIterator;F)V", "a", "offset", "length", "(Lfleet/fastutil/longs/LongList;IIF)V", "key", "", "mask", "containsNull", "", "n", "maxFill", "minN", "size", "getSize", "()I", "setSize", "(I)V", "values", "Lfleet/fastutil/longs/MutableLongIterator;", "getValues", "()Lfleet/fastutil/longs/MutableLongIterator;", "realSize", "ensureCapacity", "", "capacity", "tryCapacity", "addAll", "elements", "add", "element", "shiftKeys", "pos", "removeEntry", "removeNullEntry", "remove", "contains", "clear", "trim", "rehash", "newN", "equals", "other", "", "hashCode", "SetIterator", "Companion", "fleet.fastutil"})
@SourceDebugExtension(value={"SMAP\nLongOpenHashSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongOpenHashSet.kt\nfleet/fastutil/longs/LongOpenHashSet\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,548:1\n1#2:549\n*E\n"})
public final class LongOpenHashSet
implements MutableLongSet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private long[] key;
    private int mask;
    private boolean containsNull;
    private int n;
    private int maxFill;
    private final int minN;
    private int size;
    private final float f;

    public LongOpenHashSet(int expected, float f2) {
        if (f2 <= 0.0f || f2 >= 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f2;
        this.minN = this.n = HashCommon.INSTANCE.arraySize(expected, f2);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.INSTANCE.maxFill(this.n, f2);
        this.key = new long[this.n + 1];
    }

    public /* synthetic */ LongOpenHashSet(int n2, float f2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n2 = 16;
        }
        if ((n3 & 2) != 0) {
            f2 = 0.75f;
        }
        this(n2, f2);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public void setSize(int n2) {
        this.size = n2;
    }

    @Override
    @NotNull
    public MutableLongIterator getValues() {
        return new SetIterator();
    }

    public LongOpenHashSet(@NotNull LongList c2, float f2) {
        Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
        this(c2.getSize(), f2);
        this.addAll(c2);
    }

    public /* synthetic */ LongOpenHashSet(LongList longList, float f2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            f2 = 0.75f;
        }
        this(longList, f2);
    }

    public LongOpenHashSet(@NotNull Collection<Long> c2, float f2) {
        Intrinsics.checkNotNullParameter(c2, (String)"c");
        this(c2.size(), f2);
        this.addAll(c2);
    }

    public /* synthetic */ LongOpenHashSet(Collection collection, float f2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            f2 = 0.75f;
        }
        this(collection, f2);
    }

    public LongOpenHashSet(@NotNull LongIterator i2, float f2) {
        Intrinsics.checkNotNullParameter((Object)i2, (String)"i");
        this(16, f2);
        while (i2.hasNext()) {
            this.add(i2.next());
        }
    }

    public /* synthetic */ LongOpenHashSet(LongIterator longIterator, float f2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            f2 = 0.75f;
        }
        this(longIterator, f2);
    }

    public LongOpenHashSet(@NotNull LongList a2, int offset, int length, float f2) {
        Intrinsics.checkNotNullParameter((Object)a2, (String)"a");
        this(length < 0 ? 0 : length, f2);
        Arrays.INSTANCE.ensureOffsetLength(a2, offset, length);
        for (int i2 = 0; i2 < length; ++i2) {
            this.add(a2.get(offset + i2));
        }
    }

    public /* synthetic */ LongOpenHashSet(LongList longList, int n2, int n3, float f2, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 8) != 0) {
            f2 = 0.75f;
        }
        this(longList, n2, n3, f2);
    }

    private final int realSize() {
        return this.containsNull ? this.getSize() - 1 : this.getSize();
    }

    private final void ensureCapacity(int capacity) {
        int needed = HashCommon.INSTANCE.arraySize(capacity, this.f);
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    private final void tryCapacity(long capacity) {
        int needed = Math.min(0x40000000, Math.max(2, (int)HashCommon.INSTANCE.nextPowerOfTwo((long)Math.ceil((float)capacity / this.f))));
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    public final boolean addAll(@NotNull Collection<Long> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(elements.size());
        } else {
            this.tryCapacity(this.getSize() + elements.size());
        }
        boolean retVal = false;
        Iterator<Long> i2 = elements.iterator();
        while (i2.hasNext()) {
            if (!this.add(((Number)i2.next()).longValue())) continue;
            retVal = true;
        }
        return retVal;
    }

    public final boolean addAll(@NotNull LongList elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(elements.getSize());
        } else {
            this.tryCapacity(this.getSize() + elements.getSize());
        }
        boolean modified = false;
        IntRange intRange = LongListExtensionsKt.getIndices(elements);
        int index = intRange.getFirst();
        int n2 = intRange.getLast();
        if (index <= n2) {
            while (true) {
                if (this.add(elements.get(index))) {
                    modified = true;
                }
                if (index == n2) break;
                ++index;
            }
        }
        return modified;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean add(long element) {
        int pos = 0;
        if (element == 0L) {
            if (this.containsNull) {
                return false;
            }
            this.containsNull = true;
        } else {
            block7: {
                long l2;
                void it;
                int n2;
                long curr = 0L;
                long[] key = this.key;
                int n3 = n2 = (int)HashCommon.INSTANCE.mix(element) & this.mask;
                long[] lArray = key;
                boolean bl2 = false;
                pos = it;
                long it32 = l2 = lArray[n2];
                boolean bl3 = false;
                curr = it32;
                if (l2 != 0L) {
                    if (curr == element) {
                        return false;
                    }
                    do {
                        int n4;
                        int it32 = n4 = pos + 1 & this.mask;
                        lArray = key;
                        boolean bl4 = false;
                        pos = it32;
                        it32 = l2 = lArray[n4];
                        boolean bl5 = false;
                        curr = it32;
                        if (l2 == 0L) break block7;
                    } while (curr != element);
                    return false;
                }
            }
            key[pos] = element;
        }
        int n5 = this.getSize();
        this.setSize(n5 + 1);
        if (n5 >= this.maxFill) {
            this.rehash(HashCommon.INSTANCE.arraySize(this.getSize() + 1, this.f));
        }
        return true;
    }

    private final void shiftKeys(int pos) {
        int pos2 = pos;
        int last = 0;
        int slot2 = 0;
        long curr = 0L;
        long[] key = this.key;
        while (true) {
            int n2;
            int it = n2 = pos2;
            boolean bl2 = false;
            last = it;
            pos2 = n2 + 1 & this.mask;
            while (true) {
                long l2;
                long it2 = l2 = key[pos2];
                boolean bl3 = false;
                curr = it2;
                if (l2 == 0L) {
                    key[last] = 0L;
                    return;
                }
                slot2 = (int)HashCommon.INSTANCE.mix(curr) & this.mask;
                if (last <= pos2 ? last >= slot2 || slot2 > pos2 : (pos2 + 1 <= slot2 ? slot2 <= last : false)) break;
                pos2 = pos2 + 1 & this.mask;
            }
            key[last] = curr;
        }
    }

    private final boolean removeEntry(int pos) {
        int n2 = this.getSize();
        this.setSize(n2 + -1);
        this.shiftKeys(pos);
        if (this.n > this.minN && this.getSize() < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return true;
    }

    private final boolean removeNullEntry() {
        this.containsNull = false;
        this.key[this.n] = 0L;
        int n2 = this.getSize();
        this.setSize(n2 + -1);
        if (this.n > this.minN && this.getSize() < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean remove(long element) {
        long l2;
        void it;
        int n2;
        if (element == 0L) {
            if (this.containsNull) {
                return this.removeNullEntry();
            }
            return false;
        }
        long curr = 0L;
        long[] key = this.key;
        int pos = 0;
        int n3 = n2 = (int)HashCommon.INSTANCE.mix(element) & this.mask;
        long[] lArray = key;
        boolean bl2 = false;
        pos = it;
        long it32 = l2 = lArray[n2];
        boolean bl3 = false;
        curr = it32;
        if (l2 == 0L) {
            return false;
        }
        if (element == curr) {
            return this.removeEntry(pos);
        }
        do {
            int n4;
            int it32 = n4 = pos + 1 & this.mask;
            lArray = key;
            boolean bl4 = false;
            pos = it32;
            it32 = l2 = lArray[n4];
            boolean bl5 = false;
            curr = it32;
            if (l2 != 0L) continue;
            return false;
        } while (element != curr);
        return this.removeEntry(pos);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(long element) {
        long l2;
        void it;
        int n2;
        if (element == 0L) {
            return this.containsNull;
        }
        long curr = 0L;
        long[] key = this.key;
        int pos = 0;
        int n3 = n2 = (int)HashCommon.INSTANCE.mix(element) & this.mask;
        long[] lArray = key;
        boolean bl2 = false;
        pos = it;
        long it32 = l2 = lArray[n2];
        boolean bl3 = false;
        curr = it32;
        if (l2 == 0L) {
            return false;
        }
        if (element == curr) {
            return true;
        }
        do {
            int n4;
            int it32 = n4 = pos + 1 & this.mask;
            lArray = key;
            boolean bl4 = false;
            pos = it32;
            it32 = l2 = lArray[n4];
            boolean bl5 = false;
            curr = it32;
            if (l2 != 0L) continue;
            return false;
        } while (element != curr);
        return true;
    }

    public final void clear() {
        if (this.getSize() == 0) {
            return;
        }
        this.setSize(0);
        this.containsNull = false;
        ArraysKt.fill$default((long[])this.key, (long)0L, (int)0, (int)0, (int)6, null);
    }

    public final boolean trim(int n2) {
        int l2 = HashCommon.INSTANCE.nextPowerOfTwo((int)Math.ceil((float)n2 / this.f));
        if (l2 >= this.n || this.getSize() > HashCommon.INSTANCE.maxFill(l2, this.f)) {
            return true;
        }
        try {
            this.rehash(l2);
        }
        catch (Throwable cantDoIt) {
            return false;
        }
        return true;
    }

    public static /* synthetic */ boolean trim$default(LongOpenHashSet longOpenHashSet, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n2 = longOpenHashSet.getSize();
        }
        return longOpenHashSet.trim(n2);
    }

    private final void rehash(int newN) {
        long[] key = this.key;
        int mask = newN - 1;
        long[] newKey = new long[newN + 1];
        int i2 = this.n;
        int pos = 0;
        int j2 = this.realSize();
        while (j2-- != 0) {
            int it;
            int n2;
            while (key[--i2] == 0L) {
            }
            int n3 = n2 = (int)HashCommon.INSTANCE.mix(key[i2]) & mask;
            long[] lArray = newKey;
            boolean bl2 = false;
            pos = it;
            if (lArray[n2] != 0L) {
                do {
                    it = n2 = pos + 1 & mask;
                    lArray = newKey;
                    boolean bl3 = false;
                    pos = it;
                } while (lArray[n2] != 0L);
            }
            newKey[pos] = key[i2];
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.INSTANCE.maxFill(this.n, this.f);
        this.key = newKey;
    }

    public boolean equals(@Nullable Object other) {
        if (other == null) {
            return false;
        }
        if (super.equals(other)) {
            return true;
        }
        if (other instanceof LongSet) {
            if (((LongSet)other).getSize() != this.getSize()) {
                return false;
            }
            return LongSetExtensionsKt.containsAll(this, (LongSet)other);
        }
        return false;
    }

    public int hashCode() {
        int h7 = 0;
        long[] key = this.key;
        int j2 = this.realSize();
        int i2 = 0;
        while (j2-- != 0) {
            while (key[i2] == 0L) {
                ++i2;
            }
            h7 += (int)key[i2];
            ++i2;
        }
        return h7;
    }

    public LongOpenHashSet() {
        this(0, 0.0f, 3, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0016\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007J\u0012\u0010\u0004\u001a\u00020\u00052\n\u0010\u000b\u001a\u00020\f\"\u00020\u0007\u00a8\u0006\r"}, d2={"Lfleet/fastutil/longs/LongOpenHashSet$Companion;", "", "<init>", "()V", "of", "Lfleet/fastutil/longs/LongOpenHashSet;", "e", "", "e0", "e1", "e2", "a", "", "fleet.fastutil"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LongOpenHashSet of() {
            return new LongOpenHashSet(0, 0.0f, 3, null);
        }

        @NotNull
        public final LongOpenHashSet of(long e2) {
            LongOpenHashSet result2 = new LongOpenHashSet(1, 0.75f);
            result2.add(e2);
            return result2;
        }

        @NotNull
        public final LongOpenHashSet of(long e0, long e1) {
            LongOpenHashSet result2 = new LongOpenHashSet(2, 0.75f);
            result2.add(e0);
            if (!result2.add(e1)) {
                throw new IllegalArgumentException("Duplicate element: " + e1);
            }
            return result2;
        }

        @NotNull
        public final LongOpenHashSet of(long e0, long e1, long e2) {
            LongOpenHashSet result2 = new LongOpenHashSet(3, 0.75f);
            result2.add(e0);
            if (!result2.add(e1)) {
                throw new IllegalArgumentException("Duplicate element: " + e1);
            }
            if (!result2.add(e2)) {
                throw new IllegalArgumentException("Duplicate element: " + e2);
            }
            return result2;
        }

        @NotNull
        public final LongOpenHashSet of(long ... a2) {
            Intrinsics.checkNotNullParameter((Object)a2, (String)"a");
            LongOpenHashSet result2 = new LongOpenHashSet(a2.length, 0.75f);
            for (long element : a2) {
                if (result2.add(element)) continue;
                throw new IllegalArgumentException("Duplicate element " + element);
            }
            return result2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u001c\u001a\u00020\u0011H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020 2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\""}, d2={"Lfleet/fastutil/longs/LongOpenHashSet$SetIterator;", "Lfleet/fastutil/longs/MutableLongIterator;", "<init>", "(Lfleet/fastutil/longs/LongOpenHashSet;)V", "pos", "", "getPos", "()I", "setPos", "(I)V", "last", "getLast", "setLast", "c", "getC", "setC", "mustReturnNull", "", "getMustReturnNull", "()Z", "setMustReturnNull", "(Z)V", "wrapped", "Lfleet/fastutil/longs/LongArrayList;", "getWrapped", "()Lfleet/fastutil/longs/LongArrayList;", "setWrapped", "(Lfleet/fastutil/longs/LongArrayList;)V", "hasNext", "next", "", "remove", "", "shiftKeys", "fleet.fastutil"})
    @SourceDebugExtension(value={"SMAP\nLongOpenHashSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongOpenHashSet.kt\nfleet/fastutil/longs/LongOpenHashSet$SetIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,548:1\n1#2:549\n*E\n"})
    private final class SetIterator
    implements MutableLongIterator {
        private int pos;
        private int last;
        private int c;
        private boolean mustReturnNull;
        public LongArrayList wrapped;

        public SetIterator() {
            this.pos = LongOpenHashSet.this.n;
            this.last = -1;
            this.c = LongOpenHashSet.this.getSize();
            this.mustReturnNull = LongOpenHashSet.this.containsNull;
        }

        public final int getPos() {
            return this.pos;
        }

        public final void setPos(int n2) {
            this.pos = n2;
        }

        public final int getLast() {
            return this.last;
        }

        public final void setLast(int n2) {
            this.last = n2;
        }

        public final int getC() {
            return this.c;
        }

        public final void setC(int n2) {
            this.c = n2;
        }

        public final boolean getMustReturnNull() {
            return this.mustReturnNull;
        }

        public final void setMustReturnNull(boolean bl2) {
            this.mustReturnNull = bl2;
        }

        @NotNull
        public final LongArrayList getWrapped() {
            LongArrayList longArrayList = this.wrapped;
            if (longArrayList != null) {
                return longArrayList;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"wrapped");
            return null;
        }

        public final void setWrapped(@NotNull LongArrayList longArrayList) {
            Intrinsics.checkNotNullParameter((Object)longArrayList, (String)"<set-?>");
            this.wrapped = longArrayList;
        }

        @Override
        public boolean hasNext() {
            return this.c != 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public long next() {
            void it;
            int n2;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int n3 = this.c;
            this.c = n3 + -1;
            long[] key = LongOpenHashSet.this.key;
            if (this.mustReturnNull) {
                this.mustReturnNull = false;
                this.last = LongOpenHashSet.this.n;
                return key[LongOpenHashSet.this.n];
            }
            do {
                this.pos += -1;
                if (this.pos >= 0) continue;
                this.last = Integer.MIN_VALUE;
                return this.getWrapped().get(-this.pos - 1);
            } while (key[this.pos] == 0L);
            int n4 = n2 = this.pos;
            long[] lArray = key;
            boolean bl2 = false;
            this.last = it;
            return lArray[n2];
        }

        @Override
        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            if (this.last == LongOpenHashSet.this.n) {
                LongOpenHashSet.this.containsNull = false;
                ((LongOpenHashSet)LongOpenHashSet.this).key[((LongOpenHashSet)LongOpenHashSet.this).n] = 0L;
            } else if (this.pos >= 0) {
                this.shiftKeys(this.last);
            } else {
                LongOpenHashSet.this.remove(this.getWrapped().get(-this.pos - 1));
                this.last = -1;
                return;
            }
            int n2 = LongOpenHashSet.this.getSize();
            LongOpenHashSet.this.setSize(n2 + -1);
            this.last = -1;
        }

        private final void shiftKeys(int pos) {
            int pos2 = pos;
            int last = 0;
            long slot2 = 0L;
            long curr = 0L;
            long[] key = LongOpenHashSet.this.key;
            while (true) {
                int n2;
                int it = n2 = pos2;
                boolean bl2 = false;
                last = it;
                pos2 = n2 + 1 & LongOpenHashSet.this.mask;
                while (true) {
                    long l2;
                    long it2 = l2 = key[pos2];
                    boolean bl3 = false;
                    curr = it2;
                    if (l2 == 0L) {
                        key[last] = 0L;
                        return;
                    }
                    slot2 = HashCommon.INSTANCE.mix(curr) & (long)LongOpenHashSet.this.mask;
                    if (last <= pos2 ? (long)last >= slot2 || slot2 > (long)pos2 : ((long)(pos2 + 1) <= slot2 ? slot2 <= (long)last : false)) break;
                    pos2 = pos2 + 1 & LongOpenHashSet.this.mask;
                }
                if (pos2 < last) {
                    if (this.wrapped == null) {
                        this.setWrapped(new LongArrayList(2));
                    }
                    this.getWrapped().add(key[pos2]);
                }
                key[last] = curr;
            }
        }
    }
}

