/*
 * Decompiled with CFR 0.152.
 */
package fleet.fastutil.longs;

import fleet.fastutil.longs.LongArrays;
import fleet.fastutil.longs.LongIterator;
import fleet.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a,\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u0005*\u00020\u00022\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u0001H\u00050\u0007\u001a*\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\n0\u0004\"\u0004\b\u0000\u0010\n*\u00020\u00022\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\n0\u0007\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\u0002\u001a\n\u0010\r\u001a\u00020\f*\u00020\u0002\u001a$\u0010\u000e\u001a\u00020\u000f*\u00020\u00022\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f0\u0007H\u0086\b\u00f8\u0001\u0000\u001a\u0012\u0010\u0010\u001a\u00020\f*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0002\u001a<\u0010\u0012\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00040\u0013*\u00020\u00022\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u0007H\u0086\b\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0015"}, d2={"toLongArray", "", "Lfleet/fastutil/longs/LongSet;", "mapNotNull", "", "R", "transform", "Lkotlin/Function1;", "", "map", "V", "isEmpty", "", "isNotEmpty", "forEach", "", "containsAll", "other", "partition", "Lkotlin/Pair;", "predicate", "fleet.fastutil"})
@SourceDebugExtension(value={"SMAP\nLongSetExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongSetExtensions.kt\nfleet/fastutil/longs/LongSetExtensionsKt\n+ 2 LongIteratorExtensions.kt\nfleet/fastutil/longs/LongIteratorExtensionsKt\n*L\n1#1,75:1\n6#2,2:76\n*S KotlinDebug\n*F\n+ 1 LongSetExtensions.kt\nfleet/fastutil/longs/LongSetExtensionsKt\n*L\n67#1:76,2\n*E\n"})
public final class LongSetExtensionsKt {
    @NotNull
    public static final long[] toLongArray(@NotNull LongSet $this$toLongArray) {
        Intrinsics.checkNotNullParameter((Object)$this$toLongArray, (String)"<this>");
        int size = $this$toLongArray.getSize();
        if (size == 0) {
            return LongArrays.INSTANCE.getEMPTY_ARRAY();
        }
        long[] a2 = new long[size];
        LongArrays.INSTANCE.unwrap($this$toLongArray.getValues(), a2);
        return a2;
    }

    @NotNull
    public static final <R> List<R> mapNotNull(@NotNull LongSet $this$mapNotNull, @NotNull Function1<? super Long, ? extends R> transform2) {
        Intrinsics.checkNotNullParameter((Object)$this$mapNotNull, (String)"<this>");
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        List res2 = new ArrayList();
        LongIterator iter = $this$mapNotNull.getValues();
        while (iter.hasNext()) {
            long element = iter.next();
            Object transformed = transform2.invoke((Object)element);
            if (transformed == null) continue;
            res2.add(transformed);
        }
        return res2;
    }

    @NotNull
    public static final <V> List<V> map(@NotNull LongSet $this$map, @NotNull Function1<? super Long, ? extends V> transform2) {
        Intrinsics.checkNotNullParameter((Object)$this$map, (String)"<this>");
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        List res2 = new ArrayList();
        LongIterator iter = $this$map.getValues();
        while (iter.hasNext()) {
            long element = iter.next();
            res2.add(transform2.invoke((Object)element));
        }
        return res2;
    }

    public static final boolean isEmpty(@NotNull LongSet $this$isEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$isEmpty, (String)"<this>");
        return $this$isEmpty.getSize() == 0;
    }

    public static final boolean isNotEmpty(@NotNull LongSet $this$isNotEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$isNotEmpty, (String)"<this>");
        return $this$isNotEmpty.getSize() != 0;
    }

    public static final void forEach(@NotNull LongSet $this$forEach, @NotNull Function1<? super Long, Unit> transform2) {
        Intrinsics.checkNotNullParameter((Object)$this$forEach, (String)"<this>");
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        boolean $i$f$forEach = false;
        LongIterator iter = $this$forEach.getValues();
        while (iter.hasNext()) {
            transform2.invoke((Object)iter.next());
        }
    }

    public static final boolean containsAll(@NotNull LongSet $this$containsAll, @NotNull LongSet other) {
        Intrinsics.checkNotNullParameter((Object)$this$containsAll, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        LongIterator iter = other.getValues();
        while (iter.hasNext()) {
            if ($this$containsAll.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static final Pair<List<Long>, List<Long>> partition(@NotNull LongSet $this$partition, @NotNull Function1<? super Long, Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)$this$partition, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$partition = false;
        ArrayList<Long> first2 = new ArrayList<Long>();
        ArrayList<Long> second2 = new ArrayList<Long>();
        LongIterator $this$forEach$iv = $this$partition.getValues();
        boolean $i$f$forEach = false;
        while ($this$forEach$iv.hasNext()) {
            long it = $this$forEach$iv.next();
            boolean bl2 = false;
            boolean bl3 = (Boolean)predicate.invoke((Object)it) != false ? first2.add(it) : second2.add(it);
        }
        return new Pair(first2, second2);
    }
}

