/*
 * Decompiled with CFR 0.152.
 */
package fleet.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0005\u00a8\u0006\b"}, d2={"setExecutable", "", "path", "Ljava/nio/file/Path;", "isExecutable", "", "setReadOnly", "value", "fleet.util.core"})
public final class FileAttributesKt {
    public static final void setExecutable(@NotNull Path path) {
        Set<PosixFilePermission> permissions;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        PosixFileAttributeView view2 = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
        if (view2 != null && (permissions = view2.readAttributes().permissions()).add(PosixFilePermission.OWNER_EXECUTE)) {
            view2.setPermissions(permissions);
        }
    }

    public static final boolean isExecutable(@NotNull Path path) {
        Set<PosixFilePermission> set2;
        PosixFileAttributes posixFileAttributes;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        PosixFileAttributeView posixFileAttributeView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
        return posixFileAttributeView != null && (posixFileAttributes = posixFileAttributeView.readAttributes()) != null && (set2 = posixFileAttributes.permissions()) != null ? set2.contains((Object)PosixFilePermission.OWNER_EXECUTE) : false;
    }

    public static final void setReadOnly(@NotNull Path path, boolean value) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        PosixFileAttributeView posixFileAttributeView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
        if (posixFileAttributeView != null) {
            boolean modified;
            PosixFileAttributeView posixView = posixFileAttributeView;
            boolean bl2 = false;
            Set<PosixFilePermission> permissions = posixView.readAttributes().permissions();
            if (value) {
                PosixFilePermission[] posixFilePermissionArray = new PosixFilePermission[]{PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_WRITE};
                v1 = permissions.removeAll(SetsKt.setOf((Object[])posixFilePermissionArray));
            } else {
                v1 = modified = permissions.add(PosixFilePermission.OWNER_WRITE);
            }
            if (modified) {
                posixView.setPermissions(permissions);
            }
        } else {
            DosFileAttributeView dosFileAttributeView = Files.getFileAttributeView(path, DosFileAttributeView.class, new LinkOption[0]);
            if (dosFileAttributeView != null) {
                dosFileAttributeView.setReadOnly(value);
            } else {
                throw new IOException("Not supported: " + path.getFileSystem());
            }
        }
    }
}

