/*
 * Decompiled with CFR 0.152.
 */
package fleet.util.text;

import fleet.util.text.InsensitiveString;
import fleet.util.text.PluralizerKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0018\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00070\r0\u0013H\u0002JT\u0010\u0014\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00162\u0018\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00070\r0\u0013H\u0002J\u001e\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u0007J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u0007J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0007H\u0002J\u0018\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0007H\u0002J\u0010\u0010$\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u0018\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007H\u0002J\u001c\u0010'\u001a\u0004\u0018\u00010\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u00072\b\u0010(\u001a\u0004\u0018\u00010\u0007J\u0010\u0010)\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u0007H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00070\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00070\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lfleet/util/text/Pluralizer;", "", "<init>", "()V", "irregularSingles", "", "Lfleet/util/text/InsensitiveString;", "", "irregularPlurals", "uncountables", "", "pluralRules", "", "Lkotlin/Pair;", "Lkotlin/text/Regex;", "singularRules", "sanitizeWord", "word", "rules", "", "replaceWord", "replaceMap", "", "keepMap", "pluralize", "count", "", "inclusive", "", "plural", "singular", "addPluralRule", "", "rule", "replacement", "addSingularRule", "addUncountableRule", "addIrregularRule", "single", "restoreCase", "result", "sanitizeRule", "fleet.util.core"})
@SourceDebugExtension(value={"SMAP\nPluralizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pluralizer.kt\nfleet/util/text/Pluralizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,437:1\n1869#2,2:438\n1869#2,2:440\n1869#2,2:442\n1869#2,2:444\n*S KotlinDebug\n*F\n+ 1 Pluralizer.kt\nfleet/util/text/Pluralizer\n*L\n236#1:438,2\n269#1:440,2\n312#1:442,2\n411#1:444,2\n*E\n"})
final class Pluralizer {
    @NotNull
    public static final Pluralizer INSTANCE;
    @NotNull
    private static final Map<InsensitiveString, String> irregularSingles;
    @NotNull
    private static final Map<InsensitiveString, String> irregularPlurals;
    @NotNull
    private static final Set<InsensitiveString> uncountables;
    @NotNull
    private static final List<Pair<Regex, String>> pluralRules;
    @NotNull
    private static final List<Pair<Regex, String>> singularRules;

    private Pluralizer() {
    }

    private final String sanitizeWord(String word, List<Pair<Regex, String>> rules) {
        if (((CharSequence)word).length() == 0 || uncountables.contains(PluralizerKt.access$ignoringCase(word))) {
            return word;
        }
        int len = rules.size();
        while (--len > -1) {
            Pair<Regex, String> pair = rules.get(len);
            Regex regex2 = (Regex)pair.component1();
            String replacement = (String)pair.component2();
            if (!regex2.containsMatchIn((CharSequence)word)) continue;
            return regex2.replaceFirst((CharSequence)word, replacement);
        }
        return null;
    }

    private final String replaceWord(String word, Map<InsensitiveString, String> replaceMap, Map<InsensitiveString, String> keepMap, List<Pair<Regex, String>> rules) {
        if (((CharSequence)word).length() == 0) {
            return word;
        }
        if (keepMap.containsKey(PluralizerKt.access$ignoringCase(word))) {
            return word;
        }
        String replacement = replaceMap.get(PluralizerKt.access$ignoringCase(word));
        if (replacement != null) {
            return replacement;
        }
        return this.sanitizeWord(word, rules);
    }

    @NotNull
    public final String pluralize(@NotNull String word, int count, boolean inclusive) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        String pluralized = count == 1 ? this.singular(word) : this.plural(word);
        Object object = inclusive ? count + " " : "";
        String string2 = pluralized;
        if (string2 == null) {
            string2 = word;
        }
        return (String)object + string2;
    }

    @Nullable
    public final String plural(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        return this.restoreCase(word, this.replaceWord(word, irregularSingles, irregularPlurals, pluralRules));
    }

    @Nullable
    public final String singular(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        return this.restoreCase(word, this.replaceWord(word, irregularPlurals, irregularSingles, singularRules));
    }

    private final void addPluralRule(String rule, String replacement) {
        pluralRules.add((Pair<Regex, String>)TuplesKt.to((Object)this.sanitizeRule(rule), (Object)replacement));
    }

    private final void addSingularRule(String rule, String replacement) {
        singularRules.add((Pair<Regex, String>)TuplesKt.to((Object)this.sanitizeRule(rule), (Object)replacement));
    }

    private final void addUncountableRule(String word) {
        if (!StringsKt.startsWith$default((String)word, (String)"/", (boolean)false, (int)2, null)) {
            uncountables.add(PluralizerKt.access$ignoringCase(word));
        } else {
            this.addPluralRule(word, "$0");
            this.addSingularRule(word, "$0");
        }
    }

    private final void addIrregularRule(String single2, String plural) {
        irregularSingles.put(PluralizerKt.access$ignoringCase(single2), plural);
        irregularPlurals.put(PluralizerKt.access$ignoringCase(plural), single2);
    }

    @Nullable
    public final String restoreCase(@Nullable String word, @Nullable String result2) {
        char lc;
        char uc;
        char wc;
        if (word == null || result2 == null || word == result2) {
            return result2;
        }
        int len = (int)Math.min((double)result2.length(), (double)word.length());
        if (len == 0) {
            return result2;
        }
        char[] cArray = result2.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] chars = cArray;
        int i2 = 0;
        while (i2 < len) {
            wc = word.charAt(i2);
            if (chars[i2] == wc && i2 != len - 1) {
                ++i2;
                continue;
            }
            uc = Character.toUpperCase(chars[i2]);
            lc = Character.toLowerCase(chars[i2]);
            if (wc != lc && wc != uc) break;
            chars[i2] = wc;
            ++i2;
        }
        if (i2 > 0 && i2 < chars.length && (uc = Character.toUpperCase(wc = word.charAt(i2 - 1))) != (lc = Character.toLowerCase(wc))) {
            while (i2 < chars.length) {
                chars[i2] = wc == uc ? Character.toUpperCase(chars[i2]) : Character.toLowerCase(chars[i2]);
                ++i2;
            }
        }
        return StringsKt.concatToString((char[])chars);
    }

    private final Regex sanitizeRule(String rule) {
        Object object;
        if (StringsKt.startsWith$default((String)rule, (String)"/", (boolean)false, (int)2, null)) {
            String string2 = rule.substring(1);
            object = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            object = "^" + rule + "$";
        }
        return new Regex((String)object, RegexOption.IGNORE_CASE);
    }

    static {
        Pair o2;
        Object element$iv;
        INSTANCE = new Pluralizer();
        irregularSingles = new LinkedHashMap();
        irregularPlurals = new LinkedHashMap();
        uncountables = new LinkedHashSet();
        pluralRules = new ArrayList();
        singularRules = new ArrayList();
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"this", (Object)"these"), TuplesKt.to((Object)"that", (Object)"those"), TuplesKt.to((Object)"echo", (Object)"echoes"), TuplesKt.to((Object)"dingo", (Object)"dingoes"), TuplesKt.to((Object)"volcano", (Object)"volcanoes"), TuplesKt.to((Object)"tornado", (Object)"tornadoes"), TuplesKt.to((Object)"torpedo", (Object)"torpedoes"), TuplesKt.to((Object)"genus", (Object)"genera"), TuplesKt.to((Object)"viscus", (Object)"viscera"), TuplesKt.to((Object)"stigma", (Object)"stigmata"), TuplesKt.to((Object)"stoma", (Object)"stomata"), TuplesKt.to((Object)"dogma", (Object)"dogmata"), TuplesKt.to((Object)"lemma", (Object)"lemmata"), TuplesKt.to((Object)"anathema", (Object)"anathemata"), TuplesKt.to((Object)"ox", (Object)"oxen"), TuplesKt.to((Object)"axe", (Object)"axes"), TuplesKt.to((Object)"die", (Object)"dice"), TuplesKt.to((Object)"yes", (Object)"yeses"), TuplesKt.to((Object)"foot", (Object)"feet"), TuplesKt.to((Object)"eave", (Object)"eaves"), TuplesKt.to((Object)"goose", (Object)"geese"), TuplesKt.to((Object)"tooth", (Object)"teeth"), TuplesKt.to((Object)"quiz", (Object)"quizzes"), TuplesKt.to((Object)"human", (Object)"humans"), TuplesKt.to((Object)"proof", (Object)"proofs"), TuplesKt.to((Object)"carve", (Object)"carves"), TuplesKt.to((Object)"valve", (Object)"valves"), TuplesKt.to((Object)"looey", (Object)"looies"), TuplesKt.to((Object)"thief", (Object)"thieves"), TuplesKt.to((Object)"groove", (Object)"grooves"), TuplesKt.to((Object)"pickaxe", (Object)"pickaxes"), TuplesKt.to((Object)"whiskey", (Object)"whiskies")};
        Object $this$forEach$iv = (Object[])CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            o2 = (Pair)element$iv;
            boolean bl2 = false;
            INSTANCE.addIrregularRule((String)o2.getFirst(), (String)o2.getSecond());
        }
        $this$forEach$iv = new Pair[]{TuplesKt.to((Object)"/s?$", (Object)"s"), TuplesKt.to((Object)"/([^aeiou]ese)$", (Object)"$1"), TuplesKt.to((Object)"/(ax|test)is$", (Object)"$1es"), TuplesKt.to((Object)"/(alias|[^aou]us|t[lm]as|gas|ris)$", (Object)"$1es"), TuplesKt.to((Object)"/(e[mn]u)s?$", (Object)"$1s"), TuplesKt.to((Object)"/([^l]ias|[aeiou]las|[ejzr]as|[iu]am)$", (Object)"$1"), TuplesKt.to((Object)"/(alumn|syllab|octop|vir|radi|nucle|fung|cact|stimul|termin|bacill|foc|uter|loc|strat)(?:us|i)$", (Object)"$1i"), TuplesKt.to((Object)"/(alumn|alg|vertebr)(?:a|ae)$", (Object)"$1ae"), TuplesKt.to((Object)"/(seraph|cherub)(?:im)?$", (Object)"$1im"), TuplesKt.to((Object)"/(her|at|gr)o$", (Object)"$1oes"), TuplesKt.to((Object)"/(agend|addend|millenni|medi|dat|extrem|bacteri|desiderat|strat|candelabr|errat|ov|symposi|curricul|automat|quor)(?:a|um)$", (Object)"$1a"), TuplesKt.to((Object)"/(apheli|hyperbat|periheli|asyndet|noumen|phenomen|criteri|organ|prolegomen|hedr|automat)(?:a|on)$", (Object)"$1a"), TuplesKt.to((Object)"/sis$", (Object)"ses"), TuplesKt.to((Object)"/(?:(kni|wi|li)fe|(ar|l|ea|eo|oa|hoo)f)$", (Object)"$1$2ves"), TuplesKt.to((Object)"/([^aeiouy]|qu)y$", (Object)"$1ies"), TuplesKt.to((Object)"/([^ch][ieo][ln])ey$", (Object)"$1ies"), TuplesKt.to((Object)"/(x|ch|ss|sh|zz)$", (Object)"$1es"), TuplesKt.to((Object)"/(matr|cod|mur|sil|vert|ind|append)(?:ix|ex)$", (Object)"$1ices"), TuplesKt.to((Object)"(m|l)(?:ice|ouse)", (Object)"$1ice"), TuplesKt.to((Object)"/(pe)(?:rson|ople)$", (Object)"$1ople"), TuplesKt.to((Object)"/(child)(?:ren)?$", (Object)"$1ren"), TuplesKt.to((Object)"/eaux$", (Object)"$0"), TuplesKt.to((Object)"/m[ae]n$", (Object)"men")};
        $this$forEach$iv = CollectionsKt.listOf((Object[])$this$forEach$iv);
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            o2 = (Pair)element$iv;
            boolean bl3 = false;
            INSTANCE.addPluralRule((String)o2.getFirst(), (String)o2.getSecond());
        }
        $this$forEach$iv = new Pair[]{TuplesKt.to((Object)"/(.)s$", (Object)"$1"), TuplesKt.to((Object)"/([^aeiou]s)es$", (Object)"$1"), TuplesKt.to((Object)"/(wi|kni|(?:after|half|high|low|mid|non|night|[^\\w]|^)li)ves$", (Object)"$1fe"), TuplesKt.to((Object)"/(ar|(?:wo|[ae])l|[eo][ao])ves$", (Object)"$1f"), TuplesKt.to((Object)"/ies$", (Object)"y"), TuplesKt.to((Object)"/\\b([pl]|zomb|(?:neck|cross)?t|coll|faer|food|gen|goon|group|lass|talk|goal|cut)ies$", (Object)"$1ie"), TuplesKt.to((Object)"/\\b(mon|smil)ies$", (Object)"$1ey"), TuplesKt.to((Object)"(m|l)ice", (Object)"$1ouse"), TuplesKt.to((Object)"/(seraph|cherub)im$", (Object)"$1"), TuplesKt.to((Object)"/.(x|ch|ss|sh|zz|tto|go|cho|alias|[^aou]us|t[lm]as|gas|(?:her|at|gr)o|ris)(?:es)?$", (Object)"$1"), TuplesKt.to((Object)"/(analy|^ba|diagno|parenthe|progno|synop|the|empha|cri)(?:sis|ses)$", (Object)"$1sis"), TuplesKt.to((Object)"/(movie|twelve|abuse|e[mn]u)s$", (Object)"$1"), TuplesKt.to((Object)"/(test)(?:is|es)$", (Object)"$1is"), TuplesKt.to((Object)"/(x|ch|.ss|sh|zz|tto|go|cho|alias|[^aou]us|tlas|gas|(?:her|at|gr)o|ris)(?:es)?$", (Object)"$1"), TuplesKt.to((Object)"/(e[mn]u)s?$", (Object)"$1"), TuplesKt.to((Object)"/(cookie|movie|twelve)s$", (Object)"$1"), TuplesKt.to((Object)"/(cris|test|diagnos)(?:is|es)$", (Object)"$1is"), TuplesKt.to((Object)"/(alumn|syllab|octop|vir|radi|nucle|fung|cact|stimul|termin|bacill|foc|uter|loc|strat)(?:us|i)$", (Object)"$1us"), TuplesKt.to((Object)"/(agend|addend|millenni|dat|extrem|bacteri|desiderat|strat|candelabr|errat|ov|symposi|curricul|quor)a$", (Object)"$1um"), TuplesKt.to((Object)"/(apheli|hyperbat|periheli|asyndet|noumen|phenomen|criteri|organ|prolegomen|hedr|automat)a$", (Object)"$1on"), TuplesKt.to((Object)"/(alumn|alg|vertebr)ae$", (Object)"$1a"), TuplesKt.to((Object)"/(cod|mur|sil|vert|ind)ices$", (Object)"$1ex"), TuplesKt.to((Object)"/(matr|append)ices$", (Object)"$1ix"), TuplesKt.to((Object)"/(pe)(rson|ople)$", (Object)"$1rson"), TuplesKt.to((Object)"/(child)ren$", (Object)"$1"), TuplesKt.to((Object)"/(eau)x?$", (Object)"$1"), TuplesKt.to((Object)"/men$", (Object)"man")};
        $this$forEach$iv = CollectionsKt.listOf((Object[])$this$forEach$iv);
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            o2 = (Pair)element$iv;
            boolean bl4 = false;
            INSTANCE.addSingularRule((String)o2.getFirst(), (String)o2.getSecond());
        }
        $this$forEach$iv = new String[]{"adulthood", "advice", "agenda", "aid", "alcohol", "ammo", "anime", "athletics", "audio", "bison", "blood", "bream", "buffalo", "butter", "carp", "cash", "chassis", "chess", "clothing", "cod", "commerce", "cooperation", "corps", "debris", "diabetes", "digestion", "elk", "energy", "equipment", "excretion", "expertise", "flounder", "fun", "gallows", "garbage", "graffiti", "headquarters", "health", "herpes", "highjinks", "homework", "housework", "information", "jeans", "justice", "kudos", "labour", "literature", "machinery", "mackerel", "mail", "media", "mews", "moose", "music", "news", "pike", "plankton", "pliers", "police", "pollution", "premises", "rain", "research", "rice", "salmon", "scissors", "series", "sewage", "shambles", "shrimp", "species", "staff", "swine", "tennis", "traffic", "transportation", "trout", "tuna", "wealth", "welfare", "whiting", "wildebeest", "wildlife", "you", "/[^aeiou]ese$/i", "/deer$", "/fish$", "/measles$", "/o[iu]s$", "/pox$", "/sheep$"};
        $this$forEach$iv = CollectionsKt.listOf((Object[])$this$forEach$iv);
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            String s2 = (String)element$iv;
            boolean bl5 = false;
            INSTANCE.addUncountableRule(s2);
        }
    }
}

