/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.collections.immutable.implementations.immutableSet;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlinx.collections.immutable.implementations.immutableSet.TrieNode;
import kotlinx.collections.immutable.implementations.immutableSet.TrieNodeIterator;
import kotlinx.collections.immutable.internal.CommonFunctionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0010\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\rH\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\t\u0010\u0012\u001a\u00020\u0013H\u0096\u0002J\u000e\u0010\u001a\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001bJ\r\u0010\u001c\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010\u001bR \u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t0\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\u00020\u00138\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001d"}, d2={"Lkotlinx/collections/immutable/implementations/immutableSet/PersistentHashSetIterator;", "E", "", "node", "Lkotlinx/collections/immutable/implementations/immutableSet/TrieNode;", "<init>", "(Lkotlinx/collections/immutable/implementations/immutableSet/TrieNode;)V", "path", "", "Lkotlinx/collections/immutable/implementations/immutableSet/TrieNodeIterator;", "getPath", "()Ljava/util/List;", "pathLastIndex", "", "getPathLastIndex", "()I", "setPathLastIndex", "(I)V", "hasNext", "", "getHasNext$annotations", "()V", "moveToNextNodeWithData", "pathIndex", "ensureNextElementIsReady", "", "next", "()Ljava/lang/Object;", "currentElement", "kotlinx-collections-immutable"})
public class PersistentHashSetIterator<E>
implements Iterator<E>,
KMappedMarker {
    @NotNull
    private final List<TrieNodeIterator<E>> path;
    private int pathLastIndex;
    private boolean hasNext;

    public PersistentHashSetIterator(@NotNull TrieNode<E> node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        Object[] objectArray = new TrieNodeIterator[]{new TrieNodeIterator()};
        this.path = CollectionsKt.mutableListOf((Object[])objectArray);
        this.hasNext = true;
        TrieNodeIterator.reset$default(this.path.get(0), node.getBuffer(), 0, 2, null);
        this.pathLastIndex = 0;
        this.ensureNextElementIsReady();
    }

    @NotNull
    protected final List<TrieNodeIterator<E>> getPath() {
        return this.path;
    }

    protected final int getPathLastIndex() {
        return this.pathLastIndex;
    }

    protected final void setPathLastIndex(int n2) {
        this.pathLastIndex = n2;
    }

    private static /* synthetic */ void getHasNext$annotations() {
    }

    private final int moveToNextNodeWithData(int pathIndex) {
        if (this.path.get(pathIndex).hasNextElement()) {
            return pathIndex;
        }
        if (this.path.get(pathIndex).hasNextNode()) {
            TrieNode<E> node = this.path.get(pathIndex).currentNode();
            if (pathIndex + 1 == this.path.size()) {
                this.path.add(new TrieNodeIterator());
            }
            TrieNodeIterator.reset$default(this.path.get(pathIndex + 1), node.getBuffer(), 0, 2, null);
            return this.moveToNextNodeWithData(pathIndex + 1);
        }
        return -1;
    }

    private final void ensureNextElementIsReady() {
        if (this.path.get(this.pathLastIndex).hasNextElement()) {
            return;
        }
        for (int i2 = this.pathLastIndex; -1 < i2; --i2) {
            int result2 = this.moveToNextNodeWithData(i2);
            if (result2 == -1 && this.path.get(i2).hasNextCell()) {
                this.path.get(i2).moveToNextCell();
                result2 = this.moveToNextNodeWithData(i2);
            }
            if (result2 != -1) {
                this.pathLastIndex = result2;
                return;
            }
            if (i2 > 0) {
                this.path.get(i2 - 1).moveToNextCell();
            }
            this.path.get(i2).reset(TrieNode.Companion.getEMPTY$kotlinx_collections_immutable().getBuffer(), 0);
        }
        this.hasNext = false;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public E next() {
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        E result2 = this.path.get(this.pathLastIndex).nextElement();
        this.ensureNextElementIsReady();
        return result2;
    }

    protected final E currentElement() {
        CommonFunctionsKt.assert(this.hasNext());
        return this.path.get(this.pathLastIndex).currentElement();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

