/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlinx.datetime.DateTimeFormatException;
import kotlinx.datetime.DateTimePeriodKt;
import kotlinx.datetime.internal.MathJvmKt;
import kotlinx.datetime.serializers.DateTimePeriodIso8601Serializer;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=DateTimePeriodIso8601Serializer.class)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000  2\u00020\u0001:\u0001 B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0013\u0010\u001b\u001a\u00020\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001d\u001a\u00020\u0004H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006R\u0012\u0010\u0011\u001a\u00020\u0004X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0006R\u0012\u0010\u0013\u001a\u00020\u0014X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0006\u0082\u0001\u0002!\"\u00a8\u0006#"}, d2={"Lkotlinx/datetime/DateTimePeriod;", "", "()V", "days", "", "getDays", "()I", "hours", "getHours", "minutes", "getMinutes", "months", "getMonths", "nanoseconds", "getNanoseconds", "seconds", "getSeconds", "totalMonths", "getTotalMonths$kotlinx_datetime", "totalNanoseconds", "", "getTotalNanoseconds$kotlinx_datetime", "()J", "years", "getYears", "allNonpositive", "", "equals", "other", "hashCode", "toString", "", "Companion", "Lkotlinx/datetime/DatePeriod;", "Lkotlinx/datetime/DateTimePeriodImpl;", "kotlinx-datetime"})
@SourceDebugExtension(value={"SMAP\nDateTimePeriod.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DateTimePeriod.kt\nkotlinx/datetime/DateTimePeriod\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,610:1\n1#2:611\n*E\n"})
public abstract class DateTimePeriod {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private DateTimePeriod() {
    }

    public abstract int getTotalMonths$kotlinx_datetime();

    public abstract int getDays();

    public abstract long getTotalNanoseconds$kotlinx_datetime();

    public final int getYears() {
        return this.getTotalMonths$kotlinx_datetime() / 12;
    }

    public final int getMonths() {
        return this.getTotalMonths$kotlinx_datetime() % 12;
    }

    public int getHours() {
        return (int)(this.getTotalNanoseconds$kotlinx_datetime() / 3600000000000L);
    }

    public int getMinutes() {
        return (int)(this.getTotalNanoseconds$kotlinx_datetime() % 3600000000000L / 60000000000L);
    }

    public int getSeconds() {
        return (int)(this.getTotalNanoseconds$kotlinx_datetime() % 60000000000L / (long)1000000000);
    }

    public int getNanoseconds() {
        return (int)(this.getTotalNanoseconds$kotlinx_datetime() % (long)1000000000);
    }

    private final boolean allNonpositive() {
        return this.getTotalMonths$kotlinx_datetime() <= 0 && this.getDays() <= 0 && this.getTotalNanoseconds$kotlinx_datetime() <= 0L && ((this.getTotalMonths$kotlinx_datetime() | this.getDays()) != 0 || this.getTotalNanoseconds$kotlinx_datetime() != 0L);
    }

    @NotNull
    public String toString() {
        StringBuilder it;
        StringBuilder stringBuilder;
        int n2;
        StringBuilder stringBuilder2;
        StringBuilder $this$toString_u24lambda_u242 = stringBuilder2 = new StringBuilder();
        boolean bl2 = false;
        if (this.allNonpositive()) {
            $this$toString_u24lambda_u242.append('-');
            n2 = -1;
        } else {
            n2 = 1;
        }
        int sign2 = n2;
        $this$toString_u24lambda_u242.append('P');
        if (this.getYears() != 0) {
            $this$toString_u24lambda_u242.append(this.getYears() * sign2).append('Y');
        }
        if (this.getMonths() != 0) {
            $this$toString_u24lambda_u242.append(this.getMonths() * sign2).append('M');
        }
        if (this.getDays() != 0) {
            $this$toString_u24lambda_u242.append(this.getDays() * sign2).append('D');
        }
        String t2 = null;
        t2 = "T";
        if (this.getHours() != 0) {
            it = stringBuilder = $this$toString_u24lambda_u242.append(t2).append(this.getHours() * sign2).append('H');
            boolean bl3 = false;
            t2 = "";
        }
        if (this.getMinutes() != 0) {
            it = stringBuilder = $this$toString_u24lambda_u242.append(t2).append(this.getMinutes() * sign2).append('M');
            boolean bl4 = false;
            t2 = "";
        }
        if ((this.getSeconds() | this.getNanoseconds()) != 0) {
            $this$toString_u24lambda_u242.append(t2);
            $this$toString_u24lambda_u242.append(this.getSeconds() != 0 ? Integer.valueOf(this.getSeconds() * sign2) : (this.getNanoseconds() * sign2 < 0 ? "-0" : "0"));
            if (this.getNanoseconds() != 0) {
                $this$toString_u24lambda_u242.append('.').append(StringsKt.padStart((String)String.valueOf(Math.abs(this.getNanoseconds())), (int)9, (char)'0'));
            }
            $this$toString_u24lambda_u242.append('S');
        }
        if ($this$toString_u24lambda_u242.length() == 1) {
            $this$toString_u24lambda_u242.append("0D");
        }
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DateTimePeriod)) {
            return false;
        }
        if (this.getTotalMonths$kotlinx_datetime() != ((DateTimePeriod)other).getTotalMonths$kotlinx_datetime()) {
            return false;
        }
        if (this.getDays() != ((DateTimePeriod)other).getDays()) {
            return false;
        }
        return this.getTotalNanoseconds$kotlinx_datetime() == ((DateTimePeriod)other).getTotalNanoseconds$kotlinx_datetime();
    }

    public int hashCode() {
        int result2 = this.getTotalMonths$kotlinx_datetime();
        result2 = 31 * result2 + this.getDays();
        result2 = 31 * result2 + Long.hashCode(this.getTotalNanoseconds$kotlinx_datetime());
        return result2;
    }

    public /* synthetic */ DateTimePeriod(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u00c6\u0001\u00a8\u0006\t"}, d2={"Lkotlinx/datetime/DateTimePeriod$Companion;", "", "()V", "parse", "Lkotlinx/datetime/DateTimePeriod;", "text", "", "serializer", "Lkotlinx/serialization/KSerializer;", "kotlinx-datetime"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DateTimePeriod parse(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            int START = 0;
            int AFTER_P = 1;
            int AFTER_YEAR = 2;
            int AFTER_MONTH = 3;
            int AFTER_WEEK = 4;
            int AFTER_DAY = 5;
            int AFTER_T = 6;
            int AFTER_HOUR = 7;
            int AFTER_MINUTE = 8;
            int AFTER_SECOND_AND_NANO = 9;
            int state = START;
            int i2 = 0;
            int sign2 = 1;
            int years = 0;
            int months = 0;
            int weeks = 0;
            int days = 0;
            int hours = 0;
            int minutes = 0;
            int seconds = 0;
            int nanoseconds = 0;
            boolean someComponentParsed = false;
            while (true) {
                int iStart;
                int localSign;
                block53: {
                    char c2;
                    block51: {
                        block52: {
                            int daysTotal;
                            if (i2 >= text.length()) {
                                if (state == 0) {
                                    kotlinx.datetime.DateTimePeriod$Companion.parse$parseException("Unexpected end of input; 'P' designator is required", i2);
                                    throw new KotlinNothingValueException();
                                }
                                if (state == AFTER_T) {
                                    kotlinx.datetime.DateTimePeriod$Companion.parse$parseException("Unexpected end of input; at least one time component is required after 'T'", i2);
                                    throw new KotlinNothingValueException();
                                }
                                long n2 = (long)days + (long)(weeks * 7);
                                if (!(Integer.MIN_VALUE <= n2 ? n2 <= Integer.MAX_VALUE : false)) {
                                    kotlinx.datetime.DateTimePeriod$Companion.parse$parseException("The total number of days under 'D' and 'W' designators should fit into an Int", 0);
                                    throw new KotlinNothingValueException();
                                }
                                daysTotal = (int)n2;
                                if (!someComponentParsed) {
                                    kotlinx.datetime.DateTimePeriod$Companion.parse$parseException("At least one component is required, but none were found", 0);
                                    throw new KotlinNothingValueException();
                                }
                                return DateTimePeriodKt.DateTimePeriod(years, months, daysTotal, hours, minutes, seconds, nanoseconds);
                            }
                            if (state == 0) {
                                if (i2 + 1 >= text.length() && (text.charAt(i2) == '+' || text.charAt(i2) == '-')) {
                                    kotlinx.datetime.DateTimePeriod$Companion.parse$parseException("Unexpected end of string; 'P' designator is required", i2);
                                    throw new KotlinNothingValueException();
                                }
                                daysTotal = text.charAt(i2);
                                if (daysTotal == 43 ? true : daysTotal == 45) {
                                    if (text.charAt(i2) == '-') {
                                        sign2 = -1;
                                    }
                                    if (text.charAt(i2 + 1) != 'P') {
                                        kotlinx.datetime.DateTimePeriod$Companion.parse$parseException("Expected 'P', got '" + text.charAt(i2 + 1) + '\'', i2 + 1);
                                        throw new KotlinNothingValueException();
                                    }
                                    i2 += 2;
                                } else if (daysTotal == 80) {
                                    ++i2;
                                } else {
                                    kotlinx.datetime.DateTimePeriod$Companion.parse$parseException("Expected '+', '-', 'P', got '" + text.charAt(i2) + '\'', i2);
                                    throw new KotlinNothingValueException();
                                }
                                state = AFTER_P;
                                continue;
                            }
                            localSign = sign2;
                            iStart = i2;
                            c2 = text.charAt(i2);
                            if (!(c2 == '+' ? true : c2 == '-')) break block51;
                            if (text.charAt(i2) == '-') {
                                localSign *= -1;
                            }
                            if (++i2 >= text.length()) break block52;
                            char c3 = text.charAt(i2);
                            if ('0' <= c3 ? c3 < ':' : false) break block53;
                        }
                        kotlinx.datetime.DateTimePeriod$Companion.parse$parseException("A number expected after '" + text.charAt(i2) + '\'', i2);
                        throw new KotlinNothingValueException();
                    }
                    if (!('0' <= c2 ? c2 < ':' : false) && c2 == 'T') {
                        if (state >= AFTER_T) {
                            kotlinx.datetime.DateTimePeriod$Companion.parse$parseException("Only one 'T' designator is allowed", i2);
                            throw new KotlinNothingValueException();
                        }
                        state = AFTER_T;
                        ++i2;
                        continue;
                    }
                }
                long number = 0L;
                while (i2 < text.length()) {
                    char c4 = text.charAt(i2);
                    boolean bl2 = '0' <= c4 ? c4 < ':' : false;
                    if (!bl2) break;
                    try {
                        number = MathJvmKt.safeAdd(MathJvmKt.safeMultiply(number, 10L), (long)(text.charAt(i2) - 48));
                    }
                    catch (ArithmeticException e2) {
                        kotlinx.datetime.DateTimePeriod$Companion.parse$parseException("The number is too large", iStart);
                        throw new KotlinNothingValueException();
                    }
                    ++i2;
                }
                someComponentParsed = true;
                number *= (long)localSign;
                if (i2 == text.length()) {
                    kotlinx.datetime.DateTimePeriod$Companion.parse$parseException("Expected a designator after the numerical value", i2);
                    throw new KotlinNothingValueException();
                }
                String wrongOrder = "Wrong component order: should be 'Y', 'M', 'W', 'D', then designator 'T', then 'H', 'M', 'S'";
                char c5 = Character.toUpperCase(text.charAt(i2));
                if (c5 == 'Y') {
                    if (state >= AFTER_YEAR) {
                        kotlinx.datetime.DateTimePeriod$Companion.parse$parseException(wrongOrder, i2);
                        throw new KotlinNothingValueException();
                    }
                    state = AFTER_YEAR;
                    years = kotlinx.datetime.DateTimePeriod$Companion.parse$toIntThrowing(number, iStart, 'Y');
                } else if (c5 == 'M') {
                    if (state >= AFTER_T) {
                        if (state >= AFTER_MINUTE) {
                            kotlinx.datetime.DateTimePeriod$Companion.parse$parseException(wrongOrder, i2);
                            throw new KotlinNothingValueException();
                        }
                        state = AFTER_MINUTE;
                        minutes = kotlinx.datetime.DateTimePeriod$Companion.parse$toIntThrowing(number, iStart, 'M');
                    } else {
                        if (state >= AFTER_MONTH) {
                            kotlinx.datetime.DateTimePeriod$Companion.parse$parseException(wrongOrder, i2);
                            throw new KotlinNothingValueException();
                        }
                        state = AFTER_MONTH;
                        months = kotlinx.datetime.DateTimePeriod$Companion.parse$toIntThrowing(number, iStart, 'M');
                    }
                } else if (c5 == 'W') {
                    if (state >= AFTER_WEEK) {
                        kotlinx.datetime.DateTimePeriod$Companion.parse$parseException(wrongOrder, i2);
                        throw new KotlinNothingValueException();
                    }
                    state = AFTER_WEEK;
                    weeks = kotlinx.datetime.DateTimePeriod$Companion.parse$toIntThrowing(number, iStart, 'W');
                } else if (c5 == 'D') {
                    if (state >= AFTER_DAY) {
                        kotlinx.datetime.DateTimePeriod$Companion.parse$parseException(wrongOrder, i2);
                        throw new KotlinNothingValueException();
                    }
                    state = AFTER_DAY;
                    days = kotlinx.datetime.DateTimePeriod$Companion.parse$toIntThrowing(number, iStart, 'D');
                } else if (c5 == 'H') {
                    if (state >= AFTER_HOUR || state < AFTER_T) {
                        kotlinx.datetime.DateTimePeriod$Companion.parse$parseException(wrongOrder, i2);
                        throw new KotlinNothingValueException();
                    }
                    state = AFTER_HOUR;
                    hours = kotlinx.datetime.DateTimePeriod$Companion.parse$toIntThrowing(number, iStart, 'H');
                } else if (c5 == 'S') {
                    if (state >= AFTER_SECOND_AND_NANO || state < AFTER_T) {
                        kotlinx.datetime.DateTimePeriod$Companion.parse$parseException(wrongOrder, i2);
                        throw new KotlinNothingValueException();
                    }
                    state = AFTER_SECOND_AND_NANO;
                    seconds = kotlinx.datetime.DateTimePeriod$Companion.parse$toIntThrowing(number, iStart, 'S');
                } else if (c5 == '.' ? true : c5 == ',') {
                    int fractionLength;
                    if (++i2 >= text.length()) {
                        kotlinx.datetime.DateTimePeriod$Companion.parse$parseException("Expected designator 'S' after " + text.charAt(i2 - 1), i2);
                        throw new KotlinNothingValueException();
                    }
                    int iStartFraction = i2;
                    while (i2 < text.length()) {
                        char c6 = text.charAt(i2);
                        boolean bl3 = '0' <= c6 ? c6 < ':' : false;
                        if (!bl3) break;
                        ++i2;
                    }
                    if ((fractionLength = i2 - iStartFraction) > 9) {
                        kotlinx.datetime.DateTimePeriod$Companion.parse$parseException("Only the nanosecond fractions of a second are supported", iStartFraction);
                        throw new KotlinNothingValueException();
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    String string2 = text.substring(iStartFraction, i2);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    String fractionalPart = stringBuilder.append(string2).append(StringsKt.repeat((CharSequence)"0", (int)(9 - fractionLength))).toString();
                    nanoseconds = Integer.parseInt(fractionalPart, CharsKt.checkRadix((int)10)) * localSign;
                    if (text.charAt(i2) != 'S') {
                        kotlinx.datetime.DateTimePeriod$Companion.parse$parseException("Expected the 'S' designator after a fraction", i2);
                        throw new KotlinNothingValueException();
                    }
                    if (state >= AFTER_SECOND_AND_NANO || state < AFTER_T) {
                        kotlinx.datetime.DateTimePeriod$Companion.parse$parseException(wrongOrder, i2);
                        throw new KotlinNothingValueException();
                    }
                    state = AFTER_SECOND_AND_NANO;
                    seconds = kotlinx.datetime.DateTimePeriod$Companion.parse$toIntThrowing(number, iStart, 'S');
                } else {
                    kotlinx.datetime.DateTimePeriod$Companion.parse$parseException("Expected a designator after the numerical value", i2);
                    throw new KotlinNothingValueException();
                }
                ++i2;
            }
        }

        @NotNull
        public final KSerializer<DateTimePeriod> serializer() {
            return DateTimePeriodIso8601Serializer.INSTANCE;
        }

        private static final Void parse$parseException(String message, int position) {
            throw new DateTimeFormatException("Parse error at char " + position + ": " + message);
        }

        private static final int parse$toIntThrowing(long $this$parse_u24toIntThrowing, int iStart, char component) {
            if ($this$parse_u24toIntThrowing < Integer.MIN_VALUE || $this$parse_u24toIntThrowing > Integer.MAX_VALUE) {
                kotlinx.datetime.DateTimePeriod$Companion.parse$parseException("Value " + $this$parse_u24toIntThrowing + " does not fit into an Int, which is required for component '" + component + '\'', iStart);
                throw new KotlinNothingValueException();
            }
            return (int)$this$parse_u24toIntThrowing;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

