/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.DateTimePeriod;
import kotlinx.datetime.DateTimePeriodKt;
import kotlinx.datetime.DateTimeUnit;
import kotlinx.datetime.Instant;
import kotlinx.datetime.InstantJvmKt;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.UtcOffset;
import kotlinx.datetime.format.DateTimeComponents;
import kotlinx.datetime.format.DateTimeComponentsKt;
import kotlinx.datetime.format.DateTimeFormat;
import kotlinx.datetime.internal.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u001a\u0010\b\u001a\u00020\t*\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f\u001a\"\u0010\r\u001a\u00020\u000e*\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u001a\u001a\u0010\u0013\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016\u001a\"\u0010\u0013\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f\u001a\u001a\u0010\u0013\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u001a\u0010\u0013\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\f\u001a\u001c\u0010\u0013\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0007\u001a\u0014\u0010\u0013\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0007\u001a\"\u0010\u0013\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f\u001a\u001a\u0010\u0013\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u001a\u0010\u0013\u001a\u00020\u0019*\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f\u001a\u001a\u0010\u001a\u001a\u00020\t*\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f\u001a\u001a\u0010\u001b\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0014\u0010\u001b\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0007\u001a\f\u0010\u001c\u001a\u00020\u0005*\u00020\u000eH\u0007\u001a\u001a\u0010\u001d\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u001a\u0010\u001e\u001a\u00020\t*\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\"\u0015\u0010\u0007\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0006\u00a8\u0006\u001f"}, d2={"DISTANT_FUTURE_SECONDS", "", "DISTANT_PAST_SECONDS", "isDistantFuture", "", "Lkotlinx/datetime/Instant;", "(Lkotlinx/datetime/Instant;)Z", "isDistantPast", "daysUntil", "", "other", "timeZone", "Lkotlinx/datetime/TimeZone;", "format", "", "Lkotlinx/datetime/format/DateTimeFormat;", "Lkotlinx/datetime/format/DateTimeComponents;", "offset", "Lkotlinx/datetime/UtcOffset;", "minus", "value", "unit", "Lkotlinx/datetime/DateTimeUnit$TimeBased;", "Lkotlinx/datetime/DateTimeUnit;", "period", "Lkotlinx/datetime/DateTimePeriod;", "monthsUntil", "plus", "toInstant", "until", "yearsUntil", "kotlinx-datetime"})
@SourceDebugExtension(value={"SMAP\nInstant.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Instant.kt\nkotlinx/datetime/InstantKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,805:1\n1#2:806\n*E\n"})
public final class InstantKt {
    public static final long DISTANT_PAST_SECONDS = -3217862419201L;
    public static final long DISTANT_FUTURE_SECONDS = 3093527980800L;

    public static final boolean isDistantPast(@NotNull Instant $this$isDistantPast) {
        Intrinsics.checkNotNullParameter((Object)$this$isDistantPast, (String)"<this>");
        return $this$isDistantPast.compareTo(Instant.Companion.getDISTANT_PAST()) <= 0;
    }

    public static final boolean isDistantFuture(@NotNull Instant $this$isDistantFuture) {
        Intrinsics.checkNotNullParameter((Object)$this$isDistantFuture, (String)"<this>");
        return $this$isDistantFuture.compareTo(Instant.Companion.getDISTANT_FUTURE()) >= 0;
    }

    @Deprecated(message="Removed to support more idiomatic code. See https://github.com/Kotlin/kotlinx-datetime/issues/339", replaceWith=@ReplaceWith(expression="Instant.parse(this)", imports={}), level=DeprecationLevel.WARNING)
    @NotNull
    public static final Instant toInstant(@NotNull String $this$toInstant) {
        Intrinsics.checkNotNullParameter((Object)$this$toInstant, (String)"<this>");
        return Instant.Companion.parse$default(Instant.Companion, $this$toInstant, null, 2, null);
    }

    @NotNull
    public static final Instant minus(@NotNull Instant $this$minus, @NotNull DateTimePeriod period, @NotNull TimeZone timeZone) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)period, (String)"period");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        if (period.getTotalNanoseconds$kotlinx_datetime() != Long.MIN_VALUE) {
            DateTimePeriod $this$minus_u24lambda_u240 = period;
            boolean bl2 = false;
            DateTimePeriod negatedPeriod = DateTimePeriodKt.buildDateTimePeriod(-$this$minus_u24lambda_u240.getTotalMonths$kotlinx_datetime(), -$this$minus_u24lambda_u240.getDays(), -$this$minus_u24lambda_u240.getTotalNanoseconds$kotlinx_datetime());
            instant = InstantJvmKt.plus($this$minus, negatedPeriod, timeZone);
        } else {
            DateTimePeriod $this$minus_u24lambda_u241 = period;
            boolean bl3 = false;
            DateTimePeriod negatedPeriod = DateTimePeriodKt.buildDateTimePeriod(-$this$minus_u24lambda_u241.getTotalMonths$kotlinx_datetime(), -$this$minus_u24lambda_u241.getDays(), -($this$minus_u24lambda_u241.getTotalNanoseconds$kotlinx_datetime() + 1L));
            instant = InstantKt.plus(InstantJvmKt.plus($this$minus, negatedPeriod, timeZone), 1, DateTimeUnit.Companion.getNANOSECOND());
        }
        return instant;
    }

    public static final long until(@NotNull Instant $this$until, @NotNull Instant other, @NotNull DateTimeUnit.TimeBased unit) {
        long l2;
        Intrinsics.checkNotNullParameter((Object)$this$until, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        try {
            l2 = MathKt.multiplyAddAndDivide(other.getEpochSeconds() - $this$until.getEpochSeconds(), 1000000000L, other.getNanosecondsOfSecond() - $this$until.getNanosecondsOfSecond(), unit.getNanoseconds());
        }
        catch (ArithmeticException e2) {
            l2 = $this$until.compareTo(other) < 0 ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
        return l2;
    }

    public static final int daysUntil(@NotNull Instant $this$daysUntil, @NotNull Instant other, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)$this$daysUntil, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        return MathKt.clampToInt(InstantJvmKt.until($this$daysUntil, other, DateTimeUnit.Companion.getDAY(), timeZone));
    }

    public static final int monthsUntil(@NotNull Instant $this$monthsUntil, @NotNull Instant other, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)$this$monthsUntil, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        return MathKt.clampToInt(InstantJvmKt.until($this$monthsUntil, other, DateTimeUnit.Companion.getMONTH(), timeZone));
    }

    public static final int yearsUntil(@NotNull Instant $this$yearsUntil, @NotNull Instant other, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)$this$yearsUntil, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        return MathKt.clampToInt(InstantJvmKt.until($this$yearsUntil, other, DateTimeUnit.Companion.getYEAR(), timeZone));
    }

    @NotNull
    public static final DateTimePeriod minus(@NotNull Instant $this$minus, @NotNull Instant other, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        return InstantJvmKt.periodUntil(other, $this$minus, timeZone);
    }

    @Deprecated(message="Use the minus overload with an explicit number of units", replaceWith=@ReplaceWith(expression="this.minus(1, unit, timeZone)", imports={}))
    @NotNull
    public static final Instant minus(@NotNull Instant $this$minus, @NotNull DateTimeUnit unit, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        return InstantJvmKt.plus($this$minus, -1, unit, timeZone);
    }

    @Deprecated(message="Use the plus overload with an explicit number of units", replaceWith=@ReplaceWith(expression="this.plus(1, unit)", imports={}))
    @NotNull
    public static final Instant plus(@NotNull Instant $this$plus, @NotNull DateTimeUnit.TimeBased unit) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        return InstantJvmKt.plus($this$plus, 1L, unit);
    }

    @Deprecated(message="Use the minus overload with an explicit number of units", replaceWith=@ReplaceWith(expression="this.minus(1, unit)", imports={}))
    @NotNull
    public static final Instant minus(@NotNull Instant $this$minus, @NotNull DateTimeUnit.TimeBased unit) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        return InstantJvmKt.plus($this$minus, -1L, unit);
    }

    @NotNull
    public static final Instant plus(@NotNull Instant $this$plus, int value, @NotNull DateTimeUnit.TimeBased unit) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        return InstantJvmKt.plus($this$plus, value, unit);
    }

    @NotNull
    public static final Instant minus(@NotNull Instant $this$minus, int value, @NotNull DateTimeUnit.TimeBased unit) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        return InstantKt.minus($this$minus, (long)value, unit);
    }

    @NotNull
    public static final Instant minus(@NotNull Instant $this$minus, long value, @NotNull DateTimeUnit unit, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        return value != Long.MIN_VALUE ? InstantJvmKt.plus($this$minus, -value, unit, timeZone) : InstantJvmKt.plus(InstantJvmKt.plus($this$minus, -(value + 1L), unit, timeZone), 1, unit, timeZone);
    }

    @NotNull
    public static final Instant minus(@NotNull Instant $this$minus, long value, @NotNull DateTimeUnit.TimeBased unit) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        return value != Long.MIN_VALUE ? InstantJvmKt.plus($this$minus, -value, unit) : InstantKt.plus(InstantJvmKt.plus($this$minus, -(value + 1L), unit), 1, unit);
    }

    public static final long minus(@NotNull Instant $this$minus, @NotNull Instant other, @NotNull DateTimeUnit unit, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        return InstantJvmKt.until(other, $this$minus, unit, timeZone);
    }

    public static final long minus(@NotNull Instant $this$minus, @NotNull Instant other, @NotNull DateTimeUnit.TimeBased unit) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        return InstantKt.until(other, $this$minus, unit);
    }

    @NotNull
    public static final String format(@NotNull Instant $this$format, @NotNull DateTimeFormat<DateTimeComponents> format2, @NotNull UtcOffset offset) {
        Intrinsics.checkNotNullParameter((Object)$this$format, (String)"<this>");
        Intrinsics.checkNotNullParameter(format2, (String)"format");
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        Instant instant = $this$format;
        return DateTimeComponentsKt.format(format2, (Function1<? super DateTimeComponents, Unit>)((Function1)new Function1<DateTimeComponents, Unit>(instant, offset){
            final /* synthetic */ Instant $instant;
            final /* synthetic */ UtcOffset $offset;
            {
                this.$instant = $instant;
                this.$offset = $offset;
                super(1);
            }

            public final void invoke(@NotNull DateTimeComponents $this$format) {
                Intrinsics.checkNotNullParameter((Object)$this$format, (String)"$this$format");
                $this$format.setDateTimeOffset(this.$instant, this.$offset);
            }
        }));
    }

    public static /* synthetic */ String format$default(Instant instant, DateTimeFormat dateTimeFormat, UtcOffset utcOffset, int n2, Object object) {
        if ((n2 & 2) != 0) {
            utcOffset = UtcOffset.Companion.getZERO();
        }
        return InstantKt.format(instant, dateTimeFormat, utcOffset);
    }
}

