/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.eddsa;

public class Utils {
    public static int equal(int b2, int c2) {
        int result2 = 0;
        int xor = b2 ^ c2;
        for (int i2 = 0; i2 < 8; ++i2) {
            result2 |= xor >> i2;
        }
        return (result2 ^ true) & 1;
    }

    public static int equal(byte[] b2, byte[] c2) {
        int result2 = 0;
        for (int i2 = 0; i2 < 32; ++i2) {
            result2 |= b2[i2] ^ c2[i2];
        }
        return Utils.equal(result2, 0);
    }

    public static int negative(int b2) {
        return b2 >> 8 & 1;
    }

    public static int bit(byte[] h7, int i2) {
        return h7[i2 >> 3] >> (i2 & 7) & 1;
    }

    public static byte[] hexToBytes(String s2) {
        int len = s2.length();
        byte[] data = new byte[len / 2];
        for (int i2 = 0; i2 < len; i2 += 2) {
            data[i2 / 2] = (byte)((Character.digit(s2.charAt(i2), 16) << 4) + Character.digit(s2.charAt(i2 + 1), 16));
        }
        return data;
    }

    public static String bytesToHex(byte[] raw) {
        if (raw == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * raw.length);
        for (byte b2 : raw) {
            hex.append(Character.forDigit((b2 & 0xF0) >> 4, 16)).append(Character.forDigit(b2 & 0xF, 16));
        }
        return hex.toString();
    }
}

