/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.eddsa.math.bigint;

import java.math.BigInteger;
import net.i2p.crypto.eddsa.math.Field;
import net.i2p.crypto.eddsa.math.ScalarOps;
import net.i2p.crypto.eddsa.math.bigint.BigIntegerLittleEndianEncoding;

public class BigIntegerScalarOps
implements ScalarOps {
    private final BigInteger l;
    private final BigIntegerLittleEndianEncoding enc;

    public BigIntegerScalarOps(Field f2, BigInteger l2) {
        this.l = l2;
        this.enc = new BigIntegerLittleEndianEncoding();
        this.enc.setField(f2);
    }

    @Override
    public byte[] reduce(byte[] s2) {
        return this.enc.encode(this.enc.toBigInteger(s2).mod(this.l));
    }

    @Override
    public byte[] multiplyAndAdd(byte[] a2, byte[] b2, byte[] c2) {
        return this.enc.encode(this.enc.toBigInteger(a2).multiply(this.enc.toBigInteger(b2)).add(this.enc.toBigInteger(c2)).mod(this.l));
    }
}

